/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.RenderContext;
import com.taobao.weex.ui.RenderContextImpl;
import com.taobao.weex.ui.WXRenderHandler;
import com.taobao.weex.ui.action.BasicGraphicAction;
import com.taobao.weex.ui.action.GraphicActionBatchAction;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXRenderManager {
    private volatile ConcurrentHashMap<String, RenderContextImpl> mRenderContext;
    private WXRenderHandler mWXRenderHandler;
    private ArrayList<Map<String, Object>> mBatchActions = new ArrayList();
    private final int MAX_DROP_FRAME_NATIVE_BATCH = 2000;
    private static final String sKeyAction = "Action";
    private static int nativeBatchTimes = 0;

    public WXRenderManager() {
        this.mRenderContext = new ConcurrentHashMap();
        this.mWXRenderHandler = new WXRenderHandler();
    }

    public RenderContext getRenderContext(String instanceId) {
        return this.mRenderContext.get(instanceId);
    }

    @Nullable
    public WXComponent getWXComponent(String instanceId, String ref) {
        if (instanceId == null || TextUtils.isEmpty((CharSequence)ref)) {
            return null;
        }
        RenderContext stmt = this.getRenderContext(instanceId);
        return stmt == null ? null : stmt.getComponent(ref);
    }

    public WXSDKInstance getWXSDKInstance(String instanceId) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement == null) {
            return null;
        }
        return statement.getWXSDKInstance();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderHandler.postDelayed(WXThread.secure(runnable), delayMillis);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void postOnUiThread(Runnable runnable, String instanceId) {
        this.mWXRenderHandler.post(instanceId, WXThread.secure(runnable));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void postOnUiThread(Runnable runnable) {
        this.mWXRenderHandler.post(WXThread.secure(runnable));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void removeTask(Runnable runnable) {
        this.mWXRenderHandler.removeCallbacks(runnable);
    }

    public void removeRenderStatement(String instanceId) {
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXRenderManager] removeRenderStatement can only be called in main thread");
        }
        RenderContextImpl statement = this.mRenderContext.remove(instanceId);
        if (statement != null) {
            statement.destroy();
        }
        if (instanceId == null) {
            this.mWXRenderHandler.removeCallbacksAndMessages(null);
        } else {
            this.mWXRenderHandler.removeMessages(instanceId.hashCode());
        }
    }

    private void postAllStashedGraphicAction(String instanceId, BasicGraphicAction action) {
        ArrayList<Map<String, Object>> tmpList = new ArrayList<Map<String, Object>>(this.mBatchActions);
        this.mBatchActions.clear();
        ArrayList<BasicGraphicAction> actions = new ArrayList<BasicGraphicAction>(tmpList.size());
        for (int i = 0; i < tmpList.size(); ++i) {
            Map<String, Object> item = tmpList.get(i);
            BasicGraphicAction tmpAction = (BasicGraphicAction)item.get(sKeyAction);
            if (tmpAction.mActionType == 1 || tmpAction.mActionType == 2) continue;
            actions.add(tmpAction);
        }
        nativeBatchTimes = 0;
        this.postGraphicAction(instanceId, new GraphicActionBatchAction(action.getWXSDKIntance(), action.getRef(), actions));
    }

    public void postGraphicAction(String instanceId, BasicGraphicAction action) {
        RenderContextImpl renderContext = this.mRenderContext.get(instanceId);
        if (renderContext == null) {
            return;
        }
        if (action.mActionType == 2) {
            this.postAllStashedGraphicAction(instanceId, action);
            return;
        }
        if (action.mActionType == 1 || this.mBatchActions.size() > 0) {
            if (++nativeBatchTimes > 2000) {
                this.postAllStashedGraphicAction(instanceId, action);
            } else {
                HashMap<String, BasicGraphicAction> item = new HashMap<String, BasicGraphicAction>(1);
                item.put(sKeyAction, action);
                this.mBatchActions.add(item);
                return;
            }
        }
        this.mWXRenderHandler.post(instanceId, action);
    }

    public void registerInstance(WXSDKInstance instance) {
        if (instance.getInstanceId() == null) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_RENDER_ERR_INSTANCE_ID_NULL, "registerInstance", WXErrorCode.WX_RENDER_ERR_INSTANCE_ID_NULL.getErrorMsg() + "instanceId is null", null);
        } else {
            this.mRenderContext.put(instance.getInstanceId(), new RenderContextImpl(instance));
        }
    }

    public List<WXSDKInstance> getAllInstances() {
        ArrayList<WXSDKInstance> instances = null;
        if (this.mRenderContext != null && !this.mRenderContext.isEmpty()) {
            instances = new ArrayList<WXSDKInstance>();
            for (Map.Entry<String, RenderContextImpl> entry : this.mRenderContext.entrySet()) {
                RenderContextImpl renderStatement = entry.getValue();
                if (renderStatement == null) continue;
                instances.add(renderStatement.getWXSDKInstance());
            }
        }
        return instances;
    }

    public void registerComponent(String instanceId, String ref, WXComponent comp) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement != null) {
            statement.registerComponent(ref, comp);
            if (null != statement.getInstance()) {
                statement.getInstance().getApmForInstance().updateMaxStats("wxMaxComponentCount", statement.getComponentCount());
            }
        }
    }

    public WXComponent unregisterComponent(String instanceId, String ref) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement != null) {
            if (null != statement.getInstance()) {
                statement.getInstance().getApmForInstance().updateMaxStats("wxMaxComponentCount", statement.getComponentCount());
            }
            return statement.unregisterComponent(ref);
        }
        return null;
    }
}

