/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.performance.WXAnalyzerDataTransfer;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;
import java.util.Map;

public class WXExceptionUtils {
    public static String degradeUrl = "BundleUrlDefaultDegradeUrl";

    public static void commitCriticalExceptionRT(@Nullable String instanceId, @Nullable WXErrorCode errCode, @Nullable String function, @Nullable String exception, @Nullable Map<String, String> extParams) {
        WXExceptionUtils.commitCriticalExceptionWithDefaultUrl("BundleUrlDefault", instanceId, errCode, function, exception, extParams);
    }

    public static void commitCriticalExceptionWithDefaultUrl(@Nullable String defaultUrl, @Nullable String instanceId, @Nullable WXErrorCode errCode, @Nullable String function, @Nullable String exception, @Nullable Map<String, String> extParams) {
        String illegalValue;
        IWXJSExceptionAdapter adapter = WXSDKManager.getInstance().getIWXJSExceptionAdapter();
        WXSDKInstance instance = null;
        String bundleUrlCommit = TextUtils.isEmpty((CharSequence)defaultUrl) ? "BundleUrlDefault" : defaultUrl;
        String instanceIdCommit = "InstanceIdDefalut";
        String exceptionMsgCommit = exception;
        Map<String, String> commitMap = extParams;
        if (null == commitMap) {
            commitMap = new HashMap<String, String>();
            commitMap.put("wxSdkInitStartTime", String.valueOf(WXEnvironment.sSDKInitStart));
            commitMap.put("wxSDKInitCostTime", String.valueOf(WXEnvironment.sSDKInitTime));
            commitMap.put("wxSDKCurExceptionTime", String.valueOf(System.currentTimeMillis()));
        }
        if (!TextUtils.isEmpty((CharSequence)instanceId)) {
            instanceIdCommit = instanceId;
            instance = WXSDKManager.getInstance().getAllInstanceMap().get(instanceId);
            if (null != instance) {
                bundleUrlCommit = instance.getBundleUrl();
                commitMap.put("templateInfo", instance.getTemplateInfo());
                if (TextUtils.isEmpty((CharSequence)bundleUrlCommit) || bundleUrlCommit.equals("default")) {
                    bundleUrlCommit = !TextUtils.equals((CharSequence)degradeUrl, (CharSequence)"BundleUrlDefaultDegradeUrl") ? degradeUrl : WXSDKInstance.requestUrl;
                }
                for (Map.Entry<String, String> entry : instance.getContainerInfo().entrySet()) {
                    commitMap.put(entry.getKey(), entry.getValue());
                }
                commitMap.put("wxStageList", instance.getExceptionRecorder().convertStageToStr());
                String bundleTemplate = instance.getTemplate();
                if (null == bundleTemplate) {
                    bundleTemplate = "has recycle by gc";
                } else {
                    int length = bundleTemplate.length();
                    bundleTemplate = bundleTemplate.substring(0, Math.min(length, 300));
                }
                commitMap.put("wxTemplateOfBundle", bundleTemplate);
                Long pageStartTime = instance.getExceptionRecorder().getStageTime("wxStartDownLoadBundle");
                if (null == pageStartTime) {
                    pageStartTime = instance.getExceptionRecorder().getStageTime("wxRenderTimeOrigin");
                }
                if (null != pageStartTime) {
                    commitMap.put("wxUseTime", String.valueOf(WXUtils.getFixUnixTime() - pageStartTime));
                }
            }
        } else if (commitMap.size() > 0) {
            String string2 = bundleUrlCommit = TextUtils.isEmpty((CharSequence)commitMap.get("weexUrl")) ? commitMap.get("weexUrl") : commitMap.get("bundleUrl");
        }
        if (null != (illegalValue = commitMap.get("errorCode")) && illegalValue.length() > 200) {
            commitMap.remove("errorCode");
        }
        WXJSExceptionInfo exceptionCommit = new WXJSExceptionInfo(instanceIdCommit, bundleUrlCommit, errCode, function, exceptionMsgCommit, commitMap);
        if (adapter != null) {
            adapter.onJSException(exceptionCommit);
        }
        if (null != instance) {
            instance.getExceptionRecorder().recordErrorMsg(exceptionCommit);
        }
        WXAnalyzerDataTransfer.transferError(exceptionCommit, instanceId);
    }
}

