/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.performance.IApmGenerator;
import com.taobao.weex.performance.IWXApmMonitorAdapter;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXInstanceApm {
    public static final String WEEX_PAGE_TOPIC = "weex_page";
    public static final String KEY_PROPERTIES_ERROR_CODE = "wxErrorCode";
    public static final String KEY_PAGE_PROPERTIES_BIZ_ID = "wxBizID";
    public static final String KEY_PAGE_PROPERTIES_BUBDLE_URL = "wxBundleUrl";
    public static final String KEY_PAGE_PROPERTIES_JSLIB_VERSION = "wxJSLibVersion";
    public static final String KEY_PAGE_PROPERTIES_WEEX_VERSION = "wxSDKVersion";
    public static final String KEY_PAGE_PROPERTIES_REQUEST_TYPE = "wxRequestType";
    public static final String KEY_PAGE_PROPERTIES_CACHE_TYPE = "wxCacheType";
    public static final String KEY_PAGE_PROPERTIES_CACHE_INFO = "wxZCacheInfo";
    public static final String KEY_PAGE_PROPERTIES_JS_FM_INI = "wxJsFrameworkInit";
    public static final String KEY_PAGE_PROPERTIES_CONTAINER_NAME = "wxContainerName";
    public static final String KEY_PAGE_PROPERTIES_INSTANCE_TYPE = "wxInstanceType";
    public static final String KEY_PAGE_PROPERTIES_PARENT_PAGE = "wxParentPage";
    public static final String KEY_PAGE_PROPERTIES_BUNDLE_TYPE = "wxBundleType";
    public static final String KEY_PAGE_STAGES_DOWN_BUNDLE_START = "wxStartDownLoadBundle";
    public static final String KEY_PAGE_STAGES_DOWN_BUNDLE_END = "wxEndDownLoadBundle";
    public static final String KEY_PAGE_STAGES_RENDER_ORGIGIN = "wxRenderTimeOrigin";
    public static final String KEY_PAGE_STAGES_LOAD_BUNDLE_START = "wxStartLoadBundle";
    public static final String KEY_PAGE_STAGES_LOAD_BUNDLE_END = "wxEndLoadBundle";
    public static final String KEY_PAGE_STAGES_FIRST_INTERACTION_VIEW = "wxFirstInteractionView";
    public static final String KEY_PAGE_STAGES_CREATE_FINISH = "wxJSBundleCreateFinish";
    public static final String KEY_PAGE_STAGES_FSRENDER = "wxFsRender";
    public static final String KEY_PAGE_STAGES_NEW_FSRENDER = "wxNewFsRender";
    public static final String KEY_PAGE_STAGES_INTERACTION = "wxInteraction";
    public static final String KEY_PAGE_STAGES_DESTROY = "wxDestroy";
    public static final String KEY_PAGE_STATS_BUNDLE_SIZE = "wxBundleSize";
    public static final String KEY_PAGE_STATS_FS_CALL_JS_TIME = "wxFSCallJsTotalTime";
    public static final String KEY_PAGE_STATS_FS_CALL_JS_NUM = "wxFSCallJsTotalNum";
    public static final String KEY_PAGE_STATS_FS_TIMER_NUM = "wxFSTimerCount";
    public static final String KEY_PAGE_STATS_FS_CALL_NATIVE_TIME = "wxFSCallNativeTotalTime";
    public static final String KEY_PAGE_STATS_FS_CALL_NATIVE_NUM = "wxFSCallNativeTotalNum";
    public static final String KEY_PAGE_STATS_FS_CALL_EVENT_NUM = "wxFSCallEventTotalNum";
    public static final String KEY_PAGE_STATS_FS_REQUEST_NUM = "wxFSRequestNum";
    public static final String KEY_PAGE_STATS_CELL_EXCEED_NUM = "wxCellExceedNum";
    public static final String KEY_PAGE_STATS_MAX_DEEP_VIEW = "wxMaxDeepViewLayer";
    public static final String KEY_PAGE_STATS_MAX_DEEP_DOM = "wxMaxDeepVDomLayer";
    public static final String KEY_PAGE_STATS_MAX_COMPONENT_NUM = "wxMaxComponentCount";
    public static final String KEY_PAGE_STATS_WRONG_IMG_SIZE_COUNT = "wxWrongImgSizeCount";
    public static final String KEY_PAGE_STATS_EMBED_COUNT = "wxEmbedCount";
    public static final String KEY_PAGE_STATS_LARGE_IMG_COUNT = "wxLargeImgMaxCount";
    public static final String KEY_PAGE_STATS_BODY_RATIO = "wxBodyRatio";
    public static final String KEY_PAGE_STATS_SCROLLER_NUM = "wxScrollerCount";
    public static final String KEY_PAGE_STATS_CELL_DATA_UN_RECYCLE_NUM = "wxCellDataUnRecycleCount";
    public static final String KEY_PAGE_STATS_CELL_UN_RE_USE_NUM = "wxCellUnReUseCount";
    public static final String KEY_PAGE_STATS_IMG_UN_RECYCLE_NUM = "wxImgUnRecycleCount";
    public static final String KEY_PAGE_STATS_I_SCREEN_VIEW_COUNT = "wxInteractionScreenViewCount";
    public static final String KEY_PAGE_STATS_I_ALL_VIEW_COUNT = "wxInteractionAllViewCount";
    public static final String KEY_PAGE_STATS_I_COMPONENT_CREATE_COUNT = "wxInteractionComponentCreateCount";
    public static final String KEY_PAGE_ANIM_BACK_NUM = "wxAnimationInBackCount";
    public static final String KEY_PAGE_TIMER_BACK_NUM = "wxTimerInBackCount";
    public static final String KEY_PAGE_STATS_ACTUAL_DOWNLOAD_TIME = "wxActualNetworkTime";
    public static final String KEY_PAGE_STATS_IMG_LOAD_NUM = "wxImgLoadCount";
    public static final String KEY_PAGE_STATS_IMG_LOAD_SUCCESS_NUM = "wxImgLoadSuccessCount";
    public static final String KEY_PAGE_STATS_IMG_LOAD_FAIL_NUM = "wxImgLoadFailCount";
    public static final String KEY_PAGE_STATS_NET_NUM = "wxNetworkRequestCount";
    public static final String KEY_PAGE_STATS_NET_SUCCESS_NUM = "wxNetworkRequestSuccessCount";
    public static final String KEY_PAGE_STATS_NET_FAIL_NUM = "wxNetworkRequestFailCount";
    public static final String KEY_PAGE_STATS_JSLIB_INIT_TIME = "wxJSLibInitTime";
    public static final String VALUE_ERROR_CODE_DEFAULT = "0";
    private String mInstanceId;
    private IWXApmMonitorAdapter apmInstance;
    private Map<String, Double> recordStatsMap;
    private boolean isFSEnd;
    private boolean mHasInit = false;
    private boolean mEnd = false;
    private boolean hasRecordFistInteractionView = false;
    public final Map<String, Object> extInfo;

    public WXInstanceApm(String instanceId) {
        this.mInstanceId = instanceId;
        this.extInfo = new ConcurrentHashMap<String, Object>();
        IApmGenerator generator = WXSDKManager.getInstance().getApmGenerater();
        if (null != generator) {
            this.apmInstance = generator.generateApmInstance(WEEX_PAGE_TOPIC);
            this.recordStatsMap = new ConcurrentHashMap<String, Double>();
        }
    }

    public void onEvent(String name, Object value) {
        if (null == this.apmInstance) {
            return;
        }
        this.apmInstance.onEvent(name, value);
    }

    public void onStage(String name) {
        long time = WXUtils.getFixUnixTime();
        this.onStageWithTime(name, time);
    }

    public void onStageWithTime(String name, long time) {
        WXSDKInstance instance = WXSDKManager.getInstance().getAllInstanceMap().get(this.mInstanceId);
        if (null != instance) {
            instance.getExceptionRecorder().recordStage(name, time);
        }
        if (null == this.apmInstance || this.mEnd) {
            return;
        }
        this.apmInstance.onStage(name, time);
    }

    public void addProperty(String key, Object value) {
        if (null == this.apmInstance || this.mEnd) {
            return;
        }
        this.apmInstance.addProperty(key, value);
    }

    public void addStats(String key, double value) {
        if (null == this.apmInstance || this.mEnd) {
            return;
        }
        this.apmInstance.addStats(key, value);
    }

    public boolean hasInit() {
        return this.mHasInit;
    }

    public void doInit() {
        if (this.mHasInit) {
            return;
        }
        this.mHasInit = true;
        if (null == this.apmInstance) {
            return;
        }
        this.apmInstance.onStart(this.mInstanceId);
        WXSDKInstance instance = WXSDKManager.getInstance().getAllInstanceMap().get(this.mInstanceId);
        String url = null == instance ? "unKnowUrl" : instance.getBundleUrl();
        this.addProperty(KEY_PAGE_PROPERTIES_BUBDLE_URL, url);
        this.addProperty(KEY_PROPERTIES_ERROR_CODE, VALUE_ERROR_CODE_DEFAULT);
        this.addProperty(KEY_PAGE_PROPERTIES_JSLIB_VERSION, WXEnvironment.JS_LIB_SDK_VERSION);
        this.addProperty(KEY_PAGE_PROPERTIES_WEEX_VERSION, WXEnvironment.WXSDK_VERSION);
        if (null != instance) {
            for (Map.Entry<String, String> entry : instance.getContainerInfo().entrySet()) {
                this.addProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setPageName(String pageName) {
        WXSDKInstance instance;
        if (TextUtils.isEmpty((CharSequence)pageName) && null != (instance = WXSDKManager.getInstance().getAllInstanceMap().get(this.mInstanceId))) {
            pageName = instance.getContainerInfo().get(KEY_PAGE_PROPERTIES_CONTAINER_NAME);
        }
        String fixPageName = TextUtils.isEmpty((CharSequence)pageName) ? "emptyPageName" : pageName;
        this.addProperty(KEY_PAGE_PROPERTIES_BIZ_ID, fixPageName);
    }

    public void onAppear() {
        if (null == this.apmInstance) {
            return;
        }
        this.apmInstance.onAppear();
    }

    public void onDisAppear() {
        if (null == this.apmInstance) {
            return;
        }
        this.apmInstance.onDisappear();
    }

    public void onEnd() {
        if (null == this.apmInstance || this.mEnd) {
            return;
        }
        this.onStage(KEY_PAGE_STAGES_DESTROY);
        this.apmInstance.onEnd();
        this.mEnd = true;
    }

    public void arriveNewFsRenderTime() {
        if (null == this.apmInstance) {
            return;
        }
        this.onStage(KEY_PAGE_STAGES_NEW_FSRENDER);
    }

    public void arriveFSRenderTime() {
        if (null == this.apmInstance) {
            return;
        }
        this.isFSEnd = true;
        this.onStage(KEY_PAGE_STAGES_FSRENDER);
    }

    public void arriveInteraction(WXComponent targetComponent) {
        if (null == this.apmInstance || null == targetComponent || targetComponent.getInstance() == null) {
            return;
        }
        WXPerformance performanceRecord = targetComponent.getInstance().getWXPerformance();
        if (null == performanceRecord) {
            return;
        }
        if (!this.hasRecordFistInteractionView) {
            this.onStage(KEY_PAGE_STAGES_FIRST_INTERACTION_VIEW);
            this.hasRecordFistInteractionView = true;
        }
        long curTime = WXUtils.getFixUnixTime();
        performanceRecord.interactionTime = curTime - performanceRecord.renderUnixTimeOrigin;
        this.onStageWithTime(KEY_PAGE_STAGES_INTERACTION, curTime);
        this.updateDiffStats(KEY_PAGE_STATS_I_SCREEN_VIEW_COUNT, 1.0);
        this.updateMaxStats(KEY_PAGE_STATS_I_ALL_VIEW_COUNT, performanceRecord.localInteractionViewAddCount);
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (null != instance) {
            this.updateMaxStats(KEY_PAGE_STATS_I_COMPONENT_CREATE_COUNT, instance.getWXPerformance().componentCount);
        }
    }

    public void updateFSDiffStats(String name, double diffValue) {
        if (null == this.apmInstance || this.isFSEnd) {
            return;
        }
        this.updateDiffStats(name, diffValue);
    }

    public void updateDiffStats(String name, double diffValue) {
        if (null == this.apmInstance) {
            return;
        }
        Double preVal = this.recordStatsMap.containsKey(name) ? this.recordStatsMap.get(name) : 0.0;
        if (null == preVal) {
            WXExceptionUtils.commitCriticalExceptionRT("", WXErrorCode.WX_ERR_HASH_MAP_TMP, "updateDiffStats", "key : " + name, null);
            return;
        }
        double currentValue = preVal + diffValue;
        this.recordStatsMap.put(name, currentValue);
        this.addStats(name, currentValue);
    }

    public void updateMaxStats(String name, double currentVal) {
        if (null == this.apmInstance) {
            return;
        }
        Double maxValue = this.recordStatsMap.containsKey(name) ? this.recordStatsMap.get(name) : 0.0;
        if (null == maxValue) {
            WXExceptionUtils.commitCriticalExceptionRT("", WXErrorCode.WX_ERR_HASH_MAP_TMP, "updateMaxStats", "key : " + name, null);
            return;
        }
        if (maxValue < currentVal) {
            maxValue = currentVal;
            this.recordStatsMap.put(name, currentVal);
            this.addStats(name, maxValue);
        }
    }

    public void updateRecordInfo(Map<String, Object> extParams) {
        if (null == this.apmInstance || null == extParams) {
            return;
        }
        this.addPropeyFromExtParms(KEY_PAGE_PROPERTIES_REQUEST_TYPE, KEY_PAGE_PROPERTIES_REQUEST_TYPE, extParams);
        this.addPropeyFromExtParms("cacheType", KEY_PAGE_PROPERTIES_CACHE_TYPE, extParams);
        this.addPropeyFromExtParms("zCacheInfo", KEY_PAGE_PROPERTIES_CACHE_INFO, extParams);
        this.addStats(KEY_PAGE_STATS_JSLIB_INIT_TIME, WXEnvironment.sJSLibInitTime);
        this.addProperty(KEY_PAGE_PROPERTIES_JS_FM_INI, WXEnvironment.JsFrameworkInit);
        Object wxNetLibDownBundleTime = extParams.get("actualNetworkTime");
        if (wxNetLibDownBundleTime instanceof Long) {
            this.updateDiffStats(KEY_PAGE_STATS_ACTUAL_DOWNLOAD_TIME, ((Long)wxNetLibDownBundleTime).doubleValue());
        }
    }

    private void addPropeyFromExtParms(String fromKey, String toKey, Map<String, Object> extParams) {
        Object value = extParams.get(fromKey);
        if (value instanceof String) {
            this.addProperty(toKey, value);
        }
    }

    public void actionNetRequest() {
        if (!this.isFSEnd) {
            this.updateFSDiffStats(KEY_PAGE_STATS_FS_REQUEST_NUM, 1.0);
        }
        this.updateDiffStats(KEY_PAGE_STATS_NET_NUM, 1.0);
    }

    public void actionNetResult(boolean succeed, String errorCode) {
        if (succeed) {
            this.updateDiffStats(KEY_PAGE_STATS_NET_SUCCESS_NUM, 1.0);
        } else {
            this.updateDiffStats(KEY_PAGE_STATS_NET_FAIL_NUM, 1.0);
        }
    }

    public void actionLoadImg() {
        this.updateDiffStats(KEY_PAGE_STATS_IMG_LOAD_NUM, 1.0);
    }

    public void actionLoadImgResult(boolean succeed, String errorCode) {
        if (succeed) {
            this.updateDiffStats(KEY_PAGE_STATS_IMG_LOAD_SUCCESS_NUM, 1.0);
        } else {
            this.updateDiffStats(KEY_PAGE_STATS_IMG_LOAD_FAIL_NUM, 1.0);
        }
    }
}

