/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.performance.IWXAnalyzer;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class WXAnalyzerDataTransfer {
    private static final String GROUP = "WXAnalyzer";
    private static final String MODULE_PERFORMANCE = "WXPerformance";
    private static final String MODULE_ERROR = "WXError";

    public static void transferPerformance(WXPerformance performance, String instanceId) {
        if (!WXEnvironment.isApkDebugable()) {
            return;
        }
        List<IWXAnalyzer> transferList = WXSDKManager.getInstance().getWXAnalyzerList();
        if (null == transferList || transferList.size() == 0) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (null == instance) {
            return;
        }
        String data = "";
        try {
            JSONObject dimensionMap = new JSONObject();
            JSONObject measureMap = new JSONObject();
            for (Map.Entry<String, String> entry : performance.getDimensionMap().entrySet()) {
                dimensionMap.put(entry.getKey(), (Object)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : performance.getMeasureMap().entrySet()) {
                measureMap.put(entry.getKey(), entry.getValue());
            }
            data = new JSONObject().put("instanceId", (Object)instanceId).put("url", (Object)instance.getBundleUrl()).put("dimensionMap", (Object)dimensionMap).put("measureMap", (Object)measureMap).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IWXAnalyzer transfer : transferList) {
            transfer.transfer(GROUP, MODULE_PERFORMANCE, "instance", data);
        }
    }

    public static void transferError(WXJSExceptionInfo exceptionInfo, String instanceId) {
        if (!WXEnvironment.isApkDebugable()) {
            return;
        }
        List<IWXAnalyzer> transferList = WXSDKManager.getInstance().getWXAnalyzerList();
        if (null == transferList || transferList.size() == 0) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (null == instance) {
            return;
        }
        WXErrorCode errorCode = exceptionInfo.getErrCode();
        String data = "";
        try {
            data = new JSONObject().put("instanceId", (Object)instanceId).put("url", (Object)instance.getBundleUrl()).put("errorCode", (Object)errorCode.getErrorCode()).put("errorMsg", (Object)errorCode.getErrorMsg()).put("errorGroup", (Object)errorCode.getErrorGroup()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IWXAnalyzer transfer : transferList) {
            transfer.transfer(GROUP, MODULE_ERROR, errorCode.getErrorType().toString(), data);
        }
    }

    public static void transferFps(long fps) {
        if (!WXEnvironment.isApkDebugable()) {
            return;
        }
        List<IWXAnalyzer> transferList = WXSDKManager.getInstance().getWXAnalyzerList();
        if (null == transferList || transferList.size() == 0) {
            return;
        }
        String data = "";
        try {
            data = new JSONObject().put("fps", fps).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IWXAnalyzer transfer : transferList) {
            transfer.transfer(GROUP, MODULE_PERFORMANCE, "fps", data);
        }
    }
}

