/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.layout.measurefunc;

import android.graphics.Canvas;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AlignmentSpan;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.TextDecorationSpan;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.dom.WXLineHeightSpan;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.layout.MeasureMode;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class TextContentBoxMeasurement
extends ContentBoxMeasurement {
    private static final Canvas DUMMY_CANVAS = new Canvas();
    private static final String ELLIPSIS = "\u2026";
    private boolean mIsColorSet = false;
    private boolean hasBeenMeasured = false;
    private int mColor;
    private int mFontStyle = -1;
    private int mFontWeight = -1;
    private int mNumberOfLines = -1;
    private int mFontSize = -1;
    private int mLineHeight = -1;
    private float previousWidth = Float.NaN;
    private String mFontFamily = null;
    private String mText = null;
    private TextUtils.TruncateAt textOverflow;
    private Layout.Alignment mAlignment;
    private WXTextDecoration mTextDecoration = WXTextDecoration.NONE;
    private TextPaint mTextPaint;
    @Nullable
    private Spanned spanned;
    @Nullable
    private Layout layout;
    private AtomicReference<Layout> atomicReference = new AtomicReference();

    public TextContentBoxMeasurement(WXComponent component) {
        super(component);
    }

    @Override
    public void layoutBefore() {
        this.mTextPaint = new TextPaint(1);
        this.hasBeenMeasured = false;
        this.updateStyleAndText();
        this.spanned = this.createSpanned(this.mText);
    }

    @Override
    public void measureInternal(float width, float height, int widthMeasureMode, int heightMeasureMode) {
        float measureWidth = width;
        float measureHeight = height;
        this.hasBeenMeasured = true;
        float textWidth = this.getTextWidth(this.mTextPaint, width, widthMeasureMode == MeasureMode.EXACTLY);
        if (textWidth > 0.0f && this.mText != null) {
            this.layout = this.createLayout(textWidth, null);
            this.previousWidth = this.layout.getWidth();
            measureWidth = Float.isNaN(width) ? (float)this.layout.getWidth() : Math.min((float)this.layout.getWidth(), measureWidth);
            if (Float.isNaN(height)) {
                measureHeight = this.layout.getHeight();
            }
        } else {
            if (widthMeasureMode == MeasureMode.UNSPECIFIED) {
                measureWidth = 0.0f;
            }
            if (heightMeasureMode == MeasureMode.UNSPECIFIED) {
                measureHeight = 0.0f;
            }
        }
        this.mMeasureWidth = measureWidth;
        this.mMeasureHeight = measureHeight;
    }

    @Override
    public void layoutAfter(float computedWidth, float computedHeight) {
        if (this.mComponent != null) {
            if (this.hasBeenMeasured) {
                if (this.layout != null && WXDomUtils.getContentWidth(this.mComponent.getPadding(), this.mComponent.getBorder(), computedWidth) != this.previousWidth) {
                    this.recalculateLayout(computedWidth);
                }
            } else {
                this.updateStyleAndText();
                this.recalculateLayout(computedWidth);
            }
            this.hasBeenMeasured = false;
            if (this.layout != null && !this.layout.equals(this.atomicReference.get()) && Build.VERSION.SDK_INT >= 19 && Thread.currentThread() != Looper.getMainLooper().getThread()) {
                this.warmUpTextLayoutCache(this.layout);
            }
            this.swap();
            WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TextContentBoxMeasurement.this.mComponent.updateExtra(TextContentBoxMeasurement.this.atomicReference.get());
                }
            }, this.mComponent.getInstanceId());
        }
    }

    private void updateStyleAndText() {
        this.updateStyleImp(this.mComponent.getStyles());
        this.mText = WXAttr.getValue(this.mComponent.getAttrs());
    }

    private void updateStyleImp(Map<String, Object> style) {
        if (style != null) {
            if (style.containsKey("lines")) {
                int lines = WXStyle.getLines(style);
                int n = this.mNumberOfLines = lines > 0 ? lines : -1;
            }
            if (style.containsKey("fontSize")) {
                this.mFontSize = WXStyle.getFontSize(style, this.mComponent.getViewPortWidth());
            }
            if (style.containsKey("fontWeight")) {
                this.mFontWeight = WXStyle.getFontWeight(style);
            }
            if (style.containsKey("fontStyle")) {
                this.mFontStyle = WXStyle.getFontStyle(style);
            }
            if (style.containsKey("color")) {
                this.mColor = WXResourceUtils.getColor(WXStyle.getTextColor(style));
                boolean bl = this.mIsColorSet = this.mColor != Integer.MIN_VALUE;
            }
            if (style.containsKey("textDecoration")) {
                this.mTextDecoration = WXStyle.getTextDecoration(style);
            }
            if (style.containsKey("fontFamily")) {
                this.mFontFamily = WXStyle.getFontFamily(style);
            }
            this.mAlignment = WXStyle.getTextAlignment(style);
            this.textOverflow = WXStyle.getTextOverflow(style);
            int lineHeight = WXStyle.getLineHeight(style, this.mComponent.getViewPortWidth());
            if (lineHeight != -1) {
                this.mLineHeight = lineHeight;
            }
        }
    }

    @NonNull
    protected Spanned createSpanned(String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            SpannableString spannable = new SpannableString((CharSequence)text);
            this.updateSpannable((Spannable)spannable, 17);
            return spannable;
        }
        return new SpannableString((CharSequence)"");
    }

    protected void updateSpannable(Spannable spannable, int spanFlag) {
        int end = spannable.length();
        if (this.mFontSize == -1) {
            this.mTextPaint.setTextSize(32.0f);
        } else {
            this.mTextPaint.setTextSize((float)this.mFontSize);
        }
        if (this.mLineHeight != -1) {
            this.setSpan(spannable, new WXLineHeightSpan(this.mLineHeight), 0, end, spanFlag);
        }
        this.setSpan(spannable, new AlignmentSpan.Standard(this.mAlignment), 0, end, spanFlag);
        if (this.mFontStyle != -1 || this.mFontWeight != -1 || this.mFontFamily != null) {
            this.setSpan(spannable, (Object)new WXCustomStyleSpan(this.mFontStyle, this.mFontWeight, this.mFontFamily), 0, end, spanFlag);
        }
        if (this.mIsColorSet) {
            this.mTextPaint.setColor(this.mColor);
        }
        if (this.mTextDecoration == WXTextDecoration.UNDERLINE || this.mTextDecoration == WXTextDecoration.LINETHROUGH) {
            this.setSpan(spannable, (Object)new TextDecorationSpan(this.mTextDecoration), 0, end, spanFlag);
        }
    }

    private void setSpan(Spannable spannable, Object what, int start, int end, int spanFlag) {
        spannable.setSpan(what, start, end, spanFlag);
    }

    private float getTextWidth(TextPaint textPaint, float outerWidth, boolean forceToDesired) {
        float textWidth;
        if (this.mText == null) {
            if (forceToDesired) {
                return outerWidth;
            }
            return 0.0f;
        }
        if (forceToDesired) {
            textWidth = outerWidth;
        } else {
            float desiredWidth = Layout.getDesiredWidth((CharSequence)this.spanned, (TextPaint)textPaint);
            textWidth = WXUtils.isUndefined(outerWidth) || desiredWidth < outerWidth ? desiredWidth : outerWidth;
        }
        return textWidth;
    }

    @NonNull
    private Layout createLayout(float textWidth, @Nullable Layout previousLayout) {
        int lastLineEnd;
        int lastLineStart;
        Object layout = this.previousWidth != textWidth || previousLayout == null ? new StaticLayout((CharSequence)this.spanned, this.mTextPaint, (int)Math.ceil(textWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false) : previousLayout;
        if (this.mNumberOfLines != -1 && this.mNumberOfLines > 0 && this.mNumberOfLines < layout.getLineCount() && (lastLineStart = layout.getLineStart(this.mNumberOfLines - 1)) < (lastLineEnd = layout.getLineEnd(this.mNumberOfLines - 1))) {
            SpannableStringBuilder builder = null;
            builder = lastLineStart > 0 ? new SpannableStringBuilder(this.spanned.subSequence(0, lastLineStart)) : new SpannableStringBuilder();
            SpannableStringBuilder lastLine = new SpannableStringBuilder(this.spanned.subSequence(lastLineStart, lastLineEnd));
            builder.append((CharSequence)this.truncate((Editable)lastLine, this.mTextPaint, (int)Math.ceil(textWidth), this.textOverflow));
            this.adjustSpansRange(this.spanned, (Spannable)builder);
            this.spanned = builder;
            return new StaticLayout((CharSequence)this.spanned, this.mTextPaint, (int)Math.ceil(textWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        }
        return layout;
    }

    @NonNull
    private Spanned truncate(@Nullable Editable source, @NonNull TextPaint paint, int desired, @Nullable TextUtils.TruncateAt truncateAt) {
        SpannedString ret = new SpannedString((CharSequence)"");
        if (!TextUtils.isEmpty((CharSequence)source) && source.length() > 0) {
            if (truncateAt != null) {
                Object[] spans;
                source.append((CharSequence)ELLIPSIS);
                for (Object span : spans = source.getSpans(0, source.length(), Object.class)) {
                    int start = source.getSpanStart(span);
                    int end = source.getSpanEnd(span);
                    if (start != 0 || end != source.length() - 1) continue;
                    source.removeSpan(span);
                    source.setSpan(span, 0, source.length(), source.getSpanFlags(span));
                }
            }
            while (source.length() > 1) {
                int startOffset = source.length() - 1;
                if (truncateAt != null) {
                    --startOffset;
                }
                source.delete(startOffset, startOffset + 1);
                StaticLayout layout = new StaticLayout((CharSequence)source, paint, desired, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
                if (layout.getLineCount() > 1) continue;
                ret = source;
                break;
            }
        }
        return ret;
    }

    private void adjustSpansRange(@NonNull Spanned beforeTruncate, @NonNull Spannable afterTruncate) {
        Object[] spans;
        for (Object span : spans = beforeTruncate.getSpans(0, beforeTruncate.length(), Object.class)) {
            int start = beforeTruncate.getSpanStart(span);
            int end = beforeTruncate.getSpanEnd(span);
            if (start != 0 || end != beforeTruncate.length()) continue;
            afterTruncate.removeSpan(span);
            afterTruncate.setSpan(span, 0, afterTruncate.length(), beforeTruncate.getSpanFlags(span));
        }
    }

    private void recalculateLayout(float computedWidth) {
        float contentWidth = WXDomUtils.getContentWidth(this.mComponent.getPadding(), this.mComponent.getBorder(), computedWidth);
        if (contentWidth > 0.0f) {
            this.spanned = this.createSpanned(this.mText);
            if (this.mText != null) {
                this.layout = this.createLayout(contentWidth, this.layout);
                this.previousWidth = this.layout.getWidth();
            } else {
                this.previousWidth = 0.0f;
            }
        }
    }

    private boolean warmUpTextLayoutCache(Layout layout) {
        boolean result;
        try {
            layout.draw(DUMMY_CANVAS);
            result = true;
        }
        catch (Exception e) {
            WXLogUtils.eTag("TextWarmUp", e);
            result = false;
        }
        return result;
    }

    private void swap() {
        if (this.layout != null) {
            this.atomicReference.set(this.layout);
            this.layout = null;
        }
        this.hasBeenMeasured = false;
    }

    class SetSpanOperation {
        protected final int start;
        protected final int end;
        protected final int flag;
        protected final Object what;

        SetSpanOperation(int start, int end, Object what) {
            this(start, end, what, 17);
        }

        SetSpanOperation(int start, int end, Object what, int flag) {
            this.start = start;
            this.end = end;
            this.what = what;
            this.flag = flag;
        }

        public void execute(Spannable sb) {
            sb.setSpan(this.what, this.start, this.end, this.flag);
        }
    }
}

