/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;

public class ImageDrawable
extends PaintDrawable {
    private float[] radii;
    private int bitmapHeight;
    private int bitmapWidth;

    public static Drawable createImageDrawable(@Nullable Drawable original, @NonNull ImageView.ScaleType scaleType, @Nullable float[] borderRadius, int vWidth, int vHeight, boolean gif) {
        if (!gif && vWidth > 0 && vHeight > 0) {
            ImageDrawable imageDrawable;
            Bitmap bm;
            if (original instanceof BitmapDrawable && (bm = ((BitmapDrawable)original).getBitmap()) != null) {
                ImageDrawable imageDrawable2 = new ImageDrawable();
                imageDrawable2.bitmapWidth = bm.getWidth();
                imageDrawable2.bitmapHeight = bm.getHeight();
                BitmapShader bitmapShader = new BitmapShader(bm, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                ImageDrawable.updateShaderAndSize(scaleType, vWidth, vHeight, imageDrawable2, bitmapShader);
                imageDrawable2.getPaint().setShader((Shader)bitmapShader);
                return imageDrawable2;
            }
            if (original instanceof ImageDrawable && (imageDrawable = (ImageDrawable)original).getPaint() != null && imageDrawable.getPaint().getShader() instanceof BitmapShader) {
                BitmapShader bitmapShader = (BitmapShader)imageDrawable.getPaint().getShader();
                ImageDrawable.updateShaderAndSize(scaleType, vWidth, vHeight, imageDrawable, bitmapShader);
                return imageDrawable;
            }
        }
        return original;
    }

    private static void updateShaderAndSize(@NonNull ImageView.ScaleType scaleType, int vWidth, int vHeight, ImageDrawable imageDrawable, BitmapShader bitmapShader) {
        Matrix matrix = ImageDrawable.createShaderMatrix(scaleType, vWidth, vHeight, imageDrawable.bitmapWidth, imageDrawable.bitmapHeight);
        int intrinsicWidth = vWidth;
        int intrinsicHeight = vHeight;
        if (scaleType == ImageView.ScaleType.FIT_CENTER) {
            RectF bitmapRect = new RectF(0.0f, 0.0f, (float)imageDrawable.bitmapWidth, (float)imageDrawable.bitmapHeight);
            RectF contentRect = new RectF();
            matrix.mapRect(contentRect, bitmapRect);
            intrinsicWidth = (int)contentRect.width();
            intrinsicHeight = (int)contentRect.height();
            matrix = ImageDrawable.createShaderMatrix(scaleType, intrinsicWidth, intrinsicHeight, imageDrawable.bitmapWidth, imageDrawable.bitmapHeight);
        }
        imageDrawable.setIntrinsicWidth(intrinsicWidth);
        imageDrawable.setIntrinsicHeight(intrinsicHeight);
        bitmapShader.setLocalMatrix(matrix);
    }

    @NonNull
    private static Matrix createShaderMatrix(@NonNull ImageView.ScaleType scaleType, int vWidth, int vHeight, int bmWidth, int bmHeight) {
        float scale;
        float translateX = 0.0f;
        float translateY = 0.0f;
        if (bmWidth * vHeight > bmHeight * vWidth) {
            scale = (float)vHeight / (float)bmHeight;
            translateX = ((float)vWidth - (float)bmWidth * scale) * 0.5f;
        } else {
            scale = (float)vWidth / (float)bmWidth;
            translateY = ((float)vHeight - (float)bmHeight * scale) * 0.5f;
        }
        Matrix mMatrix = new Matrix();
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            mMatrix.setScale((float)vWidth / (float)bmWidth, (float)vHeight / (float)bmHeight);
        } else if (scaleType == ImageView.ScaleType.FIT_CENTER) {
            RectF src = new RectF(0.0f, 0.0f, (float)bmWidth, (float)bmHeight);
            RectF dist = new RectF(0.0f, 0.0f, (float)vWidth, (float)vHeight);
            mMatrix.setRectToRect(src, dist, Matrix.ScaleToFit.CENTER);
        } else if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            mMatrix.setScale(scale, scale);
            mMatrix.postTranslate(translateX + 0.5f, translateY + 0.5f);
        }
        return mMatrix;
    }

    private ImageDrawable() {
    }

    public void setCornerRadii(float[] radii) {
        this.radii = radii;
        super.setCornerRadii(radii);
    }

    protected void onDraw(Shape shape, Canvas canvas, Paint paint) {
        if (Build.VERSION.SDK_INT == 21) {
            paint.setAntiAlias(false);
        }
        super.onDraw(shape, canvas, paint);
    }

    @Nullable
    public float[] getCornerRadii() {
        return this.radii;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }
}

