/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview.adapter;

import android.graphics.Canvas;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class TransformItemDecoration
extends RecyclerView.ItemDecoration {
    boolean mIsVertical = true;
    float mAlpha = -1.0f;
    int mXTranslate = 0;
    int mYTranslate = 0;
    int mRotation = 0;
    float mScaleX = 0.0f;
    float mScaleY = 0.0f;

    public TransformItemDecoration(boolean isVertical, float alpha, int translateX, int translateY, int rotation, float scaleX, float scaleY) {
        this.mIsVertical = isVertical;
        this.mAlpha = alpha;
        this.mXTranslate = translateX;
        this.mYTranslate = translateY;
        this.mRotation = rotation;
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
        int width = parent.getWidth();
        int height = parent.getHeight();
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.updateItem(parent.getChildAt(i), width, height);
        }
    }

    private void updateItem(View child, int width, int height) {
        int childCenter;
        int size;
        int containerSize;
        if (this.mIsVertical) {
            containerSize = height;
            size = child.getHeight();
            childCenter = child.getTop() + size / 2;
        } else {
            containerSize = width;
            size = child.getWidth();
            childCenter = child.getLeft() + size / 2;
        }
        int actionDistance = (containerSize + size) / 2;
        float effectsAmount = Math.min(1.0f, Math.max(-1.0f, 1.0f / (float)actionDistance * (float)(childCenter - containerSize / 2)));
        if (this.mAlpha > 0.0f) {
            child.setAlpha(1.0f - this.mAlpha * Math.abs(effectsAmount));
        }
        if (this.mScaleX > 0.0f || this.mScaleY > 0.0f) {
            child.setScaleX(1.0f - this.mScaleX * Math.abs(effectsAmount));
            child.setScaleY(1.0f - this.mScaleY * Math.abs(effectsAmount));
        }
        if (this.mRotation != 0) {
            child.setRotation((float)this.mRotation * effectsAmount);
        }
        if (this.mXTranslate != 0) {
            child.setTranslationX((float)this.mXTranslate * Math.abs(effectsAmount));
        }
        if (this.mYTranslate != 0) {
            child.setTranslationY((float)this.mYTranslate * Math.abs(effectsAmount));
        }
    }
}

