/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import com.taobao.weex.ui.component.richtext.span.ImgSpan;
import com.taobao.weex.ui.view.WXTextView;

public class WXRichTextView
extends WXTextView {
    public WXRichTextView(Context context) {
        super(context);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        boolean superResult = super.onTouchEvent(event);
        boolean handled = false;
        if (this.isEnabled() && this.getTextLayout() != null && this.getText() instanceof Spannable) {
            Spannable spannable = (Spannable)this.getText();
            handled = this.updateSelection(event, spannable);
        }
        return handled || superResult;
    }

    protected boolean verifyDrawable(Drawable who) {
        super.verifyDrawable(who);
        return true;
    }

    @Override
    public void setTextLayout(Layout layout) {
        Spanned spanned;
        ImgSpan[] imgSpan;
        super.setTextLayout(layout);
        if (layout.getText() instanceof Spanned && (imgSpan = (ImgSpan[])(spanned = (Spanned)layout.getText()).getSpans(0, spanned.length(), ImgSpan.class)) != null) {
            for (ImgSpan span : imgSpan) {
                span.setView(this);
            }
        }
    }

    private boolean updateSelection(MotionEvent event, Spannable buffer) {
        int action = event.getActionMasked();
        if (action == 1 || action == 0) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= this.getPaddingLeft();
            y -= this.getPaddingTop();
            Layout layout = this.getTextLayout();
            int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += this.getScrollY()), (float)(x += this.getScrollX()));
            ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
            if (link.length != 0) {
                if (action == 1) {
                    link[0].onClick((View)this);
                } else {
                    Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                }
                return true;
            }
            Selection.removeSelection((Spannable)buffer);
        }
        return false;
    }
}

