/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.Spannable;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.layout.measurefunc.TextContentBoxMeasurement;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.richtext.WXRichTextView;
import com.taobao.weex.ui.component.richtext.node.RichTextNode;
import java.lang.reflect.InvocationTargetException;

public class WXRichText
extends WXText {
    public WXRichText(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.setContentBoxMeasurement(new RichTextContentBoxMeasurement(this));
    }

    @Override
    protected WXRichTextView initComponentHostView(@NonNull Context context) {
        return new WXRichTextView(context);
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXRichText(instance, parent, basicComponentData);
        }
    }

    static class RichTextContentBoxMeasurement
    extends TextContentBoxMeasurement {
        public RichTextContentBoxMeasurement(WXComponent component) {
            super(component);
        }

        @Override
        @NonNull
        protected Spanned createSpanned(String text) {
            if (this.mComponent.getInstance() != null & this.mComponent.getInstance().getUIContext() != null && !TextUtils.isEmpty((CharSequence)this.mComponent.getInstanceId())) {
                Spannable spannable = RichTextNode.parse(this.mComponent.getInstance().getUIContext(), this.mComponent.getInstanceId(), this.mComponent.getRef(), text);
                this.updateSpannable(spannable, RichTextNode.createSpanFlag(0));
                return spannable;
            }
            return new SpannedString((CharSequence)"");
        }
    }
}

