/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.binding;

import android.os.Looper;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.bridge.EventResult;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.binding.JSONUtils;
import com.taobao.weex.dom.binding.WXStatement;
import com.taobao.weex.el.parse.ArrayStack;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.el.parse.Token;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.action.GraphicPosition;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.template.CellDataManager;
import com.taobao.weex.ui.component.list.template.CellRenderContext;
import com.taobao.weex.ui.component.list.template.TemplateDom;
import com.taobao.weex.ui.component.list.template.jni.NativeRenderObjectUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Statements {
    private static final ThreadLocal<Map<String, Object>> dynamicLocal = new ThreadLocal();

    public static void parseStatementsToken(WXComponent component) {
        if (component.getBasicComponentData().isRenderPtrEmpty()) {
            component.getBasicComponentData().setRenderObjectPr(component.getRenderObjectPtr());
        }
        if (component.getBasicComponentData() != null) {
            BasicComponentData basicComponentData = component.getBasicComponentData();
            basicComponentData.getAttrs().parseStatements();
            basicComponentData.getStyles().parseStatements();
            basicComponentData.getEvents().parseStatements();
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.getChildCount();
            for (int i = 0; i < count; ++i) {
                Statements.parseStatementsToken(container.getChild(i));
            }
        }
    }

    public static void initLazyComponent(WXComponent component, WXVContainer mParent) {
        if (component.isLazy() || component.getHostView() == null) {
            component.lazy(false);
            if (mParent != null) {
                int index = mParent.indexOf(component);
                mParent.createChildViewAt(index);
            } else {
                component.createView();
            }
            component.applyLayoutAndEvent(component);
            component.bindData(component);
        }
    }

    public static WXComponent copyComponentTree(WXComponent component) {
        WXComponent copy = Statements.copyComponentTree(component, component.getParent());
        return copy;
    }

    private static final WXComponent copyComponentTree(WXComponent source, WXVContainer parent) {
        BasicComponentData basicComponentData = null;
        try {
            basicComponentData = source.getBasicComponentData().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        WXComponent component = WXComponentFactory.newInstance(source.getInstance(), parent, basicComponentData);
        GraphicPosition graphicPosition = source.getLayoutPosition();
        GraphicSize graphicSize = source.getLayoutSize();
        component.updateDemission(graphicPosition.getTop(), graphicPosition.getBottom(), graphicPosition.getLeft(), graphicPosition.getRight(), graphicSize.getHeight(), graphicSize.getWidth());
        component.updateExtra(source.getExtra());
        if (source instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)source;
            WXVContainer childParent = (WXVContainer)component;
            int count = container.getChildCount();
            for (int i = 0; i < count; ++i) {
                WXComponent sourceChild = container.getChild(i);
                if (sourceChild == null) continue;
                WXComponent targetChild = Statements.copyComponentTree(sourceChild, childParent);
                childParent.addChild(targetChild);
                NativeRenderObjectUtils.nativeAddChildRenderObject(childParent.getRenderObjectPtr(), targetChild.getRenderObjectPtr());
            }
        }
        if (source.isWaste()) {
            component.setWaste(true);
        }
        return component;
    }

    public static final List<WXComponent> doRender(WXComponent component, CellRenderContext stack) {
        ArrayList<WXComponent> updates = new ArrayList<WXComponent>(4);
        try {
            Statements.doRenderComponent(component, stack, updates);
        }
        catch (Exception e) {
            WXLogUtils.e("WeexStatementRender", e);
        }
        return updates;
    }

    public static final void doInitCompontent(List<WXComponent> updates) {
        if (updates == null || updates.size() == 0) {
            return;
        }
        for (WXComponent renderNode : updates) {
            if (renderNode.getParent() == null) {
                throw new IllegalArgumentException("render node parent cann't find");
            }
            WXVContainer parent = renderNode.getParent();
            int renderIndex = parent.indexOf(renderNode);
            if (renderIndex < 0) {
                throw new IllegalArgumentException("render node cann't find");
            }
            parent.createChildViewAt(renderIndex);
            renderNode.applyLayoutAndEvent(renderNode);
            renderNode.bindData(renderNode);
        }
    }

    private static final int doRenderComponent(WXComponent component, CellRenderContext context, List<WXComponent> updates) {
        WXVContainer parent = component.getParent();
        WXAttr attrs = component.getAttrs();
        WXStatement statement = attrs.getStatement();
        if (statement != null) {
            Token vif = null;
            JSONObject vfor = null;
            if (statement.get("[[match]]") instanceof Token) {
                vif = (Token)statement.get("[[match]]");
            }
            if (statement.get("[[repeat]]") instanceof JSONObject) {
                vfor = (JSONObject)statement.get("[[repeat]]");
            }
            if (vfor != null) {
                WXComponent wasteNode;
                int renderIndex = parent.indexOf(component);
                if (vfor.get((Object)"@expression") instanceof Token) {
                    Token listBlock = (Token)vfor.get((Object)"@expression");
                    String indexKey = vfor.getString("@index");
                    String itemKey = vfor.getString("@alias");
                    Object data = null;
                    if (listBlock != null) {
                        data = listBlock.execute(context.stack);
                    }
                    if (data instanceof List || data instanceof Map) {
                        Collection<Object> collection = null;
                        Map map = null;
                        if (data instanceof List) {
                            collection = (List)data;
                        } else {
                            map = (Map)data;
                            collection = map.keySet();
                        }
                        HashMap<String, Object> loop = new HashMap<String, Object>();
                        int index = 0;
                        for (Object item : collection) {
                            Object key = null;
                            Object value = item;
                            if (map == null) {
                                key = index;
                                value = item;
                                ++index;
                            } else {
                                key = item;
                                value = map.get(item);
                            }
                            if (indexKey != null) {
                                loop.put(indexKey, key);
                            }
                            if (itemKey != null) {
                                loop.put(itemKey, value);
                            } else {
                                context.stack.push(value);
                            }
                            if (loop.size() > 0) {
                                context.stack.push(loop);
                            }
                            if (vif != null && !Operators.isTrue(vif.execute(context.stack))) continue;
                            WXComponent renderNode = null;
                            if (renderIndex < parent.getChildCount()) {
                                renderNode = parent.getChild(renderIndex);
                                if (!Statements.isCreateFromNodeStatement(renderNode, component)) {
                                    renderNode = null;
                                }
                                if (renderNode != null && renderNode.isWaste()) {
                                    renderNode.setWaste(false);
                                }
                            }
                            if (renderNode == null) {
                                long start = System.currentTimeMillis();
                                renderNode = Statements.copyComponentTree(component, parent);
                                renderNode.setWaste(false);
                                if (renderNode.getAttrs().getStatement() != null) {
                                    renderNode.getAttrs().getStatement().remove("[[repeat]]");
                                    renderNode.getAttrs().getStatement().remove("[[match]]");
                                }
                                parent.addChild(renderNode, renderIndex);
                                NativeRenderObjectUtils.nativeAddChildRenderObject(parent.getRenderObjectPtr(), renderNode.getRenderObjectPtr());
                                updates.add(renderNode);
                                if (WXEnvironment.isApkDebugable()) {
                                    WXLogUtils.d("WXRecyclerTemplateList", Thread.currentThread().getName() + renderNode.getRef() + renderNode.getComponentType() + "statements copy component tree used " + (System.currentTimeMillis() - start));
                                }
                            }
                            Statements.doBindingAttrsEventAndRenderChildNode(renderNode, context, updates);
                            ++renderIndex;
                            if (loop.size() > 0) {
                                context.stack.push(loop);
                            }
                            if (itemKey != null) continue;
                            context.stack.pop();
                        }
                    }
                } else {
                    WXLogUtils.e("WXRecyclerTemplateList", vfor.toJSONString() + " not call vfor block, for pre compile");
                }
                while (renderIndex < parent.getChildCount() && Statements.isCreateFromNodeStatement(wasteNode = parent.getChild(renderIndex), component)) {
                    wasteNode.setWaste(true);
                    ++renderIndex;
                }
                return renderIndex - parent.indexOf(component);
            }
            if (vif != null) {
                if (!Operators.isTrue(vif.execute(context.stack))) {
                    component.setWaste(true);
                    return 1;
                }
                component.setWaste(false);
            }
        }
        Statements.doBindingAttrsEventAndRenderChildNode(component, context, updates);
        return 1;
    }

    private static void doBindingAttrsEventAndRenderChildNode(WXComponent component, CellRenderContext context, List<WXComponent> updates) {
        WXAttr attr = component.getAttrs();
        ArrayStack stack = context.stack;
        String virtualComponentId = null;
        boolean callVirtualComponentAttach = false;
        if (attr.get("@isComponentRoot") != null && WXUtils.getBoolean(attr.get("@isComponentRoot"), false).booleanValue() && attr.get("@componentProps") != null && JSONUtils.isJSON(attr.get("@componentProps"))) {
            Map<String, Object> props;
            String compoentId = (String)attr.get("@templateId");
            Map<String, Object> compoentData = null;
            if (!TextUtils.isEmpty((CharSequence)compoentId)) {
                EventResult result;
                virtualComponentId = context.getRenderState().getVirtualComponentIds().get(component.getViewTreeKey());
                if (virtualComponentId == null) {
                    virtualComponentId = CellDataManager.createVirtualComponentId(context.templateList.getRef(), component.getViewTreeKey(), context.templateList.getItemId(context.position));
                    props = Statements.renderProps(JSONUtils.toJSON(attr.get("@componentProps")), context.stack);
                    result = WXBridgeManager.getInstance().syncCallJSEventWithResult("componentHook", component.getInstanceId(), null, compoentId, "lifecycle", "create", new Object[]{virtualComponentId, props}, null);
                    if (result != null && result.getResult() != null && result.getResult() instanceof Map) {
                        props.putAll((Map)result.getResult());
                    }
                    compoentData = props;
                    context.getRenderState().getVirtualComponentIds().put(component.getViewTreeKey(), virtualComponentId);
                    context.templateList.getCellDataManager().createVirtualComponentData(context.position, virtualComponentId, compoentData);
                    callVirtualComponentAttach = true;
                } else {
                    compoentData = context.getRenderState().getVirtualComponentDatas().get(virtualComponentId);
                    if (context.getRenderState().isHasDataUpdate()) {
                        props = Statements.renderProps((JSONObject)attr.get("@componentProps"), context.stack);
                        result = WXBridgeManager.getInstance().syncCallJSEventWithResult("componentHook", component.getInstanceId(), null, virtualComponentId, "lifecycle", "syncState", new Object[]{virtualComponentId, props}, null);
                        if (result != null && result.getResult() != null && result.getResult() instanceof Map) {
                            props.putAll((Map)result.getResult());
                            context.templateList.getCellDataManager().updateVirtualComponentData(virtualComponentId, props);
                            compoentData = props;
                        }
                    }
                }
                component.getAttrs().put("@virtualComponentId", (Object)virtualComponentId);
            } else {
                compoentData = props = Statements.renderProps((JSONObject)attr.get("@componentProps"), context.stack);
            }
            context.stack = new ArrayStack();
            if (compoentData != null) {
                context.stack.push(compoentData);
            }
        }
        Object vonce = null;
        if (attr.getStatement() != null) {
            vonce = attr.getStatement().get("[[once]]");
        }
        if (vonce != null) {
            ArrayStack onceStack = context.getRenderState().getOnceComponentStates().get(component.getViewTreeKey());
            if (onceStack == null) {
                onceStack = context.templateList.copyStack(context, stack);
                context.getRenderState().getOnceComponentStates().put(component.getViewTreeKey(), onceStack);
            }
            context.stack = onceStack;
        }
        Statements.doRenderBindingAttrsAndEvent(component, context);
        if (component instanceof WXVContainer) {
            WXComponent next;
            if (component.isWaste() && !(component instanceof WXCell)) {
                return;
            }
            WXVContainer container = (WXVContainer)component;
            for (int k = 0; k < container.getChildCount(); k += Statements.doRenderComponent(next, context, updates)) {
                next = container.getChild(k);
            }
        }
        if (stack != context.stack) {
            context.stack = stack;
        }
        if (callVirtualComponentAttach && virtualComponentId != null) {
            WXBridgeManager.getInstance().asyncCallJSEventVoidResult("componentHook", component.getInstanceId(), null, virtualComponentId, "lifecycle", "attach", new Object[]{TemplateDom.findAllComponentRefs(context.templateList.getRef(), context.position, component)});
        }
    }

    private static boolean isCreateFromNodeStatement(WXComponent renderNode, WXComponent component) {
        return renderNode.getRef() != null && renderNode.getRef().equals(component.getRef());
    }

    private static void doRenderBindingAttrsAndEvent(WXComponent component, CellRenderContext context) {
        WXEvent event;
        WXStyle style;
        ArrayStack stack = context.stack;
        component.setWaste(false);
        WXAttr attr = component.getAttrs();
        if (attr != null && attr.getBindingAttrs() != null && attr.getBindingAttrs().size() > 0) {
            ArrayMap<String, Object> bindAttrs = component.getAttrs().getBindingAttrs();
            Map<String, Object> dynamic = Statements.renderBindingAttrs(bindAttrs, stack);
            Set<Map.Entry<String, Object>> entries = dynamic.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                Object oldValue = attr.get(key);
                if (value == null) {
                    if (oldValue != null) continue;
                    iterator.remove();
                    continue;
                }
                if (!value.equals(oldValue)) continue;
                iterator.remove();
            }
            if (dynamic.size() > 0) {
                if (dynamic.size() == 1 && dynamic.get("src") != null && component instanceof WXImage) {
                    component.getAttrs().put("src", dynamic.get("src"));
                } else {
                    component.nativeUpdateAttrs(dynamic);
                }
                if (Statements.isMainThread()) {
                    component.updateProperties(dynamic);
                }
                dynamic.clear();
            }
        }
        if ((style = component.getStyles()) != null && style.getBindingStyle() != null) {
            ArrayMap<String, Object> bindStyle = style.getBindingStyle();
            Map<String, Object> dynamic = Statements.renderBindingAttrs(bindStyle, stack);
            Set<Map.Entry<String, Object>> entries = dynamic.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                Object oldValue = style.get(key);
                if (value == null) {
                    if (oldValue != null) continue;
                    iterator.remove();
                    continue;
                }
                if (!value.equals(oldValue)) continue;
                iterator.remove();
            }
            if (dynamic.size() > 0) {
                component.updateNativeStyles(dynamic);
                if (Statements.isMainThread()) {
                    component.updateProperties(dynamic);
                }
            }
        }
        if ((event = component.getEvents()) == null || event.getEventBindingArgs() == null) {
            return;
        }
        Set eventBindArgsEntrySet = event.getEventBindingArgs().entrySet();
        for (Map.Entry eventBindArgsEntry : eventBindArgsEntrySet) {
            List<Object> values = Statements.getBindingEventArgs(stack, eventBindArgsEntry.getValue());
            if (values == null) continue;
            event.putEventBindingArgsValue((String)eventBindArgsEntry.getKey(), values);
        }
    }

    public static Map<String, Object> renderBindingAttrs(ArrayMap bindAttrs, ArrayStack stack) {
        Set entrySet = bindAttrs.entrySet();
        Map<String, Object> dynamic = dynamicLocal.get();
        if (dynamic == null) {
            dynamic = new HashMap<String, Object>();
            dynamicLocal.set(dynamic);
        }
        if (dynamic.size() > 0) {
            dynamic.clear();
        }
        for (Map.Entry entry : entrySet) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof JSONObject && ((JSONObject)value).get((Object)"@binding") instanceof Token) {
                JSONObject binding = (JSONObject)value;
                Token block = (Token)binding.get((Object)"@binding");
                Object blockValue = block.execute(stack);
                dynamic.put(key, blockValue);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            JSONArray array = (JSONArray)value;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < array.size(); ++i) {
                Object element = array.get(i);
                if (element instanceof CharSequence) {
                    builder.append(element);
                    continue;
                }
                if (!(element instanceof JSONObject) || !(((JSONObject)element).get((Object)"@binding") instanceof Token)) continue;
                JSONObject binding = (JSONObject)element;
                Token block = (Token)binding.get((Object)"@binding");
                Object blockValue = block.execute(stack);
                if (blockValue == null) {
                    blockValue = "";
                }
                builder.append(blockValue);
            }
            String builderString = builder.toString();
            if (builderString.length() > 256 && WXEnvironment.isApkDebugable()) {
                WXLogUtils.w("WXRecyclerTemplateList", " warn too big string " + builderString);
            }
            dynamic.put(key, builderString);
        }
        return dynamic;
    }

    public static Map<String, Object> renderProps(JSONObject props, ArrayStack stack) {
        Set entrySet = props.entrySet();
        ArrayMap renderProps = new ArrayMap(4);
        for (Map.Entry entry : entrySet) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof JSONObject && ((JSONObject)value).get((Object)"@binding") instanceof Token) {
                JSONObject binding = (JSONObject)value;
                Token block = (Token)binding.get((Object)"@binding");
                Object blockValue = block.execute(stack);
                renderProps.put(key, blockValue);
                continue;
            }
            renderProps.put(key, value);
        }
        return renderProps;
    }

    public static List<Object> getBindingEventArgs(ArrayStack stack, Object bindings) {
        ArrayList<Object> params = new ArrayList<Object>(4);
        if (bindings instanceof JSONArray) {
            JSONArray array = (JSONArray)bindings;
            for (int i = 0; i < array.size(); ++i) {
                Object value = array.get(i);
                if (value instanceof JSONObject && ((JSONObject)value).get((Object)"@binding") instanceof Token) {
                    Token block = (Token)((JSONObject)value).get((Object)"@binding");
                    Object blockValue = block.execute(stack);
                    params.add(blockValue);
                    continue;
                }
                params.add(value);
            }
        } else if (bindings instanceof JSONObject) {
            JSONObject binding = (JSONObject)bindings;
            if (binding.get((Object)"@binding") instanceof Token) {
                Token block = (Token)binding.get((Object)"@binding");
                Object blockValue = block.execute(stack);
                params.add(blockValue);
            } else {
                params.add(bindings.toString());
            }
        } else {
            params.add(bindings.toString());
        }
        return params;
    }

    private static boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public static String getComponentId(WXComponent component) {
        if (component instanceof WXCell || component == null) {
            return null;
        }
        WXAttr attr = component.getAttrs();
        if (attr.get("@isComponentRoot") != null && WXUtils.getBoolean(attr.get("@isComponentRoot"), false).booleanValue() && attr.get("@componentProps") != null && attr.get("@componentProps") instanceof JSONObject) {
            Object componentId = attr.get("@virtualComponentId");
            if (componentId == null) {
                return null;
            }
            return componentId.toString();
        }
        return Statements.getComponentId(component.getParent());
    }
}

