/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import android.util.Log;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.performance.IWXAnalyzer;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXUtils;
import java.util.List;
import org.json.JSONObject;

public class WXAnalyzerDataTransfer {
    private static final String GROUP = "WXAnalyzer";
    private static final String MODULE_ERROR = "WXError";
    private static final String MODULE_WX_APM = "wxapm";
    public static boolean isOpenPerformance = false;
    public static final String INTERACTION_TAG = "wxInteractionAnalyzer";
    private static boolean sOpenInteractionLog;

    public static void transferPerformance(String instanceId, String type, String key, Object value) {
        String data;
        List<IWXAnalyzer> transferList;
        if (!isOpenPerformance) {
            return;
        }
        if (sOpenInteractionLog && "stage".equals(type)) {
            Log.d((String)INTERACTION_TAG, (String)("[client][stage]" + instanceId + "," + key + "," + value));
        }
        if (null == (transferList = WXSDKManager.getInstance().getWXAnalyzerList()) || transferList.size() == 0) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getAllInstanceMap().get(instanceId);
        if (null == instance) {
            return;
        }
        try {
            data = new JSONObject().put(key, value).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (IWXAnalyzer transfer : transferList) {
            transfer.transfer(MODULE_WX_APM, instance.getInstanceId(), type, data);
        }
    }

    public static void transferInteractionInfo(WXComponent targetComponent) {
        String data;
        if (!isOpenPerformance) {
            return;
        }
        List<IWXAnalyzer> transferList = WXSDKManager.getInstance().getWXAnalyzerList();
        if (null == transferList || transferList.size() == 0) {
            return;
        }
        long renderOriginDiffTime = WXUtils.getFixUnixTime() - targetComponent.getInstance().getWXPerformance().renderUnixTimeOrigin;
        try {
            data = new JSONObject().put("renderOriginDiffTime", renderOriginDiffTime).put("type", (Object)targetComponent.getComponentType()).put("ref", (Object)targetComponent.getRef()).put("style", (Object)targetComponent.getStyles()).put("attrs", (Object)targetComponent.getAttrs()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (IWXAnalyzer transfer : transferList) {
            transfer.transfer(MODULE_WX_APM, targetComponent.getInstanceId(), "wxinteraction", data);
        }
    }

    public static void transferError(WXJSExceptionInfo exceptionInfo, String instanceId) {
        if (!WXEnvironment.isApkDebugable()) {
            return;
        }
        List<IWXAnalyzer> transferList = WXSDKManager.getInstance().getWXAnalyzerList();
        if (null == transferList || transferList.size() == 0) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (null == instance) {
            return;
        }
        WXErrorCode errorCode = exceptionInfo.getErrCode();
        String data = "";
        try {
            data = new JSONObject().put("instanceId", (Object)instanceId).put("url", (Object)instance.getBundleUrl()).put("errorCode", (Object)errorCode.getErrorCode()).put("errorMsg", (Object)errorCode.getErrorMsg()).put("errorGroup", (Object)errorCode.getErrorGroup()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IWXAnalyzer transfer : transferList) {
            transfer.transfer(GROUP, MODULE_ERROR, errorCode.getErrorType().toString(), data);
        }
    }

    public static void switchInteractionLog(final boolean isOpen) {
        if (sOpenInteractionLog == isOpen || !WXEnvironment.JsFrameworkInit) {
            return;
        }
        sOpenInteractionLog = isOpen;
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                WXJSObject[] args = new WXJSObject[]{new WXJSObject(isOpen ? 1 : 0)};
                WXBridgeManager.getInstance().invokeExecJS("", null, "switchInteractionLog", args, false);
            }
        });
        WXBridgeManager.getInstance().registerCoreEnv("switchInteractionLog", String.valueOf(isOpen));
    }

    public static boolean isInteractionLogOpen() {
        return sOpenInteractionLog;
    }
}

