/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.websocket;

import android.os.Looper;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.WebSocketCloseCodes;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;

public class WebSocketModule
extends WXSDKEngine.DestroyableModule {
    private static final String TAG = "WebSocketModule";
    private static final String KEY_DATA = "data";
    private static final String KEY_CODE = "code";
    private static final String KEY_REASON = "reason";
    private static final String KEY_WAS_CLEAN = "wasClean";
    private IWebSocketAdapter webSocketAdapter;
    private WebSocketEventListener eventListener;

    public WebSocketModule() {
        WXLogUtils.e(TAG, "create new instance");
    }

    @JSMethod(uiThread=false)
    public void WebSocket(String url, String protocol) {
        if (this.webSocketAdapter != null) {
            WXLogUtils.w(TAG, "close");
            this.webSocketAdapter.close(WebSocketCloseCodes.CLOSE_GOING_AWAY.getCode(), WebSocketCloseCodes.CLOSE_GOING_AWAY.name());
        }
        this.webSocketAdapter = this.mWXSDKInstance.getWXWebSocketAdapter();
        if (!this.reportErrorIfNoAdapter()) {
            this.eventListener = new WebSocketEventListener();
            this.webSocketAdapter.connect(url, protocol, this.eventListener);
        }
    }

    @JSMethod(uiThread=false)
    public void send(String data) {
        if (!this.reportErrorIfNoAdapter()) {
            this.webSocketAdapter.send(data);
        }
    }

    @JSMethod(uiThread=false)
    public void close(String code, String reason) {
        if (!this.reportErrorIfNoAdapter()) {
            int codeNumber = WebSocketCloseCodes.CLOSE_NORMAL.getCode();
            if (code != null) {
                try {
                    codeNumber = Integer.parseInt(code);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.webSocketAdapter.close(codeNumber, reason);
        }
    }

    @JSMethod(uiThread=false)
    public void onopen(JSCallback callback) {
        if (this.eventListener != null) {
            this.eventListener.onOpen = callback;
        }
    }

    @JSMethod(uiThread=false)
    public void onmessage(JSCallback callback) {
        if (this.eventListener != null) {
            this.eventListener.onMessage = callback;
        }
    }

    @JSMethod(uiThread=false)
    public void onclose(JSCallback callback) {
        if (this.eventListener != null) {
            this.eventListener.onClose = callback;
        }
    }

    @JSMethod(uiThread=false)
    public void onerror(JSCallback callback) {
        if (this.eventListener != null) {
            this.eventListener.onError = callback;
        }
    }

    @Override
    public void destroy() {
        Runnable destroyTask = new Runnable(){

            @Override
            public void run() {
                WXLogUtils.w(WebSocketModule.TAG, "close session with instance id " + WebSocketModule.this.mWXSDKInstance.getInstanceId());
                if (WebSocketModule.this.webSocketAdapter != null) {
                    WebSocketModule.this.webSocketAdapter.destroy();
                }
                WebSocketModule.this.webSocketAdapter = null;
                WebSocketModule.this.eventListener = null;
            }
        };
        if (Looper.myLooper() == Looper.getMainLooper()) {
            WXBridgeManager.getInstance().post(destroyTask);
        } else {
            destroyTask.run();
        }
    }

    private boolean reportErrorIfNoAdapter() {
        if (this.webSocketAdapter == null) {
            if (this.eventListener != null) {
                this.eventListener.onError("No implementation found for IWebSocketAdapter");
            }
            WXLogUtils.e(TAG, "No implementation found for IWebSocketAdapter");
            return true;
        }
        return false;
    }

    private class WebSocketEventListener
    implements IWebSocketAdapter.EventListener {
        private JSCallback onOpen;
        private JSCallback onClose;
        private JSCallback onError;
        private JSCallback onMessage;

        private WebSocketEventListener() {
        }

        @Override
        public void onOpen() {
            if (this.onOpen != null) {
                this.onOpen.invoke(new HashMap(0));
            }
        }

        @Override
        public void onMessage(String data) {
            if (this.onMessage != null) {
                HashMap<String, String> msg = new HashMap<String, String>(1);
                msg.put(WebSocketModule.KEY_DATA, data);
                this.onMessage.invokeAndKeepAlive(msg);
            }
        }

        @Override
        public void onClose(int code, String reason, boolean wasClean) {
            if (this.onClose != null) {
                HashMap<String, Object> msg = new HashMap<String, Object>(3);
                msg.put(WebSocketModule.KEY_CODE, code);
                msg.put(WebSocketModule.KEY_REASON, reason);
                msg.put(WebSocketModule.KEY_WAS_CLEAN, wasClean);
                this.onClose.invoke(msg);
            }
        }

        @Override
        public void onError(String msg) {
            if (this.onError != null) {
                HashMap<String, String> info = new HashMap<String, String>(1);
                info.put(WebSocketModule.KEY_DATA, msg);
                this.onError.invokeAndKeepAlive(info);
            }
        }
    }
}

