/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StickyHeaderHelper {
    private final ViewGroup mParent;
    private Map<String, View> mHeaderViews = new HashMap<String, View>();
    private Map<String, WXCell> mHeaderComps = new HashMap<String, WXCell>();
    private String mCurrentStickyRef = null;

    public StickyHeaderHelper(ViewGroup parent) {
        this.mParent = parent;
    }

    public void notifyStickyShow(WXCell component) {
        if (component == null) {
            return;
        }
        this.mHeaderComps.put(component.getRef(), component);
        if (this.mCurrentStickyRef != null) {
            WXCell cell = this.mHeaderComps.get(this.mCurrentStickyRef);
            if (cell == null || component.getScrollPositon() > cell.getScrollPositon()) {
                this.mCurrentStickyRef = component.getRef();
            }
        } else {
            this.mCurrentStickyRef = component.getRef();
        }
        if (this.mCurrentStickyRef == null) {
            WXLogUtils.e("Current Sticky ref is null.");
            return;
        }
        WXCell headComponent = this.mHeaderComps.get(this.mCurrentStickyRef);
        ViewGroup headerView = headComponent.getRealView();
        if (headerView == null) {
            WXLogUtils.e("Sticky header's real view is null.");
            return;
        }
        View header = this.mHeaderViews.get(headComponent.getRef());
        if (header != null) {
            header.bringToFront();
        } else {
            this.mHeaderViews.put(headComponent.getRef(), (View)headerView);
            float translationX = headerView.getTranslationX();
            float translationY = headerView.getTranslationY();
            headComponent.removeSticky();
            ViewGroup existedParent = (ViewGroup)headerView.getParent();
            if (existedParent != null) {
                existedParent.removeView((View)headerView);
            }
            headerView.setTag((Object)headComponent.getRef());
            this.mParent.addView((View)headerView);
            headerView.setTag((Object)this);
            if (headComponent.getStickyOffset() > 0) {
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)headerView.getLayoutParams();
                if (headComponent.getStickyOffset() != params.topMargin) {
                    params.topMargin = headComponent.getStickyOffset();
                }
            }
            headerView.setTranslationX(translationX);
            headerView.setTranslationY(translationY);
        }
        this.changeFrontStickyVisible();
        if (headComponent.getEvents().contains("sticky")) {
            headComponent.fireEvent("sticky");
        }
    }

    public void notifyStickyRemove(WXCell compToRemove) {
        if (compToRemove == null) {
            return;
        }
        final WXCell component = this.mHeaderComps.remove(compToRemove.getRef());
        final View headerView = this.mHeaderViews.remove(compToRemove.getRef());
        if (component == null || headerView == null) {
            if (WXEnvironment.isApkDebugable()) {
                // empty if block
            }
            return;
        }
        if (this.mCurrentStickyRef != null && this.mCurrentStickyRef.equals(compToRemove.getRef())) {
            this.mCurrentStickyRef = null;
        }
        this.mParent.post(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                StickyHeaderHelper.this.mParent.removeView(headerView);
                if (headerView.getVisibility() != 0) {
                    headerView.setVisibility(0);
                }
                component.recoverySticky();
                StickyHeaderHelper.this.changeFrontStickyVisible();
            }
        }));
        if (component.getEvents().contains("unsticky")) {
            component.fireEvent("unsticky");
        }
    }

    public void updateStickyView(int currentStickyPos) {
        Iterator<Map.Entry<String, WXCell>> iterator = this.mHeaderComps.entrySet().iterator();
        ArrayList<WXCell> toRemove = new ArrayList<WXCell>();
        while (iterator.hasNext()) {
            Map.Entry<String, WXCell> next = iterator.next();
            WXCell cell = next.getValue();
            int pos = cell.getScrollPositon();
            if (pos > currentStickyPos) {
                toRemove.add(cell);
                continue;
            }
            if (pos != currentStickyPos) continue;
            this.mCurrentStickyRef = cell.getRef();
            View view = this.mHeaderViews.get(cell.getRef());
            if (view == null) continue;
            view.bringToFront();
            this.changeFrontStickyVisible();
        }
        for (WXCell cell : toRemove) {
            this.notifyStickyRemove(cell);
        }
    }

    public void clearStickyHeaders() {
        if (this.mHeaderViews.size() <= 0) {
            return;
        }
        Set<String> keys = this.mHeaderViews.keySet();
        for (String key : keys) {
            this.notifyStickyRemove(this.mHeaderComps.get(key));
        }
    }

    private void changeFrontStickyVisible() {
        if (this.mHeaderViews.size() <= 0) {
            return;
        }
        boolean fontVisible = false;
        for (int i = this.mParent.getChildCount() - 1; i >= 0; --i) {
            View view = this.mParent.getChildAt(i);
            if (fontVisible && view.getTag() instanceof StickyHeaderHelper) {
                if (view.getVisibility() == 8) continue;
                view.setVisibility(8);
                continue;
            }
            if (!(view.getTag() instanceof StickyHeaderHelper)) continue;
            fontVisible = true;
            if (view == null || view.getVisibility() == 0) continue;
            view.setVisibility(0);
        }
    }
}

