/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.utils.WXViewUtils;

public class GapItemDecoration
extends RecyclerView.ItemDecoration {
    private WXListComponent listComponent;

    public GapItemDecoration(WXListComponent listComponent) {
        this.listComponent = listComponent;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        Float[] spanOffsets = this.listComponent.getSpanOffsets();
        if (spanOffsets == null) {
            return;
        }
        int position = parent.getChildAdapterPosition(view);
        if (position < 0) {
            return;
        }
        if (view.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams();
            if (params.isFullSpan()) {
                return;
            }
            WXComponent component = this.listComponent.getChild(position);
            if (component instanceof WXCell) {
                int spanOffsetPx;
                WXCell cell = (WXCell)component;
                if (cell.isFixed() || cell.isSticky()) {
                    return;
                }
                if (params.getSpanIndex() >= spanOffsets.length) {
                    return;
                }
                float spanOffset = this.listComponent.getSpanOffsets()[params.getSpanIndex()].floatValue();
                outRect.left = spanOffsetPx = Math.round(WXViewUtils.getRealPxByWidth(spanOffset, this.listComponent.getViewPortWidth()));
                outRect.right = -spanOffsetPx;
            }
        }
    }
}

