/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.support.v7.widget.helper.ItemTouchHelper;
import com.taobao.weex.ui.component.list.DragHelper;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.utils.WXLogUtils;

class DragSupportCallback
extends ItemTouchHelper.Callback {
    private final DragHelper mDragHelper;
    private boolean mEnableDifferentViewTypeDrag = false;
    private int dragFrom = -1;
    private int dragTo = -1;
    private static final String TAG = "WXListExComponent";

    DragSupportCallback(@NonNull DragHelper DragHelper2) {
        this.mDragHelper = DragHelper2;
        this.mEnableDifferentViewTypeDrag = false;
    }

    DragSupportCallback(@NonNull DragHelper DragHelper2, boolean enableDifferentViewTypeDrag) {
        this.mDragHelper = DragHelper2;
        this.mEnableDifferentViewTypeDrag = enableDifferentViewTypeDrag;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager || recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            int dragFlags = 15;
            int swipeFlags = 0;
            return DragSupportCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }
        int dragFlags = 3;
        int swipeFlags = 48;
        return DragSupportCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        if (viewHolder == null || target == null) {
            return false;
        }
        if (!this.mEnableDifferentViewTypeDrag && viewHolder.getItemViewType() != target.getItemViewType()) {
            return false;
        }
        if (this.mDragHelper.isDragExcluded(viewHolder)) {
            return false;
        }
        try {
            int fromPos = viewHolder.getAdapterPosition();
            int toPos = target.getAdapterPosition();
            if (this.dragFrom == -1) {
                this.dragFrom = fromPos;
            }
            this.dragTo = toPos;
            this.mDragHelper.onDragging(fromPos, toPos);
            return true;
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e.getMessage());
            return false;
        }
    }

    public boolean isLongPressDragEnabled() {
        return this.mDragHelper.isDraggable() && this.mDragHelper.isLongPressDragEnabled();
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
    }

    public boolean isItemViewSwipeEnabled() {
        return false;
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        ListBaseViewHolder vh;
        if (actionState != 0 && viewHolder instanceof ListBaseViewHolder && (vh = (ListBaseViewHolder)viewHolder).getComponent() != null) {
            this.mDragHelper.onDragStart(vh.getComponent(), vh.getAdapterPosition());
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        ListBaseViewHolder vh;
        super.clearView(recyclerView, viewHolder);
        if (viewHolder instanceof ListBaseViewHolder && (vh = (ListBaseViewHolder)viewHolder).getComponent() != null && this.dragFrom != -1 && this.dragTo != -1) {
            this.mDragHelper.onDragEnd(vh.getComponent(), this.dragFrom, this.dragTo);
        }
        this.dragTo = -1;
        this.dragFrom = -1;
    }
}

