/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.WXComponentRegistry;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WXComponentFactory {
    private static Map<String, Set<String>> sComponentTypes = new HashMap<String, Set<String>>();

    public static Set<String> getComponentTypesByInstanceId(String instanceId) {
        return sComponentTypes.get(instanceId);
    }

    public static void removeComponentTypesByInstanceId(String instanceId) {
        sComponentTypes.remove(instanceId);
    }

    public static WXComponent newInstance(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        if (instance == null || TextUtils.isEmpty((CharSequence)basicComponentData.mComponentType)) {
            return null;
        }
        if (sComponentTypes.get(instance.getInstanceId()) == null) {
            HashSet types = new HashSet();
            sComponentTypes.put(instance.getInstanceId(), types);
        }
        sComponentTypes.get(instance.getInstanceId()).add(basicComponentData.mComponentType);
        IFComponentHolder holder = WXComponentRegistry.getComponent(basicComponentData.mComponentType);
        if (holder == null) {
            if (WXEnvironment.isApkDebugable()) {
                String tag = "WXComponentFactory error type:[" + basicComponentData.mComponentType + "] class not found";
                WXLogUtils.e(tag);
            }
            if ((holder = WXComponentRegistry.getComponent("container")) == null) {
                throw new WXRuntimeException("Container component not found.");
            }
        }
        try {
            return holder.createInstance(instance, parent, basicComponentData);
        }
        catch (Throwable e) {
            WXLogUtils.e("WXComponentFactory Exception type:[" + basicComponentData.mComponentType + "] ", e);
            return null;
        }
    }
}

