/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.support.v4.util.ArrayMap;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.action.BasicGraphicAction;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXVContainer;
import java.util.Map;
import java.util.Set;

public abstract class GraphicActionAbstractAddElement
extends BasicGraphicAction {
    protected String mComponentType;
    protected String mParentRef;
    protected int mIndex = -1;
    protected Map<String, String> mStyle;
    protected Map<String, String> mAttributes;
    protected Set<String> mEvents;
    protected float[] mMargins;
    protected float[] mPaddings;
    protected float[] mBorders;
    private long startTime = System.currentTimeMillis();

    public GraphicActionAbstractAddElement(String pageId, String ref) {
        super(pageId, ref);
    }

    protected WXComponent createComponent(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        long createComponentStart = System.currentTimeMillis();
        if (basicComponentData != null) {
            basicComponentData.addStyle(this.mStyle);
            basicComponentData.addAttr(this.mAttributes);
            basicComponentData.addEvent(this.mEvents);
            basicComponentData.addShorthand(this.mMargins, CSSShorthand.TYPE.MARGIN);
            basicComponentData.addShorthand(this.mPaddings, CSSShorthand.TYPE.PADDING);
            basicComponentData.addShorthand(this.mBorders, CSSShorthand.TYPE.BORDER);
        }
        WXComponent component = WXComponentFactory.newInstance(instance, parent, basicComponentData);
        WXSDKManager.getInstance().getWXRenderManager().registerComponent(this.getPageId(), this.getRef(), component);
        if (this.mStyle.containsKey("transform") && component.getTransition() == null) {
            ArrayMap animationMap = new ArrayMap(2);
            animationMap.put("transform", this.mStyle.get("transform"));
            animationMap.put("transformOrigin", this.mStyle.get("transformOrigin"));
            component.addAnimationForElement((Map<String, Object>)animationMap);
        }
        instance.onComponentCreate(component, System.currentTimeMillis() - createComponentStart);
        return component;
    }

    @Override
    public void executeAction() {
        WXSDKManager.getInstance().getSDKInstance(this.getPageId()).callActionAddElementTime(System.currentTimeMillis() - this.startTime);
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getParentRef() {
        return this.mParentRef;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public Map<String, String> getStyle() {
        return this.mStyle;
    }

    public Map<String, String> getAttributes() {
        return this.mAttributes;
    }

    public Set<String> getEvents() {
        return this.mEvents;
    }
}

