/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.bridge.EventResult;
import com.taobao.weex.bridge.WXBridge;
import com.taobao.weex.bridge.WXHashMap;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.bridge.WXJsFunctions;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.bridge.WXServiceManager;
import com.taobao.weex.bridge.WXValidateProcessor;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.common.IWXDebugProxy;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.WXComponentRegistry;
import com.taobao.weex.ui.action.ActionReloadPage;
import com.taobao.weex.ui.action.GraphicActionAddElement;
import com.taobao.weex.ui.action.GraphicActionAddEvent;
import com.taobao.weex.ui.action.GraphicActionAppendTreeCreateFinish;
import com.taobao.weex.ui.action.GraphicActionCreateBody;
import com.taobao.weex.ui.action.GraphicActionCreateFinish;
import com.taobao.weex.ui.action.GraphicActionLayout;
import com.taobao.weex.ui.action.GraphicActionMoveElement;
import com.taobao.weex.ui.action.GraphicActionRefreshFinish;
import com.taobao.weex.ui.action.GraphicActionRemoveElement;
import com.taobao.weex.ui.action.GraphicActionRemoveEvent;
import com.taobao.weex.ui.action.GraphicActionUpdateAttr;
import com.taobao.weex.ui.action.GraphicActionUpdateStyle;
import com.taobao.weex.ui.action.GraphicPosition;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.module.WXDomModule;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import com.taobao.weex.utils.WXWsonJSONSwitch;
import com.taobao.weex.utils.batch.BactchExecutor;
import com.taobao.weex.utils.batch.Interceptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class WXBridgeManager
implements Handler.Callback,
BactchExecutor {
    public static final String METHOD_CREATE_INSTANCE = "createInstance";
    public static final String METHOD_DESTROY_INSTANCE = "destroyInstance";
    public static final String METHOD_CALL_JS = "callJS";
    public static final String METHOD_SET_TIMEOUT = "setTimeoutCallback";
    public static final String METHOD_REGISTER_MODULES = "registerModules";
    public static final String METHOD_REGISTER_COMPONENTS = "registerComponents";
    public static final String METHOD_FIRE_EVENT = "fireEvent";
    public static final String METHD_FIRE_EVENT_SYNC = "fireEventSync";
    public static final String METHD_COMPONENT_HOOK_SYNC = "componentHook";
    public static final String METHOD_CALLBACK = "callback";
    public static final String METHOD_REFRESH_INSTANCE = "refreshInstance";
    public static final String METHOD_NOTIFY_TRIM_MEMORY = "notifyTrimMemory";
    public static final String METHOD_NOTIFY_SERIALIZE_CODE_CACHE = "notifySerializeCodeCache";
    public static final String KEY_METHOD = "method";
    public static final String KEY_ARGS = "args";
    public static final String COMPONENT = "component";
    public static final String REF = "ref";
    public static final String MODULE = "module";
    public static final String METHOD = "method";
    public static final String KEY_PARAMS = "params";
    public static final String ARGS = "args";
    public static final String OPTIONS = "options";
    public static final String INITLOGFILE = "/jsserver_start.log";
    private static final String NON_CALLBACK = "-1";
    private static final String UNDEFINED = "undefined";
    private static final String BUNDLE_TYPE = "bundleType";
    private static final int INIT_FRAMEWORK_OK = 1;
    private static final int CRASHREINIT = 50;
    static volatile WXBridgeManager mBridgeManager;
    private static long LOW_MEM_VALUE;
    private static volatile int reInitCount;
    private static String crashUrl;
    private static long lastCrashTime;
    private static String mRaxApi;
    private static volatile boolean isSandBoxContext;
    private static boolean isUseSingleProcess;
    private static final boolean BRIDGE_LOG_SWITCH = false;
    private static volatile boolean mInit;
    private static String globalConfig;
    private static String GLOBAL_CONFIG_KEY;
    private static Map<String, String> mWeexCoreEnvOptions;
    Handler mJSHandler;
    private WXHashMap<String, ArrayList<WXHashMap<String, Object>>> mNextTickTasks = new WXHashMap();
    private WXThread mJSThread;
    private IWXBridge mWXBridge;
    private IWXDebugProxy mWxDebugProxy;
    private boolean mMock = false;
    private List<Map<String, Object>> mRegisterComponentFailList = new ArrayList<Map<String, Object>>(8);
    private List<Map<String, Object>> mRegisterModuleFailList = new ArrayList<Map<String, Object>>(8);
    private List<String> mRegisterServiceFailList = new ArrayList<String>(8);
    private List<String> mDestroyedInstanceId = new ArrayList<String>();
    private StringBuilder mLodBuilder = new StringBuilder(50);
    private Interceptor mInterceptor;
    private WXParams mInitParams;

    private WXBridgeManager() {
        this.initWXBridge(WXEnvironment.sRemoteDebugMode);
        this.mJSThread = new WXThread("WeexJSBridgeThread", this);
        this.mJSHandler = this.mJSThread.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXBridgeManager getInstance() {
        if (mBridgeManager != null) return mBridgeManager;
        Class<WXBridgeManager> clazz = WXBridgeManager.class;
        synchronized (WXBridgeManager.class) {
            if (mBridgeManager != null) return mBridgeManager;
            mBridgeManager = new WXBridgeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mBridgeManager;
        }
    }

    public void setUseSingleProcess(boolean flag) {
        if (flag != isUseSingleProcess) {
            isUseSingleProcess = flag;
        }
    }

    public void setSandBoxContext(boolean flag) {
        if (flag != isSandBoxContext) {
            isSandBoxContext = flag;
            if (this.isJSThread()) {
                this.setJSFrameworkInit(false);
                WXModuleManager.resetAllModuleState();
                String jsf = "";
                jsf = !isSandBoxContext || WXEnvironment.sDebugServerConnectable ? WXFileUtils.loadAsset("main.js", (Context)WXEnvironment.getApplication()) : WXFileUtils.loadAsset("weex-main-jsfm.js", (Context)WXEnvironment.getApplication());
                this.initFramework(jsf);
                WXServiceManager.reload();
                WXModuleManager.reload();
                WXComponentRegistry.reload();
            } else {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        WXBridgeManager.this.setJSFrameworkInit(false);
                        WXModuleManager.resetAllModuleState();
                        String jsf = "";
                        jsf = !isSandBoxContext || WXEnvironment.sDebugServerConnectable ? WXFileUtils.loadAsset("main.js", (Context)WXEnvironment.getApplication()) : WXFileUtils.loadAsset("weex-main-jsfm.js", (Context)WXEnvironment.getApplication());
                        WXBridgeManager.this.initFramework(jsf);
                        WXServiceManager.reload();
                        WXModuleManager.reload();
                        WXComponentRegistry.reload();
                    }
                }, null);
            }
        }
    }

    private boolean isJSFrameworkInit() {
        return mInit;
    }

    private void setJSFrameworkInit(boolean init) {
        mInit = init;
        if (init) {
            this.onJsFrameWorkInitSuccees();
        }
    }

    private void initWXBridge(boolean remoteDebug) {
        if (remoteDebug && WXEnvironment.isApkDebugable()) {
            WXEnvironment.sDebugServerConnectable = true;
        }
        if (this.mWxDebugProxy != null) {
            this.mWxDebugProxy.stop(false);
        }
        if (WXEnvironment.sDebugServerConnectable && WXEnvironment.isApkDebugable()) {
            if (WXEnvironment.getApplication() != null) {
                try {
                    Constructor<?> constructor;
                    Class<?> clazz = Class.forName("com.taobao.weex.devtools.debug.DebugServerProxy");
                    if (clazz != null && (constructor = clazz.getConstructor(Context.class, WXBridgeManager.class)) != null) {
                        this.mWxDebugProxy = (IWXDebugProxy)constructor.newInstance(WXEnvironment.getApplication(), this);
                        if (this.mWxDebugProxy != null) {
                            this.mWxDebugProxy.start(new WXJsFunctions());
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                WXServiceManager.execAllCacheJsService();
            } else {
                WXLogUtils.e("WXBridgeManager", "WXEnvironment.sApplication is null, skip init Inspector");
                WXLogUtils.w("WXBridgeManager", new Throwable("WXEnvironment.sApplication is null when init Inspector"));
            }
        }
        this.mWXBridge = remoteDebug && this.mWxDebugProxy != null ? this.mWxDebugProxy.getWXBridge() : new WXBridge();
    }

    public void stopRemoteDebug() {
        if (this.mWxDebugProxy != null) {
            this.mWxDebugProxy.stop(true);
        }
    }

    public Object callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args) {
        return this.callModuleMethod(instanceId, moduleStr, methodStr, args, null);
    }

    public Object callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args, JSONObject options) {
        WXSDKInstance wxsdkInstance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (wxsdkInstance == null) {
            return null;
        }
        if (wxsdkInstance.isNeedValidate() && WXSDKManager.getInstance().getValidateProcessor() != null) {
            WXValidateProcessor.WXModuleValidateResult validateResult = WXSDKManager.getInstance().getValidateProcessor().onModuleValidate(wxsdkInstance, moduleStr, methodStr, args, options);
            if (validateResult == null) {
                return null;
            }
            if (validateResult.isSuccess) {
                return WXModuleManager.callModuleMethod(instanceId, moduleStr, methodStr, args);
            }
            JSONObject validateInfo = validateResult.validateInfo;
            if (validateInfo != null) {
                WXLogUtils.e("[WXBridgeManager] module validate fail. >>> " + validateInfo.toJSONString());
            }
            return validateInfo;
        }
        return WXModuleManager.callModuleMethod(instanceId, moduleStr, methodStr, args);
    }

    public void restart() {
        this.setJSFrameworkInit(false);
        WXModuleManager.resetAllModuleState();
        this.initWXBridge(WXEnvironment.sRemoteDebugMode);
    }

    public synchronized void setStackTopInstance(final String instanceId) {
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.mNextTickTasks.setStackTopInstance(instanceId);
            }
        }, instanceId);
    }

    @Override
    public void post(Runnable r) {
        if (this.mInterceptor != null && this.mInterceptor.take(r)) {
            return;
        }
        if (this.mJSHandler == null) {
            return;
        }
        this.mJSHandler.post(WXThread.secure(r));
    }

    @Override
    public void setInterceptor(Interceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    public void post(Runnable r, Object token) {
        if (this.mJSHandler == null) {
            return;
        }
        Message m = Message.obtain((Handler)this.mJSHandler, (Runnable)WXThread.secure(r));
        m.obj = token;
        m.sendToTarget();
    }

    void setTimeout(String callbackId, String time) {
        Message message = Message.obtain();
        message.what = 1;
        TimerInfo timerInfo = new TimerInfo();
        timerInfo.callbackId = callbackId;
        timerInfo.time = (long)Float.parseFloat(time);
        message.obj = timerInfo;
        this.mJSHandler.sendMessageDelayed(message, timerInfo.time);
    }

    public void sendMessageDelayed(Message message, long delayMillis) {
        if (message == null || this.mJSHandler == null || this.mJSThread == null || !this.mJSThread.isWXThreadAlive() || this.mJSThread.getLooper() == null) {
            return;
        }
        this.mJSHandler.sendMessageDelayed(message, delayMillis);
    }

    public void removeMessage(int what, Object obj) {
        if (this.mJSHandler == null || this.mJSThread == null || !this.mJSThread.isWXThreadAlive() || this.mJSThread.getLooper() == null) {
            return;
        }
        this.mJSHandler.removeMessages(what, obj);
    }

    public Object callNativeModule(String instanceId, String module, String method, JSONArray arguments, Object options) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        try {
            if ("dom".equals(module)) {
                WXDomModule dom = WXModuleManager.getDomModule(instanceId);
                return dom.callDomMethod(method, arguments, new long[0]);
            }
            return this.callModuleMethod(instanceId, module, method, arguments);
        }
        catch (Exception e) {
            String err = "[WXBridgeManager] callNative exception: " + WXLogUtils.getStackTrace(e);
            WXLogUtils.e(err);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callNativeModule", err, null);
            return null;
        }
    }

    public Object callNativeModule(String instanceId, String module, String method, JSONArray arguments, JSONObject options) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        try {
            if ("dom".equals(module)) {
                WXDomModule dom = WXModuleManager.getDomModule(instanceId);
                if (dom != null) {
                    return dom.callDomMethod(method, arguments, new long[0]);
                }
            } else {
                return this.callModuleMethod(instanceId, module, method, arguments, options);
            }
            WXModuleManager.createDomModule(WXSDKManager.getInstance().getSDKInstance(instanceId));
        }
        catch (Exception e) {
            String err = "[WXBridgeManager] callNative exception: " + WXLogUtils.getStackTrace(e);
            WXLogUtils.e(err);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callNativeModule", err, null);
        }
        return null;
    }

    public Object callNativeComponent(String instanceId, String componentRef, String method, JSONArray arguments, Object options) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        try {
            WXDomModule dom = WXModuleManager.getDomModule(instanceId);
            dom.invokeMethod(componentRef, method, arguments);
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callNative exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callNativeComponent", WXLogUtils.getStackTrace(e), null);
        }
        return null;
    }

    public int callNative(String instanceId, JSONArray tasks, String callback) {
        if (tasks == null) {
            String err = "[WXBridgeManager] callNative: call Native tasks is null";
            WXLogUtils.e(err);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callNative", err + "| INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        long parseNanos = System.nanoTime();
        JSONArray array = tasks;
        parseNanos = System.nanoTime() - parseNanos;
        if (null != array && array.size() > 0) {
            int size = array.size();
            try {
                for (int i = 0; i < size; ++i) {
                    WXDomModule dom;
                    JSONObject task = (JSONObject)array.get(i);
                    if (task == null || WXSDKManager.getInstance().getSDKInstance(instanceId) == null) continue;
                    Object module = task.get((Object)MODULE);
                    if (module != null) {
                        if ("dom".equals(module)) {
                            dom = WXModuleManager.getDomModule(instanceId);
                            dom.callDomMethod(task, parseNanos);
                            continue;
                        }
                        JSONObject optionObj = task.getJSONObject(OPTIONS);
                        this.callModuleMethod(instanceId, (String)module, (String)task.get((Object)"method"), (JSONArray)task.get((Object)"args"), optionObj);
                        continue;
                    }
                    if (task.get((Object)COMPONENT) != null) {
                        dom = WXModuleManager.getDomModule(instanceId);
                        dom.invokeMethod((String)task.get((Object)REF), (String)task.get((Object)"method"), (JSONArray)task.get((Object)"args"));
                        continue;
                    }
                    throw new IllegalArgumentException("unknown callNative");
                }
            }
            catch (Exception e) {
                WXLogUtils.e("[WXBridgeManager] callNative exception: ", e);
                WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callNative", WXLogUtils.getStackTrace(e), null);
            }
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int callUpdateFinish(String instanceId, String callback) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) == null) {
                // empty if block
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callUpdateFinish", WXLogUtils.getStackTrace(e), null);
        }
        if (!(callback == null || callback.isEmpty() || UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback))) {
            this.getNextTick(instanceId, callback);
            return 1;
        }
        return 0;
    }

    public int callRefreshFinish(String instanceId, String callback) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                GraphicActionRefreshFinish action = new GraphicActionRefreshFinish(instanceId);
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(instanceId, action);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRefreshFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callRefreshFinish", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callReportCrashReloadPage(String instanceId, String crashFile) {
        try {
            String url = null;
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                url = instance.getBundleUrl();
            }
            try {
                if (WXEnvironment.getApplication() != null) {
                    crashFile = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath() + crashFile;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.callReportCrash(crashFile, instanceId, url);
            if (reInitCount > 50) {
                return 0;
            }
            ++reInitCount;
            this.setJSFrameworkInit(false);
            WXModuleManager.resetAllModuleState();
            this.initScriptsFramework("");
            if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
                return -1;
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callReportCrashReloadPage exception: ", e);
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                boolean reloadThisInstance = this.shouReloadCurrentInstance(WXSDKManager.getInstance().getSDKInstance(instanceId).getBundleUrl());
                new ActionReloadPage(instanceId, reloadThisInstance).executeAction();
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callReloadPage exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callReloadPage", WXLogUtils.getStackTrace(e), null);
        }
        return 0;
    }

    public boolean shouReloadCurrentInstance(String aUrl) {
        long time = System.currentTimeMillis();
        if (crashUrl == null || crashUrl != null && !crashUrl.equals(aUrl) || time - lastCrashTime > 15000L) {
            crashUrl = aUrl;
            lastCrashTime = time;
            return true;
        }
        lastCrashTime = time;
        return false;
    }

    public void callReportCrash(String crashFile, final String instanceId, final String url) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = format.format(date);
        final String origin_filename = crashFile + "." + time;
        File oldfile = new File(crashFile);
        File newfile = new File(origin_filename);
        if (oldfile.exists()) {
            oldfile.renameTo(newfile);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(origin_filename);
                    if (file.exists()) {
                        if (file.length() > 0L) {
                            StringBuilder result = new StringBuilder();
                            try {
                                BufferedReader br = new BufferedReader(new FileReader(origin_filename));
                                String s = null;
                                while ((s = br.readLine()) != null) {
                                    if ("".equals(s)) continue;
                                    result.append(s + "\n");
                                }
                                WXBridgeManager.this.commitJscCrashAlarmMonitor("jsBridge", WXErrorCode.WX_ERR_JSC_CRASH, result.toString(), instanceId, url);
                                br.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            WXLogUtils.e("[WXBridgeManager] callReportCrash crash file is empty");
                        }
                        file.delete();
                    }
                }
                catch (Throwable throwable) {
                    WXLogUtils.e("[WXBridgeManager] callReportCrash exception: ", throwable);
                }
            }
        });
        t.start();
    }

    private void getNextTick(String instanceId, String callback) {
        this.addJSTask(METHOD_CALLBACK, instanceId, callback, "{}");
        this.sendMessage(instanceId, 6);
    }

    private void getNextTick(String instanceId) {
        this.addJSTask(METHOD_CALLBACK, instanceId, "", "{}");
        this.sendMessage(instanceId, 6);
    }

    public String syncExecJsOnInstanceWithResult(String instanceId, String js, int type) {
        final CountDownLatch waitLatch = new CountDownLatch(1);
        EventResult callback = new EventResult(){

            @Override
            public void onCallback(Object result) {
                super.onCallback(result);
                waitLatch.countDown();
            }
        };
        try {
            this.execJSOnInstance(callback, instanceId, js, type);
            waitLatch.await(100L, TimeUnit.MILLISECONDS);
            if (callback != null && callback.getResult() != null) {
                return callback.getResult().toString();
            }
            return "";
        }
        catch (Throwable e) {
            WXLogUtils.e("syncCallExecJsOnInstance", e);
            return "";
        }
    }

    public EventResult syncCallJSEventWithResult(String method, String instanceId, List<Object> params, Object ... args) {
        final CountDownLatch waitLatch = new CountDownLatch(1);
        EventResult callback = new EventResult(){

            @Override
            public void onCallback(Object result) {
                super.onCallback(result);
                waitLatch.countDown();
            }
        };
        try {
            this.asyncCallJSEventWithResult(callback, method, instanceId, params, args);
            waitLatch.await(100L, TimeUnit.MILLISECONDS);
            return callback;
        }
        catch (Exception e) {
            WXLogUtils.e("syncCallJSEventWithResult", e);
            return callback;
        }
    }

    public void asyncCallJSEventVoidResult(final String method, final String instanceId, final List<Object> params, final Object ... args) {
        this.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (args == null || args.length == 0) {
                        return;
                    }
                    ArrayList<Object> argsList = new ArrayList<Object>();
                    for (Object arg : args) {
                        argsList.add(arg);
                    }
                    if (params != null) {
                        ArrayMap map = new ArrayMap(4);
                        map.put((Object)WXBridgeManager.KEY_PARAMS, (Object)params);
                        argsList.add(map);
                    }
                    WXHashMap<String, Object> task = new WXHashMap<String, Object>();
                    task.put("method", method);
                    task.put("args", argsList);
                    Object[] tasks = new Object[]{task};
                    WXJSObject[] jsArgs = new WXJSObject[]{new WXJSObject(2, instanceId), WXWsonJSONSwitch.toWsonOrJsonWXJSObject(tasks)};
                    WXBridgeManager.this.invokeExecJS(String.valueOf(instanceId), null, WXBridgeManager.METHOD_CALL_JS, jsArgs, true);
                    jsArgs[0] = null;
                    jsArgs = null;
                }
                catch (Exception e) {
                    WXLogUtils.e("asyncCallJSEventVoidResult", e);
                }
            }
        });
    }

    private void asyncCallJSEventWithResult(final EventResult eventCallback, final String method, final String instanceId, final List<Object> params, final Object ... args) {
        this.post(new Runnable(){

            @Override
            public void run() {
                Object result = null;
                try {
                    JSONArray arrayResult;
                    if (args == null || args.length == 0) {
                        return;
                    }
                    ArrayList<Object> argsList = new ArrayList<Object>();
                    for (Object arg : args) {
                        argsList.add(arg);
                    }
                    if (params != null) {
                        ArrayMap map = new ArrayMap(4);
                        map.put((Object)WXBridgeManager.KEY_PARAMS, (Object)params);
                        argsList.add(map);
                    }
                    WXHashMap<String, Object> task = new WXHashMap<String, Object>();
                    task.put("method", method);
                    task.put("args", argsList);
                    Object[] tasks = new Object[]{task};
                    WXJSObject[] jsArgs = new WXJSObject[]{new WXJSObject(2, instanceId), WXWsonJSONSwitch.toWsonOrJsonWXJSObject(tasks)};
                    byte[] taskResult = WXBridgeManager.this.invokeExecJSWithResult(String.valueOf(instanceId), null, WXBridgeManager.METHOD_CALL_JS, jsArgs, true);
                    if (eventCallback == null) {
                        return;
                    }
                    if (taskResult != null && (arrayResult = (JSONArray)WXWsonJSONSwitch.parseWsonOrJSON(taskResult)) != null && arrayResult.size() > 0) {
                        result = arrayResult.get(0);
                    }
                    eventCallback.onCallback(result);
                    jsArgs[0] = null;
                    taskResult = null;
                    jsArgs = null;
                }
                catch (Exception e) {
                    WXLogUtils.e("asyncCallJSEventWithResult", e);
                }
            }
        });
    }

    private void addJSEventTask(final String method, final String instanceId, final List<Object> params, final Object ... args) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (args == null || args.length == 0) {
                    return;
                }
                ArrayList<Object> argsList = new ArrayList<Object>();
                for (Object arg : args) {
                    argsList.add(arg);
                }
                if (params != null) {
                    ArrayMap map = new ArrayMap(4);
                    map.put((Object)WXBridgeManager.KEY_PARAMS, (Object)params);
                    argsList.add(map);
                }
                WXHashMap<String, Object> task = new WXHashMap<String, Object>();
                task.put("method", method);
                task.put("args", argsList);
                if (WXBridgeManager.this.mNextTickTasks.get(instanceId) == null) {
                    ArrayList<WXHashMap<String, Object>> list = new ArrayList<WXHashMap<String, Object>>();
                    list.add(task);
                    WXBridgeManager.this.mNextTickTasks.put(instanceId, list);
                } else {
                    ((ArrayList)WXBridgeManager.this.mNextTickTasks.get(instanceId)).add(task);
                }
            }
        });
    }

    private void addJSTask(String method, String instanceId, Object ... args) {
        this.addJSEventTask(method, instanceId, null, args);
    }

    private void sendMessage(String instanceId, int what) {
        Message msg = Message.obtain((Handler)this.mJSHandler);
        msg.obj = instanceId;
        msg.what = what;
        msg.sendToTarget();
    }

    public synchronized void initScriptsFramework(String framework) {
        Message msg = this.mJSHandler.obtainMessage();
        msg.obj = framework;
        msg.what = 7;
        msg.setTarget(this.mJSHandler);
        msg.sendToTarget();
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> data) {
        this.fireEvent(instanceId, ref, type, data, null);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        this.fireEventOnNode(instanceId, ref, type, data, domChanges);
    }

    public void fireEventOnNode(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        this.fireEventOnNode(instanceId, ref, type, data, domChanges, null, null);
    }

    public void fireEventOnNode(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges, List<Object> params) {
        this.fireEventOnNode(instanceId, ref, type, data, domChanges, params, null);
    }

    public void fireEventOnNode(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges, List<Object> params, EventResult callback) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)type) || this.mJSHandler == null) {
            return;
        }
        if (!this.checkMainThread()) {
            throw new WXRuntimeException("fireEvent must be called by main thread");
        }
        if (callback == null) {
            this.addJSEventTask(METHOD_FIRE_EVENT, instanceId, params, ref, type, data, domChanges);
            this.sendMessage(instanceId, 6);
        } else {
            this.asyncCallJSEventWithResult(callback, METHD_FIRE_EVENT_SYNC, instanceId, params, ref, type, data, domChanges);
        }
    }

    private boolean checkMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    @Deprecated
    public void callback(String instanceId, String callback, String data) {
        this.callback(instanceId, callback, data, false);
    }

    @Deprecated
    public void callback(String instanceId, String callback, Map<String, Object> data) {
        this.callback(instanceId, callback, data, false);
    }

    @Deprecated
    public void callback(String instanceId, String callback, Object data, boolean keepAlive) {
        this.callbackJavascript(instanceId, callback, data, keepAlive);
    }

    void callbackJavascript(String instanceId, String callback, Object data, boolean keepAlive) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)callback) || this.mJSHandler == null) {
            return;
        }
        this.addJSTask(METHOD_CALLBACK, instanceId, callback, data, keepAlive);
        this.sendMessage(instanceId, 6);
    }

    public void refreshInstance(final String instanceId, final WXRefreshData jsonData) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || jsonData == null) {
            return;
        }
        this.mJSHandler.postDelayed(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRefreshInstance(instanceId, jsonData);
            }
        }), 0L);
    }

    private void invokeRefreshInstance(String instanceId, WXRefreshData refreshData) {
        try {
            if (!this.isJSFrameworkInit()) {
                WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
                if (instance != null) {
                    instance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + "invokeRefreshInstance FAILED for JSFrameworkInit FAILED, intance will invoke instance.onRenderError");
                }
                String err = "[WXBridgeManager] invokeRefreshInstance: framework.js uninitialized.";
                WXLogUtils.e(err);
                return;
            }
            long start = System.currentTimeMillis();
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("refreshInstance >>>> instanceId:" + instanceId + ", data:" + refreshData.data + ", isDirty:" + refreshData.isDirty);
            }
            if (refreshData.isDirty) {
                return;
            }
            WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
            WXJSObject dataObj = new WXJSObject(3, refreshData.data == null ? "{}" : refreshData.data);
            WXJSObject[] args = new WXJSObject[]{instanceIdObj, dataObj};
            this.invokeExecJS(instanceId, null, METHOD_REFRESH_INSTANCE, args);
            WXLogUtils.renderPerformanceLog("invokeRefreshInstance", System.currentTimeMillis() - start);
        }
        catch (Throwable e) {
            String err = "[WXBridgeManager] invokeRefreshInstance " + WXLogUtils.getStackTrace(e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "invokeRefreshInstance", err, null);
            WXLogUtils.e(err);
        }
    }

    public void commitJscCrashAlarmMonitor(String type, WXErrorCode errorCode, String errMsg, String instanceId, String url) {
        if (TextUtils.isEmpty((CharSequence)type) || errorCode == null) {
            return;
        }
        String method = "callReportCrash";
        String exception = "weex core process crash and restart exception";
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("jscCrashStack", errMsg);
        IWXJSExceptionAdapter adapter = WXSDKManager.getInstance().getIWXJSExceptionAdapter();
        if (adapter != null) {
            WXJSExceptionInfo jsException = new WXJSExceptionInfo(instanceId, url, errorCode, method, exception, extParams);
            adapter.onJSException(jsException);
            WXLogUtils.e(jsException.toString());
        }
    }

    public void createInstance(String instanceId, final String template, final Map<String, Object> options, final String data) {
        final WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance == null) {
            WXLogUtils.e("WXBridgeManager", "createInstance failed, SDKInstance is not exist");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)template) || this.mJSHandler == null) {
            instance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + " instanceId==" + instanceId + " template ==" + template + " mJSHandler== " + this.mJSHandler.toString());
            return;
        }
        if (!this.isJSFrameworkInit() && reInitCount == 1 && !WXEnvironment.sDebugServerConnectable) {
            instance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + " isJSFrameworkInit==" + this.isJSFrameworkInit() + " reInitCount == 1");
            this.post(new Runnable(){

                @Override
                public void run() {
                    WXBridgeManager.this.initFramework("");
                }
            }, instanceId);
            return;
        }
        WXModuleManager.createDomModule(instance);
        this.post(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                WXBridgeManager.this.invokeCreateInstance(instance, template, options, data);
                instance.getWXPerformance().callCreateInstanceTime = System.currentTimeMillis();
                long totalTime = instance.getWXPerformance().callCreateInstanceTime - start;
                if (totalTime > 0L) {
                    instance.getWXPerformance().communicateTime = totalTime;
                }
            }
        }, instanceId);
    }

    private void invokeCreateInstance(@NonNull WXSDKInstance instance, String template, Map<String, Object> options, String data) {
        this.initFramework("");
        if (this.mMock) {
            this.mock(instance.getInstanceId());
        } else {
            if (!this.isJSFrameworkInit()) {
                String err = "[WXBridgeManager] invokeCreateInstance: framework.js uninitialized.";
                instance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg());
                WXLogUtils.e(err);
                return;
            }
            WXModuleManager.registerWhenCreateInstance();
            try {
                WXJSObject apiObj;
                BundType type = BundType.Others;
                try {
                    long start = System.currentTimeMillis();
                    type = this.getBundleType(instance.getBundleUrl(), template);
                    if (WXEnvironment.isOpenDebugLog()) {
                        long end = System.currentTimeMillis();
                        WXLogUtils.e("end getBundleType type:" + type.toString() + " time:" + (end - start));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                try {
                    if (options == null) {
                        options = new HashMap<String, Object>();
                    }
                    if (options.get(BUNDLE_TYPE) == null) {
                        if (type == BundType.Vue) {
                            options.put(BUNDLE_TYPE, "Vue");
                        } else if (type == BundType.Rax) {
                            options.put(BUNDLE_TYPE, "Rax");
                        } else {
                            options.put(BUNDLE_TYPE, "Others");
                        }
                    }
                    if (options.get("env") == null) {
                        options.put("env", this.mInitParams);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (WXEnvironment.isApkDebugable()) {
                    // empty if block
                }
                WXJSObject instanceIdObj = new WXJSObject(2, instance.getInstanceId());
                WXJSObject instanceObj = new WXJSObject(2, template);
                WXJSObject optionsObj = new WXJSObject(3, options == null ? "{}" : WXJsonUtils.fromObjectToJSONString(options));
                optionsObj = this.optionObjConvert(isSandBoxContext, type, optionsObj);
                WXJSObject dataObj = new WXJSObject(3, data == null ? "{}" : data);
                if (type == BundType.Rax) {
                    if (mRaxApi == null) {
                        mRaxApi = WXFileUtils.loadAsset("weex-rax-api.js", (Context)WXEnvironment.getApplication());
                    }
                    apiObj = new WXJSObject(2, mRaxApi);
                } else {
                    apiObj = new WXJSObject(2, "");
                }
                WXJSObject[] args = new WXJSObject[]{instanceIdObj, instanceObj, optionsObj, dataObj, apiObj};
                instance.setTemplate(template);
                if (!isSandBoxContext || WXEnvironment.sDebugServerConnectable) {
                    this.invokeExecJS(instance.getInstanceId(), null, METHOD_CREATE_INSTANCE, args, false);
                    return;
                }
                if (type == BundType.Vue || type == BundType.Rax) {
                    this.invokeCreateInstanceContext(instance.getInstanceId(), null, METHOD_CREATE_INSTANCE, args, false);
                    return;
                }
                this.invokeExecJS(instance.getInstanceId(), null, METHOD_CREATE_INSTANCE, args, false);
                return;
            }
            catch (Throwable e) {
                String err = "[WXBridgeManager] invokeCreateInstance " + e.getCause() + instance.getTemplateInfo();
                instance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + err);
                WXLogUtils.e(err);
            }
        }
    }

    public WXJSObject optionObjConvert(boolean useSandBox, BundType type, WXJSObject opt) {
        if (!useSandBox || type == BundType.Others || WXEnvironment.sDebugServerConnectable) {
            return opt;
        }
        try {
            String data = opt.data.toString();
            JSONObject obj = JSON.parseObject((String)data);
            if (obj.getJSONObject("env") != null) {
                JSONObject opts;
                JSONObject optEnv = obj.getJSONObject("env");
                if (optEnv != null && (opts = optEnv.getJSONObject(OPTIONS)) != null) {
                    optEnv.remove((Object)OPTIONS);
                    Set set = opts.keySet();
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        String key = it.next().toString();
                        optEnv.put(key, (Object)opts.getString(key));
                    }
                }
                obj.remove((Object)"env");
                obj.put("env", (Object)optEnv);
            }
            WXJSObject optionsObj = new WXJSObject(3, obj.toString());
            return optionsObj;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return opt;
        }
    }

    public BundType getBundleType(String url, String temp) {
        try {
            if (url != null) {
                Uri uri = Uri.parse((String)url);
                String type = uri.getQueryParameter(BUNDLE_TYPE);
                if ("Vue".equals(type) || "vue".equals(type)) {
                    return BundType.Vue;
                }
                if ("Rax".equals(type) || "rax".equals(type)) {
                    return BundType.Rax;
                }
            }
            if (temp != null) {
                String strTrim;
                if (temp.startsWith("// { \"framework\": \"Vue\" }") || temp.startsWith("// { \"framework\": \"vue\" }") || temp.startsWith("// {\"framework\" : \"Vue\"}") || temp.startsWith("// {\"framework\" : \"vue\"}")) {
                    return BundType.Vue;
                }
                if (temp.startsWith("// { \"framework\": \"Rax\" }") || temp.startsWith("// { \"framework\": \"rax\" }") || temp.startsWith("// {\"framework\" : \"Rax\"}") || temp.startsWith("// {\"framework\" : \"rax\"}")) {
                    return BundType.Rax;
                }
                if (temp.length() > 500) {
                    temp = temp.substring(0, 500);
                }
                if ((strTrim = temp.replaceAll("\n", "").trim()).startsWith("// { \"framework\": \"Vue\" }") || strTrim.startsWith("// { \"framework\": \"vue\" }") || strTrim.startsWith("// {\"framework\" : \"Vue\"}") || strTrim.startsWith("// {\"framework\" : \"vue\"}")) {
                    return BundType.Vue;
                }
                if (strTrim.startsWith("// { \"framework\": \"Rax\" }") || strTrim.startsWith("// { \"framework\": \"rax\" }") || strTrim.startsWith("// {\"framework\" : \"Rax\"}") || strTrim.startsWith("// {\"framework\" : \"rax\"}")) {
                    return BundType.Rax;
                }
                String regEx = "(use)(\\s+)(weex:vue)";
                Pattern pattern = Pattern.compile(regEx, 2);
                if (pattern.matcher(temp).find()) {
                    return BundType.Vue;
                }
                regEx = "(use)(\\s+)(weex:rax)";
                pattern = Pattern.compile(regEx, 2);
                if (pattern.matcher(temp).find()) {
                    return BundType.Rax;
                }
            }
            return BundType.Others;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return BundType.Others;
        }
    }

    private void mock(String instanceId) {
    }

    public void destroyInstance(final String instanceId) {
        if (this.mJSHandler == null || TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        if (this.mDestroyedInstanceId != null) {
            this.mDestroyedInstanceId.add(instanceId);
        }
        this.mJSHandler.removeCallbacksAndMessages((Object)instanceId);
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.removeTaskByInstance(instanceId);
                WXBridgeManager.this.invokeDestroyInstance(instanceId);
            }
        }, instanceId);
    }

    private void removeTaskByInstance(String instanceId) {
        this.mNextTickTasks.removeFromMapAndStack(instanceId);
    }

    private void invokeDestroyInstance(String instanceId) {
        try {
            if (WXEnvironment.isApkDebugable()) {
                // empty if block
            }
            WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
            WXJSObject[] args = new WXJSObject[]{instanceIdObj};
            if (this.isJSFrameworkInit()) {
                this.invokeDestoryInstance(instanceId, null, METHOD_DESTROY_INSTANCE, args, true);
            }
        }
        catch (Throwable e) {
            String err = "[WXBridgeManager] invokeDestroyInstance " + e.getCause();
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "invokeDestroyInstance", err, null);
            WXLogUtils.e(err);
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg == null) {
            return false;
        }
        int what = msg.what;
        switch (what) {
            case 7: {
                this.invokeInitFramework(msg);
                break;
            }
            case 6: {
                this.invokeCallJSBatch(msg);
                break;
            }
            case 1: {
                TimerInfo timerInfo = (TimerInfo)msg.obj;
                if (timerInfo == null) break;
                WXJSObject obj = new WXJSObject(2, timerInfo.callbackId);
                WXJSObject[] args = new WXJSObject[]{obj};
                this.invokeExecJS("", null, METHOD_SET_TIMEOUT, args);
                break;
            }
            case 13: {
                if (msg.obj == null) break;
                String filename = (String)msg.obj;
                this.mWXBridge.takeHeapSnapshot(filename);
                break;
            }
        }
        return false;
    }

    private void invokeExecJS(String instanceId, String namespace, String function, WXJSObject[] args) {
        this.invokeExecJS(instanceId, namespace, function, args, true);
    }

    public void invokeExecJS(String instanceId, String namespace, String function, WXJSObject[] args, boolean logTaskDetail) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("callJS >>>> instanceId:").append(instanceId).append("function:").append(function);
            if (logTaskDetail) {
                this.mLodBuilder.append(" tasks:").append(WXBridgeManager.argsToJSON(args));
            }
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        long start = System.currentTimeMillis();
        this.mWXBridge.execJS(instanceId, namespace, function, args);
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (null != instance) {
            instance.callJsTime(System.currentTimeMillis() - start);
        }
    }

    public void invokeCreateInstanceContext(String instanceId, String namespace, String function, WXJSObject[] args, boolean logTaskDetail) {
        WXLogUtils.d("invokeCreateInstanceContext instanceId:" + instanceId + " function:" + function + " isJSFrameworkInit\uff1a%d" + this.isJSFrameworkInit());
        this.mLodBuilder.append("createInstanceContext >>>> instanceId:").append(instanceId).append("function:").append(function);
        if (logTaskDetail) {
            this.mLodBuilder.append(" tasks:").append(WXJsonUtils.fromObjectToJSONString(args));
        }
        WXLogUtils.d(this.mLodBuilder.substring(0));
        this.mLodBuilder.setLength(0);
        this.mWXBridge.createInstanceContext(instanceId, namespace, function, args);
    }

    public void invokeDestoryInstance(String instanceId, String namespace, String function, WXJSObject[] args, boolean logTaskDetail) {
        this.mLodBuilder.append("callJS >>>> instanceId:").append(instanceId).append("function:").append(function);
        if (logTaskDetail) {
            this.mLodBuilder.append(" tasks:").append(WXJsonUtils.fromObjectToJSONString(args));
        }
        WXLogUtils.d(this.mLodBuilder.substring(0));
        this.mLodBuilder.setLength(0);
        this.mWXBridge.destoryInstance(instanceId, namespace, function, args);
    }

    private void execJSOnInstance(final EventResult eventCallback, final String instanceId, final String js, final int type) {
        this.post(new Runnable(){

            @Override
            public void run() {
                String ret = WXBridgeManager.this.invokeExecJSOnInstance(instanceId, js, type);
                eventCallback.onCallback(ret);
            }
        });
    }

    private String invokeExecJSOnInstance(String instanceId, String js, int type) {
        this.mLodBuilder.append("execJSOnInstance >>>> instanceId:").append(instanceId);
        WXLogUtils.d(this.mLodBuilder.substring(0));
        this.mLodBuilder.setLength(0);
        return this.mWXBridge.execJSOnInstance(instanceId, js, type);
    }

    private byte[] invokeExecJSWithResult(String instanceId, String namespace, String function, WXJSObject[] args, boolean logTaskDetail) {
        if (WXEnvironment.isOpenDebugLog()) {
            // empty if block
        }
        return this.mWXBridge.execJSWithResult(instanceId, namespace, function, args);
    }

    @NonNull
    public static String argsToJSON(WXJSObject[] args) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (WXJSObject object : args) {
            builder.append(WXJsonUtils.fromObjectToJSONString(object));
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private void invokeInitFramework(Message msg) {
        String framework = "";
        if (msg.obj != null) {
            framework = (String)msg.obj;
        }
        if (WXUtils.getAvailMemory((Context)WXEnvironment.getApplication()) > LOW_MEM_VALUE) {
            this.initFramework(framework);
        }
    }

    private void initFramework(String framework) {
        if (!this.isJSFrameworkInit()) {
            if (TextUtils.isEmpty((CharSequence)framework)) {
                WXLogUtils.d("weex JS framework from assets");
                framework = !isSandBoxContext || WXEnvironment.sDebugServerConnectable ? WXFileUtils.loadAsset("main.js", (Context)WXEnvironment.getApplication()) : WXFileUtils.loadAsset("weex-main-jsfm.js", (Context)WXEnvironment.getApplication());
            }
            if (TextUtils.isEmpty((CharSequence)framework)) {
                this.setJSFrameworkInit(false);
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK, "initFramework", "framework is empty!! ", null);
                return;
            }
            try {
                if (WXSDKManager.getInstance().getWXStatisticsListener() != null) {
                    WXSDKManager.getInstance().getWXStatisticsListener().onJsFrameworkStart();
                }
                long start = System.currentTimeMillis();
                String crashFile = "";
                try {
                    crashFile = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                boolean pieSupport = true;
                try {
                    if (Build.VERSION.SDK_INT < 16) {
                        pieSupport = false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                WXLogUtils.d("[WXBridgeManager] initFrameworkEnv crashFile:" + crashFile + " pieSupport:" + pieSupport);
                if (this.mWXBridge.initFrameworkEnv(framework, this.assembleDefaultOptions(), crashFile, pieSupport) == 1) {
                    WXEnvironment.sJSLibInitTime = System.currentTimeMillis() - start;
                    WXLogUtils.renderPerformanceLog("initFramework", WXEnvironment.sJSLibInitTime);
                    WXEnvironment.sSDKInitTime = System.currentTimeMillis() - WXEnvironment.sSDKInitStart;
                    WXLogUtils.renderPerformanceLog("SDKInitTime", WXEnvironment.sSDKInitTime);
                    this.setJSFrameworkInit(true);
                    if (WXSDKManager.getInstance().getWXStatisticsListener() != null) {
                        WXSDKManager.getInstance().getWXStatisticsListener().onJsFrameworkReady();
                    }
                    this.execRegisterFailTask();
                    WXEnvironment.JsFrameworkInit = true;
                    this.registerDomModule();
                    this.trackComponentAndModulesTime();
                    String reinitInfo = "";
                    if (reInitCount > 1) {
                        reinitInfo = "reinit Framework:";
                    }
                } else if (reInitCount > 1) {
                    WXLogUtils.e("[WXBridgeManager] invokeReInitFramework  ExecuteJavaScript fail");
                    String string2 = "[WXBridgeManager] invokeReInitFramework  ExecuteJavaScript fail reinit FrameWork";
                } else {
                    WXLogUtils.e("[WXBridgeManager] invokeInitFramework  ExecuteJavaScript fail");
                    String string3 = "[WXBridgeManager] invokeInitFramework  ExecuteJavaScript fail";
                }
            }
            catch (Throwable e) {
                if (reInitCount > 1) {
                    WXLogUtils.e("[WXBridgeManager] invokeInitFramework ", e);
                    String string4 = "[WXBridgeManager] invokeInitFramework reinit FrameWork exception!#" + e.toString();
                }
                WXLogUtils.e("[WXBridgeManager] invokeInitFramework ", e);
                String string5 = "[WXBridgeManager] invokeInitFramework exception!#" + e.toString();
            }
        }
    }

    private void trackComponentAndModulesTime() {
        this.post(new Runnable(){

            @Override
            public void run() {
                WXEnvironment.sComponentsAndModulesReadyTime = System.currentTimeMillis() - WXEnvironment.sSDKInitStart;
                WXLogUtils.renderPerformanceLog("ComponentModulesReadyTime", WXEnvironment.sComponentsAndModulesReadyTime);
                WXLogUtils.d("ComponentModulesReadyTime " + WXEnvironment.sComponentsAndModulesReadyTime);
            }
        });
    }

    private void invokeCallJSBatch(Message message) {
        if (this.mNextTickTasks.isEmpty() || !this.isJSFrameworkInit()) {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized!!  message:" + message.toString());
            }
            return;
        }
        try {
            Object instanceId = message.obj;
            Object task = null;
            Stack<String> instanceStack = this.mNextTickTasks.getInstanceStack();
            int size = instanceStack.size();
            for (int i = size - 1; i >= 0 && ((task = this.mNextTickTasks.remove(instanceId = instanceStack.get(i))) == null || ((ArrayList)task).isEmpty()); --i) {
            }
            task = ((ArrayList)task).toArray();
            WXJSObject[] args = new WXJSObject[]{new WXJSObject(2, instanceId), WXWsonJSONSwitch.toWsonOrJsonWXJSObject(task)};
            this.invokeExecJS(String.valueOf(instanceId), null, METHOD_CALL_JS, args);
        }
        catch (Throwable e) {
            WXLogUtils.e("WXBridgeManager", e);
            String err = "invokeCallJSBatch#" + WXLogUtils.getStackTrace(e);
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK, "invokeCallJSBatch", err, null);
        }
        if (!this.mNextTickTasks.isEmpty()) {
            this.mJSHandler.sendEmptyMessage(6);
        }
    }

    private WXParams assembleDefaultOptions() {
        Map<String, String> config = WXEnvironment.getConfig();
        WXParams wxParams = new WXParams();
        wxParams.setPlatform(config.get("os"));
        wxParams.setCacheDir(config.get("cacheDir"));
        wxParams.setOsVersion(config.get("sysVersion"));
        wxParams.setAppVersion(config.get("appVersion"));
        wxParams.setWeexVersion(config.get("weexVersion"));
        wxParams.setDeviceModel(config.get("sysModel"));
        wxParams.setShouldInfoCollect(config.get("infoCollect"));
        wxParams.setLogLevel(config.get("logLevel"));
        wxParams.setUseSingleProcess(isUseSingleProcess ? "true" : "false");
        wxParams.setLibJssPath(WXEnvironment.getLibJssRealPath());
        String appName = config.get("appName");
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            wxParams.setAppName(appName);
        }
        wxParams.setDeviceWidth(TextUtils.isEmpty((CharSequence)config.get("deviceWidth")) ? String.valueOf(WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication)) : config.get("deviceWidth"));
        wxParams.setDeviceHeight(TextUtils.isEmpty((CharSequence)config.get("deviceHeight")) ? String.valueOf(WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication)) : config.get("deviceHeight"));
        wxParams.setOptions(WXEnvironment.getCustomOptions());
        wxParams.setNeedInitV8(WXSDKManager.getInstance().needInitV8());
        this.mInitParams = wxParams;
        return wxParams;
    }

    public WXParams getInitParams() {
        return this.mInitParams;
    }

    private void execRegisterFailTask() {
        ArrayList<Map<String, Object>> receiver;
        if (this.mRegisterModuleFailList.size() > 0) {
            ArrayList<Map<String, Object>> moduleReceiver = new ArrayList<Map<String, Object>>();
            int moduleCount = this.mRegisterModuleFailList.size();
            for (int i = 0; i < moduleCount; ++i) {
                this.invokeRegisterModules(this.mRegisterModuleFailList.get(i), moduleReceiver);
            }
            this.mRegisterModuleFailList.clear();
            if (moduleReceiver.size() > 0) {
                this.mRegisterModuleFailList.addAll(moduleReceiver);
            }
        }
        if (this.mRegisterComponentFailList.size() > 0) {
            receiver = new ArrayList<Map<String, Object>>();
            this.invokeRegisterComponents(this.mRegisterComponentFailList, receiver);
            this.mRegisterComponentFailList.clear();
            if (receiver.size() > 0) {
                this.mRegisterComponentFailList.addAll(receiver);
            }
        }
        if (this.mRegisterServiceFailList.size() > 0) {
            receiver = new ArrayList();
            for (String service : this.mRegisterServiceFailList) {
                this.invokeExecJSService(service, receiver);
            }
            this.mRegisterServiceFailList.clear();
            if (receiver.size() > 0) {
                this.mRegisterServiceFailList.addAll(receiver);
            }
        }
    }

    public void registerModules(final Map<String, Object> modules) {
        if (modules != null && modules.size() != 0) {
            if (this.isJSThread()) {
                this.invokeRegisterModules(modules, this.mRegisterModuleFailList);
            } else {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        WXBridgeManager.this.invokeRegisterModules(modules, WXBridgeManager.this.mRegisterModuleFailList);
                    }
                }, null);
            }
        }
    }

    public void registerComponents(final List<Map<String, Object>> components) {
        if (this.mJSHandler == null || components == null || components.size() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRegisterComponents(components, WXBridgeManager.this.mRegisterComponentFailList);
            }
        };
        if (this.isJSThread() && this.isJSFrameworkInit()) {
            runnable.run();
        } else {
            this.post(runnable, null);
        }
    }

    public void execJSService(final String service) {
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeExecJSService(service, WXBridgeManager.this.mRegisterServiceFailList);
            }
        });
    }

    private void invokeExecJSService(String service, List<String> receiver) {
        try {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.e("[WXBridgeManager] invoke execJSService: framework.js uninitialized.");
                receiver.add(service);
                return;
            }
            this.mWXBridge.execJSService(service);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterService:", e);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("inputParams", service + "||" + receiver.toString());
            WXExceptionUtils.commitCriticalExceptionRT("invokeExecJSService", WXErrorCode.WX_KEY_EXCEPTION_INVOKE_JSSERVICE_EXECUTE, "invokeExecJSService", WXErrorCode.WX_KEY_EXCEPTION_INVOKE_JSSERVICE_EXECUTE.getErrorMsg() + "[WXBridgeManager] invokeRegisterService:" + WXLogUtils.getStackTrace(e), data);
        }
    }

    public boolean isJSThread() {
        return this.mJSThread != null && this.mJSThread.getId() == Thread.currentThread().getId();
    }

    private void invokeRegisterModules(Map<String, Object> modules, List<Map<String, Object>> failReceiver) {
        if (modules == null || !this.isJSFrameworkInit()) {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.d("[WXinvokeRegisterModulesBridgeManager] invokeRegisterModules: framework.js uninitialized.");
            }
            failReceiver.add(modules);
            return;
        }
        WXJSObject[] args = new WXJSObject[]{WXWsonJSONSwitch.toWsonOrJsonWXJSObject(modules)};
        try {
            this.mWXBridge.execJS("", null, METHOD_REGISTER_MODULES, args);
            try {
                for (String module : modules.keySet()) {
                    if (module == null) continue;
                    WXModuleManager.resetModuleState(module, true);
                    WXLogUtils.e("[WXBridgeManager]invokeRegisterModules METHOD_REGISTER_MODULES success module:" + module);
                }
            }
            catch (Throwable e) {
                WXLogUtils.e("Weex [invokeRegisterModules]", e);
            }
        }
        catch (Throwable e) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_MODULES, "invokeRegisterModules", WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_MODULES.getErrorMsg() + " \n " + e.getMessage() + modules.entrySet().toString(), null);
            WXLogUtils.e("[WXBridgeManager] invokeRegisterModules:", e);
        }
    }

    private void invokeRegisterComponents(List<Map<String, Object>> components, List<Map<String, Object>> failReceiver) {
        if (components == failReceiver) {
            throw new RuntimeException("Fail receiver should not use source.");
        }
        if (!this.isJSFrameworkInit()) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterComponents: framework.js uninitialized.");
            for (Map<String, Object> comp : components) {
                failReceiver.add(comp);
            }
            return;
        }
        if (components == null) {
            return;
        }
        WXJSObject[] args = new WXJSObject[]{WXWsonJSONSwitch.toWsonOrJsonWXJSObject(components)};
        try {
            this.mWXBridge.execJS("", null, METHOD_REGISTER_COMPONENTS, args);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterComponents ", e);
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_CONTENT_FAILED, METHOD_REGISTER_COMPONENTS, (Object)((Object)WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_CONTENT_FAILED) + args.toString() + WXLogUtils.getStackTrace(e), null);
        }
    }

    public void destroy() {
        if (this.mJSThread != null) {
            this.mJSThread.quit();
        }
        mBridgeManager = null;
        if (this.mDestroyedInstanceId != null) {
            this.mDestroyedInstanceId.clear();
        }
    }

    public void reportJSException(String instanceId, String function, String exception) {
        WXLogUtils.e("reportJSException >>>> instanceId:" + instanceId + ", exception function:" + function + ", exception:" + exception);
        WXSDKInstance instance = null;
        if (instanceId != null && (instance = WXSDKManager.getInstance().getSDKInstance(instanceId)) != null) {
            exception = exception + "\n getTemplateInfo==" + instance.getTemplateInfo();
            if (METHOD_CREATE_INSTANCE.equals(function)) {
                try {
                    if (this.isJSFrameworkInit() && reInitCount > 1 && !instance.isNeedReLoad()) {
                        new ActionReloadPage(instanceId, true).executeAction();
                        instance.setNeedLoad(true);
                        return;
                    }
                    instance.onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorMsg() + "reportJSException >>>> instanceId:" + instanceId + ", exception function:" + function + ", exception:" + exception);
                    WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_RENDER_ERR_JS_CREATE_INSTANCE, function, exception, null);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            instance.onJSException(WXErrorCode.WX_ERR_JS_EXECUTE.getErrorCode(), function, exception);
        }
        this.doReportJSException(instanceId, function, exception);
    }

    private void doReportJSException(String instanceId, String function, String exception) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        IWXJSExceptionAdapter adapter = WXSDKManager.getInstance().getIWXJSExceptionAdapter();
        if (adapter != null) {
            String exceptionId = instanceId;
            if (instanceId == "" || instanceId == null) {
                exceptionId = "instanceIdisNull";
            }
            if (instance == null && "initFramework".equals(function)) {
                String exceptionExt;
                block14: {
                    exceptionExt = null;
                    try {
                        if (WXEnvironment.getApplication() == null) break block14;
                        String fileName = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath() + INITLOGFILE;
                        try {
                            File file = new File(fileName);
                            if (!file.exists()) break block14;
                            if (file.length() > 0L) {
                                StringBuilder result = new StringBuilder();
                                try {
                                    InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                                    BufferedReader br = new BufferedReader(read);
                                    String s = null;
                                    while ((s = br.readLine()) != null) {
                                        result.append(s + "\n");
                                    }
                                    exceptionExt = result.toString();
                                    br.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            file.delete();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                exception = exception + "\n" + exceptionExt;
                WXLogUtils.e("reportJSException:" + exception);
            }
            if (this.checkEmptyScreen(instance)) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.e("render error 4 js error !");
                }
                WXExceptionUtils.commitCriticalExceptionRT(exceptionId, WXErrorCode.WX_RENDER_ERR_JS_RUNTIME, function, WXErrorCode.WX_RENDER_ERR_JS_RUNTIME.getErrorMsg() + exception, null);
            } else {
                WXExceptionUtils.commitCriticalExceptionRT(exceptionId, WXErrorCode.WX_KEY_EXCEPTION_WXBRIDGE, function, WXErrorCode.WX_KEY_EXCEPTION_WXBRIDGE.getErrorMsg() + exception, null);
            }
        }
    }

    private boolean checkEmptyScreen(WXSDKInstance instance) {
        if (null == instance || instance.isDestroy()) {
            return false;
        }
        WXComponent rootComponent = instance.getRootComponent();
        if (null == rootComponent) {
            return true;
        }
        View rootView = rootComponent.getRealView();
        if (null == rootView) {
            return true;
        }
        if (rootView instanceof ViewGroup) {
            return ((ViewGroup)rootView).getChildCount() > 0;
        }
        return false;
    }

    private void registerDomModule() throws WXException {
        HashMap<String, Object> domMap = new HashMap<String, Object>();
        domMap.put("dom", WXDomModule.METHODS);
        this.registerModules(domMap);
    }

    @Deprecated
    public void notifyTrimMemory() {
    }

    public static void updateGlobalConfig(String config) {
        if (TextUtils.isEmpty((CharSequence)config)) {
            config = "none";
        }
        if (!TextUtils.equals((CharSequence)config, (CharSequence)globalConfig)) {
            globalConfig = config;
            WXEnvironment.getCustomOptions().put(GLOBAL_CONFIG_KEY, globalConfig);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (mBridgeManager != null && mBridgeManager.isJSFrameworkInit() && mBridgeManager.mWXBridge instanceof WXBridge) {
                        WXBridge bridge = (WXBridge)mBridgeManager.mWXBridge;
                        bridge.nativeUpdateGlobalConfig(globalConfig);
                    }
                    WXWsonJSONSwitch.USE_WSON = !globalConfig.contains("wson_off");
                }
            };
            if (mBridgeManager != null && mBridgeManager.isJSFrameworkInit()) {
                mBridgeManager.post(runnable);
            } else {
                runnable.run();
            }
        }
    }

    @Nullable
    public Looper getJSLooper() {
        Looper ret = null;
        if (this.mJSThread != null) {
            ret = this.mJSThread.getLooper();
        }
        return ret;
    }

    public void notifySerializeCodeCache() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!WXBridgeManager.this.isJSFrameworkInit()) {
                    return;
                }
                WXBridgeManager.this.invokeExecJS("", null, WXBridgeManager.METHOD_NOTIFY_SERIALIZE_CODE_CACHE, new WXJSObject[0]);
            }
        });
    }

    public void takeJSHeapSnapshot(String filename) {
        Message msg = this.mJSHandler.obtainMessage();
        msg.obj = filename;
        msg.what = 13;
        msg.setTarget(this.mJSHandler);
        msg.sendToTarget();
    }

    public int callCreateBody(String pageId, String componentType, String ref, HashMap<String, String> styles, HashMap<String, String> attributes, HashSet<String> events, float[] margins, float[] paddings, float[] borders) {
        long start = System.currentTimeMillis();
        if (TextUtils.isEmpty((CharSequence)pageId) || TextUtils.isEmpty((CharSequence)componentType) || TextUtils.isEmpty((CharSequence)ref)) {
            WXLogUtils.d("[WXBridgeManager] callCreateBody: call CreateBody tasks is null");
            WXExceptionUtils.commitCriticalExceptionRT(pageId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callCreateBody", "tasks is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(pageId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(pageId) != null) {
                GraphicActionCreateBody action = new GraphicActionCreateBody(pageId, ref, componentType, styles, attributes, events, margins, paddings, borders);
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(action.getPageId(), action);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callCreateBody exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(pageId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callCreateBody", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public int callAddElement(String pageId, String componentType, String ref, int index, String parentRef, HashMap<String, String> styles, HashMap<String, String> attributes, HashSet<String> events, float[] margins, float[] paddings, float[] borders, boolean willLayout) {
        long start = System.currentTimeMillis();
        if (TextUtils.isEmpty((CharSequence)pageId) || TextUtils.isEmpty((CharSequence)componentType) || TextUtils.isEmpty((CharSequence)ref)) {
            WXLogUtils.d("[WXBridgeManager] callAddElement: call CreateBody tasks is null");
            WXExceptionUtils.commitCriticalExceptionRT(pageId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callAddElement", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(pageId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(pageId) != null) {
                GraphicActionAddElement action = new GraphicActionAddElement(pageId, ref, componentType, parentRef, index, styles, attributes, events, margins, paddings, borders);
                if (willLayout) {
                    WXSDKManager.getInstance().getSDKInstance(pageId).addInActiveAddElementAction(ref, action);
                } else {
                    WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(pageId, action);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callAddElement exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(pageId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callAddElement", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public int callRemoveElement(String instanceId, String ref) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                GraphicActionRemoveElement action = new GraphicActionRemoveElement(instanceId, ref);
                if (instance.getInActiveAddElementAction(ref) != null) {
                    instance.removeInActiveAddElmentAction(ref);
                } else {
                    WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(action.getPageId(), action);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveElement exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callRemoveElement", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public int callMoveElement(String instanceId, String ref, String parentref, int index) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                GraphicActionMoveElement action = new GraphicActionMoveElement(instanceId, ref, parentref, index);
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(action.getPageId(), action);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callMoveElement exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callMoveElement", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public int callAddEvent(String instanceId, String ref, String event) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                new GraphicActionAddEvent(instanceId, ref, event).executeActionOnRender();
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callAddEvent exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callAddEvent", WXLogUtils.getStackTrace(e), null);
        }
        this.getNextTick(instanceId);
        return 1;
    }

    public int callRemoveEvent(String instanceId, String ref, String event) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                new GraphicActionRemoveEvent(instanceId, ref, event).executeActionOnRender();
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveEvent exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callAddEvent", WXLogUtils.getStackTrace(e), null);
        }
        this.getNextTick(instanceId);
        return 1;
    }

    public int callUpdateStyle(String instanceId, String ref, HashMap<String, Object> styles, HashMap<String, String> paddings, HashMap<String, String> margins, HashMap<String, String> borders) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                GraphicActionUpdateStyle action = new GraphicActionUpdateStyle(instanceId, ref, styles, paddings, margins, borders);
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(action.getPageId(), action);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateStyle exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callUpdateStyle", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public int callUpdateAttrs(String instanceId, String ref, HashMap<String, String> attrs) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                GraphicActionUpdateAttr action = new GraphicActionUpdateAttr(instanceId, ref, attrs);
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(action.getPageId(), action);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateAttrs exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callUpdateAttrs", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public int callLayout(String pageId, String ref, int top, int bottom, int left, int right, int height, int width, int index) {
        long start = System.currentTimeMillis();
        if (TextUtils.isEmpty((CharSequence)pageId) || TextUtils.isEmpty((CharSequence)ref)) {
            WXLogUtils.d("[WXBridgeManager] callLayout: call callLayout arguments is null");
            WXExceptionUtils.commitCriticalExceptionRT(pageId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callLayout", "arguments is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(pageId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(pageId) != null) {
                GraphicSize size = new GraphicSize(width, height);
                GraphicPosition position = new GraphicPosition(left, top, right, bottom);
                GraphicActionAddElement addAction = WXSDKManager.getInstance().getSDKInstance(pageId).getInActiveAddElementAction(ref);
                if (addAction != null) {
                    addAction.setSize(size);
                    addAction.setPosition(position);
                    if (!TextUtils.equals((CharSequence)ref, (CharSequence)"_root")) {
                        addAction.setIndex(index);
                    }
                    WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(pageId, addAction);
                    WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(pageId);
                    if (instance != null) {
                        instance.removeInActiveAddElmentAction(ref);
                    }
                } else {
                    GraphicActionLayout action = new GraphicActionLayout(pageId, ref, position, size);
                    WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(action.getPageId(), action);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callLayout exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(pageId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callLayout", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public int callAppendTreeCreateFinish(String instanceId, String ref) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            GraphicActionAppendTreeCreateFinish action = new GraphicActionAppendTreeCreateFinish(instanceId, ref);
            WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(instanceId, action);
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callAppendTreeCreateFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callAppendTreeCreateFinish", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public int callCreateFinish(String instanceId) {
        if (WXEnvironment.isApkDebugable()) {
            // empty if block
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            long start = System.currentTimeMillis();
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
                GraphicActionCreateFinish action = new GraphicActionCreateFinish(instanceId);
                WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(instanceId, action);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callCreateFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE, "callCreateFinish", WXLogUtils.getStackTrace(e), null);
        }
        return 1;
    }

    public ContentBoxMeasurement getMeasurementFunc(String instanceId, long renderObjectPtr) {
        ContentBoxMeasurement contentBoxMeasurement = null;
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            contentBoxMeasurement = instance.getContentBoxMeasurement(renderObjectPtr);
        }
        return contentBoxMeasurement;
    }

    public void bindMeasurementToRenderObject(long ptr) {
        this.mWXBridge.bindMeasurementToRenderObject(ptr);
    }

    @UiThread
    public boolean notifyLayout(String instanceId) {
        return this.mWXBridge.notifyLayout(instanceId);
    }

    @UiThread
    public void forceLayout(String instanceId) {
        this.mWXBridge.forceLayout(instanceId);
    }

    public void onInstanceClose(String instanceId) {
        this.mWXBridge.onInstanceClose(instanceId);
    }

    public void setDefaultRootSize(String instanceId, float defaultWidth, float defaultHeight, boolean isWidthWrapContent, boolean isHeightWrapContent) {
        this.mWXBridge.setDefaultHeightAndWidthIntoRootDom(instanceId, defaultWidth, defaultHeight, isWidthWrapContent, isHeightWrapContent);
    }

    public void setRenderContentWrapContentToCore(boolean wrap, String instanceId) {
        this.mWXBridge.setRenderContainerWrapContent(wrap, instanceId);
    }

    public void setStyleWidth(String instanceId, String ref, float value) {
        this.mWXBridge.setStyleWidth(instanceId, ref, value);
    }

    public void setStyleHeight(String instanceId, String ref, float value) {
        this.mWXBridge.setStyleHeight(instanceId, ref, value);
    }

    public long[] getFirstScreenRenderTime(String instanceId) {
        return this.mWXBridge.getFirstScreenRenderTime(instanceId);
    }

    public long[] getRenderFinishTime(String instanceId) {
        return this.mWXBridge.getRenderFinishTime(instanceId);
    }

    public void setMargin(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.mWXBridge.setMargin(instanceId, ref, edge, value);
    }

    public void setPadding(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.mWXBridge.setPadding(instanceId, ref, edge, value);
    }

    public void setPosition(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.mWXBridge.setPosition(instanceId, ref, edge, value);
    }

    public void markDirty(String instanceId, String ref, boolean dirty) {
        this.mWXBridge.markDirty(instanceId, ref, dirty);
    }

    public int callHasTransitionPros(String instanceId, String ref, HashMap<String, String> styles) {
        WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(instanceId, ref);
        if (null == component || null == component.getTransition() || null == component.getTransition().getProperties()) {
            return -1;
        }
        for (String property : component.getTransition().getProperties()) {
            if (!styles.containsKey(property)) continue;
            return 1;
        }
        return 0;
    }

    public void registerCoreEnv(String key, String value) {
        if (this.isJSFrameworkInit()) {
            this.mWXBridge.registerCoreEnv(key, value);
        } else {
            mWeexCoreEnvOptions.put(key, value);
        }
    }

    private void onJsFrameWorkInitSuccees() {
        for (Map.Entry<String, String> entry : mWeexCoreEnvOptions.entrySet()) {
            this.mWXBridge.registerCoreEnv(entry.getKey(), entry.getValue());
        }
        mWeexCoreEnvOptions.clear();
    }

    static {
        LOW_MEM_VALUE = 120L;
        reInitCount = 1;
        crashUrl = null;
        lastCrashTime = 0L;
        mRaxApi = null;
        isSandBoxContext = true;
        isUseSingleProcess = false;
        mInit = false;
        globalConfig = "none";
        GLOBAL_CONFIG_KEY = "global_switch_config";
        mWeexCoreEnvOptions = new HashMap<String, String>();
    }

    public static class TimerInfo {
        public String callbackId;
        public long time;
        public String instanceId;
    }

    private static enum BundType {
        Vue,
        Rax,
        Others;

    }
}

