/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.os.Build;
import android.view.Choreographer;
import com.taobao.weex.WXSDKManager;
import java.lang.ref.WeakReference;

public class WeexFrameRateControl {
    private static final long VSYNC_FRAME = 62L;
    private WeakReference<VSyncListener> mListener;
    private final Choreographer mChoreographer;
    private final Choreographer.FrameCallback mVSyncFrameCallback;
    private final Runnable runnable;

    public WeexFrameRateControl(VSyncListener listener) {
        this.mListener = new WeakReference<VSyncListener>(listener);
        if (Build.VERSION.SDK_INT > 15) {
            this.mChoreographer = Choreographer.getInstance();
            this.mVSyncFrameCallback = new Choreographer.FrameCallback(){

                public void doFrame(long frameTimeNanos) {
                    WeexFrameRateControl.this.mChoreographer.postFrameCallback(WeexFrameRateControl.this.mVSyncFrameCallback);
                    if (WeexFrameRateControl.this.mListener != null && WeexFrameRateControl.this.mListener.get() != null) {
                        ((VSyncListener)WeexFrameRateControl.this.mListener.get()).OnVSync();
                    }
                }
            };
            this.runnable = null;
        } else {
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(WeexFrameRateControl.this.runnable, 62L);
                    if (WeexFrameRateControl.this.mListener != null && WeexFrameRateControl.this.mListener.get() != null) {
                        ((VSyncListener)WeexFrameRateControl.this.mListener.get()).OnVSync();
                    }
                }
            };
            this.mChoreographer = null;
            this.mVSyncFrameCallback = null;
        }
    }

    public void start() {
        if (this.mChoreographer != null) {
            this.mChoreographer.postFrameCallback(this.mVSyncFrameCallback);
        } else if (this.runnable != null) {
            WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(this.runnable, 62L);
        }
    }

    public void stop() {
        if (this.mChoreographer != null) {
            this.mChoreographer.removeFrameCallback(this.mVSyncFrameCallback);
        } else if (this.runnable != null) {
            WXSDKManager.getInstance().getWXRenderManager().removeTask(this.runnable);
        }
    }

    public static interface VSyncListener {
        public void OnVSync();
    }
}

