/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jacoco.agent.rt.internal_b0d6a23.Offline;

public class BoxShadowUtil {
    private static final String TAG = "BoxShadowUtil";
    private static boolean sBoxShadowEnabled;
    private static Pattern sColorPattern;
    private static final transient /* synthetic */ boolean[] $jacocoData;

    public BoxShadowUtil() {
        boolean[] blArray = BoxShadowUtil.$jacocoInit();
        blArray[0] = true;
    }

    public static void setBoxShadowEnabled(boolean bl) {
        boolean enabled;
        boolean[] blArray = BoxShadowUtil.$jacocoInit();
        sBoxShadowEnabled = enabled;
        blArray[1] = true;
        WXLogUtils.w(TAG, "Switch box-shadow status: " + enabled);
        blArray[2] = true;
    }

    public static boolean isBoxShadowEnabled() {
        boolean[] blArray = BoxShadowUtil.$jacocoInit();
        blArray[3] = true;
        return sBoxShadowEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public static void setBoxShadow(View view, String string2, float[] fArray, int n, float f) {
        void quality;
        void radii;
        BoxShadowOptions[] shadows;
        void viewPort;
        View target;
        block22: {
            void style;
            block21: {
                block20: {
                    boolean[] blArray = BoxShadowUtil.$jacocoInit();
                    if (!sBoxShadowEnabled) {
                        blArray[4] = true;
                        WXLogUtils.w(TAG, "box-shadow was disabled by config");
                        blArray[5] = true;
                        return;
                    }
                    if (target == null) {
                        blArray[6] = true;
                        WXLogUtils.w(TAG, "Target view is null!");
                        blArray[7] = true;
                        return;
                    }
                    if (!TextUtils.isEmpty((CharSequence)style)) {
                        blArray[8] = true;
                    } else if (Build.VERSION.SDK_INT < 18) {
                        blArray[9] = true;
                    } else {
                        blArray[10] = true;
                        target.getOverlay().clear();
                        blArray[11] = true;
                        WXLogUtils.d(TAG, "Remove all box-shadow");
                        blArray[12] = true;
                        return;
                    }
                    shadows = BoxShadowUtil.parseBoxShadows((String)style, (int)viewPort);
                    if (shadows != null) break block20;
                    blArray[13] = true;
                    break block21;
                }
                if (shadows.length != 0) break block22;
                blArray[14] = true;
            }
            WXLogUtils.w(TAG, "Failed to parse box-shadow: " + (String)style);
            blArray[15] = true;
            return;
        }
        ArrayList<BoxShadowOptions> normalShadows = new ArrayList<BoxShadowOptions>();
        ArrayList<BoxShadowOptions> insetShadows = new ArrayList<BoxShadowOptions>();
        BoxShadowOptions[] boxShadowOptionsArray = shadows;
        int n2 = boxShadowOptionsArray.length;
        blArray[16] = true;
        for (int i = 0; i < n2; ++i) {
            BoxShadowOptions shadow = boxShadowOptionsArray[i];
            if (shadow == null) {
                blArray[17] = true;
            } else if (shadow.isInset) {
                blArray[18] = true;
                insetShadows.add(0, shadow);
                blArray[19] = true;
            } else {
                normalShadows.add(0, shadow);
                blArray[20] = true;
            }
            blArray[21] = true;
        }
        if (radii == null) {
            blArray[22] = true;
        } else if (((void)radii).length != 8) {
            blArray[23] = true;
            WXLogUtils.w(TAG, "Length of radii must be 8");
            blArray[24] = true;
        } else {
            boolean bl = false;
            blArray[25] = true;
            while (true) {
                float realRadius;
                void i;
                if (i >= ((void)radii).length) {
                    blArray[26] = true;
                    break;
                }
                blArray[27] = true;
                radii[i] = realRadius = WXViewUtils.getRealSubPxByWidth((float)radii[i], (int)viewPort);
                ++i;
                blArray[28] = true;
            }
        }
        target.post(WXThread.secure(new Runnable(target, normalShadows, (float)quality, (float[])radii, insetShadows){
            final /* synthetic */ View val$target;
            final /* synthetic */ List val$normalShadows;
            final /* synthetic */ float val$quality;
            final /* synthetic */ float[] val$radii;
            final /* synthetic */ List val$insetShadows;
            private static final transient /* synthetic */ boolean[] $jacocoData;
            {
                boolean[] blArray = 1.$jacocoInit();
                this.val$target = view;
                this.val$normalShadows = list;
                this.val$quality = f;
                this.val$radii = fArray;
                this.val$insetShadows = list2;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 1.$jacocoInit();
                if (Build.VERSION.SDK_INT < 18) {
                    blArray[1] = true;
                } else {
                    blArray[2] = true;
                    this.val$target.getOverlay().clear();
                    blArray[3] = true;
                    if (this.val$normalShadows.size() <= 0) {
                        blArray[4] = true;
                    } else {
                        blArray[5] = true;
                        BoxShadowUtil.access$000(this.val$target, this.val$normalShadows, this.val$quality, this.val$radii);
                        blArray[6] = true;
                    }
                    if (this.val$insetShadows.size() <= 0) {
                        blArray[7] = true;
                    } else {
                        blArray[8] = true;
                        BoxShadowUtil.access$100(this.val$target, this.val$insetShadows, this.val$quality, this.val$radii);
                        blArray[9] = true;
                    }
                }
                blArray[10] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-5292266106802981424L, (String)"com/taobao/weex/utils/BoxShadowUtil$1", (int)11);
                }
                return blArray;
            }
        }));
        blArray[29] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void drawShadow(Canvas canvas, BoxShadowOptions boxShadowOptions) {
        Canvas canvas2;
        void i;
        void shadowPaint;
        void options;
        boolean[] blArray = BoxShadowUtil.$jacocoInit();
        RectF shadowRect = new RectF(0.0f, 0.0f, (float)options.viewWidth + 2.0f * options.spread, (float)options.viewHeight + 2.0f * options.spread);
        if (options.topLeft == null) {
            blArray[30] = true;
        } else {
            blArray[31] = true;
            shadowRect.offset(options.topLeft.x, options.topLeft.y);
            blArray[32] = true;
        }
        float shadowDx = options.blur;
        float shadowDy = options.blur;
        if (!(options.hShadow > 0.0f)) {
            blArray[33] = true;
        } else {
            shadowDx += 2.0f * options.hShadow;
            blArray[34] = true;
        }
        if (!(options.vShadow > 0.0f)) {
            blArray[35] = true;
        } else {
            shadowDy += 2.0f * options.vShadow;
            blArray[36] = true;
        }
        shadowRect.offset(shadowDx, shadowDy);
        blArray[37] = true;
        Paint paint = new Paint();
        blArray[38] = true;
        shadowPaint.setAntiAlias(true);
        blArray[39] = true;
        shadowPaint.setColor(options.color);
        blArray[40] = true;
        shadowPaint.setStyle(Paint.Style.FILL);
        if (!(options.blur > 0.0f)) {
            blArray[41] = true;
        } else {
            blArray[42] = true;
            shadowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(options.blur, BlurMaskFilter.Blur.NORMAL));
            blArray[43] = true;
        }
        Path shadowPath = new Path();
        float[] shadowRadii = new float[8];
        boolean bl = false;
        blArray[44] = true;
        while (i < options.radii.length) {
            float contentRadius = options.radii[i];
            if (contentRadius == 0.0f) {
                shadowRadii[i] = 0.0f;
                blArray[45] = true;
            } else {
                shadowRadii[i] = options.radii[i] + options.spread;
                blArray[46] = true;
            }
            ++i;
            blArray[47] = true;
        }
        shadowPath.addRoundRect(shadowRect, shadowRadii, Path.Direction.CCW);
        blArray[48] = true;
        canvas2.drawPath(shadowPath, (Paint)shadowPaint);
        blArray[49] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void setNormalBoxShadow(View view, List<BoxShadowOptions> list, float f, float[] fArray) {
        void w;
        void h;
        View target;
        block19: {
            block18: {
                block17: {
                    boolean[] blArray = BoxShadowUtil.$jacocoInit();
                    int n = target.getHeight();
                    blArray[50] = true;
                    int n2 = target.getWidth();
                    blArray[51] = true;
                    ViewGroup.LayoutParams p = target.getLayoutParams();
                    if (h != false) break block17;
                    blArray[52] = true;
                    break block18;
                }
                if (w != false) break block19;
                blArray[53] = true;
            }
            Log.w((String)TAG, (String)"Target view is invisible, ignore set shadow.");
            blArray[54] = true;
            return;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            void shadowDrawable;
            void paddingY;
            OverflowBitmapDrawable rect;
            void canvasHeight;
            void quality;
            int maxHeight;
            void radii;
            void options;
            int maxWidth = 0;
            boolean bl = false;
            blArray[55] = true;
            Iterator iterator = options.iterator();
            blArray[56] = true;
            while (iterator.hasNext()) {
                void rect2;
                BoxShadowOptions option = (BoxShadowOptions)iterator.next();
                option.viewWidth = w;
                option.viewHeight = h;
                option.radii = radii;
                blArray[57] = true;
                Rect rect3 = option.getTargetCanvasRect();
                blArray[58] = true;
                if (maxWidth >= rect2.width()) {
                    blArray[59] = true;
                } else {
                    blArray[60] = true;
                    maxWidth = rect2.width();
                    blArray[61] = true;
                }
                if (maxHeight >= rect2.height()) {
                    blArray[62] = true;
                } else {
                    blArray[63] = true;
                    maxHeight = rect2.height();
                    blArray[64] = true;
                }
                blArray[65] = true;
            }
            int canvasWidth = (int)((float)maxWidth * quality);
            int option = (int)((float)maxHeight * quality);
            blArray[66] = true;
            Bitmap output = Bitmap.createBitmap((int)canvasWidth, (int)canvasHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
            if (Build.VERSION.SDK_INT < 19) {
                blArray[67] = true;
            } else {
                blArray[68] = true;
                WXLogUtils.d(TAG, "Allocation memory for box-shadow: " + output.getAllocationByteCount() / 1024 + " KB");
                blArray[69] = true;
            }
            Canvas canvas = new Canvas(output);
            blArray[70] = true;
            Iterator iterator2 = options.iterator();
            blArray[71] = true;
            while (iterator2.hasNext()) {
                void scaledOption;
                void canvas2;
                void top;
                void left;
                void option2;
                BoxShadowOptions boxShadowOptions = (BoxShadowOptions)iterator2.next();
                blArray[72] = true;
                Rect rect4 = option2.getTargetCanvasRect();
                blArray[73] = true;
                float f2 = (float)(maxWidth - rect.width()) / 2.0f;
                blArray[74] = true;
                float f3 = (float)(maxHeight - rect.height()) / 2.0f;
                blArray[75] = true;
                option2.topLeft = new PointF((float)left, (float)top);
                blArray[76] = true;
                BoxShadowOptions boxShadowOptions2 = option2.scale((float)quality);
                blArray[77] = true;
                BoxShadowUtil.drawShadow((Canvas)canvas2, (BoxShadowOptions)scaledOption);
                blArray[78] = true;
            }
            int paddingX = (maxWidth - w) / 2;
            int option2 = (maxHeight - h) / 2;
            blArray[79] = true;
            rect = new OverflowBitmapDrawable(target.getResources(), output, new Point(paddingX, (int)paddingY), new Rect(0, 0, (int)w, (int)h), (float[])radii, null);
            blArray[80] = true;
            target.getOverlay().add((Drawable)shadowDrawable);
            blArray[81] = true;
            ViewParent parent = target.getParent();
            if (parent == null) {
                blArray[82] = true;
            } else {
                blArray[83] = true;
                parent.requestLayout();
                if (!(parent instanceof ViewGroup)) {
                    blArray[84] = true;
                } else {
                    blArray[85] = true;
                    ((ViewGroup)parent).invalidate(shadowDrawable.getBounds());
                    blArray[86] = true;
                }
            }
            blArray[87] = true;
        } else {
            Log.w((String)TAG, (String)"Call setNormalBoxShadow() requires API level 18 or higher.");
            blArray[88] = true;
        }
        blArray[89] = true;
    }

    /*
     * WARNING - void declaration
     */
    private static void setInsetBoxShadow(View view, List<BoxShadowOptions> list, float f, float[] fArray) {
        void options;
        View target;
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                boolean[] blArray = BoxShadowUtil.$jacocoInit();
                                if (target != null) break block9;
                                blArray[90] = true;
                                break block10;
                            }
                            if (options != null) break block11;
                            blArray[91] = true;
                        }
                        WXLogUtils.w(TAG, "Illegal arguments");
                        blArray[92] = true;
                        return;
                    }
                    if (target.getWidth() != 0) break block12;
                    blArray[93] = true;
                    break block13;
                }
                if (target.getHeight() != 0) break block14;
                blArray[94] = true;
            }
            WXLogUtils.w(TAG, "Target view is invisible, ignore set shadow.");
            blArray[95] = true;
            return;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            void layerDrawable;
            void drawables;
            void i22;
            blArray[96] = true;
            Drawable[] drawableArray = new Drawable[options.size()];
            blArray[97] = true;
            boolean bl = false;
            blArray[98] = true;
            while (i22 < options.size()) {
                void radii;
                void option;
                InsetShadowDrawable shadow;
                blArray[99] = true;
                BoxShadowOptions boxShadowOptions = (BoxShadowOptions)options.get((int)i22);
                blArray[100] = true;
                drawables[i22] = shadow = new InsetShadowDrawable(target.getWidth(), target.getHeight(), option.hShadow, option.vShadow, option.blur, option.spread, option.color, (float[])radii, null);
                ++i22;
                blArray[101] = true;
            }
            LayerDrawable i22 = new LayerDrawable((Drawable[])drawables);
            blArray[102] = true;
            target.getOverlay().add((Drawable)layerDrawable);
            blArray[103] = true;
            target.invalidate();
            blArray[104] = true;
        } else {
            Log.w((String)TAG, (String)"Call setInsetBoxShadow() requires API level 18 or higher.");
            blArray[105] = true;
        }
        blArray[106] = true;
    }

    /*
     * WARNING - void declaration
     */
    public static BoxShadowOptions[] parseBoxShadows(String string2, int n) {
        String processedStyle;
        String boxShadowStyle;
        boolean[] blArray = BoxShadowUtil.$jacocoInit();
        if (sColorPattern != null) {
            blArray[107] = true;
        } else {
            blArray[108] = true;
            sColorPattern = Pattern.compile("([rR][gG][bB][aA]?)\\((\\d+\\s*),\\s*(\\d+\\s*),\\s*(\\d+\\s*)(?:,\\s*(\\d+(?:\\.\\d+)?))?\\)");
            blArray[109] = true;
        }
        Matcher matcher = sColorPattern.matcher(boxShadowStyle);
        String string3 = boxShadowStyle;
        blArray[110] = true;
        while (matcher.find()) {
            void color;
            blArray[111] = true;
            String string4 = matcher.group();
            blArray[112] = true;
            processedStyle = processedStyle.replace((CharSequence)color, "#" + String.format("%8s", Integer.toHexString(WXResourceUtils.getColor((String)color, -16777216))).replaceAll("\\s", "0"));
            blArray[113] = true;
        }
        String[] styles = processedStyle.split(",");
        if (styles == null) {
            blArray[114] = true;
        } else if (styles.length <= 0) {
            blArray[115] = true;
        } else {
            void i;
            BoxShadowOptions[] result = new BoxShadowOptions[styles.length];
            boolean bl = false;
            blArray[116] = true;
            while (i < styles.length) {
                void viewport;
                blArray[117] = true;
                result[i] = BoxShadowUtil.parseBoxShadow(styles[i], (int)viewport);
                ++i;
                blArray[118] = true;
            }
            blArray[119] = true;
            return result;
        }
        blArray[120] = true;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static BoxShadowOptions parseBoxShadow(String var0, int var1_1) {
        block12: {
            block15: {
                block17: {
                    block16: {
                        block14: {
                            block13: {
                                var2_2 = BoxShadowUtil.$jacocoInit();
                                var3_3 = new BoxShadowOptions((int)viewport, null);
                                var2_2[121] = true;
                                if (TextUtils.isEmpty((CharSequence)boxShadow)) {
                                    var2_2[122] = true;
                                    return null;
                                }
                                var4_4 = boxShadow;
                                var2_2[123] = true;
                                boxShadowCopy = boxShadowCopy.replaceAll("\\s*,\\s+", ",");
                                var2_2[124] = true;
                                if (!boxShadowCopy.contains("inset")) {
                                    var2_2[125] = true;
                                } else {
                                    result.isInset = true;
                                    var2_2[126] = true;
                                    boxShadowCopy = boxShadowCopy.replace("inset", "");
                                    var2_2[127] = true;
                                }
                                boxShadowCopy = boxShadowCopy.trim();
                                var2_2[128] = true;
                                var5_5 = new ArrayList<String>(Arrays.asList(boxShadowCopy.split("\\s+")));
                                var2_2[129] = true;
                                var6_6 = (String)params.get(params.size() - 1);
                                var2_2[130] = true;
                                if (!TextUtils.isEmpty((CharSequence)maybeColor)) break block13;
                                var2_2[131] = true;
                                ** GOTO lbl49
                            }
                            var2_2[132] = true;
                            if (!maybeColor.startsWith("#")) break block14;
                            var2_2[133] = true;
                            break block15;
                        }
                        if (!maybeColor.startsWith("rgb")) break block16;
                        var2_2[134] = true;
                        break block15;
                    }
                    if (WXResourceUtils.isNamedColor((String)maybeColor)) break block17;
                    var2_2[135] = true;
                    ** GOTO lbl49
                }
                var2_2[136] = true;
            }
            result.color = WXResourceUtils.getColor((String)maybeColor, -16777216);
            var2_2[137] = true;
            params.remove(params.size() - 1);
            var2_2[138] = true;
lbl49:
            // 3 sources

            if (params.size() >= 2) {
                var2_2[139] = true;
                break block12;
            }
            var2_2[140] = true;
            return null;
        }
        try {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)params.get(0)))) {
                var2_2[141] = true;
            } else {
                var2_2[142] = true;
                var7_7 = WXUtils.getFloat(((String)params.get(0)).trim(), Float.valueOf(0.0f)).floatValue();
                var2_2[143] = true;
                result.hShadow = WXViewUtils.getRealSubPxByWidth(px, (int)viewport);
                var2_2[144] = true;
            }
            if (TextUtils.isEmpty((CharSequence)((CharSequence)params.get(1)))) {
                var2_2[145] = true;
            } else {
                var2_2[146] = true;
                px = WXUtils.getFloat(((String)params.get(1)).trim(), Float.valueOf(0.0f)).floatValue();
                var2_2[147] = true;
                result.vShadow = WXViewUtils.getRealPxByWidth(px, (int)viewport);
                var2_2[148] = true;
            }
            px = 2;
            var2_2[149] = true;
            while (i < params.size()) {
                var8_10 = i - 2;
                var2_2[150] = true;
                var9_11 = (BoxShadowOptions.IParser)BoxShadowOptions.access$500((BoxShadowOptions)result).get((int)parserIndex);
                var2_2[151] = true;
                parser.parse((String)params.get((int)i));
                ++i;
                var2_2[152] = true;
            }
            var2_2[153] = true;
        }
        catch (Throwable i) {
            var2_2[154] = true;
            t.printStackTrace();
            var2_2[155] = true;
        }
        var2_2[156] = true;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(View view, List list, float f, float[] fArray) {
        void x3;
        void x2;
        void x1;
        View x0;
        boolean[] blArray = BoxShadowUtil.$jacocoInit();
        BoxShadowUtil.setNormalBoxShadow(x0, (List<BoxShadowOptions>)x1, (float)x2, (float[])x3);
        blArray[157] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(View view, List list, float f, float[] fArray) {
        void x3;
        void x2;
        void x1;
        View x0;
        boolean[] blArray = BoxShadowUtil.$jacocoInit();
        BoxShadowUtil.setInsetBoxShadow(x0, (List<BoxShadowOptions>)x1, (float)x2, (float[])x3);
        blArray[158] = true;
    }

    static {
        boolean[] blArray = BoxShadowUtil.$jacocoInit();
        sBoxShadowEnabled = true;
        blArray[159] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-5786973724711575516L, (String)"com/taobao/weex/utils/BoxShadowUtil", (int)160);
        }
        return blArray;
    }

    public static class BoxShadowOptions {
        private List<IParser> optionParamParsers;
        private int viewport;
        public float hShadow;
        public float vShadow;
        public float blur;
        public float spread;
        public float[] radii;
        public int color;
        public boolean isInset;
        public int viewWidth;
        public int viewHeight;
        public PointF topLeft;
        private static final transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        private BoxShadowOptions(int n) {
            void spreadParser;
            void blurParser;
            boolean[] blArray = BoxShadowOptions.$jacocoInit();
            this.viewport = 750;
            this.blur = 0.0f;
            this.spread = 0.0f;
            this.radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            this.color = -16777216;
            this.isInset = false;
            this.viewWidth = 0;
            this.viewHeight = 0;
            this.topLeft = null;
            if (this.viewport == 0) {
                blArray[0] = true;
            } else {
                void vp;
                this.viewport = vp;
                blArray[1] = true;
            }
            this.optionParamParsers = new ArrayList<IParser>();
            blArray[2] = true;
            IParser iParser = new IParser(this){
                final /* synthetic */ BoxShadowOptions this$0;
                private static final transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 1.$jacocoInit();
                    this.this$0 = this$0;
                    blArray[0] = true;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void parse(String string2) {
                    void param;
                    boolean[] blArray = 1.$jacocoInit();
                    if (TextUtils.isEmpty((CharSequence)param)) {
                        blArray[1] = true;
                    } else {
                        void px;
                        blArray[2] = true;
                        float f = WXUtils.getFloat(param, Float.valueOf(0.0f)).floatValue();
                        blArray[3] = true;
                        this.this$0.spread = WXViewUtils.getRealSubPxByWidth((float)px, BoxShadowOptions.access$600(this.this$0));
                        blArray[4] = true;
                        WXLogUtils.w(BoxShadowUtil.TAG, "Experimental box-shadow attribute: spread");
                        blArray[5] = true;
                    }
                    blArray[6] = true;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-3001446126167292908L, (String)"com/taobao/weex/utils/BoxShadowUtil$BoxShadowOptions$1", (int)7);
                    }
                    return blArray;
                }
            };
            blArray[3] = true;
            IParser iParser2 = new IParser(this){
                final /* synthetic */ BoxShadowOptions this$0;
                private static final transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 2.$jacocoInit();
                    this.this$0 = this$0;
                    blArray[0] = true;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void parse(String string2) {
                    void param;
                    boolean[] blArray = 2.$jacocoInit();
                    if (TextUtils.isEmpty((CharSequence)param)) {
                        blArray[1] = true;
                    } else {
                        void px;
                        blArray[2] = true;
                        float f = WXUtils.getFloat(param, Float.valueOf(0.0f)).floatValue();
                        blArray[3] = true;
                        this.this$0.blur = WXViewUtils.getRealSubPxByWidth((float)px, BoxShadowOptions.access$600(this.this$0));
                        blArray[4] = true;
                    }
                    blArray[5] = true;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-2853570194300930051L, (String)"com/taobao/weex/utils/BoxShadowUtil$BoxShadowOptions$2", (int)6);
                    }
                    return blArray;
                }
            };
            blArray[4] = true;
            this.optionParamParsers.add((IParser)blurParser);
            blArray[5] = true;
            this.optionParamParsers.add((IParser)spreadParser);
            blArray[6] = true;
        }

        /*
         * WARNING - void declaration
         */
        public BoxShadowOptions scale(float f) {
            void scale;
            boolean[] blArray = BoxShadowOptions.$jacocoInit();
            if (!(scale > 0.0f)) {
                blArray[7] = true;
            } else if (!(scale <= 1.0f)) {
                blArray[8] = true;
            } else {
                void i;
                blArray[9] = true;
                BoxShadowOptions scaledOptions = new BoxShadowOptions(this.viewport);
                scaledOptions.hShadow = this.hShadow * scale;
                scaledOptions.vShadow = this.vShadow * scale;
                scaledOptions.blur = this.blur * scale;
                scaledOptions.spread = this.spread * scale;
                boolean bl = false;
                blArray[10] = true;
                while (i < this.radii.length) {
                    scaledOptions.radii[i] = this.radii[i] * scale;
                    ++i;
                    blArray[11] = true;
                }
                scaledOptions.viewHeight = (int)((float)this.viewHeight * scale);
                scaledOptions.viewWidth = (int)((float)this.viewWidth * scale);
                if (this.topLeft == null) {
                    blArray[12] = true;
                } else {
                    blArray[13] = true;
                    scaledOptions.topLeft = new PointF();
                    scaledOptions.topLeft.x = this.topLeft.x * scale;
                    scaledOptions.topLeft.y = this.topLeft.y * scale;
                    blArray[14] = true;
                }
                scaledOptions.color = this.color;
                scaledOptions.isInset = this.isInset;
                blArray[15] = true;
                WXLogUtils.d(BoxShadowUtil.TAG, "Scaled BoxShadowOptions: [" + (float)scale + "] " + scaledOptions);
                blArray[16] = true;
                return scaledOptions;
            }
            blArray[17] = true;
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Rect getTargetCanvasRect() {
            void canvasHeight;
            void canvasWidth;
            boolean[] blArray = BoxShadowOptions.$jacocoInit();
            int n = this.viewWidth + 2 * (int)(this.blur + this.spread + Math.abs(this.hShadow));
            blArray[18] = true;
            int n2 = this.viewHeight + 2 * (int)(this.blur + this.spread + Math.abs(this.vShadow));
            blArray[19] = true;
            blArray[20] = true;
            return new Rect(0, 0, (int)canvasWidth, (int)canvasHeight);
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void r;
            void sb;
            boolean[] blArray = BoxShadowOptions.$jacocoInit();
            String string2 = "[" + this.radii[0] + "," + this.radii[2] + "," + this.radii[4] + "," + this.radii[6] + "]";
            blArray[21] = true;
            StringBuffer stringBuffer = new StringBuffer("BoxShadowOptions{");
            blArray[22] = true;
            sb.append("h-shadow=").append(this.hShadow);
            blArray[23] = true;
            sb.append(", v-shadow=").append(this.vShadow);
            blArray[24] = true;
            sb.append(", blur=").append(this.blur);
            blArray[25] = true;
            sb.append(", spread=").append(this.spread);
            blArray[26] = true;
            sb.append(", corner-radius=").append((String)r);
            blArray[27] = true;
            sb.append(", color=#").append(Integer.toHexString(this.color));
            blArray[28] = true;
            sb.append(", inset=").append(this.isInset);
            blArray[29] = true;
            sb.append('}');
            blArray[30] = true;
            blArray[31] = true;
            return sb.toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ BoxShadowOptions(int n, com.taobao.weex.utils.BoxShadowUtil$1 var2_2) {
            void x0;
            boolean[] blArray = BoxShadowOptions.$jacocoInit();
            this((int)x0);
            blArray[32] = true;
        }

        static /* synthetic */ List access$500(BoxShadowOptions boxShadowOptions) {
            BoxShadowOptions x0;
            boolean[] blArray = BoxShadowOptions.$jacocoInit();
            blArray[33] = true;
            return x0.optionParamParsers;
        }

        static /* synthetic */ int access$600(BoxShadowOptions boxShadowOptions) {
            BoxShadowOptions x0;
            boolean[] blArray = BoxShadowOptions.$jacocoInit();
            blArray[34] = true;
            return x0.viewport;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)2970479754294225753L, (String)"com/taobao/weex/utils/BoxShadowUtil$BoxShadowOptions", (int)35);
            }
            return blArray;
        }

        private static interface IParser {
            public void parse(String var1);
        }
    }

    private static class InsetShadowDrawable
    extends Drawable {
        private static final int LEFT_TO_RIGHT = 0;
        private static final int TOP_TO_BOTTOM = 1;
        private static final int RIGHT_TO_LEFT = 2;
        private static final int BOTTOM_TO_TOP = 3;
        private float blurRadius;
        private int shadowColor;
        private float[] radii;
        private float width;
        private float height;
        private float shadowXSize;
        private float shadowYSize;
        private Shader[] shades;
        private Path[] paths;
        private Paint paint;
        private static final transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        private InsetShadowDrawable(int n, int n2, float f, float f2, float f3, float f4, int n3, float[] fArray) {
            void radii;
            void spread;
            void dy;
            void viewHeight;
            void dx;
            void viewWidth;
            void shadowColor;
            void blurRadius;
            boolean[] blArray = InsetShadowDrawable.$jacocoInit();
            this.shades = new Shader[4];
            this.paths = new Path[4];
            this.blurRadius = blurRadius;
            this.shadowColor = shadowColor;
            this.width = (float)viewWidth + 2.0f * dx;
            this.height = (float)viewHeight + 2.0f * dy;
            this.shadowXSize = dx + spread;
            this.shadowYSize = dy + spread;
            this.radii = radii;
            blArray[0] = true;
            this.setBounds(0, 0, (int)viewWidth, (int)viewHeight);
            blArray[1] = true;
            this.prepare();
            blArray[2] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void prepare() {
            void bttPath;
            void rtlPath;
            void ttbPath;
            void d;
            void h;
            void ltrPath;
            void rtl;
            void ttb;
            void ltr;
            void g;
            void f;
            void e;
            void c;
            void a;
            void b;
            boolean[] blArray = InsetShadowDrawable.$jacocoInit();
            PointF pointF = new PointF(0.0f, 0.0f);
            blArray[3] = true;
            PointF pointF2 = new PointF(this.width, 0.0f);
            blArray[4] = true;
            PointF pointF3 = new PointF(b.x, this.height);
            blArray[5] = true;
            PointF pointF4 = new PointF(a.x, c.y);
            blArray[6] = true;
            PointF pointF5 = new PointF(this.shadowXSize, this.shadowYSize);
            blArray[7] = true;
            PointF pointF6 = new PointF(b.x - this.shadowXSize, e.y);
            blArray[8] = true;
            PointF pointF7 = new PointF(f.x, c.y - this.shadowYSize);
            blArray[9] = true;
            PointF pointF8 = new PointF(e.x, g.y);
            blArray[10] = true;
            LinearGradient linearGradient = new LinearGradient(e.x - this.blurRadius, e.y, e.x, e.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
            blArray[11] = true;
            LinearGradient linearGradient2 = new LinearGradient(e.x, e.y - this.blurRadius, e.x, e.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
            blArray[12] = true;
            LinearGradient linearGradient3 = new LinearGradient(g.x + this.blurRadius, g.y, g.x, g.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
            blArray[13] = true;
            LinearGradient btt = new LinearGradient(g.x, g.y + this.blurRadius, g.x, g.y, this.shadowColor, 0, Shader.TileMode.CLAMP);
            this.shades[0] = ltr;
            this.shades[1] = ttb;
            this.shades[2] = rtl;
            this.shades[3] = btt;
            blArray[14] = true;
            Path path = new Path();
            blArray[15] = true;
            ltrPath.moveTo(a.x, a.y);
            blArray[16] = true;
            ltrPath.lineTo(e.x, e.y);
            blArray[17] = true;
            ltrPath.lineTo(h.x, h.y);
            blArray[18] = true;
            ltrPath.lineTo(d.x, d.y);
            blArray[19] = true;
            ltrPath.close();
            blArray[20] = true;
            Path path2 = new Path();
            blArray[21] = true;
            ttbPath.moveTo(a.x, a.y);
            blArray[22] = true;
            ttbPath.lineTo(b.x, b.y);
            blArray[23] = true;
            ttbPath.lineTo(f.x, f.y);
            blArray[24] = true;
            ttbPath.lineTo(e.x, e.y);
            blArray[25] = true;
            ttbPath.close();
            blArray[26] = true;
            Path path3 = new Path();
            blArray[27] = true;
            rtlPath.moveTo(b.x, b.y);
            blArray[28] = true;
            rtlPath.lineTo(c.x, c.y);
            blArray[29] = true;
            rtlPath.lineTo(g.x, g.y);
            blArray[30] = true;
            rtlPath.lineTo(f.x, f.y);
            blArray[31] = true;
            rtlPath.close();
            blArray[32] = true;
            Path path4 = new Path();
            blArray[33] = true;
            bttPath.moveTo(d.x, d.y);
            blArray[34] = true;
            bttPath.lineTo(c.x, c.y);
            blArray[35] = true;
            bttPath.lineTo(g.x, g.y);
            blArray[36] = true;
            bttPath.lineTo(h.x, h.y);
            blArray[37] = true;
            bttPath.close();
            this.paths[0] = ltrPath;
            this.paths[1] = ttbPath;
            this.paths[2] = rtlPath;
            this.paths[3] = bttPath;
            blArray[38] = true;
            this.paint = new Paint();
            blArray[39] = true;
            this.paint.setAntiAlias(true);
            blArray[40] = true;
            this.paint.setStyle(Paint.Style.FILL);
            blArray[41] = true;
            this.paint.setColor(this.shadowColor);
            blArray[42] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void draw(Canvas canvas) {
            void i;
            void rectF;
            void border;
            void bounds;
            void canvas2;
            boolean[] blArray = InsetShadowDrawable.$jacocoInit();
            Rect rect = canvas2.getClipBounds();
            blArray[43] = true;
            Path path = new Path();
            blArray[44] = true;
            RectF rectF2 = new RectF((Rect)bounds);
            blArray[45] = true;
            border.addRoundRect((RectF)rectF, this.radii, Path.Direction.CCW);
            blArray[46] = true;
            canvas2.clipPath((Path)border);
            blArray[47] = true;
            canvas2.translate((float)bounds.left, (float)bounds.top);
            boolean bl = false;
            blArray[48] = true;
            while (i < 4) {
                void path2;
                Shader shader = this.shades[i];
                Path path3 = this.paths[i];
                blArray[49] = true;
                this.paint.setShader(shader);
                blArray[50] = true;
                canvas2.drawPath((Path)path2, this.paint);
                ++i;
                blArray[51] = true;
            }
            blArray[52] = true;
        }

        public void setAlpha(@IntRange(from=0L, to=255L) int n) {
            boolean[] blArray = InsetShadowDrawable.$jacocoInit();
            blArray[53] = true;
        }

        public void setColorFilter(@Nullable ColorFilter colorFilter) {
            boolean[] blArray = InsetShadowDrawable.$jacocoInit();
            blArray[54] = true;
        }

        public int getOpacity() {
            boolean[] blArray = InsetShadowDrawable.$jacocoInit();
            blArray[55] = true;
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ InsetShadowDrawable(int n, int n2, float f, float f2, float f3, float f4, int n3, float[] fArray, 1 var9_9) {
            void x7;
            void x6;
            void x5;
            void x4;
            void x3;
            void x2;
            void x1;
            void x0;
            boolean[] blArray = InsetShadowDrawable.$jacocoInit();
            this((int)x0, (int)x1, (float)x2, (float)x3, (float)x4, (float)x5, (int)x6, (float[])x7);
            blArray[56] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)623045553784419351L, (String)"com/taobao/weex/utils/BoxShadowUtil$InsetShadowDrawable", (int)57);
            }
            return blArray;
        }
    }

    private static class OverflowBitmapDrawable
    extends BitmapDrawable {
        private int paddingX;
        private int paddingY;
        private Rect viewRect;
        private float[] radii;
        private static final transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        private OverflowBitmapDrawable(Resources resources, Bitmap bitmap, Point point, Rect rect, float[] fArray) {
            void radii;
            void viewRect;
            void topLeft;
            void bitmap2;
            void resources2;
            boolean[] blArray = OverflowBitmapDrawable.$jacocoInit();
            super((Resources)resources2, (Bitmap)bitmap2);
            this.paddingX = topLeft.x;
            this.paddingY = topLeft.y;
            this.viewRect = viewRect;
            this.radii = radii;
            blArray[0] = true;
            this.setBounds(-this.paddingX, -this.paddingY, viewRect.width() + this.paddingX, viewRect.height() + this.paddingY);
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void draw(Canvas canvas) {
            void rectF;
            void contentPath;
            void newRect;
            void bounds;
            void canvas2;
            boolean[] blArray = OverflowBitmapDrawable.$jacocoInit();
            Rect rect = canvas2.getClipBounds();
            blArray[2] = true;
            Rect rect2 = new Rect((Rect)bounds);
            blArray[3] = true;
            newRect.inset(-this.paddingX * 2, -this.paddingY * 2);
            blArray[4] = true;
            canvas2.clipRect((Rect)newRect, Region.Op.REPLACE);
            blArray[5] = true;
            Path path = new Path();
            blArray[6] = true;
            RectF rectF2 = new RectF((Rect)bounds);
            blArray[7] = true;
            contentPath.addRoundRect((RectF)rectF, this.radii, Path.Direction.CCW);
            blArray[8] = true;
            canvas2.clipPath((Path)contentPath, Region.Op.DIFFERENCE);
            blArray[9] = true;
            canvas2.translate((float)bounds.left, (float)bounds.top);
            blArray[10] = true;
            super.draw((Canvas)canvas2);
            blArray[11] = true;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ OverflowBitmapDrawable(Resources resources, Bitmap bitmap, Point point, Rect rect, float[] fArray, 1 var6_6) {
            void x4;
            void x3;
            void x2;
            void x1;
            void x0;
            boolean[] blArray = OverflowBitmapDrawable.$jacocoInit();
            this((Resources)x0, (Bitmap)x1, (Point)x2, (Rect)x3, (float[])x4);
            blArray[12] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-9134652153690576096L, (String)"com/taobao/weex/utils/BoxShadowUtil$OverflowBitmapDrawable", (int)13);
            }
            return blArray;
        }
    }
}

