/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.circlebar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.taobao.weex.ui.view.refresh.circlebar.MaterialProgressDrawable;
import org.jacoco.agent.rt.internal_b0d6a23.Offline;

public class CircleProgressBar
extends ImageView {
    private static final int KEY_SHADOW_COLOR = 0x1E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.75f;
    private static final float SHADOW_RADIUS = 3.5f;
    private static final int SHADOW_ELEVATION = 4;
    public static final int DEFAULT_CIRCLE_BG_LIGHT = -328966;
    public static final int DEFAULT_CIRCLE_COLOR = -1048576;
    private static final int DEFAULT_CIRCLE_DIAMETER = 40;
    private static final int STROKE_WIDTH_LARGE = 3;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;
    private int mBackGroundColor;
    private int mProgressColor;
    private int mProgressStokeWidth;
    private int mArrowWidth;
    private int mArrowHeight;
    private int mProgress;
    private int mMax;
    private int mDiameter;
    private int mInnerRadius;
    private boolean mShowArrow;
    public MaterialProgressDrawable mProgressDrawable;
    private ShapeDrawable mBgCircle;
    private boolean mCircleBackgroundEnabled;
    private int[] mColors;
    private static final transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public CircleProgressBar(Context context) {
        void context2;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super((Context)context2);
        this.mColors = new int[]{-16777216};
        blArray[0] = true;
        this.init((Context)context2, null, 0);
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    public CircleProgressBar(Context context, AttributeSet attributeSet) {
        void attrs;
        void context2;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super((Context)context2, (AttributeSet)attrs);
        this.mColors = new int[]{-16777216};
        blArray[2] = true;
        this.init((Context)context2, (AttributeSet)attrs, 0);
        blArray[3] = true;
    }

    /*
     * WARNING - void declaration
     */
    public CircleProgressBar(Context context, AttributeSet attributeSet, int n) {
        void defStyleAttr;
        void attrs;
        void context2;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super((Context)context2, (AttributeSet)attrs, (int)defStyleAttr);
        this.mColors = new int[]{-16777216};
        blArray[4] = true;
        this.init((Context)context2, (AttributeSet)attrs, (int)defStyleAttr);
        blArray[5] = true;
    }

    private void init(Context context, AttributeSet attributeSet, int n) {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        float density = this.getContext().getResources().getDisplayMetrics().density;
        this.mBackGroundColor = -328966;
        this.mProgressColor = -1048576;
        this.mColors = new int[]{this.mProgressColor};
        this.mInnerRadius = -1;
        this.mProgressStokeWidth = (int)(3.0f * density);
        this.mArrowWidth = -1;
        this.mArrowHeight = -1;
        this.mShowArrow = true;
        this.mCircleBackgroundEnabled = true;
        this.mProgress = 0;
        this.mMax = 100;
        blArray[6] = true;
        this.mProgressDrawable = new MaterialProgressDrawable(this.getContext(), (View)this);
        blArray[7] = true;
        super.setImageDrawable((Drawable)this.mProgressDrawable);
        blArray[8] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setProgressBackGroundColor(int n) {
        void color;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mBackGroundColor = color;
        blArray[9] = true;
    }

    private boolean elevationSupported() {
        boolean bl;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        if (Build.VERSION.SDK_INT >= 21) {
            bl = blArray[10] = true;
        } else {
            bl = false;
            blArray[11] = true;
        }
        blArray[12] = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int n, int n2) {
        void heightMeasureSpec;
        void widthMeasureSpec;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super.onMeasure((int)widthMeasureSpec, (int)heightMeasureSpec);
        blArray[13] = true;
        if (this.elevationSupported()) {
            blArray[14] = true;
        } else {
            blArray[15] = true;
            this.setMeasuredDimension(this.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
            blArray[16] = true;
        }
        blArray[17] = true;
    }

    public int getProgressStokeWidth() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        blArray[18] = true;
        return this.mProgressStokeWidth;
    }

    /*
     * WARNING - void declaration
     */
    public void setProgressStokeWidth(int n) {
        void mProgressStokeWidth;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        float density = this.getContext().getResources().getDisplayMetrics().density;
        this.mProgressStokeWidth = (int)((float)mProgressStokeWidth * density);
        blArray[19] = true;
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        void density;
        void bottom;
        void right;
        void top;
        void left;
        void changed;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super.onLayout((boolean)changed, (int)left, (int)top, (int)right, (int)bottom);
        blArray[20] = true;
        float f = this.getContext().getResources().getDisplayMetrics().density;
        blArray[21] = true;
        this.mDiameter = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
        if (this.mDiameter > 0) {
            blArray[22] = true;
        } else {
            this.mDiameter = (int)density * 40;
            blArray[23] = true;
        }
        if (this.getBackground() != null) {
            blArray[24] = true;
        } else if (!this.mCircleBackgroundEnabled) {
            blArray[25] = true;
        } else {
            int shadowYOffset = (int)(density * 1.75f);
            int shadowXOffset = (int)(density * 0.0f);
            this.mShadowRadius = (int)(density * 3.5f);
            blArray[26] = true;
            if (this.elevationSupported()) {
                blArray[27] = true;
                this.mBgCircle = new ShapeDrawable((Shape)new OvalShape());
                blArray[28] = true;
                ViewCompat.setElevation((View)this, (float)(4.0f * density));
                blArray[29] = true;
            } else {
                void padding;
                void oval;
                OvalShadow ovalShadow = new OvalShadow(this, this.mShadowRadius, this.mDiameter - this.mShadowRadius * 2);
                blArray[30] = true;
                this.mBgCircle = new ShapeDrawable((Shape)oval);
                blArray[31] = true;
                ViewCompat.setLayerType((View)this, (int)1, (Paint)this.mBgCircle.getPaint());
                blArray[32] = true;
                this.mBgCircle.getPaint().setShadowLayer((float)this.mShadowRadius, (float)shadowXOffset, (float)shadowYOffset, 0x1E000000);
                int n5 = this.mShadowRadius;
                blArray[33] = true;
                this.setPadding((int)padding, (int)padding, (int)padding, (int)padding);
                blArray[34] = true;
            }
            this.mBgCircle.getPaint().setColor(this.mBackGroundColor);
            blArray[35] = true;
            this.setBackgroundDrawable((Drawable)this.mBgCircle);
            blArray[36] = true;
        }
        this.mProgressDrawable.setBackgroundColor(this.mBackGroundColor);
        blArray[37] = true;
        this.mProgressDrawable.setColorSchemeColors(this.mColors);
        blArray[38] = true;
        if (!this.isShowArrow()) {
            blArray[39] = true;
        } else {
            blArray[40] = true;
            this.mProgressDrawable.setArrowScale(1.0f);
            blArray[41] = true;
            this.mProgressDrawable.showArrow(true);
            blArray[42] = true;
        }
        super.setImageDrawable(null);
        blArray[43] = true;
        super.setImageDrawable((Drawable)this.mProgressDrawable);
        blArray[44] = true;
        this.mProgressDrawable.setAlpha(255);
        blArray[45] = true;
        if (this.getVisibility() != 0) {
            blArray[46] = true;
        } else {
            blArray[47] = true;
            this.mProgressDrawable.setStartEndTrim(0.0f, 0.8f);
            blArray[48] = true;
        }
        blArray[49] = true;
    }

    public boolean isShowArrow() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        blArray[50] = true;
        return this.mShowArrow;
    }

    /*
     * WARNING - void declaration
     */
    public void setShowArrow(boolean bl) {
        void showArrow;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mShowArrow = showArrow;
        blArray[51] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setAnimationListener(Animation.AnimationListener animationListener) {
        void listener;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mListener = listener;
        blArray[52] = true;
    }

    public void onAnimationStart() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super.onAnimationStart();
        if (this.mListener == null) {
            blArray[53] = true;
        } else {
            blArray[54] = true;
            this.mListener.onAnimationStart(this.getAnimation());
            blArray[55] = true;
        }
        blArray[56] = true;
    }

    public void onAnimationEnd() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super.onAnimationEnd();
        if (this.mListener == null) {
            blArray[57] = true;
        } else {
            blArray[58] = true;
            this.mListener.onAnimationEnd(this.getAnimation());
            blArray[59] = true;
        }
        blArray[60] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setColorSchemeColors(int ... nArray) {
        void colors;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mColors = colors;
        if (this.mProgressDrawable == null) {
            blArray[61] = true;
        } else {
            blArray[62] = true;
            this.mProgressDrawable.setColorSchemeColors((int[])colors);
            blArray[63] = true;
        }
        blArray[64] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundColorResource(int n) {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        if (!(this.getBackground() instanceof ShapeDrawable)) {
            blArray[65] = true;
        } else {
            void colorRes;
            void res;
            blArray[66] = true;
            Resources resources = this.getResources();
            blArray[67] = true;
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(res.getColor((int)colorRes));
            blArray[68] = true;
        }
        blArray[69] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundColor(int n) {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        if (!(this.getBackground() instanceof ShapeDrawable)) {
            blArray[70] = true;
        } else {
            void color;
            blArray[71] = true;
            ((ShapeDrawable)this.getBackground()).getPaint().setColor((int)color);
            blArray[72] = true;
        }
        blArray[73] = true;
    }

    public int getMax() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        blArray[74] = true;
        return this.mMax;
    }

    /*
     * WARNING - void declaration
     */
    public void setMax(int n) {
        void max;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mMax = max;
        blArray[75] = true;
    }

    public int getProgress() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        blArray[76] = true;
        return this.mProgress;
    }

    /*
     * WARNING - void declaration
     */
    public void setProgress(int n) {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        if (this.getMax() <= 0) {
            blArray[77] = true;
        } else {
            void progress;
            this.mProgress = progress;
            blArray[78] = true;
        }
        this.invalidate();
        blArray[79] = true;
    }

    public boolean circleBackgroundEnabled() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        blArray[80] = true;
        return this.mCircleBackgroundEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setCircleBackgroundEnabled(boolean bl) {
        void enableCircleBackground;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mCircleBackgroundEnabled = enableCircleBackground;
        blArray[81] = true;
    }

    protected void onAttachedToWindow() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super.onAttachedToWindow();
        if (this.mProgressDrawable == null) {
            blArray[82] = true;
        } else {
            boolean bl;
            blArray[83] = true;
            this.mProgressDrawable.stop();
            blArray[84] = true;
            if (this.getVisibility() == 0) {
                bl = blArray[85] = true;
            } else {
                bl = false;
                blArray[86] = true;
            }
            this.mProgressDrawable.setVisible(bl, false);
            blArray[87] = true;
        }
        blArray[88] = true;
    }

    protected void onDetachedFromWindow() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        super.onDetachedFromWindow();
        if (this.mProgressDrawable == null) {
            blArray[89] = true;
        } else {
            blArray[90] = true;
            this.mProgressDrawable.stop();
            blArray[91] = true;
            this.mProgressDrawable.setVisible(false, false);
            blArray[92] = true;
        }
        blArray[93] = true;
    }

    public void start() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mProgressDrawable.start();
        blArray[94] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setStartEndTrim(float f, float f2) {
        void endAngle;
        void startAngle;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mProgressDrawable.setStartEndTrim((float)startAngle, (float)endAngle);
        blArray[95] = true;
    }

    public void stop() {
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mProgressDrawable.stop();
        blArray[96] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setProgressRotation(float f) {
        void rotation;
        boolean[] blArray = CircleProgressBar.$jacocoInit();
        this.mProgressDrawable.setProgressRotation((float)rotation);
        blArray[97] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-8137010856730187997L, (String)"com/taobao/weex/ui/view/refresh/circlebar/CircleProgressBar", (int)98);
        }
        return blArray;
    }

    private class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private int mShadowRadius;
        private Paint mShadowPaint;
        private int mCircleDiameter;
        final /* synthetic */ CircleProgressBar this$0;
        private static final transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public OvalShadow(CircleProgressBar circleProgressBar, int n, int n2) {
            void circleDiameter;
            void shadowRadius;
            boolean[] blArray = OvalShadow.$jacocoInit();
            this.this$0 = circleProgressBar;
            blArray[0] = true;
            blArray[1] = true;
            this.mShadowPaint = new Paint();
            this.mShadowRadius = shadowRadius;
            this.mCircleDiameter = circleDiameter;
            blArray[2] = true;
            this.mRadialGradient = new RadialGradient((float)(this.mCircleDiameter / 2), (float)(this.mCircleDiameter / 2), (float)this.mShadowRadius, new int[]{0x3D000000, 0}, null, Shader.TileMode.CLAMP);
            blArray[3] = true;
            this.mShadowPaint.setShader((Shader)this.mRadialGradient);
            blArray[4] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void draw(Canvas canvas, Paint paint) {
            void paint2;
            void viewHeight;
            void viewWidth;
            void canvas2;
            boolean[] blArray = OvalShadow.$jacocoInit();
            int n = this.this$0.getWidth();
            blArray[5] = true;
            int n2 = this.this$0.getHeight();
            blArray[6] = true;
            canvas2.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(this.mCircleDiameter / 2 + this.mShadowRadius), this.mShadowPaint);
            blArray[7] = true;
            canvas2.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(this.mCircleDiameter / 2), (Paint)paint2);
            blArray[8] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-6981962019769824068L, (String)"com/taobao/weex/ui/view/refresh/circlebar/CircleProgressBar$OvalShadow", (int)9);
            }
            return blArray;
        }
    }
}

