/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseIntArray;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.ui.view.border.BorderEdge;
import com.taobao.weex.ui.view.border.BorderStyle;
import com.taobao.weex.ui.view.border.BorderUtil;
import com.taobao.weex.ui.view.border.BottomLeftCorner;
import com.taobao.weex.ui.view.border.BottomRightCorner;
import com.taobao.weex.ui.view.border.TopLeftCorner;
import com.taobao.weex.ui.view.border.TopRightCorner;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jacoco.agent.rt.internal_b0d6a23.Offline;

public class BorderDrawable
extends Drawable {
    public static final int BORDER_TOP_LEFT_RADIUS = 0;
    public static final int BORDER_TOP_RIGHT_RADIUS = 1;
    public static final int BORDER_BOTTOM_RIGHT_RADIUS = 2;
    public static final int BORDER_BOTTOM_LEFT_RADIUS = 3;
    public static final int BORDER_RADIUS_ALL = 5;
    static final int DEFAULT_BORDER_COLOR = -16777216;
    static final float DEFAULT_BORDER_WIDTH = 0.0f;
    private static final BorderStyle DEFAULT_BORDER_STYLE;
    private static final String TAG = "Border";
    private final Paint mPaint;
    private static BorderStyle[] sBorderStyle;
    @Nullable
    private CSSShorthand<CSSShorthand.EDGE> mBorderWidth;
    @Nullable
    private CSSShorthand<CSSShorthand.CORNER> mBorderRadius;
    @Nullable
    private CSSShorthand<CSSShorthand.CORNER> mOverlappingBorderRadius;
    @Nullable
    private SparseIntArray mBorderColor;
    @Nullable
    private SparseIntArray mBorderStyle;
    @Nullable
    private Path mPathForBorderOutline;
    private boolean mNeedUpdatePath;
    private int mColor;
    private Shader mShader;
    private int mAlpha;
    private TopLeftCorner mTopLeftCorner;
    private TopRightCorner mTopRightCorner;
    private BottomRightCorner mBottomRightCorner;
    private BottomLeftCorner mBottomLeftCorner;
    private final BorderEdge mBorderEdge;
    private RectF mRectBounds;
    private static final transient /* synthetic */ boolean[] $jacocoData;

    public BorderDrawable() {
        boolean[] blArray = BorderDrawable.$jacocoInit();
        blArray[0] = true;
        this.mPaint = new Paint(1);
        this.mNeedUpdatePath = false;
        this.mColor = 0;
        this.mShader = null;
        this.mAlpha = 255;
        blArray[1] = true;
        this.mBorderEdge = new BorderEdge();
        blArray[2] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void draw(@NonNull Canvas canvas) {
        void canvas2;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        canvas2.save();
        blArray[3] = true;
        this.updateBorderOutline();
        blArray[4] = true;
        this.mPaint.setAlpha(255);
        if (this.mPathForBorderOutline == null) {
            blArray[5] = true;
        } else {
            blArray[6] = true;
            int useColor = WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha);
            if (this.mShader != null) {
                blArray[7] = true;
                this.mPaint.setShader(this.mShader);
                blArray[8] = true;
                this.mPaint.setStyle(Paint.Style.FILL);
                blArray[9] = true;
                canvas2.drawPath(this.mPathForBorderOutline, this.mPaint);
                blArray[10] = true;
                this.mPaint.setShader(null);
                blArray[11] = true;
            } else if (useColor >>> 24 == 0) {
                blArray[12] = true;
            } else {
                blArray[13] = true;
                this.mPaint.setColor(useColor);
                blArray[14] = true;
                this.mPaint.setStyle(Paint.Style.FILL);
                blArray[15] = true;
                canvas2.drawPath(this.mPathForBorderOutline, this.mPaint);
                blArray[16] = true;
                this.mPaint.setShader(null);
                blArray[17] = true;
            }
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        blArray[18] = true;
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        blArray[19] = true;
        this.drawBorders((Canvas)canvas2);
        blArray[20] = true;
        this.mPaint.setShader(null);
        blArray[21] = true;
        canvas2.restore();
        blArray[22] = true;
    }

    /*
     * WARNING - void declaration
     */
    protected void onBoundsChange(Rect rect) {
        void bounds;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        super.onBoundsChange((Rect)bounds);
        this.mNeedUpdatePath = true;
        blArray[23] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setAlpha(int n) {
        void alpha;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (alpha == this.mAlpha) {
            blArray[24] = true;
        } else {
            this.mAlpha = alpha;
            blArray[25] = true;
            this.invalidateSelf();
            blArray[26] = true;
        }
        blArray[27] = true;
    }

    public int getAlpha() {
        boolean[] blArray = BorderDrawable.$jacocoInit();
        blArray[28] = true;
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter colorFilter) {
        boolean[] blArray = BorderDrawable.$jacocoInit();
        blArray[29] = true;
    }

    public int getOpacity() {
        int n;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (this.mShader != null) {
            n = -1;
            blArray[30] = true;
        } else {
            blArray[31] = true;
            n = WXViewUtils.getOpacityFromColor(WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha));
            blArray[32] = true;
        }
        blArray[33] = true;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void getOutline(@NonNull Outline outline) {
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (Build.VERSION.SDK_INT < 21) {
            blArray[34] = true;
        } else {
            void outline2;
            if (this.mPathForBorderOutline != null) {
                blArray[35] = true;
            } else {
                this.mNeedUpdatePath = true;
                blArray[36] = true;
            }
            this.updateBorderOutline();
            blArray[37] = true;
            outline2.setConvexPath(this.mPathForBorderOutline);
            blArray[38] = true;
        }
        blArray[39] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderWidth(CSSShorthand.EDGE eDGE, float f) {
        void width;
        void edge;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (this.mBorderWidth != null) {
            blArray[40] = true;
        } else {
            blArray[41] = true;
            this.mBorderWidth = new CSSShorthand();
            blArray[42] = true;
        }
        if (this.mBorderWidth.get((CSSShorthand.EDGE)edge) == width) {
            blArray[43] = true;
        } else {
            blArray[44] = true;
            this.mBorderWidth.set((CSSShorthand.EDGE)edge, (float)width);
            this.mNeedUpdatePath = true;
            blArray[45] = true;
            this.invalidateSelf();
            blArray[46] = true;
        }
        blArray[47] = true;
    }

    /*
     * WARNING - void declaration
     */
    float getBorderWidth(CSSShorthand.EDGE eDGE) {
        void edge;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        blArray[48] = true;
        return this.mBorderWidth.get((CSSShorthand.EDGE)edge);
    }

    /*
     * Unable to fully structure code
     */
    public void setBorderRadius(CSSShorthand.CORNER var1_1, float var2_2) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            block4: {
                                var3_3 = BorderDrawable.$jacocoInit();
                                if (this.mBorderRadius != null) {
                                    var3_3[49] = true;
                                } else {
                                    var3_3[50] = true;
                                    this.mBorderRadius = new CSSShorthand<T>();
                                    var3_3[51] = true;
                                }
                                if (this.mBorderRadius.get((CSSShorthand.CORNER)position) == radius) break block4;
                                var3_3[52] = true;
                                ** GOTO lbl36
                            }
                            if (position == CSSShorthand.CORNER.ALL) break block5;
                            var3_3[53] = true;
                            break block6;
                        }
                        var3_3[54] = true;
                        if (radius == this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT)) break block7;
                        var3_3[55] = true;
                        ** GOTO lbl36
                    }
                    var3_3[56] = true;
                    if (radius == this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT)) break block8;
                    var3_3[57] = true;
                    ** GOTO lbl36
                }
                var3_3[58] = true;
                if (radius == this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT)) break block9;
                var3_3[59] = true;
                ** GOTO lbl36
            }
            var3_3[60] = true;
            if (radius == this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT)) {
                var3_3[61] = true;
            } else {
                var3_3[62] = true;
lbl36:
                // 5 sources

                this.mBorderRadius.set((CSSShorthand.CORNER)position, (float)radius);
                this.mNeedUpdatePath = true;
                var3_3[63] = true;
                this.invalidateSelf();
                var3_3[64] = true;
            }
        }
        var3_3[65] = true;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public float[] getBorderRadius(RectF rectF) {
        void bottomRightRadius;
        void topRightRadius;
        void topLeftRadius;
        void borderBox;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        this.prepareBorderRadius((RectF)borderBox);
        if (this.mOverlappingBorderRadius != null) {
            blArray[66] = true;
        } else {
            blArray[67] = true;
            this.mOverlappingBorderRadius = new CSSShorthand();
            blArray[68] = true;
        }
        float f = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
        blArray[69] = true;
        float f2 = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
        blArray[70] = true;
        float f3 = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
        blArray[71] = true;
        float bottomLeftRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
        blArray[72] = true;
        return new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius};
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public float[] getBorderInnerRadius(RectF rectF) {
        float bottomRightRadius;
        float topRightRadius;
        float topLeftRadius;
        void borderBox;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        this.prepareBorderRadius((RectF)borderBox);
        if (this.mOverlappingBorderRadius != null) {
            blArray[73] = true;
        } else {
            blArray[74] = true;
            this.mOverlappingBorderRadius = new CSSShorthand();
            blArray[75] = true;
        }
        float f = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
        blArray[76] = true;
        float f2 = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
        blArray[77] = true;
        float f3 = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
        blArray[78] = true;
        float bottomLeftRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
        if (null == this.mBorderWidth) {
            blArray[79] = true;
        } else {
            blArray[80] = true;
            topLeftRadius = Math.max((float)(topLeftRadius - this.mBorderWidth.get(CSSShorthand.EDGE.TOP)), 0.0f);
            blArray[81] = true;
            topRightRadius = Math.max((float)(topRightRadius - this.mBorderWidth.get(CSSShorthand.EDGE.TOP)), 0.0f);
            blArray[82] = true;
            bottomRightRadius = Math.max((float)(bottomRightRadius - this.mBorderWidth.get(CSSShorthand.EDGE.BOTTOM)), 0.0f);
            blArray[83] = true;
            bottomLeftRadius = Math.max(bottomLeftRadius - this.mBorderWidth.get(CSSShorthand.EDGE.BOTTOM), 0.0f);
            blArray[84] = true;
        }
        blArray[85] = true;
        return new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius};
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderColor(CSSShorthand.EDGE eDGE, int n) {
        void color;
        void edge;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (this.mBorderColor != null) {
            blArray[86] = true;
        } else {
            blArray[87] = true;
            this.mBorderColor = new SparseIntArray(5);
            blArray[88] = true;
            this.mBorderColor.put(CSSShorthand.EDGE.ALL.ordinal(), -16777216);
            blArray[89] = true;
        }
        if (this.getBorderColor((CSSShorthand.EDGE)edge) == color) {
            blArray[90] = true;
        } else {
            blArray[91] = true;
            BorderUtil.updateSparseArray(this.mBorderColor, edge.ordinal(), (int)color);
            blArray[92] = true;
            this.invalidateSelf();
            blArray[93] = true;
        }
        blArray[94] = true;
    }

    /*
     * WARNING - void declaration
     */
    int getBorderColor(CSSShorthand.EDGE eDGE) {
        void edge;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        blArray[95] = true;
        return BorderUtil.fetchFromSparseArray(this.mBorderColor, edge.ordinal(), -16777216);
    }

    /*
     * Unable to fully structure code
     */
    public void setBorderStyle(CSSShorthand.EDGE var1_1, @NonNull String var2_2) {
        block3: {
            block4: {
                var3_3 = BorderDrawable.$jacocoInit();
                if (this.mBorderStyle == null) break block4;
                var3_3[96] = true;
                ** GOTO lbl12
            }
            var3_3[97] = true;
            this.mBorderStyle = new SparseIntArray(5);
            var3_3[98] = true;
            this.mBorderStyle.put(CSSShorthand.EDGE.ALL.ordinal(), BorderDrawable.DEFAULT_BORDER_STYLE.ordinal());
            try {
                var3_3[99] = true;
lbl12:
                // 2 sources

                var4_4 = BorderStyle.valueOf(style.toUpperCase(Locale.US)).ordinal();
                var3_3[100] = true;
                if (this.getBorderStyle((CSSShorthand.EDGE)edge) == borderStyle) {
                    var3_3[101] = true;
                    break block3;
                }
                var3_3[102] = true;
                BorderUtil.updateSparseArray(this.mBorderStyle, edge.ordinal(), (int)borderStyle);
                var3_3[103] = true;
                this.invalidateSelf();
                var3_3[104] = true;
            }
            catch (IllegalArgumentException borderStyle) {
                var3_3[106] = true;
                WXLogUtils.e("Border", WXLogUtils.getStackTrace((Throwable)e));
                var3_3[107] = true;
            }
        }
        var3_3[105] = true;
        var3_3[108] = true;
    }

    /*
     * WARNING - void declaration
     */
    int getBorderStyle(CSSShorthand.EDGE eDGE) {
        void edge;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        blArray[109] = true;
        return BorderUtil.fetchFromSparseArray(this.mBorderStyle, edge.ordinal(), BorderStyle.SOLID.ordinal());
    }

    public int getColor() {
        boolean[] blArray = BorderDrawable.$jacocoInit();
        blArray[110] = true;
        return this.mColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setColor(int n) {
        void color;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        this.mColor = color;
        blArray[111] = true;
        this.invalidateSelf();
        blArray[112] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setImage(Shader shader) {
        void shader2;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        this.mShader = shader2;
        blArray[113] = true;
        this.invalidateSelf();
        blArray[114] = true;
    }

    public boolean hasImage() {
        boolean bl;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (this.mShader != null) {
            bl = blArray[115] = true;
        } else {
            bl = false;
            blArray[116] = true;
        }
        blArray[117] = true;
        return bl;
    }

    public boolean isRounded() {
        boolean bl;
        block7: {
            block1: {
                block3: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    block0: {
                                        boolean[] blArray = BorderDrawable.$jacocoInit();
                                        if (this.mBorderRadius != null) break block0;
                                        blArray[118] = true;
                                        break block1;
                                    }
                                    blArray[119] = true;
                                    if (this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) == 0.0f) break block2;
                                    blArray[120] = true;
                                    break block3;
                                }
                                blArray[121] = true;
                                if (this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) == 0.0f) break block4;
                                blArray[122] = true;
                                break block3;
                            }
                            blArray[123] = true;
                            if (this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) == 0.0f) break block5;
                            blArray[124] = true;
                            break block3;
                        }
                        blArray[125] = true;
                        if (this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT) != 0.0f) break block6;
                        blArray[126] = true;
                        break block1;
                    }
                    blArray[127] = true;
                }
                bl = blArray[128] = true;
                break block7;
            }
            bl = false;
            blArray[129] = true;
        }
        blArray[130] = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Path getContentPath(@NonNull RectF rectF) {
        void contentClip;
        void borderBox;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        Path path = new Path();
        blArray[131] = true;
        this.prepareBorderPath(0, 0, 0, 0, (RectF)borderBox, (Path)contentClip);
        blArray[132] = true;
        return contentClip;
    }

    private void updateBorderOutline() {
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (!this.mNeedUpdatePath) {
            blArray[133] = true;
        } else {
            this.mNeedUpdatePath = false;
            if (this.mPathForBorderOutline != null) {
                blArray[134] = true;
            } else {
                blArray[135] = true;
                this.mPathForBorderOutline = new Path();
                blArray[136] = true;
            }
            this.mPathForBorderOutline.reset();
            blArray[137] = true;
            this.prepareBorderPath(0, 0, 0, 0, new RectF(this.getBounds()), this.mPathForBorderOutline);
            blArray[138] = true;
        }
        blArray[139] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void prepareBorderPath(int n, int n2, int n3, int n4, @NonNull RectF rectF, @NonNull Path path) {
        void path2;
        void rectF2;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (this.mBorderRadius != null) {
            void bottomLeftRadius;
            void bottomPadding;
            void bottomRightRadius;
            void rightPadding;
            void topRightRadius;
            void topPadding;
            void leftPadding;
            void topLeftRadius;
            blArray[140] = true;
            this.prepareBorderRadius((RectF)rectF2);
            if (this.mOverlappingBorderRadius != null) {
                blArray[141] = true;
            } else {
                blArray[142] = true;
                this.mOverlappingBorderRadius = new CSSShorthand();
                blArray[143] = true;
            }
            float f = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
            blArray[144] = true;
            float f2 = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
            blArray[145] = true;
            float f3 = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
            blArray[146] = true;
            float f4 = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
            blArray[147] = true;
            path2.addRoundRect((RectF)rectF2, new float[]{topLeftRadius - (float)leftPadding, topLeftRadius - (float)topPadding, topRightRadius - (float)rightPadding, topRightRadius - (float)topPadding, bottomRightRadius - (float)rightPadding, bottomRightRadius - (float)bottomPadding, bottomLeftRadius - (float)leftPadding, bottomLeftRadius - (float)bottomPadding}, Path.Direction.CW);
            blArray[148] = true;
        } else {
            path2.addRect((RectF)rectF2, Path.Direction.CW);
            blArray[149] = true;
        }
        blArray[150] = true;
    }

    /*
     * Unable to fully structure code
     */
    private void prepareBorderRadius(@NonNull RectF var1_1) {
        block5: {
            block6: {
                block4: {
                    var2_2 = BorderDrawable.$jacocoInit();
                    if (this.mBorderRadius != null) break block4;
                    var2_2[151] = true;
                    break block5;
                }
                var2_2[152] = true;
                factor = this.getScaleFactor((RectF)borderBox);
                if (this.mOverlappingBorderRadius != null) {
                    var2_2[153] = true;
                } else {
                    var2_2[154] = true;
                    this.mOverlappingBorderRadius = new CSSShorthand<T>();
                    var2_2[155] = true;
                }
                if (!Float.isNaN(factor)) break block6;
                var2_2[156] = true;
                ** GOTO lbl34
            }
            if (factor < 1.0f) {
                var2_2[158] = true;
                var2_2[159] = true;
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_TOP_LEFT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) * factor);
                var2_2[160] = true;
                var2_2[161] = true;
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_TOP_RIGHT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) * factor);
                var2_2[162] = true;
                var2_2[163] = true;
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) * factor);
                var2_2[164] = true;
                var2_2[165] = true;
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT) * factor);
                var2_2[166] = true;
            } else {
                var2_2[157] = true;
lbl34:
                // 2 sources

                var2_2[167] = true;
                var2_2[168] = true;
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_TOP_LEFT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT));
                var2_2[169] = true;
                var2_2[170] = true;
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_TOP_RIGHT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT));
                var2_2[171] = true;
                var2_2[172] = true;
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT));
                var2_2[173] = true;
                var2_2[174] = true;
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT));
                var2_2[175] = true;
            }
        }
        var2_2[176] = true;
    }

    /*
     * WARNING - void declaration
     */
    private float getScaleFactor(@NonNull RectF rectF) {
        float factor;
        void leftRadius;
        void bottomRadius;
        void rightRadius;
        void topRadius;
        void borderBox;
        void factors;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        blArray[177] = true;
        float f = this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) + this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
        blArray[178] = true;
        blArray[179] = true;
        float f2 = this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) + this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
        blArray[180] = true;
        blArray[181] = true;
        float f3 = this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) + this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
        blArray[182] = true;
        blArray[183] = true;
        float f4 = this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT) + this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
        blArray[184] = true;
        ArrayList arrayList = new ArrayList(4);
        blArray[185] = true;
        this.updateFactor((List<Float>)factors, borderBox.width(), (float)topRadius);
        blArray[186] = true;
        this.updateFactor((List<Float>)factors, borderBox.height(), (float)rightRadius);
        blArray[187] = true;
        this.updateFactor((List<Float>)factors, borderBox.width(), (float)bottomRadius);
        blArray[188] = true;
        this.updateFactor((List<Float>)factors, borderBox.height(), (float)leftRadius);
        blArray[189] = true;
        if (factors.isEmpty()) {
            factor = Float.NaN;
            blArray[190] = true;
        } else {
            factor = ((Float)Collections.min(factors)).floatValue();
            blArray[191] = true;
        }
        blArray[192] = true;
        return factor;
    }

    /*
     * WARNING - void declaration
     */
    private void updateFactor(@NonNull List<Float> list, float f, float f2) {
        void denominator;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (denominator == 0.0f) {
            blArray[193] = true;
        } else {
            void numerator;
            void list2;
            blArray[194] = true;
            list2.add(Float.valueOf((float)(numerator / denominator)));
            blArray[195] = true;
        }
        blArray[196] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void drawBorders(Canvas canvas) {
        void canvas2;
        void bottomBorderWidth;
        void topBorderWidth;
        void leftBorderWidth;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (this.mRectBounds == null) {
            blArray[197] = true;
            this.mRectBounds = new RectF(this.getBounds());
            blArray[198] = true;
        } else {
            this.mRectBounds.set(this.getBounds());
            blArray[199] = true;
        }
        if (this.mBorderWidth == null) {
            blArray[200] = true;
            return;
        }
        float f = this.mBorderWidth.get(CSSShorthand.EDGE.LEFT);
        blArray[201] = true;
        float f2 = this.mBorderWidth.get(CSSShorthand.EDGE.TOP);
        blArray[202] = true;
        float f3 = this.mBorderWidth.get(CSSShorthand.EDGE.BOTTOM);
        blArray[203] = true;
        float rightBorderWidth = this.mBorderWidth.get(CSSShorthand.EDGE.RIGHT);
        if (this.mTopLeftCorner != null) {
            blArray[204] = true;
        } else {
            blArray[205] = true;
            this.mTopLeftCorner = new TopLeftCorner();
            blArray[206] = true;
        }
        this.mTopLeftCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_TOP_LEFT), (float)leftBorderWidth, (float)topBorderWidth, this.mRectBounds);
        if (this.mTopRightCorner != null) {
            blArray[207] = true;
        } else {
            blArray[208] = true;
            this.mTopRightCorner = new TopRightCorner();
            blArray[209] = true;
        }
        this.mTopRightCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_TOP_RIGHT), (float)topBorderWidth, rightBorderWidth, this.mRectBounds);
        if (this.mBottomRightCorner != null) {
            blArray[210] = true;
        } else {
            blArray[211] = true;
            this.mBottomRightCorner = new BottomRightCorner();
            blArray[212] = true;
        }
        this.mBottomRightCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT), rightBorderWidth, (float)bottomBorderWidth, this.mRectBounds);
        if (this.mBottomLeftCorner != null) {
            blArray[213] = true;
        } else {
            blArray[214] = true;
            this.mBottomLeftCorner = new BottomLeftCorner();
            blArray[215] = true;
        }
        this.mBottomLeftCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT), (float)bottomBorderWidth, (float)leftBorderWidth, this.mRectBounds);
        blArray[216] = true;
        this.drawOneSide((Canvas)canvas2, this.mBorderEdge.set(this.mTopLeftCorner, this.mTopRightCorner, (float)topBorderWidth, CSSShorthand.EDGE.TOP));
        blArray[217] = true;
        this.drawOneSide((Canvas)canvas2, this.mBorderEdge.set(this.mTopRightCorner, this.mBottomRightCorner, rightBorderWidth, CSSShorthand.EDGE.RIGHT));
        blArray[218] = true;
        this.drawOneSide((Canvas)canvas2, this.mBorderEdge.set(this.mBottomRightCorner, this.mBottomLeftCorner, (float)bottomBorderWidth, CSSShorthand.EDGE.BOTTOM));
        blArray[219] = true;
        this.drawOneSide((Canvas)canvas2, this.mBorderEdge.set(this.mBottomLeftCorner, this.mTopLeftCorner, (float)leftBorderWidth, CSSShorthand.EDGE.LEFT));
        blArray[220] = true;
    }

    /*
     * WARNING - void declaration
     */
    private float getBorderRadius(CSSShorthand.CORNER cORNER) {
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (null != this.mOverlappingBorderRadius) {
            void position;
            blArray[221] = true;
            blArray[222] = true;
            return this.mOverlappingBorderRadius.get((CSSShorthand.CORNER)position);
        }
        blArray[223] = true;
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private void drawOneSide(Canvas canvas, @NonNull BorderEdge borderEdge) {
        void borderEdge2;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        if (0.0f == borderEdge2.getBorderWidth()) {
            blArray[224] = true;
        } else {
            void canvas2;
            blArray[225] = true;
            this.preparePaint(borderEdge2.getEdge());
            blArray[226] = true;
            borderEdge2.drawEdge((Canvas)canvas2, this.mPaint);
            blArray[227] = true;
        }
        blArray[228] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void preparePaint(CSSShorthand.EDGE eDGE) {
        void shader;
        void color;
        void borderWidth;
        void borderStyle;
        void edge;
        boolean[] blArray = BorderDrawable.$jacocoInit();
        float f = this.mBorderWidth.get((CSSShorthand.EDGE)edge);
        blArray[229] = true;
        int n = WXViewUtils.multiplyColorAlpha(this.getBorderColor((CSSShorthand.EDGE)edge), this.mAlpha);
        blArray[230] = true;
        BorderStyle borderStyle2 = sBorderStyle[this.getBorderStyle((CSSShorthand.EDGE)edge)];
        blArray[231] = true;
        Shader shader2 = borderStyle.getLineShader((float)borderWidth, (int)color, (CSSShorthand.EDGE)edge);
        blArray[232] = true;
        this.mPaint.setShader((Shader)shader);
        blArray[233] = true;
        this.mPaint.setColor((int)color);
        blArray[234] = true;
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        blArray[235] = true;
    }

    static {
        boolean[] blArray = BorderDrawable.$jacocoInit();
        DEFAULT_BORDER_STYLE = BorderStyle.SOLID;
        blArray[236] = true;
        sBorderStyle = BorderStyle.values();
        blArray[237] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)3356097340267904084L, (String)"com/taobao/weex/ui/view/border/BorderDrawable", (int)238);
        }
        return blArray;
    }
}

