/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.animation.Interpolator;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.ui.animation.BackgroundColorProperty;
import com.taobao.weex.ui.animation.TransformParser;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.jacoco.agent.rt.internal_b0d6a23.Offline;

public class WXTransition {
    public static final String TRANSITION_PROPERTY = "transitionProperty";
    public static final String TRANSITION_DURATION = "transitionDuration";
    public static final String TRANSITION_DELAY = "transitionDelay";
    public static final String TRANSITION_TIMING_FUNCTION = "transitionTimingFunction";
    public static final Pattern PROPERTY_SPLIT_PATTERN;
    private static final Set<String> LAYOUT_PROPERTIES;
    private static final Set<String> TRANSFORM_PROPERTIES;
    private List<String> properties;
    private Interpolator interpolator;
    private long duration;
    private long delay;
    private WXComponent mWXComponent;
    private Handler handler;
    private ValueAnimator layoutValueAnimator;
    private Map<String, Object> layoutPendingUpdates;
    private ObjectAnimator transformAnimator;
    private Map<String, Object> transformPendingUpdates;
    private Runnable transitionEndEvent;
    private Map<String, Object> targetStyles;
    private Runnable animationRunnable;
    private Runnable transformAnimationRunnable;
    private volatile AtomicInteger lockToken;
    private static final transient /* synthetic */ boolean[] $jacocoData;

    public WXTransition() {
        boolean[] blArray = WXTransition.$jacocoInit();
        blArray[0] = true;
        this.lockToken = new AtomicInteger(0);
        blArray[1] = true;
        this.properties = new ArrayList<String>(4);
        blArray[2] = true;
        this.handler = new Handler();
        blArray[3] = true;
        this.layoutPendingUpdates = new ArrayMap();
        blArray[4] = true;
        this.transformPendingUpdates = new ArrayMap();
        blArray[5] = true;
        this.targetStyles = new ArrayMap();
        blArray[6] = true;
    }

    /*
     * WARNING - void declaration
     */
    public static WXTransition fromMap(Map<String, Object> map, WXComponent wXComponent) {
        void component;
        void transition;
        Map<String, Object> style;
        boolean[] blArray = WXTransition.$jacocoInit();
        if (style.get(TRANSITION_PROPERTY) == null) {
            blArray[7] = true;
            return null;
        }
        String propertyString = WXUtils.getString(style.get(TRANSITION_PROPERTY), null);
        if (propertyString == null) {
            blArray[8] = true;
            return null;
        }
        WXTransition wXTransition = new WXTransition();
        blArray[9] = true;
        WXTransition.updateTransitionProperties((WXTransition)transition, propertyString);
        blArray[10] = true;
        if (transition.properties.isEmpty()) {
            blArray[11] = true;
            return null;
        }
        transition.duration = WXTransition.parseTimeMillis(style, TRANSITION_DURATION, 0L);
        blArray[12] = true;
        transition.delay = WXTransition.parseTimeMillis(style, TRANSITION_DELAY, 0L);
        blArray[13] = true;
        transition.interpolator = WXTransition.createTimeInterpolator(WXUtils.getString(style.get(TRANSITION_TIMING_FUNCTION), null));
        transition.mWXComponent = component;
        blArray[14] = true;
        return transition;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasTransitionProperty(Map<String, Object> map) {
        boolean[] blArray = WXTransition.$jacocoInit();
        Iterator<String> iterator = this.properties.iterator();
        blArray[15] = true;
        while (iterator.hasNext()) {
            void property;
            void styles;
            String string2 = iterator.next();
            blArray[16] = true;
            if (styles.containsKey(property)) {
                blArray[17] = true;
                return true;
            }
            blArray[18] = true;
        }
        blArray[19] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void updateTranstionParams(Map<String, Object> map) {
        void updates;
        boolean[] blArray = WXTransition.$jacocoInit();
        if (!updates.containsKey(TRANSITION_DELAY)) {
            blArray[20] = true;
        } else {
            blArray[21] = true;
            this.mWXComponent.getStyles().put(TRANSITION_DELAY, updates.remove(TRANSITION_DELAY));
            blArray[22] = true;
            this.delay = WXTransition.parseTimeMillis(this.mWXComponent.getStyles(), TRANSITION_DELAY, 0L);
            blArray[23] = true;
        }
        if (!updates.containsKey(TRANSITION_TIMING_FUNCTION)) {
            blArray[24] = true;
        } else if (updates.get(TRANSITION_TIMING_FUNCTION) == null) {
            blArray[25] = true;
        } else {
            blArray[26] = true;
            this.mWXComponent.getStyles().put(TRANSITION_TIMING_FUNCTION, updates.remove(TRANSITION_TIMING_FUNCTION));
            blArray[27] = true;
            this.interpolator = WXTransition.createTimeInterpolator(this.mWXComponent.getStyles().get(TRANSITION_TIMING_FUNCTION).toString());
            blArray[28] = true;
        }
        if (!updates.containsKey(TRANSITION_DURATION)) {
            blArray[29] = true;
        } else {
            blArray[30] = true;
            this.mWXComponent.getStyles().put(TRANSITION_DURATION, updates.remove(TRANSITION_DURATION));
            blArray[31] = true;
            this.duration = WXTransition.parseTimeMillis(this.mWXComponent.getStyles(), TRANSITION_DURATION, 0L);
            blArray[32] = true;
        }
        if (!updates.containsKey(TRANSITION_PROPERTY)) {
            blArray[33] = true;
        } else {
            blArray[34] = true;
            this.mWXComponent.getStyles().put(TRANSITION_PROPERTY, updates.remove(TRANSITION_PROPERTY));
            blArray[35] = true;
            WXTransition.updateTransitionProperties(this, WXUtils.getString(this.mWXComponent.getStyles().get(TRANSITION_PROPERTY), null));
            blArray[36] = true;
        }
        blArray[37] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void startTransition(Map<String, Object> map) {
        boolean[] blArray = WXTransition.$jacocoInit();
        AtomicInteger atomicInteger = this.lockToken;
        synchronized (atomicInteger) {
            blArray[38] = true;
            View taregtView = this.getTargetView();
            if (taregtView == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 17, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
                blArray[40] = true;
                return;
            }
            blArray[39] = true;
            try {
                void token;
                int n = this.lockToken.incrementAndGet();
                blArray[41] = true;
                Iterator<String> iterator = this.properties.iterator();
                blArray[42] = true;
                while (iterator.hasNext()) {
                    void property;
                    void updates;
                    String string2 = iterator.next();
                    blArray[43] = true;
                    if (!updates.containsKey(property)) {
                        blArray[44] = true;
                    } else {
                        void targetValue;
                        blArray[45] = true;
                        Object v = updates.remove(property);
                        blArray[46] = true;
                        if (LAYOUT_PROPERTIES.contains(property)) {
                            blArray[47] = true;
                            this.layoutPendingUpdates.put((String)property, targetValue);
                            blArray[48] = true;
                        } else if (!TRANSFORM_PROPERTIES.contains(property)) {
                            blArray[49] = true;
                        } else {
                            blArray[50] = true;
                            this.transformPendingUpdates.put((String)property, targetValue);
                            blArray[51] = true;
                        }
                    }
                    blArray[52] = true;
                }
                int delay = WXUtils.getNumberInt(this.mWXComponent.getAttrs().get("actionDelay"), 16);
                if ((long)delay <= this.duration) {
                    blArray[53] = true;
                } else {
                    delay = (int)this.duration;
                    blArray[54] = true;
                }
                if (this.animationRunnable == null) {
                    blArray[55] = true;
                } else {
                    blArray[56] = true;
                    this.handler.removeCallbacks(this.animationRunnable);
                    blArray[57] = true;
                }
                this.animationRunnable = new Runnable(this, (int)token){
                    final /* synthetic */ int val$token;
                    final /* synthetic */ WXTransition this$0;
                    private static final transient /* synthetic */ boolean[] $jacocoData;
                    {
                        void this$0;
                        boolean[] blArray = 1.$jacocoInit();
                        this.this$0 = this$0;
                        this.val$token = n;
                        blArray[0] = true;
                    }

                    @Override
                    public void run() {
                        boolean[] blArray = 1.$jacocoInit();
                        if (this.val$token != WXTransition.access$000(this.this$0).get()) {
                            blArray[1] = true;
                        } else {
                            blArray[2] = true;
                            WXTransition.access$100(this.this$0, this.val$token);
                            blArray[3] = true;
                        }
                        WXTransition.access$202(this.this$0, null);
                        blArray[4] = true;
                    }

                    private static /* synthetic */ boolean[] $jacocoInit() {
                        boolean[] blArray = $jacocoData;
                        if ($jacocoData == null) {
                            blArray = $jacocoData = Offline.getProbes((long)-3207339354435588053L, (String)"com/taobao/weex/dom/transition/WXTransition$1", (int)5);
                        }
                        return blArray;
                    }
                };
                if (delay > 0) {
                    blArray[58] = true;
                    this.handler.postDelayed(this.animationRunnable, (long)delay);
                    blArray[59] = true;
                } else {
                    this.animationRunnable.run();
                    blArray[60] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl65 : MonitorExitStatement: MONITOREXIT : var3_3
                blArray[61] = true;
                throw throwable;
            }
        }
        blArray[62] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void doTransitionAnimation(int n) {
        void token;
        boolean[] blArray = WXTransition.$jacocoInit();
        View taregtView = this.getTargetView();
        if (taregtView == null) {
            blArray[63] = true;
            return;
        }
        if (this.targetStyles.size() <= 0) {
            blArray[64] = true;
        } else {
            blArray[65] = true;
            Iterator<String> iterator = this.properties.iterator();
            blArray[66] = true;
            while (true) {
                void property;
                if (!iterator.hasNext()) {
                    blArray[67] = true;
                    break;
                }
                String string2 = iterator.next();
                blArray[68] = true;
                if (LAYOUT_PROPERTIES.contains(property)) {
                    blArray[69] = true;
                } else if (TRANSFORM_PROPERTIES.contains(property)) {
                    blArray[70] = true;
                } else {
                    blArray[71] = true;
                    continue;
                }
                if (this.layoutPendingUpdates.containsKey(property)) {
                    blArray[72] = true;
                    continue;
                }
                if (this.transformPendingUpdates.containsKey(property)) {
                    blArray[73] = true;
                    continue;
                }
                Map<String, Object> map = this.targetStyles;
                synchronized (map) {
                    try {
                        blArray[74] = true;
                        if (!this.targetStyles.containsKey(property)) {
                            blArray[75] = true;
                        } else {
                            void targetValue;
                            blArray[76] = true;
                            Object object = this.targetStyles.remove(property);
                            blArray[77] = true;
                            this.mWXComponent.getStyles().put((String)property, (Object)targetValue);
                            blArray[78] = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 22] lbl48 : MonitorExitStatement: MONITOREXIT : var6_6
                        blArray[79] = true;
                        throw throwable;
                    }
                }
                blArray[80] = true;
            }
        }
        if (this.transitionEndEvent == null) {
            blArray[81] = true;
        } else {
            blArray[82] = true;
            taregtView.removeCallbacks(this.transitionEndEvent);
            blArray[83] = true;
        }
        if (this.transitionEndEvent != null) {
            blArray[84] = true;
        } else if (!((float)this.duration > Float.MIN_NORMAL)) {
            blArray[85] = true;
        } else {
            blArray[86] = true;
            this.transitionEndEvent = new Runnable(this){
                final /* synthetic */ WXTransition this$0;
                private static final transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 2.$jacocoInit();
                    this.this$0 = this$0;
                    blArray[0] = true;
                }

                @Override
                public void run() {
                    boolean[] blArray = 2.$jacocoInit();
                    WXTransition.access$302(this.this$0, null);
                    blArray[1] = true;
                    if ((float)WXTransition.access$400(this.this$0) < Float.MIN_NORMAL) {
                        blArray[2] = true;
                        return;
                    }
                    if (WXTransition.access$500(this.this$0) == null) {
                        blArray[3] = true;
                    } else if (!WXTransition.access$500(this.this$0).getEvents().contains("transitionEnd")) {
                        blArray[4] = true;
                    } else {
                        blArray[5] = true;
                        WXTransition.access$500(this.this$0).fireEvent("transitionEnd");
                        blArray[6] = true;
                    }
                    blArray[7] = true;
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-4569027234215973707L, (String)"com/taobao/weex/dom/transition/WXTransition$2", (int)8);
                    }
                    return blArray;
                }
            };
            blArray[87] = true;
        }
        if (this.transformAnimationRunnable == null) {
            blArray[88] = true;
        } else {
            blArray[89] = true;
            taregtView.removeCallbacks(this.transformAnimationRunnable);
            blArray[90] = true;
        }
        this.transformAnimationRunnable = new Runnable(this, (int)token){
            final /* synthetic */ int val$token;
            final /* synthetic */ WXTransition this$0;
            private static final transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 3.$jacocoInit();
                this.this$0 = this$0;
                this.val$token = n;
                blArray[0] = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean[] blArray = 3.$jacocoInit();
                AtomicInteger atomicInteger = WXTransition.access$000(this.this$0);
                synchronized (atomicInteger) {
                    try {
                        blArray[1] = true;
                        if (this.val$token != WXTransition.access$000(this.this$0).get()) {
                            blArray[2] = true;
                        } else {
                            blArray[3] = true;
                            WXTransition.access$600(this.this$0, this.val$token);
                            blArray[4] = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                        blArray[5] = true;
                        throw throwable;
                    }
                }
                blArray[6] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-3375017917801866972L, (String)"com/taobao/weex/dom/transition/WXTransition$3", (int)7);
                }
                return blArray;
            }
        };
        blArray[91] = true;
        taregtView.post(this.transformAnimationRunnable);
        blArray[92] = true;
        this.doPendingLayoutAnimation();
        blArray[93] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void doPendingTransformAnimation(int n) {
        void token;
        void holders;
        int n2;
        PropertyValuesHolder[] transformHolders;
        Object object;
        void transform;
        boolean[] blArray = WXTransition.$jacocoInit();
        if (this.transformAnimator == null) {
            blArray[94] = true;
        } else {
            blArray[95] = true;
            this.transformAnimator.cancel();
            this.transformAnimator = null;
            blArray[96] = true;
        }
        if (this.transformPendingUpdates.size() == 0) {
            blArray[97] = true;
            return;
        }
        View taregtView = this.getTargetView();
        if (taregtView == null) {
            blArray[98] = true;
            return;
        }
        ArrayList arrayList = new ArrayList(8);
        blArray[99] = true;
        String string2 = WXUtils.getString(this.transformPendingUpdates.remove("transform"), null);
        blArray[100] = true;
        if (TextUtils.isEmpty((CharSequence)transform)) {
            blArray[101] = true;
        } else {
            void properties;
            blArray[102] = true;
            object = TransformParser.parseTransForm((String)transform, (int)this.mWXComponent.getLayoutWidth(), (int)this.mWXComponent.getLayoutHeight(), this.mWXComponent.getViewPortWidth());
            blArray[103] = true;
            Object object2 = transformHolders = TransformParser.toHolders((Map<Property<View, Float>, Float>)properties);
            int n3 = ((PropertyValuesHolder[])object2).length;
            blArray[104] = true;
            for (n2 = 0; n2 < n3; ++n2) {
                void holder;
                PropertyValuesHolder propertyValuesHolder = object2[n2];
                blArray[105] = true;
                holders.add(holder);
                blArray[106] = true;
            }
            object2 = this.targetStyles;
            synchronized (object2) {
                try {
                    blArray[107] = true;
                    this.targetStyles.put("transform", transform);
                    // MONITOREXIT @DISABLED, blocks:[0, 34, 3] lbl42 : MonitorExitStatement: MONITOREXIT : var8_8 /* !! */ 
                    blArray[108] = true;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[34, 3, 12] lbl46 : MonitorExitStatement: MONITOREXIT : var8_8 /* !! */ 
                    blArray[109] = true;
                    throw throwable;
                }
            }
        }
        object = this.properties.iterator();
        blArray[110] = true;
        while (object.hasNext()) {
            void property;
            transformHolders = object.next();
            blArray[111] = true;
            if (!TRANSFORM_PROPERTIES.contains(property)) {
                blArray[112] = true;
                continue;
            }
            if (!this.transformPendingUpdates.containsKey(property)) {
                blArray[113] = true;
                continue;
            }
            Object value = this.transformPendingUpdates.remove(property);
            Map<String, Object> map = this.targetStyles;
            synchronized (map) {
                try {
                    blArray[114] = true;
                    this.targetStyles.put((String)property, value);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 13, 15] lbl70 : MonitorExitStatement: MONITOREXIT : var9_10
                    blArray[115] = true;
                    throw throwable;
                }
            }
            map = property;
            n2 = -1;
            switch (((String)((Object)map)).hashCode()) {
                default: {
                    blArray[116] = true;
                    break;
                }
                case -1267206133: {
                    if (!((String)((Object)map)).equals("opacity")) {
                        blArray[117] = true;
                        break;
                    }
                    n2 = 0;
                    blArray[118] = true;
                    break;
                }
                case 1287124693: {
                    if (!((String)((Object)map)).equals("backgroundColor")) {
                        blArray[119] = true;
                        break;
                    }
                    n2 = 1;
                    blArray[120] = true;
                }
            }
            switch (n2) {
                default: {
                    blArray[121] = true;
                    break;
                }
                case 0: {
                    holders.add(PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{taregtView.getAlpha(), WXUtils.getFloat(value, Float.valueOf(1.0f)).floatValue()}));
                    blArray[122] = true;
                    taregtView.setLayerType(1, null);
                    blArray[123] = true;
                    break;
                }
                case 1: {
                    void toColor;
                    int fromColor;
                    int holder = WXResourceUtils.getColor(WXUtils.getString(this.mWXComponent.getStyles().getBackgroundColor(), null), 0);
                    blArray[124] = true;
                    int n4 = WXResourceUtils.getColor(WXUtils.getString(value, null), 0);
                    blArray[125] = true;
                    if (WXViewUtils.getBorderDrawable(taregtView) != null) {
                        blArray[126] = true;
                        fromColor = WXViewUtils.getBorderDrawable(taregtView).getColor();
                        blArray[127] = true;
                    } else if (!(taregtView.getBackground() instanceof ColorDrawable)) {
                        blArray[128] = true;
                    } else {
                        blArray[129] = true;
                        fromColor = ((ColorDrawable)taregtView.getBackground()).getColor();
                        blArray[130] = true;
                    }
                    holders.add(PropertyValuesHolder.ofObject((Property)new BackgroundColorProperty(), (TypeEvaluator)new ArgbEvaluator(), (Object[])new Integer[]{fromColor, (int)toColor}));
                    blArray[131] = true;
                    break;
                }
            }
            blArray[132] = true;
        }
        if (token != this.lockToken.get()) {
            blArray[133] = true;
        } else {
            blArray[134] = true;
            this.transformPendingUpdates.clear();
            blArray[135] = true;
        }
        this.transformAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)taregtView, (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
        blArray[136] = true;
        this.transformAnimator.setDuration(this.duration);
        if (this.delay <= 0L) {
            blArray[137] = true;
        } else {
            blArray[138] = true;
            this.transformAnimator.setStartDelay(this.delay);
            blArray[139] = true;
        }
        if (this.interpolator == null) {
            blArray[140] = true;
        } else {
            blArray[141] = true;
            this.transformAnimator.setInterpolator((TimeInterpolator)this.interpolator);
            blArray[142] = true;
        }
        this.transformAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            boolean hasCancel;
            final /* synthetic */ WXTransition this$0;
            private static final transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 4.$jacocoInit();
                this.this$0 = this$0;
                this.hasCancel = false;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onAnimationCancel(Animator animator) {
                void animation;
                boolean[] blArray = 4.$jacocoInit();
                super.onAnimationCancel((Animator)animation);
                this.hasCancel = true;
                blArray[1] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onAnimationEnd(Animator animator) {
                void animation;
                boolean[] blArray = 4.$jacocoInit();
                if (this.hasCancel) {
                    blArray[2] = true;
                    return;
                }
                super.onAnimationEnd((Animator)animation);
                blArray[3] = true;
                WXTransition.access$700(this.this$0);
                blArray[4] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)4694938833623153859L, (String)"com/taobao/weex/dom/transition/WXTransition$4", (int)5);
                }
                return blArray;
            }
        });
        blArray[143] = true;
        this.transformAnimator.start();
        blArray[144] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void doPendingLayoutAnimation() {
        boolean[] blArray = WXTransition.$jacocoInit();
        if (this.layoutValueAnimator == null) {
            blArray[145] = true;
        } else {
            blArray[146] = true;
            this.layoutValueAnimator.cancel();
            this.layoutValueAnimator = null;
            blArray[147] = true;
        }
        if (this.layoutPendingUpdates.size() == 0) {
            blArray[148] = true;
            return;
        }
        PropertyValuesHolder[] holders = new PropertyValuesHolder[this.layoutPendingUpdates.size()];
        boolean bl = false;
        blArray[149] = true;
        Iterator<String> iterator = this.properties.iterator();
        blArray[150] = true;
        while (iterator.hasNext()) {
            void property;
            String string2 = iterator.next();
            blArray[151] = true;
            if (!LAYOUT_PROPERTIES.contains(property)) {
                blArray[152] = true;
                continue;
            }
            if (!this.layoutPendingUpdates.containsKey(property)) {
                blArray[153] = true;
            } else {
                void index;
                blArray[154] = true;
                Object targetValue = this.layoutPendingUpdates.remove(property);
                Map<String, Object> map = this.targetStyles;
                synchronized (map) {
                    try {
                        blArray[155] = true;
                        this.targetStyles.put((String)property, targetValue);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 8] lbl37 : MonitorExitStatement: MONITOREXIT : var7_7
                        blArray[156] = true;
                        throw throwable;
                    }
                }
                holders[index] = this.createLayoutPropertyValueHolder((String)property, targetValue);
                ++index;
                blArray[157] = true;
            }
            blArray[158] = true;
        }
        this.layoutPendingUpdates.clear();
        blArray[159] = true;
        this.doLayoutPropertyValuesHolderAnimation(holders);
        blArray[160] = true;
    }

    /*
     * WARNING - void declaration
     */
    private PropertyValuesHolder createLayoutPropertyValueHolder(String string2, Object object) {
        PropertyValuesHolder holder;
        void property;
        boolean[] blArray = WXTransition.$jacocoInit();
        Object var4_4 = null;
        blArray[161] = true;
        void var5_5 = property;
        int n = -1;
        switch (var5_5.hashCode()) {
            default: {
                blArray[162] = true;
                break;
            }
            case 113126854: {
                if (!var5_5.equals("width")) {
                    blArray[163] = true;
                    break;
                }
                n = 0;
                blArray[164] = true;
                break;
            }
            case -1221029593: {
                if (!var5_5.equals("height")) {
                    blArray[165] = true;
                    break;
                }
                n = 1;
                blArray[166] = true;
                break;
            }
            case -1044792121: {
                if (!var5_5.equals("marginTop")) {
                    blArray[167] = true;
                    break;
                }
                n = 2;
                blArray[168] = true;
                break;
            }
            case 1970934485: {
                if (!var5_5.equals("marginLeft")) {
                    blArray[169] = true;
                    break;
                }
                n = 3;
                blArray[170] = true;
                break;
            }
            case 975087886: {
                if (!var5_5.equals("marginRight")) {
                    blArray[171] = true;
                    break;
                }
                n = 4;
                blArray[172] = true;
                break;
            }
            case -289173127: {
                if (!var5_5.equals("marginBottom")) {
                    blArray[173] = true;
                    break;
                }
                n = 5;
                blArray[174] = true;
                break;
            }
            case 3317767: {
                if (!var5_5.equals("left")) {
                    blArray[175] = true;
                    break;
                }
                n = 6;
                blArray[176] = true;
                break;
            }
            case 108511772: {
                if (!var5_5.equals("right")) {
                    blArray[177] = true;
                    break;
                }
                n = 7;
                blArray[178] = true;
                break;
            }
            case -1383228885: {
                if (!var5_5.equals("bottom")) {
                    blArray[179] = true;
                    break;
                }
                n = 8;
                blArray[180] = true;
                break;
            }
            case 115029: {
                if (!var5_5.equals("top")) {
                    blArray[181] = true;
                    break;
                }
                n = 9;
                blArray[182] = true;
                break;
            }
            case 90130308: {
                if (!var5_5.equals("paddingTop")) {
                    blArray[183] = true;
                    break;
                }
                n = 10;
                blArray[184] = true;
                break;
            }
            case 202355100: {
                if (!var5_5.equals("paddingBottom")) {
                    blArray[185] = true;
                    break;
                }
                n = 11;
                blArray[186] = true;
                break;
            }
            case -1501175880: {
                if (!var5_5.equals("paddingLeft")) {
                    blArray[187] = true;
                    break;
                }
                n = 12;
                blArray[188] = true;
                break;
            }
            case 713848971: {
                if (!var5_5.equals("paddingRight")) {
                    blArray[189] = true;
                    break;
                }
                n = 13;
                blArray[190] = true;
            }
        }
        switch (n) {
            default: {
                blArray[191] = true;
                break;
            }
            case 0: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getLayoutWidth();
                blArray[192] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(value, Float.valueOf(0.0f)).floatValue(), this.mWXComponent.getViewPortWidth());
                blArray[193] = true;
                holder = PropertyValuesHolder.ofFloat((String)"width", (float[])fArray);
                blArray[194] = true;
                break;
            }
            case 1: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getLayoutHeight();
                blArray[195] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(value, Float.valueOf(0.0f)).floatValue(), this.mWXComponent.getViewPortWidth());
                blArray[196] = true;
                holder = PropertyValuesHolder.ofFloat((String)"height", (float[])fArray);
                blArray[197] = true;
                break;
            }
            case 2: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getMargin().get(CSSShorthand.EDGE.TOP);
                blArray[198] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[199] = true;
                holder = PropertyValuesHolder.ofFloat((String)"marginTop", (float[])fArray);
                blArray[200] = true;
                break;
            }
            case 3: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getMargin().get(CSSShorthand.EDGE.LEFT);
                blArray[201] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[202] = true;
                holder = PropertyValuesHolder.ofFloat((String)"marginLeft", (float[])fArray);
                blArray[203] = true;
                break;
            }
            case 4: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getMargin().get(CSSShorthand.EDGE.RIGHT);
                blArray[204] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[205] = true;
                holder = PropertyValuesHolder.ofFloat((String)"marginRight", (float[])fArray);
                blArray[206] = true;
                break;
            }
            case 5: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getMargin().get(CSSShorthand.EDGE.BOTTOM);
                blArray[207] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[208] = true;
                holder = PropertyValuesHolder.ofFloat((String)"marginBottom", (float[])fArray);
                blArray[209] = true;
                break;
            }
            case 6: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getPadding().get(CSSShorthand.EDGE.LEFT);
                blArray[210] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[211] = true;
                holder = PropertyValuesHolder.ofFloat((String)"left", (float[])fArray);
                blArray[212] = true;
                break;
            }
            case 7: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getPadding().get(CSSShorthand.EDGE.RIGHT);
                blArray[213] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[214] = true;
                holder = PropertyValuesHolder.ofFloat((String)"right", (float[])fArray);
                blArray[215] = true;
                break;
            }
            case 8: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getPadding().get(CSSShorthand.EDGE.BOTTOM);
                blArray[216] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[217] = true;
                holder = PropertyValuesHolder.ofFloat((String)"bottom", (float[])fArray);
                blArray[218] = true;
                break;
            }
            case 9: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getPadding().get(CSSShorthand.EDGE.TOP);
                blArray[219] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[220] = true;
                holder = PropertyValuesHolder.ofFloat((String)"top", (float[])fArray);
                blArray[221] = true;
                break;
            }
            case 10: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getPadding().get(CSSShorthand.EDGE.TOP);
                blArray[222] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[223] = true;
                holder = PropertyValuesHolder.ofFloat((String)"paddingTop", (float[])fArray);
                blArray[224] = true;
                break;
            }
            case 11: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getPadding().get(CSSShorthand.EDGE.BOTTOM);
                blArray[225] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[226] = true;
                holder = PropertyValuesHolder.ofFloat((String)"paddingBottom", (float[])fArray);
                blArray[227] = true;
                break;
            }
            case 12: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getPadding().get(CSSShorthand.EDGE.LEFT);
                blArray[228] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[229] = true;
                holder = PropertyValuesHolder.ofFloat((String)"paddingLeft", (float[])fArray);
                blArray[230] = true;
                break;
            }
            case 13: {
                void value;
                float[] fArray = new float[2];
                fArray[0] = this.mWXComponent.getPadding().get(CSSShorthand.EDGE.RIGHT);
                blArray[231] = true;
                fArray[1] = WXViewUtils.getRealPxByWidth(WXUtils.getFloatByViewport(value, this.mWXComponent.getViewPortWidth()), this.mWXComponent.getViewPortWidth());
                blArray[232] = true;
                holder = PropertyValuesHolder.ofFloat((String)"paddingRight", (float[])fArray);
                blArray[233] = true;
                break;
            }
        }
        if (holder != null) {
            blArray[234] = true;
        } else {
            blArray[235] = true;
            holder = PropertyValuesHolder.ofFloat((String)property, (float[])new float[]{1.0f, 1.0f});
            blArray[236] = true;
        }
        blArray[237] = true;
        return holder;
    }

    /*
     * WARNING - void declaration
     */
    private void doLayoutPropertyValuesHolderAnimation(PropertyValuesHolder[] propertyValuesHolderArray) {
        void holders;
        boolean[] blArray = WXTransition.$jacocoInit();
        this.layoutValueAnimator = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])holders);
        blArray[238] = true;
        this.layoutValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ WXTransition this$0;
            private static final transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 5.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                void animation;
                PropertyValuesHolder[] holders;
                boolean[] blArray = 5.$jacocoInit();
                PropertyValuesHolder[] propertyValuesHolderArray = holders = animation.getValues();
                int n = propertyValuesHolderArray.length;
                blArray[1] = true;
                for (int i = 0; i < n; ++i) {
                    void property;
                    void holder;
                    PropertyValuesHolder propertyValuesHolder = propertyValuesHolderArray[i];
                    blArray[2] = true;
                    String string2 = holder.getPropertyName();
                    blArray[3] = true;
                    WXTransition.asynchronouslyUpdateLayout(WXTransition.access$500(this.this$0), (String)property, ((Float)animation.getAnimatedValue((String)property)).floatValue());
                    blArray[4] = true;
                }
                blArray[5] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)7426898797712283782L, (String)"com/taobao/weex/dom/transition/WXTransition$5", (int)6);
                }
                return blArray;
            }
        });
        blArray[239] = true;
        this.layoutValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            boolean hasCancel;
            final /* synthetic */ WXTransition this$0;
            private static final transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 6.$jacocoInit();
                this.this$0 = this$0;
                this.hasCancel = false;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onAnimationCancel(Animator animator) {
                void animation;
                boolean[] blArray = 6.$jacocoInit();
                super.onAnimationCancel((Animator)animation);
                this.hasCancel = true;
                blArray[1] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onAnimationEnd(Animator animator) {
                void animation;
                boolean[] blArray = 6.$jacocoInit();
                if (this.hasCancel) {
                    blArray[2] = true;
                    return;
                }
                super.onAnimationEnd((Animator)animation);
                blArray[3] = true;
                WXTransition.access$700(this.this$0);
                blArray[4] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-8572149697388404892L, (String)"com/taobao/weex/dom/transition/WXTransition$6", (int)5);
                }
                return blArray;
            }
        });
        if (this.interpolator == null) {
            blArray[240] = true;
        } else {
            blArray[241] = true;
            this.layoutValueAnimator.setInterpolator((TimeInterpolator)this.interpolator);
            blArray[242] = true;
        }
        this.layoutValueAnimator.setStartDelay(this.delay);
        blArray[243] = true;
        this.layoutValueAnimator.setDuration(this.duration);
        blArray[244] = true;
        this.layoutValueAnimator.start();
        blArray[245] = true;
    }

    /*
     * WARNING - void declaration
     */
    public static void asynchronouslyUpdateLayout(WXComponent wXComponent, String string2, float f) {
        void propertyValue;
        void propertyName;
        void instanceId;
        void ref;
        block6: {
            block5: {
                block4: {
                    WXComponent component;
                    boolean[] blArray = WXTransition.$jacocoInit();
                    if (component == null) {
                        blArray[246] = true;
                        return;
                    }
                    String string3 = component.getRef();
                    blArray[247] = true;
                    String string4 = component.getInstanceId();
                    blArray[248] = true;
                    if (!TextUtils.isEmpty((CharSequence)ref)) break block4;
                    blArray[249] = true;
                    break block5;
                }
                if (!TextUtils.isEmpty((CharSequence)instanceId)) break block6;
                blArray[250] = true;
            }
            blArray[251] = true;
            return;
        }
        WXSDKManager.getInstance().getWXBridgeManager().post(new Runnable((String)propertyName, (String)instanceId, (String)ref, (float)propertyValue){
            final /* synthetic */ String val$propertyName;
            final /* synthetic */ String val$instanceId;
            final /* synthetic */ String val$ref;
            final /* synthetic */ float val$propertyValue;
            private static final transient /* synthetic */ boolean[] $jacocoData;
            {
                boolean[] blArray = 7.$jacocoInit();
                this.val$propertyName = string2;
                this.val$instanceId = string3;
                this.val$ref = string4;
                this.val$propertyValue = f;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 7.$jacocoInit();
                String string2 = this.val$propertyName;
                int n = -1;
                switch (string2.hashCode()) {
                    default: {
                        blArray[1] = true;
                        break;
                    }
                    case 113126854: {
                        if (!string2.equals("width")) {
                            blArray[2] = true;
                            break;
                        }
                        n = 0;
                        blArray[3] = true;
                        break;
                    }
                    case -1221029593: {
                        if (!string2.equals("height")) {
                            blArray[4] = true;
                            break;
                        }
                        n = 1;
                        blArray[5] = true;
                        break;
                    }
                    case -1044792121: {
                        if (!string2.equals("marginTop")) {
                            blArray[6] = true;
                            break;
                        }
                        n = 2;
                        blArray[7] = true;
                        break;
                    }
                    case 1970934485: {
                        if (!string2.equals("marginLeft")) {
                            blArray[8] = true;
                            break;
                        }
                        n = 3;
                        blArray[9] = true;
                        break;
                    }
                    case 975087886: {
                        if (!string2.equals("marginRight")) {
                            blArray[10] = true;
                            break;
                        }
                        n = 4;
                        blArray[11] = true;
                        break;
                    }
                    case -289173127: {
                        if (!string2.equals("marginBottom")) {
                            blArray[12] = true;
                            break;
                        }
                        n = 5;
                        blArray[13] = true;
                        break;
                    }
                    case 3317767: {
                        if (!string2.equals("left")) {
                            blArray[14] = true;
                            break;
                        }
                        n = 6;
                        blArray[15] = true;
                        break;
                    }
                    case 108511772: {
                        if (!string2.equals("right")) {
                            blArray[16] = true;
                            break;
                        }
                        n = 7;
                        blArray[17] = true;
                        break;
                    }
                    case -1383228885: {
                        if (!string2.equals("bottom")) {
                            blArray[18] = true;
                            break;
                        }
                        n = 8;
                        blArray[19] = true;
                        break;
                    }
                    case 115029: {
                        if (!string2.equals("top")) {
                            blArray[20] = true;
                            break;
                        }
                        n = 9;
                        blArray[21] = true;
                        break;
                    }
                    case 90130308: {
                        if (!string2.equals("paddingTop")) {
                            blArray[22] = true;
                            break;
                        }
                        n = 10;
                        blArray[23] = true;
                        break;
                    }
                    case 202355100: {
                        if (!string2.equals("paddingBottom")) {
                            blArray[24] = true;
                            break;
                        }
                        n = 11;
                        blArray[25] = true;
                        break;
                    }
                    case -1501175880: {
                        if (!string2.equals("paddingLeft")) {
                            blArray[26] = true;
                            break;
                        }
                        n = 12;
                        blArray[27] = true;
                        break;
                    }
                    case 713848971: {
                        if (!string2.equals("paddingRight")) {
                            blArray[28] = true;
                            break;
                        }
                        n = 13;
                        blArray[29] = true;
                    }
                }
                switch (n) {
                    default: {
                        blArray[30] = true;
                        break;
                    }
                    case 0: {
                        WXBridgeManager.getInstance().setStyleWidth(this.val$instanceId, this.val$ref, this.val$propertyValue);
                        blArray[31] = true;
                        break;
                    }
                    case 1: {
                        WXBridgeManager.getInstance().setStyleHeight(this.val$instanceId, this.val$ref, this.val$propertyValue);
                        blArray[32] = true;
                        break;
                    }
                    case 2: {
                        WXBridgeManager.getInstance().setMargin(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.TOP, this.val$propertyValue);
                        blArray[33] = true;
                        break;
                    }
                    case 3: {
                        WXBridgeManager.getInstance().setMargin(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.LEFT, this.val$propertyValue);
                        blArray[34] = true;
                        break;
                    }
                    case 4: {
                        WXBridgeManager.getInstance().setMargin(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.RIGHT, this.val$propertyValue);
                        blArray[35] = true;
                        break;
                    }
                    case 5: {
                        WXBridgeManager.getInstance().setMargin(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.BOTTOM, this.val$propertyValue);
                        blArray[36] = true;
                        break;
                    }
                    case 6: {
                        WXBridgeManager.getInstance().setPosition(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.LEFT, this.val$propertyValue);
                        blArray[37] = true;
                        break;
                    }
                    case 7: {
                        WXBridgeManager.getInstance().setPosition(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.RIGHT, this.val$propertyValue);
                        blArray[38] = true;
                        break;
                    }
                    case 8: {
                        WXBridgeManager.getInstance().setPosition(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.BOTTOM, this.val$propertyValue);
                        blArray[39] = true;
                        break;
                    }
                    case 9: {
                        WXBridgeManager.getInstance().setPosition(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.TOP, this.val$propertyValue);
                        blArray[40] = true;
                        break;
                    }
                    case 10: {
                        WXBridgeManager.getInstance().setPadding(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.TOP, this.val$propertyValue);
                        blArray[41] = true;
                        break;
                    }
                    case 11: {
                        WXBridgeManager.getInstance().setPadding(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.BOTTOM, this.val$propertyValue);
                        blArray[42] = true;
                        break;
                    }
                    case 12: {
                        WXBridgeManager.getInstance().setPadding(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.LEFT, this.val$propertyValue);
                        blArray[43] = true;
                        break;
                    }
                    case 13: {
                        WXBridgeManager.getInstance().setPadding(this.val$instanceId, this.val$ref, CSSShorthand.EDGE.RIGHT, this.val$propertyValue);
                        blArray[44] = true;
                        break;
                    }
                }
                blArray[45] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-8483729103183923733L, (String)"com/taobao/weex/dom/transition/WXTransition$7", (int)46);
                }
                return blArray;
            }
        });
        blArray[252] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private synchronized void onTransitionAnimationEnd() {
        boolean[] blArray = WXTransition.$jacocoInit();
        if (this.duration <= 0L) {
            blArray[253] = true;
        } else if (this.transitionEndEvent == null) {
            blArray[254] = true;
        } else {
            blArray[255] = true;
            View view = this.getTargetView();
            if (view == null) {
                blArray[256] = true;
            } else if (this.transitionEndEvent == null) {
                blArray[257] = true;
            } else {
                blArray[258] = true;
                view.post(this.transitionEndEvent);
                blArray[259] = true;
            }
            this.transitionEndEvent = null;
            blArray[260] = true;
        }
        Map<String, Object> map = this.targetStyles;
        synchronized (map) {
            try {
                blArray[261] = true;
                if (this.targetStyles.size() <= 0) {
                    blArray[262] = true;
                } else {
                    blArray[263] = true;
                    Iterator<String> iterator = this.properties.iterator();
                    blArray[264] = true;
                    while (iterator.hasNext()) {
                        void property;
                        String string2 = iterator.next();
                        blArray[265] = true;
                        if (!this.targetStyles.containsKey(property)) {
                            blArray[266] = true;
                        } else {
                            void targetValue;
                            blArray[267] = true;
                            Object object = this.targetStyles.remove(property);
                            blArray[268] = true;
                            this.mWXComponent.getStyles().put((String)property, (Object)targetValue);
                            blArray[269] = true;
                        }
                        blArray[270] = true;
                    }
                    this.targetStyles.clear();
                    blArray[271] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl51 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[272] = true;
                throw throwable;
            }
        }
        blArray[273] = true;
    }

    private View getTargetView() {
        View view;
        boolean[] blArray = WXTransition.$jacocoInit();
        if (null != this.mWXComponent) {
            view = (View)this.mWXComponent.getHostView();
            blArray[274] = true;
        } else {
            view = null;
            blArray[275] = true;
        }
        blArray[276] = true;
        return view;
    }

    /*
     * WARNING - void declaration
     */
    private static long parseTimeMillis(Map<String, Object> map, String string2, long l) {
        long l2;
        void defaultValue;
        void key;
        Map<String, Object> style;
        boolean[] blArray = WXTransition.$jacocoInit();
        String duration = WXUtils.getString(style.get(key), null);
        if (duration == null) {
            blArray[277] = true;
        } else {
            blArray[278] = true;
            duration = duration.replaceAll("ms", "");
            blArray[279] = true;
        }
        if (TextUtils.isEmpty((CharSequence)duration)) {
            blArray[281] = true;
            return (long)defaultValue;
        }
        blArray[280] = true;
        try {
            l2 = (long)Float.parseFloat(duration);
        }
        catch (NumberFormatException e) {
            blArray[283] = true;
            return (long)defaultValue;
        }
        blArray[282] = true;
        return l2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Interpolator createTimeInterpolator(String string2) {
        block28: {
            String interpolator;
            boolean[] blArray = WXTransition.$jacocoInit();
            if (TextUtils.isEmpty((CharSequence)interpolator)) {
                blArray[284] = true;
            } else {
                block27: {
                    Interpolator interpolator2;
                    blArray[285] = true;
                    String string3 = interpolator;
                    int n = -1;
                    switch (string3.hashCode()) {
                        default: {
                            blArray[286] = true;
                            break;
                        }
                        case -1965120668: {
                            if (!string3.equals("ease-in")) {
                                blArray[287] = true;
                                break;
                            }
                            n = 0;
                            blArray[288] = true;
                            break;
                        }
                        case -789192465: {
                            if (!string3.equals("ease-out")) {
                                blArray[289] = true;
                                break;
                            }
                            n = 1;
                            blArray[290] = true;
                            break;
                        }
                        case -361990811: {
                            if (!string3.equals("ease-in-out")) {
                                blArray[291] = true;
                                break;
                            }
                            n = 2;
                            blArray[292] = true;
                            break;
                        }
                        case 3105774: {
                            if (!string3.equals("ease")) {
                                blArray[293] = true;
                                break;
                            }
                            n = 3;
                            blArray[294] = true;
                            break;
                        }
                        case -1102672091: {
                            if (!string3.equals("linear")) {
                                blArray[295] = true;
                                break;
                            }
                            n = 4;
                            blArray[296] = true;
                        }
                    }
                    switch (n) {
                        default: {
                            blArray[297] = true;
                            break;
                        }
                        case 0: {
                            blArray[298] = true;
                            return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)1.0f, (float)1.0f);
                        }
                        case 1: {
                            blArray[299] = true;
                            return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)0.58f, (float)1.0f);
                        }
                        case 2: {
                            blArray[300] = true;
                            return PathInterpolatorCompat.create((float)0.42f, (float)0.0f, (float)0.58f, (float)1.0f);
                        }
                        case 3: {
                            blArray[301] = true;
                            return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
                        }
                        case 4: {
                            blArray[302] = true;
                            return PathInterpolatorCompat.create((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                        }
                    }
                    try {
                        void params;
                        void parser;
                        SingleFunctionParser<Float> singleFunctionParser = new SingleFunctionParser<Float>(interpolator, new SingleFunctionParser.FlatMapper<Float>(){
                            private static final transient /* synthetic */ boolean[] $jacocoData;
                            {
                                boolean[] blArray = 8.$jacocoInit();
                                blArray[0] = true;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public Float map(String string2) {
                                void raw;
                                boolean[] blArray = 8.$jacocoInit();
                                blArray[1] = true;
                                return Float.valueOf(Float.parseFloat((String)raw));
                            }

                            private static /* synthetic */ boolean[] $jacocoInit() {
                                boolean[] blArray = $jacocoData;
                                if ($jacocoData == null) {
                                    blArray = $jacocoData = Offline.getProbes((long)-3067835389993004430L, (String)"com/taobao/weex/dom/transition/WXTransition$8", (int)3);
                                }
                                return blArray;
                            }
                        });
                        blArray[303] = true;
                        List list = parser.parse("cubic-bezier");
                        blArray[304] = true;
                        if (params == null) {
                            blArray[305] = true;
                            break block27;
                        }
                        if (params.size() != 4) {
                            blArray[306] = true;
                            break block27;
                        }
                        blArray[307] = true;
                        blArray[308] = true;
                        interpolator2 = PathInterpolatorCompat.create((float)((Float)params.get(0)).floatValue(), (float)((Float)params.get(1)).floatValue(), (float)((Float)params.get(2)).floatValue(), (float)((Float)params.get(3)).floatValue());
                    }
                    catch (RuntimeException parser) {
                        blArray[311] = true;
                        if (!WXEnvironment.isApkDebugable()) {
                            blArray[312] = true;
                            break block28;
                        } else {
                            void e;
                            blArray[313] = true;
                            WXLogUtils.e("WXTransition", (Throwable)e);
                            blArray[314] = true;
                        }
                        break block28;
                    }
                    blArray[309] = true;
                    return interpolator2;
                }
                blArray[310] = true;
            }
        }
        blArray[315] = true;
        return PathInterpolatorCompat.create((float)0.25f, (float)0.1f, (float)0.25f, (float)1.0f);
    }

    /*
     * Unable to fully structure code
     */
    private static void updateTransitionProperties(WXTransition var0, String var1_1) {
        var2_2 = WXTransition.$jacocoInit();
        if (transtionProperty == null) {
            var2_2[316] = true;
            return;
        }
        transition.properties.clear();
        var2_2[317] = true;
        var4_4 = propertiesArray = WXTransition.PROPERTY_SPLIT_PATTERN.split((CharSequence)transtionProperty);
        var5_5 = var4_4.length;
        var2_2[318] = true;
        for (var6_6 = 0; var6_6 < var5_5; ++var6_6) {
            block7: {
                block8: {
                    block6: {
                        var7_7 = var4_4[var6_6];
                        var2_2[319] = true;
                        var8_8 = property.trim();
                        var2_2[320] = true;
                        if (!TextUtils.isEmpty((CharSequence)trim)) break block6;
                        var2_2[321] = true;
                        break block7;
                    }
                    if (!WXTransition.LAYOUT_PROPERTIES.contains(trim)) break block8;
                    var2_2[322] = true;
                    ** GOTO lbl33
                }
                if (!WXTransition.TRANSFORM_PROPERTIES.contains(trim)) {
                    var2_2[324] = true;
                    if (!WXEnvironment.isApkDebugable()) {
                        var2_2[325] = true;
                    } else {
                        var2_2[326] = true;
                        WXLogUtils.e("WXTransition Property Not Supported" + (String)trim + " in " + (String)transtionProperty);
                        var2_2[327] = true;
                    }
                } else {
                    var2_2[323] = true;
lbl33:
                    // 2 sources

                    transition.properties.add((String)trim);
                    var2_2[328] = true;
                }
            }
            var2_2[329] = true;
        }
        var2_2[330] = true;
    }

    public List<String> getProperties() {
        boolean[] blArray = WXTransition.$jacocoInit();
        blArray[331] = true;
        return this.properties;
    }

    static /* synthetic */ AtomicInteger access$000(WXTransition wXTransition) {
        WXTransition x0;
        boolean[] blArray = WXTransition.$jacocoInit();
        blArray[332] = true;
        return x0.lockToken;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(WXTransition wXTransition, int n) {
        void x1;
        WXTransition x0;
        boolean[] blArray = WXTransition.$jacocoInit();
        x0.doTransitionAnimation((int)x1);
        blArray[333] = true;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Runnable access$202(WXTransition wXTransition, Runnable runnable) {
        WXTransition x0;
        void x1;
        boolean[] blArray = WXTransition.$jacocoInit();
        x0.animationRunnable = x1;
        blArray[334] = true;
        return x0.animationRunnable;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Runnable access$302(WXTransition wXTransition, Runnable runnable) {
        WXTransition x0;
        void x1;
        boolean[] blArray = WXTransition.$jacocoInit();
        x0.transitionEndEvent = x1;
        blArray[335] = true;
        return x0.transitionEndEvent;
    }

    static /* synthetic */ long access$400(WXTransition wXTransition) {
        WXTransition x0;
        boolean[] blArray = WXTransition.$jacocoInit();
        blArray[336] = true;
        return x0.duration;
    }

    static /* synthetic */ WXComponent access$500(WXTransition wXTransition) {
        WXTransition x0;
        boolean[] blArray = WXTransition.$jacocoInit();
        blArray[337] = true;
        return x0.mWXComponent;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(WXTransition wXTransition, int n) {
        void x1;
        WXTransition x0;
        boolean[] blArray = WXTransition.$jacocoInit();
        x0.doPendingTransformAnimation((int)x1);
        blArray[338] = true;
    }

    static /* synthetic */ void access$700(WXTransition wXTransition) {
        WXTransition x0;
        boolean[] blArray = WXTransition.$jacocoInit();
        x0.onTransitionAnimationEnd();
        blArray[339] = true;
    }

    static {
        boolean[] blArray = WXTransition.$jacocoInit();
        PROPERTY_SPLIT_PATTERN = Pattern.compile("\\||,");
        blArray[340] = true;
        LAYOUT_PROPERTIES = new HashSet<String>();
        blArray[341] = true;
        LAYOUT_PROPERTIES.add("width");
        blArray[342] = true;
        LAYOUT_PROPERTIES.add("height");
        blArray[343] = true;
        LAYOUT_PROPERTIES.add("marginTop");
        blArray[344] = true;
        LAYOUT_PROPERTIES.add("marginBottom");
        blArray[345] = true;
        LAYOUT_PROPERTIES.add("marginLeft");
        blArray[346] = true;
        LAYOUT_PROPERTIES.add("marginRight");
        blArray[347] = true;
        LAYOUT_PROPERTIES.add("left");
        blArray[348] = true;
        LAYOUT_PROPERTIES.add("right");
        blArray[349] = true;
        LAYOUT_PROPERTIES.add("top");
        blArray[350] = true;
        LAYOUT_PROPERTIES.add("bottom");
        blArray[351] = true;
        LAYOUT_PROPERTIES.add("paddingLeft");
        blArray[352] = true;
        LAYOUT_PROPERTIES.add("paddingRight");
        blArray[353] = true;
        LAYOUT_PROPERTIES.add("paddingTop");
        blArray[354] = true;
        LAYOUT_PROPERTIES.add("paddingBottom");
        blArray[355] = true;
        TRANSFORM_PROPERTIES = new HashSet<String>();
        blArray[356] = true;
        TRANSFORM_PROPERTIES.add("opacity");
        blArray[357] = true;
        TRANSFORM_PROPERTIES.add("backgroundColor");
        blArray[358] = true;
        TRANSFORM_PROPERTIES.add("transform");
        blArray[359] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-6318592324907256961L, (String)"com/taobao/weex/dom/transition/WXTransition", (int)360);
        }
        return blArray;
    }
}

