/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.storage;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taobao.weex.utils.WXLogUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jacoco.agent.rt.internal_b0d6a23.Offline;

public class WXSQLiteOpenHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "WXStorage";
    private static final int DATABASE_VERSION = 2;
    static final String TAG_STORAGE = "weex_storage";
    private long mMaximumDatabaseSize;
    static SimpleDateFormat sDateFormatter;
    private Context mContext;
    private SQLiteDatabase mDb;
    static final String TABLE_STORAGE = "default_wx_storage";
    static final String COLUMN_KEY = "key";
    static final String COLUMN_VALUE = "value";
    static final String COLUMN_TIMESTAMP = "timestamp";
    static final String COLUMN_PERSISTENT = "persistent";
    private static final int SLEEP_TIME_MS = 30;
    private static final String STATEMENT_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS default_wx_storage (key TEXT PRIMARY KEY,value TEXT NOT NULL,timestamp TEXT NOT NULL,persistent INTEGER DEFAULT 0)";
    private static final transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public WXSQLiteOpenHelper(Context context) {
        void context2;
        boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
        super((Context)context2, DATABASE_NAME, null, 2);
        this.mMaximumDatabaseSize = 0x3200000L;
        this.mContext = context2;
        blArray[0] = true;
    }

    @Nullable
    public SQLiteDatabase getDatabase() {
        boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
        this.ensureDatabase();
        blArray[1] = true;
        return this.mDb;
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        void db;
        boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
        db.execSQL(STATEMENT_CREATE_TABLE);
        blArray[2] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        block7: {
            void db;
            block9: {
                block10: {
                    boolean updateResult;
                    void newVersion;
                    void oldVersion;
                    block8: {
                        block6: {
                            boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
                            if (oldVersion != newVersion) break block6;
                            blArray[3] = true;
                            break block7;
                        }
                        if (newVersion == 2) break block8;
                        blArray[4] = true;
                        break block9;
                    }
                    if (oldVersion != true) break block10;
                    blArray[6] = true;
                    WXLogUtils.d(TAG_STORAGE, "storage is updating from version " + (int)oldVersion + " to version " + (int)newVersion);
                    boolean bl = true;
                    try {
                        void time;
                        void start;
                        void SQL_UPDATE_TABLE;
                        void SQL_ADD_COLUMN_PERSISTENT;
                        void SQL_ADD_COLUMN_TIMESTAMP;
                        blArray[7] = true;
                        long l = System.currentTimeMillis();
                        blArray[8] = true;
                        db.beginTransaction();
                        String string2 = "ALTER TABLE default_wx_storage ADD COLUMN timestamp TEXT;";
                        blArray[9] = true;
                        WXLogUtils.d(TAG_STORAGE, "exec sql : " + (String)SQL_ADD_COLUMN_TIMESTAMP);
                        blArray[10] = true;
                        db.execSQL((String)SQL_ADD_COLUMN_TIMESTAMP);
                        String string3 = "ALTER TABLE default_wx_storage ADD COLUMN persistent INTEGER;";
                        blArray[11] = true;
                        WXLogUtils.d(TAG_STORAGE, "exec sql : " + (String)SQL_ADD_COLUMN_PERSISTENT);
                        blArray[12] = true;
                        db.execSQL((String)SQL_ADD_COLUMN_PERSISTENT);
                        blArray[13] = true;
                        String string4 = "UPDATE default_wx_storage SET timestamp = '" + sDateFormatter.format(new Date()) + "' , " + COLUMN_PERSISTENT + " = 0";
                        blArray[14] = true;
                        WXLogUtils.d(TAG_STORAGE, "exec sql : " + (String)SQL_UPDATE_TABLE);
                        blArray[15] = true;
                        db.execSQL((String)SQL_UPDATE_TABLE);
                        blArray[16] = true;
                        db.setTransactionSuccessful();
                        blArray[17] = true;
                        long l2 = System.currentTimeMillis() - start;
                        blArray[18] = true;
                        WXLogUtils.d(TAG_STORAGE, "storage updated success (" + (long)time + "ms)");
                        blArray[19] = true;
                    }
                    catch (Exception start) {
                        try {
                            void e;
                            blArray[21] = true;
                            WXLogUtils.d(TAG_STORAGE, "storage updated failed from version " + (int)oldVersion + " to version " + (int)newVersion + "," + e.getMessage());
                            updateResult = false;
                            blArray[22] = true;
                        }
                        catch (Throwable throwable) {
                            db.endTransaction();
                            blArray[24] = true;
                            throw throwable;
                        }
                        db.endTransaction();
                        blArray[23] = true;
                    }
                    db.endTransaction();
                    blArray[20] = true;
                    if (updateResult) {
                        blArray[25] = true;
                    } else {
                        blArray[26] = true;
                        WXLogUtils.d(TAG_STORAGE, "storage is rollback,all data will be removed");
                        blArray[27] = true;
                        this.deleteDB();
                        blArray[28] = true;
                        this.onCreate((SQLiteDatabase)db);
                        blArray[29] = true;
                    }
                    blArray[30] = true;
                    break block7;
                }
                blArray[5] = true;
            }
            this.deleteDB();
            blArray[31] = true;
            this.onCreate((SQLiteDatabase)db);
            blArray[32] = true;
        }
        blArray[33] = true;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void ensureDatabase() {
        boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
        if (this.mDb == null) {
            blArray[34] = true;
        } else if (!this.mDb.isOpen()) {
            blArray[35] = true;
        } else {
            blArray[36] = true;
            return;
        }
        boolean bl = false;
        blArray[37] = true;
        while (true) {
            void tries;
            if (tries >= 2) {
                blArray[38] = true;
                break;
            }
            try {
                blArray[39] = true;
                if (tries <= 0) {
                    blArray[40] = true;
                } else {
                    blArray[41] = true;
                    this.deleteDB();
                    blArray[42] = true;
                }
                this.mDb = this.getWritableDatabase();
                blArray[43] = true;
            }
            catch (SQLiteException sQLiteException) {
                void e22;
                blArray[44] = true;
                e22.printStackTrace();
                try {
                    blArray[45] = true;
                    Thread.sleep(30L);
                    blArray[46] = true;
                }
                catch (InterruptedException e22) {
                    blArray[47] = true;
                    Thread.currentThread().interrupt();
                    blArray[48] = true;
                }
                ++tries;
                blArray[49] = true;
                continue;
            }
            break;
        }
        if (this.mDb == null) {
            blArray[50] = true;
            return;
        }
        this.createTableIfNotExists(this.mDb);
        blArray[51] = true;
        this.mDb.setMaximumSize(this.mMaximumDatabaseSize);
        blArray[52] = true;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setMaximumSize(long l) {
        void size;
        boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
        this.mMaximumDatabaseSize = size;
        if (this.mDb == null) {
            blArray[53] = true;
        } else {
            blArray[54] = true;
            this.mDb.setMaximumSize(this.mMaximumDatabaseSize);
            blArray[55] = true;
        }
        blArray[56] = true;
    }

    private boolean deleteDB() {
        boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
        this.closeDatabase();
        blArray[57] = true;
        blArray[58] = true;
        return this.mContext.deleteDatabase(DATABASE_NAME);
    }

    public void closeDatabase() {
        boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
        if (this.mDb == null) {
            blArray[59] = true;
        } else if (!this.mDb.isOpen()) {
            blArray[60] = true;
        } else {
            blArray[61] = true;
            this.mDb.close();
            this.mDb = null;
            blArray[62] = true;
        }
        blArray[63] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void createTableIfNotExists(@NonNull SQLiteDatabase sQLiteDatabase) {
        block14: {
            Cursor cursor;
            void db;
            block12: {
                block13: {
                    boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
                    Object var3_3 = null;
                    blArray[64] = true;
                    cursor = db.rawQuery("SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = 'default_wx_storage'", null);
                    blArray[65] = true;
                    if (cursor == null) {
                        blArray[66] = true;
                        break block12;
                    }
                    if (cursor.getCount() <= 0) {
                        blArray[67] = true;
                        break block12;
                    }
                    if (cursor == null) {
                        blArray[68] = true;
                        break block13;
                    }
                    blArray[69] = true;
                    cursor.close();
                    blArray[70] = true;
                }
                blArray[71] = true;
                return;
            }
            try {
                db.execSQL(STATEMENT_CREATE_TABLE);
                if (cursor == null) {
                    blArray[72] = true;
                    break block14;
                }
                blArray[73] = true;
            }
            catch (Exception exception) {
                try {
                    void e;
                    blArray[75] = true;
                    e.printStackTrace();
                    if (cursor == null) {
                        blArray[76] = true;
                        break block14;
                    }
                    blArray[77] = true;
                }
                catch (Throwable throwable) {
                    if (cursor == null) {
                        blArray[79] = true;
                    } else {
                        blArray[80] = true;
                        cursor.close();
                        blArray[81] = true;
                    }
                    blArray[82] = true;
                    throw throwable;
                }
                cursor.close();
                blArray[78] = true;
            }
            cursor.close();
            blArray[74] = true;
        }
        blArray[83] = true;
    }

    static {
        boolean[] blArray = WXSQLiteOpenHelper.$jacocoInit();
        sDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        blArray[84] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)6901098392874832692L, (String)"com/taobao/weex/appfram/storage/WXSQLiteOpenHelper", (int)85);
        }
        return blArray;
    }
}

