/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.support.annotation.NonNull;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.wson.Wson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WXJsonUtils {
    public static boolean USE_WSON = true;

    @NonNull
    public static <T> List<T> getList(String json, Class<T> clazz) {
        ArrayList result = null;
        try {
            result = JSONObject.parseArray((String)json, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new ArrayList();
        }
        return result;
    }

    @NonNull
    public static String fromObjectToJSONString(Object obj, boolean WriteNonStringKeyAsString) {
        try {
            if (WriteNonStringKeyAsString) {
                return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNonStringKeyAsString});
            }
            return JSON.toJSONString((Object)obj);
        }
        catch (Exception e) {
            if (WXEnvironment.isApkDebugable()) {
                throw new WXRuntimeException("fromObjectToJSONString parse error!");
            }
            WXLogUtils.e("fromObjectToJSONString error:", e);
            return "{}";
        }
    }

    @NonNull
    public static String fromObjectToJSONString(Object obj) {
        return WXJsonUtils.fromObjectToJSONString(obj, false);
    }

    public static void putAll(Map<String, Object> container, JSONObject rawValue) {
        for (Map.Entry entry : rawValue.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            container.put(key, value);
        }
    }

    public static final Object parseWson(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            if (USE_WSON) {
                return Wson.parse(data);
            }
            return JSON.parse((String)new String(data, "UTF-8"));
        }
        catch (Exception e) {
            WXLogUtils.e("weex wson parse error ", e);
            return null;
        }
    }

    public static final WXJSObject wsonWXJSObject(Object tasks) {
        if (USE_WSON) {
            return new WXJSObject(4, Wson.toWson(tasks));
        }
        return new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(tasks));
    }
}

