/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.view.IRenderResult;
import com.taobao.weex.ui.view.IRenderStatus;
import com.taobao.weex.ui.view.IWXTextView;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import java.lang.ref.WeakReference;

public class WXTextView
extends View
implements WXGestureObservable,
IWXTextView,
IRenderStatus<WXText>,
IRenderResult<WXText> {
    private WeakReference<WXText> mWeakReference;
    private WXGesture wxGesture;
    private Layout textLayout;
    private boolean mIsLabelSet = false;

    public WXTextView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        Layout layout = this.getTextLayout();
        if (layout != null) {
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            layout.draw(canvas);
        }
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch(this, event);
        }
        return result;
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public CharSequence getText() {
        return this.textLayout.getText();
    }

    public Layout getTextLayout() {
        return this.textLayout;
    }

    public void setTextLayout(Layout layout) {
        WXText wxText;
        this.textLayout = layout;
        if (layout != null && !this.mIsLabelSet) {
            this.setContentDescription(layout.getText());
        }
        if (this.mWeakReference != null && (wxText = (WXText)this.mWeakReference.get()) != null) {
            wxText.readyToRender();
        }
    }

    public void setAriaLabel(String label) {
        if (!TextUtils.isEmpty((CharSequence)label)) {
            this.mIsLabelSet = true;
            this.setContentDescription(label);
        } else {
            this.mIsLabelSet = false;
            if (this.textLayout != null) {
                this.setContentDescription(this.textLayout.getText());
            }
        }
    }

    @Override
    public void holdComponent(WXText component) {
        this.mWeakReference = new WeakReference<WXText>(component);
    }

    @Override
    @Nullable
    public WXText getComponent() {
        return null != this.mWeakReference ? (WXText)this.mWeakReference.get() : null;
    }
}

