/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.WXCellDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.util.List;

public abstract class AbstractAddElementAction
extends TraceableAction
implements DOMAction,
RenderAction {
    protected WXComponent generateComponentTree(DOMActionContext context, WXDomObject dom, WXVContainer parent) {
        if (dom == null) {
            return null;
        }
        long startNanos = System.nanoTime();
        WXComponent component = WXComponentFactory.newInstance(context.getInstance(), dom, parent);
        if (component != null) {
            component.mTraceInfo.domThreadStart = dom.mDomThreadTimestamp;
            component.mTraceInfo.rootEventId = this.mTracingEventId;
            component.mTraceInfo.domQueueTime = this.mDomQueueTime;
        }
        context.registerComponent(dom.getRef(), component);
        if (component instanceof WXVContainer) {
            WXVContainer parentC = (WXVContainer)component;
            int count = dom.childCount();
            WXDomObject child = null;
            for (int i = 0; i < count; ++i) {
                child = dom.getChild(i);
                if (child == null) continue;
                WXComponent createdComponent = this.generateComponentTree(context, child, parentC);
                if (createdComponent != null) {
                    parentC.addChild(createdComponent);
                    continue;
                }
                WXLogUtils.e("[generateComponentTree] " + this.getStatementName() + " create dom component failed name " + child.getType());
                WXExceptionUtils.commitCriticalExceptionRT(context.getInstanceId(), this.getErrorCode().getErrorCode(), "generateComponentTree", " create dom component failed name " + child.getType(), null);
            }
        }
        if (component != null) {
            component.mTraceInfo.domThreadNanos = System.nanoTime() - startNanos;
        }
        return component;
    }

    protected void addDomInternal(DOMActionContext context, JSONObject dom) {
        if (context.isDestory()) {
            return;
        }
        WXSDKInstance instance = context.getInstance();
        if (instance == null) {
            return;
        }
        String errCode = this.getErrorCode().getErrorCode();
        String errMsg = this.getErrorMsg();
        if (dom == null) {
            WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), errCode, "addDomInternal", errMsg, null);
        }
        Stopwatch.tick();
        WXDomObject domObject = WXDomObject.parse(dom, instance, null);
        Stopwatch.split("parseDomObject");
        if (domObject == null || context.getDomByRef(domObject.getRef()) != null) {
            WXLogUtils.e("[DOMActionContextImpl] " + this.getStatementName() + " error,DOM object is null or already registered!!");
            WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), errCode, "addDomInternal", errMsg, null);
            return;
        }
        this.appendDomToTree(context, domObject);
        Stopwatch.split("appendDomToTree");
        domObject.traverseTree(context.getAddDOMConsumer(), context.getApplyStyleConsumer());
        Stopwatch.split("traverseTree");
        WXComponent component = this.createComponent(context, domObject);
        if (component == null) {
            return;
        }
        Stopwatch.split("createComponent");
        boolean needAddDomInfo = true;
        if (domObject.getType().equals("cell-slot") && domObject instanceof WXCellDomObject) {
            needAddDomInfo = false;
        }
        if (needAddDomInfo) {
            context.addDomInfo(domObject.getRef(), component);
        }
        context.postRenderTask(this);
        this.addAnimationForDomTree(context, domObject);
        if (WXTracing.isAvailable()) {
            List<Stopwatch.ProcessEvent> events = Stopwatch.getProcessEvents();
            for (Stopwatch.ProcessEvent event : events) {
                this.submitPerformance(event.fname, "X", context.getInstanceId(), event.duration, event.startMillis, true);
            }
        }
    }

    public void addAnimationForDomTree(DOMActionContext context, WXDomObject domObject) {
        context.addAnimationForElement(domObject.getRef(), domObject.getStyles());
        for (int i = 0; i < domObject.childCount(); ++i) {
            this.addAnimationForDomTree(context, domObject.getChild(i));
        }
    }

    protected abstract WXComponent createComponent(DOMActionContext var1, WXDomObject var2);

    protected abstract void appendDomToTree(DOMActionContext var1, WXDomObject var2);

    protected abstract String getStatementName();

    protected abstract WXErrorCode getErrorCode();

    protected abstract String getErrorMsg();
}

