/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.ForegroundColorSpan;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.TextDecorationSpan;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXLineHeightSpan;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSConstants;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.dom.flex.FloatUtil;
import com.taobao.weex.dom.flex.MeasureOutput;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.StaticLayoutProxy;
import com.taobao.weex.utils.WXDomUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class WXTextDomObject
extends WXDomObject {
    static final CSSNode.MeasureFunction TEXT_MEASURE_FUNCTION = new CSSNode.MeasureFunction(){

        @Override
        public void measure(CSSNode node, float width, @NonNull MeasureOutput measureOutput) {
            WXTextDomObject textDomObject = (WXTextDomObject)node;
            if (CSSConstants.isUndefined(width)) {
                width = node.cssstyle.maxWidth;
            }
            boolean forceWidth = false;
            if (width > 0.0f && node.getParent() != null && textDomObject.mAlignment == Layout.Alignment.ALIGN_CENTER) {
                forceWidth = FloatUtil.floatsEqual(width, node.getParent().getLayoutWidth());
            }
            textDomObject.hasBeenMeasured = true;
            width = textDomObject.getTextWidth(textDomObject.mTextPaint, width, forceWidth);
            if (width > 0.0f && textDomObject.mText != null) {
                textDomObject.layout = textDomObject.createLayout(width, true, null);
                textDomObject.previousWidth = textDomObject.layout.getWidth();
                measureOutput.height = textDomObject.layout.getHeight();
                measureOutput.width = textDomObject.previousWidth;
            } else {
                measureOutput.height = 0.0f;
                measureOutput.width = 0.0f;
            }
        }
    };
    private static final Canvas DUMMY_CANVAS = new Canvas();
    private static final String ELLIPSIS = "\u2026";
    private boolean mIsColorSet = false;
    private boolean hasBeenMeasured = false;
    private int mColor;
    private int mFontStyle = -1;
    private int mFontWeight = -1;
    private int mNumberOfLines = -1;
    private int mFontSize = -1;
    private int mLineHeight = -1;
    private float previousWidth = Float.NaN;
    private String mFontFamily = WXEnvironment.getGlobalFontFamilyName();
    private String mText = null;
    private TextUtils.TruncateAt textOverflow;
    private Layout.Alignment mAlignment;
    private WXTextDecoration mTextDecoration = WXTextDecoration.NONE;
    private TextPaint mTextPaint = new TextPaint();
    @Nullable
    private Spanned spanned;
    @Nullable
    private Layout layout;
    private AtomicReference<Layout> atomicReference = new AtomicReference();
    private BroadcastReceiver mTypefaceObserver;

    public WXTextDomObject() {
        this.mTextPaint.setFlags(1);
        this.setMeasureFunction(TEXT_MEASURE_FUNCTION);
        this.registerTypefaceObserverIfNeed(WXStyle.getFontFamily(this.getStyles()));
    }

    public TextPaint getTextPaint() {
        return this.mTextPaint;
    }

    @Override
    public void layoutBefore() {
        this.hasBeenMeasured = false;
        this.updateStyleAndText();
        this.spanned = this.createSpanned(this.mText);
        if (this.hasNewLayout()) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("Previous csslayout was ignored! markLayoutSeen() never called");
            }
            this.markUpdateSeen();
        }
        super.dirty();
        super.layoutBefore();
    }

    @Override
    public void layoutAfter() {
        if (this.hasBeenMeasured) {
            if (this.layout != null && !FloatUtil.floatsEqual(WXDomUtils.getContentWidth(this), this.previousWidth)) {
                this.recalculateLayout();
            }
        } else {
            this.updateStyleAndText();
            this.recalculateLayout();
        }
        this.hasBeenMeasured = false;
        if (this.layout != null && !this.layout.equals(this.atomicReference.get()) && Build.VERSION.SDK_INT >= 19 && Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.warmUpTextLayoutCache(this.layout);
        }
        this.swap();
        super.layoutAfter();
    }

    public Layout getExtra() {
        return this.atomicReference.get();
    }

    @Override
    public void updateAttr(Map<String, Object> attrs) {
        this.swap();
        super.updateAttr(attrs);
        if (attrs.containsKey("value")) {
            this.mText = WXAttr.getValue(attrs);
        }
    }

    @Override
    public void updateStyle(Map<String, Object> styles) {
        this.swap();
        super.updateStyle(styles);
        this.updateStyleImp(styles);
    }

    @Override
    public WXTextDomObject clone() {
        WXTextDomObject dom;
        block4: {
            if (this.isCloneThis()) {
                return this;
            }
            dom = null;
            try {
                dom = new WXTextDomObject();
                this.copyFields(dom);
                dom.hasBeenMeasured = this.hasBeenMeasured;
                dom.atomicReference = new AtomicReference<Layout>(this.atomicReference.get());
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e("WXTextDomObject clone error: ", e);
            }
        }
        if (dom != null) {
            dom.spanned = this.spanned;
        }
        return dom;
    }

    private void recalculateLayout() {
        float contentWidth = WXDomUtils.getContentWidth(this);
        if (contentWidth > 0.0f) {
            this.spanned = this.createSpanned(this.mText);
            if (this.mText != null) {
                this.layout = this.createLayout(contentWidth, true, this.layout);
                this.previousWidth = this.layout.getWidth();
            } else {
                this.previousWidth = 0.0f;
            }
        }
    }

    private void updateStyleAndText() {
        this.updateStyleImp(this.getStyles());
        this.mText = WXAttr.getValue(this.getAttrs());
    }

    private void updateStyleImp(Map<String, Object> style) {
        if (style != null) {
            if (style.containsKey("lines")) {
                int lines = WXStyle.getLines(style);
                int n = this.mNumberOfLines = lines > 0 ? lines : -1;
            }
            if (style.containsKey("fontSize")) {
                this.mFontSize = WXStyle.getFontSize(style, this.getViewPortWidth());
            }
            if (style.containsKey("fontWeight")) {
                this.mFontWeight = WXStyle.getFontWeight(style);
            }
            if (style.containsKey("fontStyle")) {
                this.mFontStyle = WXStyle.getFontStyle(style);
            }
            if (style.containsKey("color")) {
                this.mColor = WXResourceUtils.getColor(WXStyle.getTextColor(style));
                boolean bl = this.mIsColorSet = this.mColor != Integer.MIN_VALUE;
            }
            if (style.containsKey("textDecoration")) {
                this.mTextDecoration = WXStyle.getTextDecoration(style);
            }
            if (style.containsKey("fontFamily")) {
                this.mFontFamily = WXStyle.getFontFamily(style);
            }
            this.mAlignment = WXStyle.getTextAlignment(style);
            this.textOverflow = WXStyle.getTextOverflow(style);
            int lineHeight = WXStyle.getLineHeight(style, this.getViewPortWidth());
            if (lineHeight != -1) {
                this.mLineHeight = lineHeight;
            }
            this.registerTypefaceObserverIfNeed(this.mFontFamily);
        }
    }

    @NonNull
    private Layout createLayout(float width, boolean forceWidth, @Nullable Layout previousLayout) {
        int lastLineEnd;
        int lastLineStart;
        Layout layout2;
        float textWidth = this.getTextWidth(this.mTextPaint, width, forceWidth);
        if (!FloatUtil.floatsEqual(this.previousWidth, textWidth) || previousLayout == null) {
            boolean forceRtl = false;
            Object direction = this.getStyles().get("direction");
            if (direction != null && "text".equals(this.mType)) {
                forceRtl = direction.equals("rtl");
            }
            layout2 = StaticLayoutProxy.create((CharSequence)this.spanned, this.mTextPaint, (int)Math.ceil(textWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false, forceRtl);
        } else {
            layout2 = previousLayout;
        }
        if (this.mNumberOfLines != -1 && this.mNumberOfLines > 0 && this.mNumberOfLines < layout2.getLineCount() && (lastLineStart = layout2.getLineStart(this.mNumberOfLines - 1)) < (lastLineEnd = layout2.getLineEnd(this.mNumberOfLines - 1))) {
            SpannableStringBuilder builder = null;
            builder = lastLineStart > 0 ? new SpannableStringBuilder(this.spanned.subSequence(0, lastLineStart)) : new SpannableStringBuilder();
            SpannableStringBuilder lastLine = new SpannableStringBuilder(this.spanned.subSequence(lastLineStart, lastLineEnd));
            builder.append((CharSequence)this.truncate((Editable)lastLine, this.mTextPaint, (int)Math.ceil(textWidth), this.textOverflow));
            this.adjustSpansRange(this.spanned, (Spannable)builder);
            this.spanned = builder;
            return new StaticLayout((CharSequence)this.spanned, this.mTextPaint, (int)Math.ceil(textWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        }
        return layout2;
    }

    @NonNull
    private Spanned truncate(@Nullable Editable source, @NonNull TextPaint paint, int desired, @Nullable TextUtils.TruncateAt truncateAt) {
        SpannedString ret = new SpannedString((CharSequence)"");
        if (!TextUtils.isEmpty((CharSequence)source) && source.length() > 0) {
            if (truncateAt != null) {
                Object[] spans;
                source.append((CharSequence)ELLIPSIS);
                for (Object span : spans = source.getSpans(0, source.length(), Object.class)) {
                    int start = source.getSpanStart(span);
                    int end = source.getSpanEnd(span);
                    if (start != 0 || end != source.length() - 1) continue;
                    source.removeSpan(span);
                    source.setSpan(span, 0, source.length(), source.getSpanFlags(span));
                }
            }
            while (source.length() > 1) {
                int startOffset = source.length() - 1;
                if (truncateAt != null) {
                    --startOffset;
                }
                source.delete(startOffset, startOffset + 1);
                StaticLayout layout2 = new StaticLayout((CharSequence)source, paint, desired, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
                if (layout2.getLineCount() > 1) continue;
                ret = source;
                break;
            }
        }
        return ret;
    }

    private void adjustSpansRange(@NonNull Spanned beforeTruncate, @NonNull Spannable afterTruncate) {
        Object[] spans;
        for (Object span : spans = beforeTruncate.getSpans(0, beforeTruncate.length(), Object.class)) {
            int start = beforeTruncate.getSpanStart(span);
            int end = beforeTruncate.getSpanEnd(span);
            if (start != 0 || end != beforeTruncate.length()) continue;
            afterTruncate.removeSpan(span);
            afterTruncate.setSpan(span, 0, afterTruncate.length(), beforeTruncate.getSpanFlags(span));
        }
    }

    float getTextWidth(TextPaint textPaint, float outerWidth, boolean forceToDesired) {
        float textWidth;
        if (this.mText == null) {
            if (forceToDesired) {
                return outerWidth;
            }
            return 0.0f;
        }
        if (forceToDesired) {
            textWidth = outerWidth;
        } else {
            float desiredWidth = Layout.getDesiredWidth((CharSequence)this.spanned, (TextPaint)textPaint);
            textWidth = CSSConstants.isUndefined(outerWidth) || desiredWidth < outerWidth ? desiredWidth : outerWidth;
        }
        return textWidth;
    }

    @NonNull
    protected Spanned createSpanned(String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            SpannableString spannable = new SpannableString((CharSequence)text);
            this.updateSpannable((Spannable)spannable, 17);
            return spannable;
        }
        return new SpannableString((CharSequence)"");
    }

    protected void updateSpannable(Spannable spannable, int spanFlag) {
        List<SetSpanOperation> ops = this.createSetSpanOperation(spannable.length(), spanFlag);
        if (this.mFontSize == -1) {
            ops.add(new SetSpanOperation(0, spannable.length(), new AbsoluteSizeSpan(32), spanFlag));
        }
        Collections.reverse(ops);
        for (SetSpanOperation op : ops) {
            op.execute(spannable);
        }
    }

    private List<SetSpanOperation> createSetSpanOperation(int end, int spanFlag) {
        LinkedList<SetSpanOperation> ops = new LinkedList<SetSpanOperation>();
        int start = 0;
        if (end >= start) {
            if (this.mTextDecoration == WXTextDecoration.UNDERLINE || this.mTextDecoration == WXTextDecoration.LINETHROUGH) {
                ops.add(new SetSpanOperation(start, end, (Object)new TextDecorationSpan(this.mTextDecoration), spanFlag));
            }
            if (this.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ForegroundColorSpan(this.mColor), spanFlag));
            }
            if (this.mFontSize != -1) {
                ops.add(new SetSpanOperation(start, end, new AbsoluteSizeSpan(this.mFontSize), spanFlag));
            }
            if (this.mFontStyle != -1 || this.mFontWeight != -1 || this.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, (Object)new WXCustomStyleSpan(this.mFontStyle, this.mFontWeight, this.mFontFamily), spanFlag));
            }
            ops.add(new SetSpanOperation(start, end, new AlignmentSpan.Standard(this.mAlignment), spanFlag));
            if (this.mLineHeight != -1) {
                ops.add(new SetSpanOperation(start, end, new WXLineHeightSpan(this.mLineHeight), spanFlag));
            }
        }
        return ops;
    }

    private void swap() {
        if (this.layout != null) {
            this.atomicReference.set(this.layout);
            this.layout = null;
            this.mTextPaint = new TextPaint((Paint)this.mTextPaint);
        }
        this.hasBeenMeasured = false;
    }

    private boolean warmUpTextLayoutCache(Layout layout2) {
        boolean result;
        try {
            layout2.draw(DUMMY_CANVAS);
            result = true;
        }
        catch (Exception e) {
            WXLogUtils.eTag(TAG, e);
            result = false;
        }
        return result;
    }

    @Override
    public void destroy() {
        if (WXEnvironment.getApplication() != null && this.mTypefaceObserver != null) {
            WXLogUtils.d("WXText", "Unregister the typeface observer");
            LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).unregisterReceiver(this.mTypefaceObserver);
            this.mTypefaceObserver = null;
        }
        super.destroy();
    }

    private void registerTypefaceObserverIfNeed(String desiredFontFamily) {
        if (TextUtils.isEmpty((CharSequence)desiredFontFamily)) {
            return;
        }
        if (WXEnvironment.getApplication() == null) {
            WXLogUtils.w("WXText", "ApplicationContent is null on register typeface observer");
            return;
        }
        this.mFontFamily = desiredFontFamily;
        if (this.mTypefaceObserver != null) {
            return;
        }
        this.mTypefaceObserver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String fontFamily = intent.getStringExtra("fontFamily");
                if (!WXTextDomObject.this.mFontFamily.equals(fontFamily)) {
                    return;
                }
                if (WXTextDomObject.this.isDestroy() || WXTextDomObject.this.getDomContext() == null) {
                    return;
                }
                DOMActionContext domActionContext = WXSDKManager.getInstance().getWXDomManager().getDomContext(WXTextDomObject.this.getDomContext().getInstanceId());
                if (domActionContext == null) {
                    return;
                }
                WXDomObject domObject = domActionContext.getDomByRef(WXTextDomObject.this.getRef());
                if (domObject == null) {
                    return;
                }
                domObject.markDirty();
                domActionContext.markDirty();
                WXSDKManager.getInstance().getWXDomManager().sendEmptyMessageDelayed(252, 2L);
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("WXText", "Font family " + fontFamily + " is available");
                }
            }
        };
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("WXText", "Font family register " + desiredFontFamily + " is available" + this.getRef());
        }
        LocalBroadcastManager.getInstance((Context)WXEnvironment.getApplication()).registerReceiver(this.mTypefaceObserver, new IntentFilter("type_face_available"));
    }

    private static class SetSpanOperation {
        protected final int start;
        protected final int end;
        protected final int flag;
        protected final Object what;

        SetSpanOperation(int start, int end, Object what) {
            this(start, end, what, 17);
        }

        SetSpanOperation(int start, int end, Object what, int flag) {
            this.start = start;
            this.end = end;
            this.what = what;
            this.flag = flag;
        }

        public void execute(Spannable sb) {
            sb.setSpan(this.what, this.start, this.end, this.flag);
        }
    }
}

