/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXValidateProcessor;
import com.taobao.weex.dom.DomContext;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObjectFactory;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.dom.transition.WXTransition;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class WXDomObject
extends CSSNode
implements Cloneable,
ImmutableDomObject {
    public static final String CHILDREN = "children";
    public static final String TYPE = "type";
    public static final String TAG = WXDomObject.class.getSimpleName();
    public static final String ROOT = "_root";
    @Deprecated
    public static final String TRANSFORM = "transform";
    @Deprecated
    public static final String TRANSFORM_ORIGIN = "transformOrigin";
    static final WXDomObject DESTROYED = new WXDomObject();
    private AtomicBoolean sDestroy = new AtomicBoolean();
    private int mViewPortWidth = 750;
    private DomContext mDomContext;
    String mRef = "_root";
    String mType = "div";
    WXStyle mStyles;
    WXAttr mAttributes;
    WXEvent mEvents;
    private WXTransition transition;
    private List<WXDomObject> mDomChildren;
    @Deprecated
    public WXDomObject parent;
    private ArrayList<String> fixedStyleRefs;
    private boolean mYoung = false;
    public long mDomThreadNanos;
    public long mDomThreadTimestamp;
    private boolean cloneThis = false;
    private static final Set<String> dirtyStyle;

    public void traverseTree(Consumer ... consumers) {
        long startNanos = System.nanoTime();
        if (consumers == null) {
            return;
        }
        for (Consumer consumer : consumers) {
            consumer.accept(this);
        }
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            WXDomObject child = this.getChild(i);
            child.traverseTree(consumers);
        }
        this.mDomThreadNanos += System.nanoTime() - startNanos;
    }

    public void traverseUpdateTree(Consumer ... consumers) {
        if (consumers == null) {
            return;
        }
        if (!this.hasUpdate()) {
            return;
        }
        for (Consumer consumer : consumers) {
            consumer.accept(this);
        }
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            WXDomObject child = this.getChild(i);
            child.traverseTree(consumers);
        }
    }

    public int getViewPortWidth() {
        return this.mViewPortWidth;
    }

    public void setViewPortWidth(int mViewPortWidth) {
        this.mViewPortWidth = mViewPortWidth;
    }

    @Override
    public String getRef() {
        return this.mRef;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    @Override
    @NonNull
    public WXStyle getStyles() {
        if (this.mStyles == null) {
            this.mStyles = new WXStyle();
        }
        return this.mStyles;
    }

    @Override
    @NonNull
    public WXAttr getAttrs() {
        if (this.mAttributes == null) {
            this.mAttributes = new WXAttr();
        }
        return this.mAttributes;
    }

    @Override
    @NonNull
    public WXEvent getEvents() {
        if (this.mEvents == null) {
            this.mEvents = new WXEvent();
        }
        return this.mEvents;
    }

    public WXTransition getTransition() {
        return this.transition;
    }

    @NonNull
    public DomContext getDomContext() {
        return this.mDomContext;
    }

    public void clearEvents() {
        if (this.mEvents != null) {
            this.mEvents.clear();
        }
    }

    public static void prepareRoot(WXDomObject domObj, float defaultHeight, float defaultWidth) {
        domObj.mRef = ROOT;
        WXStyle domStyles = domObj.getStyles();
        HashMap<String, Object> style = new HashMap<String, Object>(5);
        if (!domStyles.containsKey("flexDirection")) {
            style.put("flexDirection", "column");
        }
        style.put("defaultWidth", Float.valueOf(defaultWidth));
        style.put("defaultHeight", Float.valueOf(defaultHeight));
        domObj.updateStyle(style);
    }

    protected final void copyFields(WXDomObject dest) {
        dest.cssstyle.copy(this.cssstyle);
        dest.mRef = this.mRef;
        dest.mType = this.mType;
        dest.mStyles = this.mStyles == null ? null : this.mStyles.clone();
        dest.mAttributes = this.mAttributes == null ? null : this.mAttributes.clone();
        dest.mEvents = this.mEvents == null ? null : this.mEvents.clone();
        dest.csslayout.copy(this.csslayout);
    }

    public void parseFromJson(JSONObject map) {
        Object event;
        Object attr;
        String type;
        if (map == null || map.size() <= 0) {
            return;
        }
        this.mType = type = (String)map.get((Object)TYPE);
        this.mRef = (String)map.get((Object)"ref");
        Object style = map.get((Object)"style");
        if (style != null && style instanceof JSONObject) {
            WXStyle styles;
            this.mStyles = styles = new WXStyle((Map<String, Object>)((JSONObject)style), false);
            this.transition = WXTransition.fromMap(styles, this);
        }
        if ((attr = map.get((Object)"attr")) != null && attr instanceof JSONObject) {
            WXAttr attrs;
            this.mAttributes = attrs = new WXAttr((Map<String, Object>)((JSONObject)attr));
        }
        if ((event = map.get((Object)"event")) != null && event instanceof JSONArray) {
            WXEvent events = new WXEvent();
            JSONArray eventArray = (JSONArray)event;
            int count = eventArray.size();
            for (int i = 0; i < count; ++i) {
                Object value = eventArray.get(i);
                events.addEvent(value);
            }
            this.mEvents = events;
        }
    }

    public void layoutBefore() {
    }

    public void layoutAfter() {
    }

    public final boolean hasUpdate() {
        return this.hasNewLayout() || this.isDirty();
    }

    void young() {
        this.mYoung = true;
    }

    void old() {
        this.mYoung = false;
    }

    boolean isYoung() {
        return this.mYoung;
    }

    public final void markUpdateSeen() {
        if (this.hasNewLayout()) {
            this.markLayoutSeen();
        }
    }

    @Override
    public void setStyleHeight(float height) {
        if (this.getAttrs().containsKey("overflowHiddenHeight")) {
            super.setStyleHeight(height);
            super.setMaxHeight(height);
        } else {
            super.setStyleHeight(height);
        }
    }

    @Override
    public void setStyleWidth(float width) {
        if (this.getAttrs().containsKey("overflowHiddenWidth")) {
            super.setStyleWidth(width);
            super.setMaxWidth(width);
        } else {
            super.setStyleWidth(width);
        }
    }

    @Override
    public boolean isFixed() {
        return this.mStyles == null ? false : this.mStyles.isFixed();
    }

    public boolean canRecycled() {
        return this.mAttributes == null ? false : this.mAttributes.canRecycled();
    }

    @Override
    public Object getExtra() {
        return null;
    }

    public void remove(WXDomObject child) {
        if (child == null || this.mDomChildren == null || this.sDestroy.get()) {
            return;
        }
        int index = this.mDomChildren.indexOf(child);
        this.removeFromDom(child);
        if (index != -1) {
            super.removeChildAt(index);
        }
    }

    public void removeFromDom(WXDomObject child) {
        if (child == null || this.mDomChildren == null || this.sDestroy.get()) {
            return;
        }
        int index = this.mDomChildren.indexOf(child);
        if (index == -1) {
            WXLogUtils.e("[WXDomObject] remove function error");
            return;
        }
        this.mDomChildren.remove((int)index).parent = null;
    }

    public int index(WXDomObject child) {
        if (child == null || this.mDomChildren == null || this.sDestroy.get()) {
            return -1;
        }
        return this.mDomChildren.indexOf(child);
    }

    public void add(WXDomObject child, int index) {
        int count;
        if (child == null || index < -1 || this.sDestroy.get()) {
            return;
        }
        if (this.mDomChildren == null) {
            this.mDomChildren = new ArrayList<WXDomObject>();
        }
        int n = index = index >= (count = this.mDomChildren.size()) ? -1 : index;
        if (index == -1) {
            this.mDomChildren.add(child);
            super.addChildAt(child, super.getChildCount());
        } else {
            this.mDomChildren.add(index, child);
            super.addChildAt(child, index);
        }
        child.parent = this;
    }

    @Deprecated
    public void add2Dom(WXDomObject child, int index) {
        if (child == null || index < -1 || this.sDestroy.get()) {
            return;
        }
        int count = super.getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            super.addChildAt(child, super.getChildCount());
        } else {
            super.addChildAt(child, index);
        }
        child.parent = this;
    }

    public WXDomObject getChild(int index) {
        if (this.mDomChildren == null || this.sDestroy.get()) {
            return null;
        }
        return this.mDomChildren.get(index);
    }

    public void addEvent(String e) {
        if (TextUtils.isEmpty((CharSequence)e)) {
            return;
        }
        if (this.mEvents == null) {
            this.mEvents = new WXEvent();
        }
        if (this.containsEvent(e)) {
            return;
        }
        this.mEvents.add(e);
    }

    public boolean containsEvent(String e) {
        if (this.mEvents == null) {
            return false;
        }
        return this.mEvents.contains(e);
    }

    public void removeEvent(String e) {
        if (TextUtils.isEmpty((CharSequence)e)) {
            return;
        }
        if (this.mEvents == null) {
            return;
        }
        this.mEvents.remove(e);
    }

    public void updateAttr(Map<String, Object> updates) {
        if (!WXDomObject.diffUpdates(updates, this.getAttrs())) {
            return;
        }
        if (this.mAttributes == null) {
            this.mAttributes = new WXAttr();
        }
        this.mAttributes.skipFilterPutAll(updates);
        if (this.hasNewLayout()) {
            this.markUpdateSeen();
        }
        if (WXDomObject.shouldDirty(updates)) {
            super.dirty();
        }
    }

    public void updateStyle(Map<String, Object> styles) {
        this.updateStyle(styles, false);
    }

    public void updateStyle(Map<String, Object> updates, boolean byPesudo) {
        if (this.transition != null) {
            this.transition.updateTranstionParams(updates);
            if (this.transition.hasTransitionProperty(updates)) {
                this.transition.startTransition(updates);
            }
        }
        if (!WXDomObject.diffUpdates(updates, this.getStyles())) {
            return;
        }
        if (this.mStyles == null) {
            this.mStyles = new WXStyle();
        }
        this.mStyles.putAll(updates, byPesudo);
        if (this.transition == null) {
            this.transition = WXTransition.fromMap(this.mStyles, this);
        }
        if (WXDomObject.shouldDirty(updates)) {
            super.dirty();
        }
    }

    public void applyStyle(Map<String, Object> styles) {
        this.applyStyleToNode(styles);
    }

    void applyStyleToNode() {
        this.applyStyleToNode(this.getStyles());
    }

    void applyStyleToNode(Map<String, Object> updates) {
        if (updates.size() == 0) {
            return;
        }
        WXStyle stylesMap = this.getStyles();
        int vp = this.getViewPortWidth();
        if (!stylesMap.isEmpty()) {
            for (Map.Entry<String, Object> item : updates.entrySet()) {
                switch (item.getKey()) {
                    case "alignItems": {
                        this.setAlignItems(stylesMap.getAlignItems());
                        break;
                    }
                    case "alignSelf": {
                        this.setAlignSelf(stylesMap.getAlignSelf());
                        break;
                    }
                    case "flex": {
                        this.setFlex(stylesMap.getFlex());
                        break;
                    }
                    case "flexDirection": {
                        this.setFlexDirection(stylesMap.getFlexDirection());
                        break;
                    }
                    case "justifyContent": {
                        this.setJustifyContent(stylesMap.getJustifyContent());
                        break;
                    }
                    case "flexWrap": {
                        this.setWrap(stylesMap.getCSSWrap());
                        break;
                    }
                    case "minWidth": {
                        this.setMinWidth(WXViewUtils.getRealPxByWidth(stylesMap.getMinWidth(vp), vp));
                        break;
                    }
                    case "minHeight": {
                        this.setMinHeight(WXViewUtils.getRealPxByWidth(stylesMap.getMinHeight(vp), vp));
                        break;
                    }
                    case "maxWidth": {
                        this.setMaxWidth(WXViewUtils.getRealPxByWidth(stylesMap.getMaxWidth(vp), vp));
                        break;
                    }
                    case "maxHeight": {
                        this.setMaxHeight(WXViewUtils.getRealPxByWidth(stylesMap.getMaxHeight(vp), vp));
                        break;
                    }
                    case "defaultHeight": 
                    case "height": {
                        this.setStyleHeight(WXViewUtils.getRealPxByWidth(stylesMap.containsKey("height") ? stylesMap.getHeight(vp) : stylesMap.getDefaultHeight(), vp));
                        break;
                    }
                    case "width": 
                    case "defaultWidth": {
                        this.setStyleWidth(WXViewUtils.getRealPxByWidth(stylesMap.containsKey("width") ? stylesMap.getWidth(vp) : stylesMap.getDefaultWidth(), vp));
                        break;
                    }
                    case "position": {
                        this.setPositionType(stylesMap.getPosition());
                        break;
                    }
                    case "left": {
                        this.setPositionLeft(WXViewUtils.getRealPxByWidth(stylesMap.getLeft(vp), vp));
                        break;
                    }
                    case "top": {
                        this.setPositionTop(WXViewUtils.getRealPxByWidth(stylesMap.getTop(vp), vp));
                        break;
                    }
                    case "right": {
                        this.setPositionRight(WXViewUtils.getRealPxByWidth(stylesMap.getRight(vp), vp));
                        break;
                    }
                    case "bottom": {
                        this.setPositionBottom(WXViewUtils.getRealPxByWidth(stylesMap.getBottom(vp), vp));
                        break;
                    }
                    case "margin": {
                        this.setMargin(8, WXViewUtils.getRealPxByWidth(stylesMap.getMargin(vp), vp));
                        break;
                    }
                    case "marginLeft": {
                        this.setMargin(0, WXViewUtils.getRealPxByWidth(stylesMap.getMarginLeft(vp), vp));
                        break;
                    }
                    case "marginTop": {
                        this.setMargin(1, WXViewUtils.getRealPxByWidth(stylesMap.getMarginTop(vp), vp));
                        break;
                    }
                    case "marginRight": {
                        this.setMargin(2, WXViewUtils.getRealPxByWidth(stylesMap.getMarginRight(vp), vp));
                        break;
                    }
                    case "marginBottom": {
                        this.setMargin(3, WXViewUtils.getRealPxByWidth(stylesMap.getMarginBottom(vp), vp));
                        break;
                    }
                    case "borderWidth": {
                        this.setBorder(8, WXViewUtils.getRealPxByWidth(stylesMap.getBorderWidth(vp), vp));
                        break;
                    }
                    case "borderTopWidth": {
                        this.setBorder(1, WXViewUtils.getRealPxByWidth(stylesMap.getBorderTopWidth(vp), vp));
                        break;
                    }
                    case "borderRightWidth": {
                        this.setBorder(2, WXViewUtils.getRealPxByWidth(stylesMap.getBorderRightWidth(vp), vp));
                        break;
                    }
                    case "borderBottomWidth": {
                        this.setBorder(3, WXViewUtils.getRealPxByWidth(stylesMap.getBorderBottomWidth(vp), vp));
                        break;
                    }
                    case "borderLeftWidth": {
                        this.setBorder(0, WXViewUtils.getRealPxByWidth(stylesMap.getBorderLeftWidth(vp), vp));
                        break;
                    }
                    case "padding": {
                        this.setPadding(8, WXViewUtils.getRealPxByWidth(stylesMap.getPadding(vp), vp));
                        break;
                    }
                    case "paddingLeft": {
                        this.setPadding(0, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingLeft(vp), vp));
                        break;
                    }
                    case "paddingTop": {
                        this.setPadding(1, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingTop(vp), vp));
                        break;
                    }
                    case "paddingRight": {
                        this.setPadding(2, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingRight(vp), vp));
                        break;
                    }
                    case "paddingBottom": {
                        this.setPadding(3, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingBottom(vp), vp));
                    }
                }
            }
        }
    }

    public int childCount() {
        return this.mDomChildren == null ? 0 : this.mDomChildren.size();
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    public boolean isVisible() {
        return super.isShow();
    }

    public WXDomObject clone() {
        WXDomObject dom;
        block4: {
            if (this.sDestroy.get()) {
                return null;
            }
            if (this.isCloneThis()) {
                return this;
            }
            dom = null;
            try {
                dom = WXDomObjectFactory.newInstance(this.mType);
                this.copyFields(dom);
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e("WXDomObject clone error: ", e);
            }
        }
        return dom;
    }

    public boolean isDestroy() {
        if (this.sDestroy == null) {
            return true;
        }
        return this.sDestroy.get();
    }

    public void destroy() {
        this.sDestroy.set(true);
        if (this.mStyles != null) {
            this.mStyles.clear();
        }
        if (this.mAttributes != null) {
            this.mAttributes.clear();
        }
        if (this.mEvents != null) {
            this.mEvents.clear();
        }
        if (this.mDomChildren != null) {
            int count = this.mDomChildren.size();
            for (int i = 0; i < count; ++i) {
                this.mDomChildren.get(i).destroy();
            }
            this.mDomChildren.clear();
        }
        this.mDomContext = null;
    }

    protected Map<String, String> getDefaultStyle() {
        return null;
    }

    public ArrayList<String> getFixedStyleRefs() {
        return this.fixedStyleRefs;
    }

    public void add2FixedDomList(String ref) {
        if (this.fixedStyleRefs == null) {
            this.fixedStyleRefs = new ArrayList();
        }
        this.fixedStyleRefs.add(ref);
    }

    public String dumpDomTree() {
        return this.mRef + ": " + this.toString();
    }

    @Nullable
    public static WXDomObject parse(JSONObject json, WXSDKInstance wxsdkInstance) {
        return WXDomObject.parse(json, wxsdkInstance, null);
    }

    @Nullable
    public static WXDomObject parse(JSONObject json, WXSDKInstance wxsdkInstance, WXDomObject parentDomObject) {
        WXValidateProcessor processor;
        long startNanos = System.nanoTime();
        long timestamp = System.currentTimeMillis();
        if (json == null || json.size() <= 0) {
            return null;
        }
        String type = (String)json.get((Object)TYPE);
        if (wxsdkInstance.isNeedValidate() && (processor = WXSDKManager.getInstance().getValidateProcessor()) != null) {
            WXValidateProcessor.WXComponentValidateResult result = processor.onComponentValidate(wxsdkInstance, type, parentDomObject);
            if (result != null && !result.isSuccess) {
                type = TextUtils.isEmpty((CharSequence)result.replacedComponent) ? "div" : result.replacedComponent;
                json.put(TYPE, (Object)type);
                if (result.validateInfo != null) {
                    String tag = "[WXDomObject]onComponentValidate failure. >>> " + result.validateInfo.toJSONString();
                    WXLogUtils.e(tag);
                }
            } else if (result == null) {
                return null;
            }
        }
        WXDomObject domObject = WXDomObjectFactory.newInstance(type);
        domObject.setViewPortWidth(wxsdkInstance.getInstanceViewPortWidth());
        if (domObject == null) {
            return null;
        }
        domObject.parseFromJson(json);
        domObject.mDomContext = wxsdkInstance;
        domObject.parent = parentDomObject;
        Object children = json.get((Object)CHILDREN);
        if (children != null && children instanceof JSONArray) {
            JSONArray childrenArray = (JSONArray)children;
            int count = childrenArray.size();
            for (int i = 0; i < count; ++i) {
                domObject.add(WXDomObject.parse(childrenArray.getJSONObject(i), wxsdkInstance, domObject), -1);
            }
        }
        domObject.mDomThreadNanos = System.nanoTime() - startNanos;
        domObject.mDomThreadTimestamp = timestamp;
        return domObject;
    }

    public boolean isCloneThis() {
        return this.cloneThis;
    }

    public void setCloneThis(boolean cloneThis) {
        this.cloneThis = cloneThis;
    }

    private static boolean diffUpdates(Map<String, Object> updates, Map<String, Object> source) {
        if (updates == null) {
            return false;
        }
        Set<Map.Entry<String, Object>> entries = updates.entrySet();
        Iterator<Map.Entry<String, Object>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            Object old = source.get(entry.getKey());
            if (entry.getValue() == old) {
                it.remove();
                continue;
            }
            if (old == null || !old.equals(entry.getValue())) continue;
            it.remove();
        }
        return updates.size() > 0;
    }

    private static boolean shouldDirty(Map<String, Object> updates) {
        if (updates.size() > 0) {
            return true;
        }
        Set<Map.Entry<String, Object>> entries = updates.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (!dirtyStyle.contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public static void addDirtyKey(String key) {
        dirtyStyle.add(key);
    }

    static {
        WXDomObject.DESTROYED.mRef = "_destroyed";
        dirtyStyle = new HashSet<String>();
        dirtyStyle.add("defaultHeight");
        dirtyStyle.add("defaultWidth");
        dirtyStyle.add("width");
        dirtyStyle.add("minWidth");
        dirtyStyle.add("maxWidth");
        dirtyStyle.add("height");
        dirtyStyle.add("minHeight");
        dirtyStyle.add("maxHeight");
        dirtyStyle.add("alignItems");
        dirtyStyle.add("alignSelf");
        dirtyStyle.add("flex");
        dirtyStyle.add("flexDirection");
        dirtyStyle.add("justifyContent");
        dirtyStyle.add("flexWrap");
        dirtyStyle.add("margin");
        dirtyStyle.add("marginTop");
        dirtyStyle.add("marginLeft");
        dirtyStyle.add("marginRight");
        dirtyStyle.add("marginBottom");
        dirtyStyle.add("padding");
        dirtyStyle.add("paddingTop");
        dirtyStyle.add("paddingLeft");
        dirtyStyle.add("paddingRight");
        dirtyStyle.add("paddingBottom");
        dirtyStyle.add("left");
        dirtyStyle.add("top");
        dirtyStyle.add("right");
        dirtyStyle.add("bottom");
        dirtyStyle.add("borderWidth");
        dirtyStyle.add("borderTopWidth");
        dirtyStyle.add("borderRightWidth");
        dirtyStyle.add("borderBottomWidth");
        dirtyStyle.add("borderLeftWidth");
        dirtyStyle.add("position");
        dirtyStyle.add("textDecoration");
        dirtyStyle.add("textAlign");
        dirtyStyle.add("fontWeight");
        dirtyStyle.add("fontStyle");
        dirtyStyle.add("fontSize");
        dirtyStyle.add("color");
        dirtyStyle.add("lines");
        dirtyStyle.add("fontFamily");
        dirtyStyle.add("textOverflow");
        dirtyStyle.add("ellipsis");
        dirtyStyle.add("lineHeight");
        dirtyStyle.add("value");
        dirtyStyle.add("overflow");
        dirtyStyle.add("singleline");
        dirtyStyle.add("maxLength");
        dirtyStyle.add("maxlength");
        dirtyStyle.add("rows");
        dirtyStyle.add("visibility");
        dirtyStyle.add("itemSize");
        dirtyStyle.add("display");
        dirtyStyle.add("resize");
        dirtyStyle.add("fontFace");
        dirtyStyle.add("max");
        dirtyStyle.add("min");
        dirtyStyle.add("fontFace");
    }

    public static interface Consumer {
        public void accept(WXDomObject var1);
    }
}

