/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXRenderErrorCode;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.bridge.EventResult;
import com.taobao.weex.bridge.WXBridge;
import com.taobao.weex.bridge.WXHashMap;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.bridge.WXServiceManager;
import com.taobao.weex.bridge.WXValidateProcessor;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.common.IWXDebugProxy;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.WXDomModule;
import com.taobao.weex.dom.action.Actions;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import com.taobao.weex.utils.batch.BactchExecutor;
import com.taobao.weex.utils.batch.Interceptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WXBridgeManager
implements Handler.Callback,
BactchExecutor {
    public static final String METHOD_CREATE_INSTANCE = "createInstance";
    public static final String METHOD_DESTROY_INSTANCE = "destroyInstance";
    public static final String METHOD_CALL_JS = "callJS";
    public static final String METHOD_SET_TIMEOUT = "setTimeoutCallback";
    public static final String METHOD_REGISTER_MODULES = "registerModules";
    public static final String METHOD_REGISTER_COMPONENTS = "registerComponents";
    public static final String METHOD_FIRE_EVENT = "fireEvent";
    public static final String METHD_FIRE_EVENT_SYNC = "fireEventSync";
    public static final String METHD_COMPONENT_HOOK_SYNC = "componentHook";
    public static final String METHOD_CALLBACK = "callback";
    public static final String METHOD_REFRESH_INSTANCE = "refreshInstance";
    public static final String METHOD_NOTIFY_TRIM_MEMORY = "notifyTrimMemory";
    public static final String METHOD_NOTIFY_SERIALIZE_CODE_CACHE = "notifySerializeCodeCache";
    public static final String KEY_METHOD = "method";
    public static final String KEY_ARGS = "args";
    public static final String COMPONENT = "component";
    public static final String REF = "ref";
    public static final String MODULE = "module";
    public static final String METHOD = "method";
    public static final String KEY_PARAMS = "params";
    public static final String ARGS = "args";
    public static final String OPTIONS = "options";
    public static final String INITLOGFILE = "/jsserver_start.log";
    private static final String NON_CALLBACK = "-1";
    private static final String UNDEFINED = "undefined";
    private static final int INIT_FRAMEWORK_OK = 1;
    private static final int CRASHREINIT = 50;
    static volatile WXBridgeManager mBridgeManager;
    private static long LOW_MEM_VALUE;
    private static volatile int reInitCount;
    private static String crashUrl;
    private static long lastCrashTime;
    private static volatile boolean mInit;
    private static String globalConfig;
    private static String GLOBAL_CONFIG_KEY;
    Handler mJSHandler;
    private WXHashMap<String, ArrayList<WXHashMap<String, Object>>> mNextTickTasks = new WXHashMap();
    private WXThread mJSThread;
    private IWXBridge mWXBridge;
    private IWXDebugProxy mWxDebugProxy;
    private boolean mMock = false;
    private List<Map<String, Object>> mRegisterComponentFailList = new ArrayList<Map<String, Object>>(8);
    private List<Map<String, Object>> mRegisterModuleFailList = new ArrayList<Map<String, Object>>(8);
    private List<String> mRegisterServiceFailList = new ArrayList<String>(8);
    private List<String> mDestroyedInstanceId = new ArrayList<String>();
    private StringBuilder mLodBuilder = new StringBuilder(50);
    private Interceptor mInterceptor;
    private WXParams mInitParams;

    private WXBridgeManager() {
        this.initWXBridge(WXEnvironment.sRemoteDebugMode);
        this.mJSThread = new WXThread("WeexJSBridgeThread", this);
        this.mJSHandler = this.mJSThread.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXBridgeManager getInstance() {
        if (mBridgeManager != null) return mBridgeManager;
        Class<WXBridgeManager> clazz = WXBridgeManager.class;
        synchronized (WXBridgeManager.class) {
            if (mBridgeManager != null) return mBridgeManager;
            mBridgeManager = new WXBridgeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mBridgeManager;
        }
    }

    private boolean isJSFrameworkInit() {
        return mInit;
    }

    private void setJSFrameworkInit(boolean init) {
        mInit = init;
    }

    private void initWXBridge(boolean remoteDebug) {
        if (remoteDebug && WXEnvironment.isApkDebugable()) {
            WXEnvironment.sDebugServerConnectable = true;
        }
        if (this.mWxDebugProxy != null) {
            this.mWxDebugProxy.stop(false);
        }
        if (WXEnvironment.sDebugServerConnectable && (WXEnvironment.isApkDebugable() || WXEnvironment.sForceEnableDevTool)) {
            if (WXEnvironment.getApplication() != null) {
                try {
                    Constructor<?> constructor;
                    Class<?> clazz = Class.forName("com.taobao.weex.devtools.debug.DebugServerProxy");
                    if (clazz != null && (constructor = clazz.getConstructor(Context.class, WXBridgeManager.class)) != null) {
                        this.mWxDebugProxy = (IWXDebugProxy)constructor.newInstance(WXEnvironment.getApplication(), this);
                        if (this.mWxDebugProxy != null) {
                            this.mWxDebugProxy.start();
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                WXServiceManager.execAllCacheJsService();
            } else {
                WXLogUtils.e("WXBridgeManager", "WXEnvironment.sApplication is null, skip init Inspector");
                WXLogUtils.w("WXBridgeManager", new Throwable("WXEnvironment.sApplication is null when init Inspector"));
            }
        }
        this.mWXBridge = remoteDebug && this.mWxDebugProxy != null ? this.mWxDebugProxy.getWXBridge() : new WXBridge();
    }

    public void stopRemoteDebug() {
        if (this.mWxDebugProxy != null) {
            this.mWxDebugProxy.stop(true);
        }
    }

    public Object callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args) {
        return this.callModuleMethod(instanceId, moduleStr, methodStr, args, null);
    }

    public Object callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args, JSONObject options) {
        WXSDKInstance wxsdkInstance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (wxsdkInstance == null) {
            return null;
        }
        if (wxsdkInstance.isNeedValidate() && WXSDKManager.getInstance().getValidateProcessor() != null) {
            WXValidateProcessor.WXModuleValidateResult validateResult = WXSDKManager.getInstance().getValidateProcessor().onModuleValidate(wxsdkInstance, moduleStr, methodStr, args, options);
            if (validateResult == null) {
                return null;
            }
            if (validateResult.isSuccess) {
                return WXModuleManager.callModuleMethod(instanceId, moduleStr, methodStr, args);
            }
            JSONObject validateInfo = validateResult.validateInfo;
            if (validateInfo != null) {
                WXLogUtils.e("[WXBridgeManager] module validate fail. >>> " + validateInfo.toJSONString());
            }
            return validateInfo;
        }
        return WXModuleManager.callModuleMethod(instanceId, moduleStr, methodStr, args);
    }

    public void restart() {
        this.setJSFrameworkInit(false);
        this.initWXBridge(WXEnvironment.sRemoteDebugMode);
    }

    public synchronized void setStackTopInstance(final String instanceId) {
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.mNextTickTasks.setStackTopInstance(instanceId);
            }
        }, instanceId);
    }

    @Override
    public void post(Runnable r) {
        if (this.mInterceptor != null && this.mInterceptor.take(r)) {
            return;
        }
        if (this.mJSHandler == null) {
            return;
        }
        this.mJSHandler.post(WXThread.secure(r));
    }

    @Override
    public void setInterceptor(Interceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    public void post(Runnable r, Object token) {
        if (this.mJSHandler == null) {
            return;
        }
        Message m = Message.obtain((Handler)this.mJSHandler, (Runnable)WXThread.secure(r));
        m.obj = token;
        m.sendToTarget();
    }

    void setTimeout(String callbackId, String time) {
        Message message = Message.obtain();
        message.what = 1;
        TimerInfo timerInfo = new TimerInfo();
        timerInfo.callbackId = callbackId;
        timerInfo.time = (long)Float.parseFloat(time);
        message.obj = timerInfo;
        this.mJSHandler.sendMessageDelayed(message, timerInfo.time);
    }

    public void sendMessageDelayed(Message message, long delayMillis) {
        if (message == null || this.mJSHandler == null || this.mJSThread == null || !this.mJSThread.isWXThreadAlive() || this.mJSThread.getLooper() == null) {
            return;
        }
        this.mJSHandler.sendMessageDelayed(message, delayMillis);
    }

    public void removeMessage(int what, Object obj) {
        if (this.mJSHandler == null || this.mJSThread == null || !this.mJSThread.isWXThreadAlive() || this.mJSThread.getLooper() == null) {
            return;
        }
        this.mJSHandler.removeMessages(what, obj);
    }

    public Object callNativeModule(String instanceId, String module, String method, JSONArray arguments, Object options) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callNativeModule >>>> instanceId:").append(instanceId).append(", module:").append(module).append(", method:").append(method).append(", arguments:").append(arguments);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        try {
            if ("dom".equals(module)) {
                WXDomModule dom = WXModuleManager.getDomModule(instanceId);
                return dom.callDomMethod(method, arguments, new long[0]);
            }
            return this.callModuleMethod(instanceId, module, method, arguments);
        }
        catch (Exception e) {
            String err = "[WXBridgeManager] callNative exception: " + WXLogUtils.getStackTrace(e);
            WXLogUtils.e(err);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callNativeModule", err, null);
            return null;
        }
    }

    public Object callNativeModule(String instanceId, String module, String method, JSONArray arguments, JSONObject options) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callNativeModule >>>> instanceId:").append(instanceId).append(", module:").append(module).append(", method:").append(method).append(", arguments:").append(arguments);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        try {
            if ("dom".equals(module)) {
                WXDomModule dom = WXModuleManager.getDomModule(instanceId);
                if (dom != null) {
                    return dom.callDomMethod(method, arguments, new long[0]);
                }
            } else {
                return this.callModuleMethod(instanceId, module, method, arguments, options);
            }
            WXModuleManager.createDomModule(WXSDKManager.getInstance().getSDKInstance(instanceId));
        }
        catch (Exception e) {
            String err = "[WXBridgeManager] callNative exception: " + WXLogUtils.getStackTrace(e);
            WXLogUtils.e(err);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callNativeModule", err, null);
        }
        return null;
    }

    public Object callNativeComponent(String instanceId, String componentRef, String method, JSONArray arguments, Object options) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callNativeComponent >>>> instanceId:").append(instanceId).append(", componentRef:").append(componentRef).append(", method:").append(method).append(", arguments:").append(arguments);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        try {
            WXDomModule dom = WXModuleManager.getDomModule(instanceId);
            dom.invokeMethod(componentRef, method, arguments);
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callNative exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callNativeComponent", WXLogUtils.getStackTrace(e), null);
        }
        return null;
    }

    public int callNative(String instanceId, JSONArray tasks, String callback) {
        int size;
        if (tasks == null || tasks.isEmpty()) {
            String err = "[WXBridgeManager] callNative: call Native tasks is null";
            WXLogUtils.e(err);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callNative", err + "| INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callNative >>>> instanceId:").append(instanceId).append(", tasks:").append(tasks).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        long start = System.currentTimeMillis();
        long parseNanos = System.nanoTime();
        JSONArray array = tasks;
        parseNanos = System.nanoTime() - parseNanos;
        if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
            WXSDKManager.getInstance().getSDKInstance(instanceId).jsonParseTime(System.currentTimeMillis() - start);
        }
        if ((size = array.size()) > 0) {
            try {
                for (int i = 0; i < size; ++i) {
                    WXDomModule dom;
                    JSONObject task = (JSONObject)array.get(i);
                    if (task == null || WXSDKManager.getInstance().getSDKInstance(instanceId) == null) continue;
                    Object target = task.get((Object)MODULE);
                    if (target != null) {
                        if ("dom".equals(target)) {
                            dom = WXModuleManager.getDomModule(instanceId);
                            dom.callDomMethod(task, parseNanos);
                            continue;
                        }
                        JSONObject optionObj = task.getJSONObject(OPTIONS);
                        this.callModuleMethod(instanceId, (String)target, (String)task.get((Object)"method"), (JSONArray)task.get((Object)"args"), optionObj);
                        continue;
                    }
                    if (task.get((Object)COMPONENT) != null) {
                        dom = WXModuleManager.getDomModule(instanceId);
                        dom.invokeMethod((String)task.get((Object)REF), (String)task.get((Object)"method"), (JSONArray)task.get((Object)"args"));
                        continue;
                    }
                    throw new IllegalArgumentException("unknown callNative");
                }
            }
            catch (Exception e) {
                WXLogUtils.e("[WXBridgeManager] callNative exception: ", e);
                WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callNative", WXLogUtils.getStackTrace(e), null);
            }
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callCreateBody(String instanceId, String tasks, String callback) {
        if (TextUtils.isEmpty((CharSequence)tasks)) {
            WXLogUtils.d("[WXBridgeManager] callCreateBody: call CreateBody tasks is null");
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callCreateBody", "tasks is empty, INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callCreateBody >>>> instanceId:").append(instanceId).append(", tasks:").append(tasks).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                long start = System.currentTimeMillis();
                long nanosTemp = System.nanoTime();
                JSONObject domObject = JSON.parseObject((String)tasks);
                nanosTemp = System.nanoTime() - nanosTemp;
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getCreateBody(domObject);
                domModule.postAction(action, true);
                if (WXTracing.isAvailable() && action instanceof TraceableAction) {
                    ((TraceableAction)((Object)action)).mParseJsonNanos = nanosTemp;
                    ((TraceableAction)((Object)action)).mStartMillis = start;
                    ((TraceableAction)((Object)action)).onStartDomExecute(instanceId, "createBody", "_root", domObject.getString("type"), tasks);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callCreateBody exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callCreateBody", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callUpdateFinish(String instanceId, String callback) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callUpdateFinish >>>> instanceId:").append(instanceId).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getUpdateFinish();
                domModule.postAction(action, false);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callUpdateFinish", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callCreateFinish(String instanceId, String callback) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callCreateFinish >>>> instanceId:").append(instanceId).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getCreateFinish();
                domModule.postAction(action, false);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callCreateFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callUpdateFinish", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callRefreshFinish(String instanceId, String callback) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callRefreshFinish >>>> instanceId:").append(instanceId).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getRefreshFinish();
                domModule.postAction(action, false);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRefreshFinish exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callRefreshFinish", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callUpdateAttrs(String instanceId, String ref, String task, String callback) {
        if (TextUtils.isEmpty((CharSequence)task)) {
            WXLogUtils.e("[WXBridgeManager] callUpdateAttrs: call UpdateAttrs tasks is null");
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callUpdateAttrs", "call UpdateAttrs tasks is null| INSTANCE_RENDERING_ERROR will be set", null);
            return 0;
        }
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callUpdateAttrs >>>> instanceId:").append(instanceId).append(", ref:").append(ref).append(", task:").append(task).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                long start = System.currentTimeMillis();
                long parseNanos = System.nanoTime();
                JSONObject domObject = JSON.parseObject((String)task);
                parseNanos = System.nanoTime() - parseNanos;
                DOMAction action = Actions.getUpdateAttrs(ref, domObject);
                domModule.postAction(action, false);
                if (WXTracing.isAvailable() && action instanceof TraceableAction) {
                    ((TraceableAction)((Object)action)).mStartMillis = start;
                    ((TraceableAction)((Object)action)).mParseJsonNanos = parseNanos;
                    ((TraceableAction)((Object)action)).onStartDomExecute(instanceId, "updateAttrs", domObject.getString(REF), domObject.getString("type"), task);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateAttrs exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callUpdateAttrs", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callUpdateStyle(String instanceId, String ref, String task, String callback) {
        if (TextUtils.isEmpty((CharSequence)task)) {
            WXLogUtils.e("[WXBridgeManager] callUpdateStyle: call UpdateStyle tasks is null");
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callUpdateStyle", "task is empty", null);
            return 0;
        }
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callUpdateStyle >>>> instanceId:").append(instanceId).append(", ref:").append(ref).append(", task:").append(task).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                long start = System.currentTimeMillis();
                long nanosTemp = System.nanoTime();
                JSONObject domObject = JSON.parseObject((String)task);
                nanosTemp = System.nanoTime() - nanosTemp;
                DOMAction action = Actions.getUpdateStyle(ref, domObject, false);
                domModule.postAction(action, false);
                if (WXTracing.isAvailable() && action instanceof TraceableAction) {
                    ((TraceableAction)((Object)action)).mParseJsonNanos = nanosTemp;
                    ((TraceableAction)((Object)action)).mStartMillis = start;
                    ((TraceableAction)((Object)action)).onStartDomExecute(instanceId, "updateStyle", ref, domObject.getString("type"), domObject.toJSONString());
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callUpdateStyle exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callUpdateStyle", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callRemoveElement(String instanceId, String ref, String callback) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callRemoveElement >>>> instanceId:").append(instanceId).append(", ref:").append(ref);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getRemoveElement(ref);
                domModule.postAction(action, false);
                if (WXTracing.isAvailable() && action instanceof TraceableAction) {
                    ((TraceableAction)((Object)action)).onStartDomExecute(instanceId, "removeElement", ref, null, ref);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveElement exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callRemoveElement", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callMoveElement(String instanceId, String ref, String parentref, String index, String callback) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callMoveElement >>>> instanceId:").append(instanceId).append(", parentref:").append(parentref).append(", index:").append(index).append(", ref:").append(ref);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getMoveElement(ref, parentref, Integer.parseInt(index));
                domModule.postAction(action, false);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callMoveElement exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callMoveElement", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callAddEvent(String instanceId, String ref, String event, String callback) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callAddEvent >>>> instanceId:").append(instanceId).append(", ref:").append(ref).append(", event:").append(event);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getAddEvent(ref, event);
                domModule.postAction(action, false);
                if (WXTracing.isAvailable() && action instanceof TraceableAction) {
                    ((TraceableAction)((Object)action)).onStartDomExecute(instanceId, "addEvent", ref, null, event);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callAddEvent exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callAddEvent", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callRemoveEvent(String instanceId, String ref, String event, String callback) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callRemoveEvent >>>> instanceId:").append(instanceId).append(", ref:").append(ref).append(", event:").append(event);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getRemoveEvent(ref, event);
                domModule.postAction(action, false);
                if (WXTracing.isAvailable() && action instanceof TraceableAction) {
                    ((TraceableAction)((Object)action)).onStartDomExecute(instanceId, "removeEvent", ref, null, event);
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callRemoveEvent exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callAddEvent", WXLogUtils.getStackTrace(e), null);
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callAddElement(String instanceId, String ref, JSONObject dom, String index, String callback) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("[WXBridgeManager] callNative::callAddElement >>>> instanceId:").append(instanceId).append(", ref:").append(ref).append(", dom:").append(dom).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
            return -1;
        }
        if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
            long start = System.currentTimeMillis();
            long nanosTemp = System.nanoTime();
            JSONObject domObject = dom;
            nanosTemp = System.nanoTime() - nanosTemp;
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                WXSDKManager.getInstance().getSDKInstance(instanceId).jsonParseTime(System.currentTimeMillis() - start);
            }
            WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
            DOMAction addElementAction = Actions.getAddElement(domObject, ref, Integer.parseInt(index));
            domModule.postAction(addElementAction, false);
            if (WXTracing.isAvailable() && addElementAction instanceof TraceableAction) {
                ((TraceableAction)((Object)addElementAction)).mParseJsonNanos = nanosTemp;
                ((TraceableAction)((Object)addElementAction)).mStartMillis = start;
                ((TraceableAction)((Object)addElementAction)).onStartDomExecute(instanceId, "addElement", domObject.getString(REF), domObject.getString("type"), dom.toString());
            }
        }
        if (UNDEFINED.equals(callback) || NON_CALLBACK.equals(callback)) {
            return 0;
        }
        this.getNextTick(instanceId, callback);
        return 1;
    }

    public int callReportCrashReloadPage(String instanceId, String crashFile) {
        try {
            String url = null;
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                url = instance.getBundleUrl();
            }
            try {
                if (WXEnvironment.getApplication() != null) {
                    crashFile = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath() + crashFile;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.callReportCrash(crashFile, instanceId, url);
            if (reInitCount > 50) {
                return 0;
            }
            ++reInitCount;
            this.setJSFrameworkInit(false);
            this.initScriptsFramework("");
            if (this.mDestroyedInstanceId != null && this.mDestroyedInstanceId.contains(instanceId)) {
                return -1;
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callReportCrashReloadPage exception: ", e);
        }
        try {
            if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
                boolean reloadThisInstance = this.shouReloadCurrentInstance(WXSDKManager.getInstance().getSDKInstance(instanceId).getBundleUrl());
                WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                DOMAction action = Actions.getReloadPage(instanceId, reloadThisInstance);
                domModule.postAction(action, true);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXBridgeManager] callReloadPage exception: ", e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "callReloadPage", WXLogUtils.getStackTrace(e), null);
        }
        return 0;
    }

    public boolean shouReloadCurrentInstance(String aUrl) {
        long time = System.currentTimeMillis();
        if (crashUrl == null || crashUrl != null && !crashUrl.equals(aUrl) || time - lastCrashTime > 15000L) {
            crashUrl = aUrl;
            lastCrashTime = time;
            return true;
        }
        lastCrashTime = time;
        return false;
    }

    public void callReportCrash(String crashFile, final String instanceId, final String url) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = format.format(date);
        final String origin_filename = crashFile + "." + time;
        File oldfile = new File(crashFile);
        File newfile = new File(origin_filename);
        if (oldfile.exists()) {
            oldfile.renameTo(newfile);
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(origin_filename);
                    if (file.exists()) {
                        if (file.length() > 0L) {
                            StringBuilder result = new StringBuilder();
                            try {
                                BufferedReader br = new BufferedReader(new FileReader(origin_filename));
                                String s = null;
                                while ((s = br.readLine()) != null) {
                                    if ("".equals(s)) continue;
                                    result.append(s + "\n");
                                }
                                WXBridgeManager.this.commitJscCrashAlarmMonitor("jsBridge", WXErrorCode.WX_ERR_JSC_CRASH, result.toString(), instanceId, url);
                                br.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            WXLogUtils.e("[WXBridgeManager] callReportCrash crash file is empty");
                        }
                        file.delete();
                    }
                }
                catch (Throwable throwable) {
                    WXLogUtils.e("[WXBridgeManager] callReportCrash exception: ", throwable);
                }
            }
        });
        t.start();
    }

    private void getNextTick(String instanceId, String callback) {
        this.addJSTask(METHOD_CALLBACK, instanceId, callback, "{}");
        this.sendMessage(instanceId, 6);
    }

    public EventResult syncCallJSEventWithResult(String method, String instanceId, List<Object> params, Object ... args) {
        final CountDownLatch waitLatch = new CountDownLatch(1);
        EventResult callback = new EventResult(){

            @Override
            public void onCallback(Object result) {
                super.onCallback(result);
                waitLatch.countDown();
            }
        };
        try {
            this.asyncCallJSEventWithResult(callback, method, instanceId, params, args);
            waitLatch.await(100L, TimeUnit.MILLISECONDS);
            return callback;
        }
        catch (Exception e) {
            WXLogUtils.e("syncCallJSEventWithResult", e);
            return callback;
        }
    }

    public void asyncCallJSEventVoidResult(final String method, final String instanceId, final List<Object> params, final Object ... args) {
        this.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (args == null || args.length == 0) {
                        return;
                    }
                    ArrayList<Object> argsList = new ArrayList<Object>();
                    for (Object arg : args) {
                        argsList.add(arg);
                    }
                    if (params != null) {
                        ArrayMap map = new ArrayMap(4);
                        map.put((Object)WXBridgeManager.KEY_PARAMS, (Object)params);
                        argsList.add(map);
                    }
                    WXHashMap<String, Object> task = new WXHashMap<String, Object>();
                    task.put("method", method);
                    task.put("args", argsList);
                    Object[] tasks = new Object[]{task};
                    WXJSObject[] jsArgs = new WXJSObject[]{new WXJSObject(2, instanceId), WXJsonUtils.wsonWXJSObject(tasks)};
                    WXBridgeManager.this.invokeExecJS(String.valueOf(instanceId), null, WXBridgeManager.METHOD_CALL_JS, jsArgs, true);
                    jsArgs[0] = null;
                    jsArgs = null;
                }
                catch (Exception e) {
                    WXLogUtils.e("asyncCallJSEventVoidResult", e);
                }
            }
        });
    }

    private void asyncCallJSEventWithResult(final EventResult eventCallback, final String method, final String instanceId, final List<Object> params, final Object ... args) {
        this.post(new Runnable(){

            @Override
            public void run() {
                Object result = null;
                try {
                    JSONArray arrayResult;
                    if (args == null || args.length == 0) {
                        return;
                    }
                    ArrayList<Object> argsList = new ArrayList<Object>();
                    for (Object arg : args) {
                        argsList.add(arg);
                    }
                    if (params != null) {
                        ArrayMap map = new ArrayMap(4);
                        map.put((Object)WXBridgeManager.KEY_PARAMS, (Object)params);
                        argsList.add(map);
                    }
                    WXHashMap<String, Object> task = new WXHashMap<String, Object>();
                    task.put("method", method);
                    task.put("args", argsList);
                    Object[] tasks = new Object[]{task};
                    WXJSObject[] jsArgs = new WXJSObject[]{new WXJSObject(2, instanceId), WXJsonUtils.wsonWXJSObject(tasks)};
                    byte[] taskResult = WXBridgeManager.this.invokeExecJSWithResult(String.valueOf(instanceId), null, WXBridgeManager.METHOD_CALL_JS, jsArgs, true);
                    if (eventCallback == null) {
                        return;
                    }
                    if (taskResult != null && (arrayResult = (JSONArray)WXJsonUtils.parseWson(taskResult)) != null && arrayResult.size() > 0) {
                        result = arrayResult.get(0);
                    }
                    eventCallback.onCallback(result);
                    jsArgs[0] = null;
                    taskResult = null;
                    jsArgs = null;
                }
                catch (Exception e) {
                    WXLogUtils.e("asyncCallJSEventWithResult", e);
                }
            }
        });
    }

    private void addJSEventTask(final String method, final String instanceId, final List<Object> params, final Object ... args) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (args == null || args.length == 0) {
                    return;
                }
                ArrayList<Object> argsList = new ArrayList<Object>();
                for (Object arg : args) {
                    argsList.add(arg);
                }
                if (params != null) {
                    ArrayMap map = new ArrayMap(4);
                    map.put((Object)WXBridgeManager.KEY_PARAMS, (Object)params);
                    argsList.add(map);
                }
                WXHashMap<String, Object> task = new WXHashMap<String, Object>();
                task.put("method", method);
                task.put("args", argsList);
                if (WXBridgeManager.this.mNextTickTasks.get(instanceId) == null) {
                    ArrayList<WXHashMap<String, Object>> list = new ArrayList<WXHashMap<String, Object>>();
                    list.add(task);
                    WXBridgeManager.this.mNextTickTasks.put(instanceId, list);
                } else {
                    ((ArrayList)WXBridgeManager.this.mNextTickTasks.get(instanceId)).add(task);
                }
            }
        });
    }

    private void addJSTask(String method, String instanceId, Object ... args) {
        this.addJSEventTask(method, instanceId, null, args);
    }

    private void sendMessage(String instanceId, int what) {
        Message msg = Message.obtain((Handler)this.mJSHandler);
        msg.obj = instanceId;
        msg.what = what;
        msg.sendToTarget();
    }

    public synchronized void initScriptsFramework(String framework) {
        Message msg = this.mJSHandler.obtainMessage();
        msg.obj = framework;
        msg.what = 7;
        msg.setTarget(this.mJSHandler);
        msg.sendToTarget();
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> data) {
        this.fireEvent(instanceId, ref, type, data, null);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        this.fireEventOnNode(instanceId, ref, type, data, domChanges);
    }

    public void fireEventOnNode(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        this.fireEventOnNode(instanceId, ref, type, data, domChanges, null, null);
    }

    public void fireEventOnNode(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges, List<Object> params) {
        this.fireEventOnNode(instanceId, ref, type, data, domChanges, params, null);
    }

    public void fireEventOnNode(String instanceId, String ref, String type, Map<String, Object> data, Map<String, Object> domChanges, List<Object> params, EventResult callback) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)type) || this.mJSHandler == null) {
            return;
        }
        if (!this.checkMainThread()) {
            throw new WXRuntimeException("fireEvent must be called by main thread");
        }
        if (callback == null) {
            this.addJSEventTask(METHOD_FIRE_EVENT, instanceId, params, ref, type, data, domChanges);
            this.sendMessage(instanceId, 6);
        } else {
            this.asyncCallJSEventWithResult(callback, METHD_FIRE_EVENT_SYNC, instanceId, params, ref, type, data, domChanges);
        }
    }

    private boolean checkMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    @Deprecated
    public void callback(String instanceId, String callback, String data) {
        this.callback(instanceId, callback, data, false);
    }

    @Deprecated
    public void callback(String instanceId, String callback, Map<String, Object> data) {
        this.callback(instanceId, callback, data, false);
    }

    @Deprecated
    public void callback(String instanceId, String callback, Object data, boolean keepAlive) {
        this.callbackJavascript(instanceId, callback, data, keepAlive);
    }

    void callbackJavascript(String instanceId, String callback, Object data, boolean keepAlive) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)callback) || this.mJSHandler == null) {
            return;
        }
        this.addJSTask(METHOD_CALLBACK, instanceId, callback, data, keepAlive);
        this.sendMessage(instanceId, 6);
    }

    public void refreshInstance(final String instanceId, final WXRefreshData jsonData) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || jsonData == null) {
            return;
        }
        this.mJSHandler.postDelayed(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRefreshInstance(instanceId, jsonData);
            }
        }), 0L);
    }

    private void invokeRefreshInstance(String instanceId, WXRefreshData refreshData) {
        try {
            if (!this.isJSFrameworkInit()) {
                WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
                if (instance != null) {
                    instance.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorCode(), WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorMsg() + "invokeRefreshInstance FAILED for JSFrameworkInit FAILED, intance will invoke instance.onRenderError");
                }
                String err = "[WXBridgeManager] invokeRefreshInstance: framework.js uninitialized.";
                WXLogUtils.e(err);
                return;
            }
            long start = System.currentTimeMillis();
            if (WXEnvironment.isOpenDebugLog()) {
                WXLogUtils.d("refreshInstance >>>> instanceId:" + instanceId + ", data:" + refreshData.data + ", isDirty:" + refreshData.isDirty);
            }
            if (refreshData.isDirty) {
                return;
            }
            WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
            WXJSObject dataObj = new WXJSObject(3, refreshData.data == null ? "{}" : refreshData.data);
            WXJSObject[] args = new WXJSObject[]{instanceIdObj, dataObj};
            this.invokeExecJS(instanceId, null, METHOD_REFRESH_INSTANCE, args);
            WXLogUtils.renderPerformanceLog("invokeRefreshInstance", System.currentTimeMillis() - start);
        }
        catch (Throwable e) {
            String err = "[WXBridgeManager] invokeRefreshInstance " + WXLogUtils.getStackTrace(e);
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "invokeRefreshInstance", err, null);
            WXLogUtils.e(err);
        }
    }

    public void commitJscCrashAlarmMonitor(String type, WXErrorCode errorCode, String errMsg, String instanceId, String url) {
        if (TextUtils.isEmpty((CharSequence)type) || errorCode == null) {
            return;
        }
        String method = "callReportCrash";
        String exception = "weexjsc process crash and restart exception";
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("jscCrashStack", errMsg);
        IWXJSExceptionAdapter adapter = WXSDKManager.getInstance().getIWXJSExceptionAdapter();
        if (adapter != null) {
            WXJSExceptionInfo jsException = new WXJSExceptionInfo(instanceId, url, errorCode.getErrorCode(), method, exception, extParams);
            adapter.onJSException(jsException);
            WXLogUtils.e(jsException.toString());
        }
    }

    public void createInstance(String instanceId, final String template, final Map<String, Object> options, final String data) {
        final WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance == null) {
            WXLogUtils.e("WXBridgeManager", "createInstance failed, SDKInstance is not exist");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)template) || this.mJSHandler == null) {
            instance.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorCode(), WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorMsg() + " instanceId==" + instanceId + " template ==" + template + " mJSHandler== " + this.mJSHandler.toString());
            return;
        }
        if (!this.isJSFrameworkInit() && reInitCount == 1 && !WXEnvironment.sDebugServerConnectable) {
            instance.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorCode(), WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorMsg() + " isJSFrameworkInit==" + this.isJSFrameworkInit() + " reInitCount == 1");
            this.post(new Runnable(){

                @Override
                public void run() {
                    WXBridgeManager.this.initFramework("");
                }
            }, instanceId);
            return;
        }
        WXModuleManager.createDomModule(instance);
        this.post(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                WXBridgeManager.this.invokeCreateInstance(instance, template, options, data);
                final long totalTime = System.currentTimeMillis() - start;
                WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        instance.createInstanceFinished(totalTime);
                    }
                }, 0L);
            }
        }, instanceId);
    }

    private void invokeCreateInstance(@NonNull WXSDKInstance instance, String template, Map<String, Object> options, String data) {
        this.initFramework("");
        if (this.mMock) {
            this.mock(instance.getInstanceId());
        } else {
            if (!this.isJSFrameworkInit()) {
                String err = "[WXBridgeManager] invokeCreateInstance: framework.js uninitialized.";
                instance.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorCode(), WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorMsg());
                WXLogUtils.e(err);
                return;
            }
            try {
                if (WXEnvironment.isOpenDebugLog()) {
                    WXLogUtils.d("createInstance >>>> instanceId:" + instance.getInstanceId() + ", options:" + WXJsonUtils.fromObjectToJSONString(options) + ", data:" + data);
                }
                WXJSObject instanceIdObj = new WXJSObject(2, instance.getInstanceId());
                WXJSObject instanceObj = new WXJSObject(2, template);
                WXJSObject optionsObj = new WXJSObject(3, options == null ? "{}" : WXJsonUtils.fromObjectToJSONString(options));
                WXJSObject dataObj = new WXJSObject(3, data == null ? "{}" : data);
                WXJSObject[] args = new WXJSObject[]{instanceIdObj, instanceObj, optionsObj, dataObj};
                instance.setTemplate(template);
                this.invokeExecJS(instance.getInstanceId(), null, METHOD_CREATE_INSTANCE, args, false);
            }
            catch (Throwable e) {
                String err = "[WXBridgeManager] invokeCreateInstance " + e.getCause() + instance.getTemplateInfo();
                instance.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorCode(), WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorMsg() + err);
                WXLogUtils.e(err);
            }
        }
    }

    private void mock(String instanceId) {
    }

    public void destroyInstance(final String instanceId) {
        if (this.mJSHandler == null || TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        if (this.mDestroyedInstanceId != null) {
            this.mDestroyedInstanceId.add(instanceId);
        }
        this.mJSHandler.removeCallbacksAndMessages((Object)instanceId);
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.removeTaskByInstance(instanceId);
                WXBridgeManager.this.invokeDestroyInstance(instanceId);
            }
        }, instanceId);
    }

    private void removeTaskByInstance(String instanceId) {
        this.mNextTickTasks.removeFromMapAndStack(instanceId);
    }

    private void invokeDestroyInstance(String instanceId) {
        try {
            if (WXEnvironment.isOpenDebugLog()) {
                WXLogUtils.d("destroyInstance >>>> instanceId:" + instanceId);
            }
            WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
            WXJSObject[] args = new WXJSObject[]{instanceIdObj};
            if (this.isJSFrameworkInit()) {
                this.invokeExecJS(instanceId, null, METHOD_DESTROY_INSTANCE, args);
            }
        }
        catch (Throwable e) {
            String err = "[WXBridgeManager] invokeDestroyInstance " + e.getCause();
            WXExceptionUtils.commitCriticalExceptionRT(instanceId, WXErrorCode.WX_KEY_EXCEPTION_INVOKE.getErrorCode(), "invokeDestroyInstance", err, null);
            WXLogUtils.e(err);
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg == null) {
            return false;
        }
        int what = msg.what;
        switch (what) {
            case 7: {
                this.invokeInitFramework(msg);
                break;
            }
            case 6: {
                this.invokeCallJSBatch(msg);
                break;
            }
            case 1: {
                TimerInfo timerInfo = (TimerInfo)msg.obj;
                if (timerInfo == null) break;
                WXJSObject obj = new WXJSObject(2, timerInfo.callbackId);
                WXJSObject[] args = new WXJSObject[]{obj};
                this.invokeExecJS("", null, METHOD_SET_TIMEOUT, args);
                break;
            }
            case 13: {
                if (msg.obj == null) break;
                String filename = (String)msg.obj;
                this.mWXBridge.takeHeapSnapshot(filename);
                break;
            }
        }
        return false;
    }

    private void invokeExecJS(String instanceId, String namespace, String function, WXJSObject[] args) {
        this.invokeExecJS(instanceId, namespace, function, args, true);
    }

    public void invokeExecJS(String instanceId, String namespace, String function, WXJSObject[] args, boolean logTaskDetail) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("callJS >>>> instanceId:").append(instanceId).append("function:").append(function);
            if (logTaskDetail) {
                this.mLodBuilder.append(" tasks:").append(WXBridgeManager.argsToJSON(args));
            }
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        this.mWXBridge.execJS(instanceId, namespace, function, args);
    }

    private byte[] invokeExecJSWithResult(String instanceId, String namespace, String function, WXJSObject[] args, boolean logTaskDetail) {
        if (WXEnvironment.isOpenDebugLog()) {
            this.mLodBuilder.append("callJS >>>> instanceId:").append(instanceId).append("function:").append(function);
            if (logTaskDetail) {
                this.mLodBuilder.append(" tasks:").append(WXBridgeManager.argsToJSON(args));
            }
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        return this.mWXBridge.execJSWithResult(instanceId, namespace, function, args);
    }

    @NonNull
    public static String argsToJSON(WXJSObject[] args) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (WXJSObject object : args) {
            if (object.type == 4) {
                object = new WXJSObject(4, WXJsonUtils.parseWson((byte[])object.data));
            }
            builder.append(WXJsonUtils.fromObjectToJSONString(object));
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private void invokeInitFramework(Message msg) {
        String framework = "";
        if (msg.obj != null) {
            framework = (String)msg.obj;
        }
        if (WXUtils.getAvailMemory((Context)WXEnvironment.getApplication()) > LOW_MEM_VALUE) {
            this.initFramework(framework);
        }
    }

    private void initFramework(String framework) {
        if (!this.isJSFrameworkInit()) {
            if (TextUtils.isEmpty((CharSequence)framework)) {
                WXLogUtils.d("weex JS framework from assets");
                framework = WXFileUtils.loadAsset("main.js", (Context)WXEnvironment.getApplication());
            }
            if (TextUtils.isEmpty((CharSequence)framework)) {
                this.setJSFrameworkInit(false);
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK.getErrorCode(), "initFramework", "framework is empty!! ", null);
                return;
            }
            try {
                if (WXSDKManager.getInstance().getWXStatisticsListener() != null) {
                    WXSDKManager.getInstance().getWXStatisticsListener().onJsFrameworkStart();
                }
                long start = System.currentTimeMillis();
                String crashFile = "";
                try {
                    crashFile = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                boolean pieSupport = true;
                try {
                    if (Build.VERSION.SDK_INT < 16) {
                        pieSupport = false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                WXLogUtils.d("[WXBridgeManager] initFrameworkEnv crashFile:" + crashFile + " pieSupport:" + pieSupport);
                if (this.mWXBridge.initFrameworkEnv(framework, this.assembleDefaultOptions(), crashFile, pieSupport) == 1) {
                    WXEnvironment.sJSLibInitTime = System.currentTimeMillis() - start;
                    WXLogUtils.renderPerformanceLog("initFramework", WXEnvironment.sJSLibInitTime);
                    WXEnvironment.sSDKInitTime = System.currentTimeMillis() - WXEnvironment.sSDKInitStart;
                    WXLogUtils.renderPerformanceLog("SDKInitTime", WXEnvironment.sSDKInitTime);
                    this.setJSFrameworkInit(true);
                    if (WXSDKManager.getInstance().getWXStatisticsListener() != null) {
                        WXSDKManager.getInstance().getWXStatisticsListener().onJsFrameworkReady();
                    }
                    this.execRegisterFailTask();
                    WXEnvironment.JsFrameworkInit = true;
                    this.registerDomModule();
                    String reinitInfo = "";
                    if (reInitCount > 1) {
                        reinitInfo = "reinit Framework:";
                    }
                } else if (reInitCount > 1) {
                    WXLogUtils.e("[WXBridgeManager] invokeReInitFramework  ExecuteJavaScript fail");
                    String err = "[WXBridgeManager] invokeReInitFramework  ExecuteJavaScript fail reinit FrameWork";
                    WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK.getErrorCode(), "initFramework", "reInitCount = " + reInitCount + err, null);
                } else {
                    WXLogUtils.e("[WXBridgeManager] invokeInitFramework  ExecuteJavaScript fail");
                    String err = "[WXBridgeManager] invokeInitFramework  ExecuteJavaScript fail";
                    WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK.getErrorCode(), "initFramework", err, null);
                }
            }
            catch (Throwable e) {
                if (reInitCount > 1) {
                    WXLogUtils.e("[WXBridgeManager] invokeInitFramework ", e);
                    String err = "[WXBridgeManager] invokeInitFramework reinit FrameWork exception!#" + e.toString();
                    WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK.getErrorCode(), "initFramework", "reInitCount ==" + reInitCount + err, null);
                }
                WXLogUtils.e("[WXBridgeManager] invokeInitFramework ", e);
                String err = "[WXBridgeManager] invokeInitFramework exception!#" + e.toString();
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK.getErrorCode(), "initFramework", err, null);
            }
        }
    }

    private void invokeCallJSBatch(Message message) {
        if (this.mNextTickTasks.isEmpty() || !this.isJSFrameworkInit()) {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized!!  message:" + message.toString());
            }
            return;
        }
        try {
            Object instanceId = message.obj;
            ArrayList<WXHashMap<String, Object>> task = null;
            Stack<String> instanceStack = this.mNextTickTasks.getInstanceStack();
            int size = instanceStack.size();
            for (int i = size - 1; i >= 0 && ((task = this.mNextTickTasks.remove(instanceId = instanceStack.get(i))) == null || task.isEmpty()); --i) {
            }
            Object[] tasks = task.toArray();
            WXJSObject[] args = new WXJSObject[]{new WXJSObject(2, instanceId), WXJsonUtils.wsonWXJSObject(tasks)};
            this.invokeExecJS(String.valueOf(instanceId), null, METHOD_CALL_JS, args);
            task.clear();
            for (int i = 0; i < tasks.length; ++i) {
                args[i] = null;
            }
            args = null;
        }
        catch (Throwable e) {
            WXLogUtils.e("WXBridgeManager", e);
            String err = "invokeCallJSBatch#" + WXLogUtils.getStackTrace(e);
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_ERR_JS_FRAMEWORK.getErrorCode(), "invokeCallJSBatch", err, null);
        }
        if (!this.mNextTickTasks.isEmpty()) {
            this.mJSHandler.sendEmptyMessage(6);
        }
    }

    private WXParams assembleDefaultOptions() {
        Map<String, String> config = WXEnvironment.getConfig();
        WXParams wxParams = new WXParams();
        wxParams.setPlatform(config.get("os"));
        wxParams.setCacheDir(config.get("cacheDir"));
        wxParams.setOsVersion(config.get("sysVersion"));
        wxParams.setAppVersion(config.get("appVersion"));
        wxParams.setWeexVersion(config.get("weexVersion"));
        wxParams.setDeviceModel(config.get("sysModel"));
        wxParams.setShouldInfoCollect(config.get("infoCollect"));
        wxParams.setLogLevel(config.get("logLevel"));
        String appName = config.get("appName");
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            wxParams.setAppName(appName);
        }
        wxParams.setDeviceWidth(TextUtils.isEmpty((CharSequence)config.get("deviceWidth")) ? String.valueOf(WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication)) : config.get("deviceWidth"));
        wxParams.setDeviceHeight(TextUtils.isEmpty((CharSequence)config.get("deviceHeight")) ? String.valueOf(WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication)) : config.get("deviceHeight"));
        wxParams.setOptions(WXEnvironment.getCustomOptions());
        wxParams.setNeedInitV8(WXSDKManager.getInstance().needInitV8());
        this.mInitParams = wxParams;
        return wxParams;
    }

    public WXParams getInitParams() {
        return this.mInitParams;
    }

    private void execRegisterFailTask() {
        ArrayList<Map<String, Object>> receiver;
        if (this.mRegisterModuleFailList.size() > 0) {
            ArrayList<Map<String, Object>> moduleReceiver = new ArrayList<Map<String, Object>>();
            int moduleCount = this.mRegisterModuleFailList.size();
            for (int i = 0; i < moduleCount; ++i) {
                this.invokeRegisterModules(this.mRegisterModuleFailList.get(i), moduleReceiver);
            }
            this.mRegisterModuleFailList.clear();
            if (moduleReceiver.size() > 0) {
                this.mRegisterModuleFailList.addAll(moduleReceiver);
            }
        }
        if (this.mRegisterComponentFailList.size() > 0) {
            receiver = new ArrayList<Map<String, Object>>();
            this.invokeRegisterComponents(this.mRegisterComponentFailList, receiver);
            this.mRegisterComponentFailList.clear();
            if (receiver.size() > 0) {
                this.mRegisterComponentFailList.addAll(receiver);
            }
        }
        if (this.mRegisterServiceFailList.size() > 0) {
            receiver = new ArrayList();
            for (String service : this.mRegisterServiceFailList) {
                this.invokeExecJSService(service, receiver);
            }
            this.mRegisterServiceFailList.clear();
            if (receiver.size() > 0) {
                this.mRegisterServiceFailList.addAll(receiver);
            }
        }
    }

    public void registerModules(final Map<String, Object> modules) {
        if (modules != null && modules.size() != 0) {
            if (this.isJSThread()) {
                this.invokeRegisterModules(modules, this.mRegisterModuleFailList);
            } else {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        WXBridgeManager.this.invokeRegisterModules(modules, WXBridgeManager.this.mRegisterComponentFailList);
                    }
                }, null);
            }
        }
    }

    public void registerComponents(final List<Map<String, Object>> components) {
        if (this.mJSHandler == null || components == null || components.size() == 0) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRegisterComponents(components, WXBridgeManager.this.mRegisterComponentFailList);
            }
        }, null);
    }

    public void execJSService(final String service) {
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeExecJSService(service, WXBridgeManager.this.mRegisterServiceFailList);
            }
        });
    }

    private void invokeExecJSService(String service, List<String> receiver) {
        try {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.e("[WXBridgeManager] invoke execJSService: framework.js uninitialized.");
                receiver.add(service);
                return;
            }
            this.mWXBridge.execJSService(service);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterService:", e);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("inputParams", service + "||" + receiver.toString());
            WXExceptionUtils.commitCriticalExceptionRT("invokeExecJSService", WXErrorCode.WX_KEY_EXCEPTION_INVOKE_JSSERVICE_EXECUTE.getErrorCode(), "invokeExecJSService", WXErrorCode.WX_KEY_EXCEPTION_INVOKE_JSSERVICE_EXECUTE.getErrorMsg() + "[WXBridgeManager] invokeRegisterService:" + WXLogUtils.getStackTrace(e), data);
        }
    }

    private boolean isJSThread() {
        return this.mJSThread != null && this.mJSThread.getId() == Thread.currentThread().getId();
    }

    private void invokeRegisterModules(Map<String, Object> modules, List<Map<String, Object>> failReceiver) {
        if (modules == null || !this.isJSFrameworkInit()) {
            if (!this.isJSFrameworkInit()) {
                WXLogUtils.d("[WXinvokeRegisterModulesBridgeManager] invokeRegisterModules: framework.js uninitialized.");
            }
            failReceiver.add(modules);
            return;
        }
        WXJSObject[] args = new WXJSObject[]{new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(modules))};
        try {
            this.mWXBridge.execJS("", null, METHOD_REGISTER_MODULES, args);
        }
        catch (Throwable e) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_MODULES.getErrorCode(), "invokeRegisterModules", WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_MODULES.getErrorMsg() + " \n " + e.getMessage() + modules.entrySet().toString(), null);
            WXLogUtils.e("[WXBridgeManager] invokeRegisterModules:", e);
        }
    }

    private void invokeRegisterComponents(List<Map<String, Object>> components, List<Map<String, Object>> failReceiver) {
        if (components == failReceiver) {
            throw new RuntimeException("Fail receiver should not use source.");
        }
        if (!this.isJSFrameworkInit()) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterComponents: framework.js uninitialized.");
            for (Map<String, Object> comp : components) {
                failReceiver.add(comp);
            }
            return;
        }
        if (components == null) {
            return;
        }
        WXJSObject[] args = new WXJSObject[]{new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(components))};
        try {
            this.mWXBridge.execJS("", null, METHOD_REGISTER_COMPONENTS, args);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterComponents ", e);
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_CONTENT_FAILED.getErrorCode(), METHOD_REGISTER_COMPONENTS, WXErrorCode.WX_KEY_EXCEPTION_INVOKE_REGISTER_CONTENT_FAILED.getErrorMsg() + args.toString() + WXLogUtils.getStackTrace(e), null);
        }
    }

    public void destroy() {
        if (this.mJSThread != null) {
            this.mJSThread.quit();
        }
        mBridgeManager = null;
        if (this.mDestroyedInstanceId != null) {
            this.mDestroyedInstanceId.clear();
        }
    }

    public void reportJSException(String instanceId, String function, String exception) {
        IWXJSExceptionAdapter adapter;
        WXLogUtils.e("reportJSException >>>> instanceId:" + instanceId + ", exception function:" + function + ", exception:" + exception);
        WXSDKInstance instance = null;
        if (instanceId != null && (instance = WXSDKManager.getInstance().getSDKInstance(instanceId)) != null) {
            exception = exception + "\n getTemplateInfo==" + instance.getTemplateInfo();
            if (METHOD_CREATE_INSTANCE.equals(function) || !instance.isContentMd5Match()) {
                try {
                    if (this.isJSFrameworkInit() && reInitCount > 1 && !instance.isNeedReLoad()) {
                        WXDomModule domModule = WXModuleManager.getDomModule(instanceId);
                        DOMAction action = Actions.getReloadPage(instanceId, true);
                        domModule.postAction(action, true);
                        instance.setNeedLoad(true);
                        return;
                    }
                    instance.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorCode(), WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getDegradErrorMsg() + "reportJSException >>>> instanceId:" + instanceId + ", exception function:" + function + ", exception:" + exception);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            instance.onJSException(WXErrorCode.WX_ERR_JS_EXECUTE.getErrorCode(), function, exception);
        }
        if ((adapter = WXSDKManager.getInstance().getIWXJSExceptionAdapter()) != null) {
            String exceptionId = instanceId;
            if (instanceId == "" || instanceId == null) {
                exceptionId = "instanceIdisNull";
            }
            if (instance == null) {
                if ("initFramework".equals(function)) {
                    String exceptionExt;
                    block21: {
                        String bundleUrl = "jsExceptionBeforeRenderInstanceNull";
                        exceptionExt = null;
                        try {
                            if (WXEnvironment.getApplication() == null) break block21;
                            String fileName = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath() + INITLOGFILE;
                            try {
                                File file = new File(fileName);
                                if (!file.exists()) break block21;
                                if (file.length() > 0L) {
                                    StringBuilder result = new StringBuilder();
                                    try {
                                        InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                                        BufferedReader br = new BufferedReader(read);
                                        String s = null;
                                        while ((s = br.readLine()) != null) {
                                            result.append(s + "\n");
                                        }
                                        exceptionExt = result.toString();
                                        br.close();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                file.delete();
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    exception = exception + "\n" + exceptionExt;
                    WXLogUtils.e("reportJSException:" + exception);
                } else if (function == null) {
                    String bundleUrl = "jsExceptionInstanceAndFunctionNull";
                } else {
                    String bundleUrl = "jsExceptionInstanceNull" + function;
                }
            } else {
                String bundleUrl = instance.getBundleUrl();
            }
            WXExceptionUtils.commitCriticalExceptionRT(exceptionId, WXErrorCode.WX_KEY_EXCEPTION_WXBRIDGE.getErrorCode(), function, WXErrorCode.WX_KEY_EXCEPTION_WXBRIDGE.getErrorMsg() + exception, null);
        }
    }

    private void registerDomModule() throws WXException {
        HashMap<String, Object> domMap = new HashMap<String, Object>();
        domMap.put("dom", WXDomModule.METHODS);
        this.registerModules(domMap);
    }

    @Deprecated
    public void notifyTrimMemory() {
    }

    public static void updateGlobalConfig(String config) {
        if (TextUtils.isEmpty((CharSequence)config)) {
            config = "none";
        }
        if (!TextUtils.equals((CharSequence)config, (CharSequence)globalConfig)) {
            globalConfig = config;
            WXEnvironment.getCustomOptions().put(GLOBAL_CONFIG_KEY, globalConfig);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (mBridgeManager != null && mBridgeManager.isJSFrameworkInit() && mBridgeManager.mWXBridge instanceof WXBridge) {
                        WXBridge bridge = (WXBridge)mBridgeManager.mWXBridge;
                        bridge.updateGlobalConfig(globalConfig);
                    }
                    WXJsonUtils.USE_WSON = !globalConfig.contains("wson_off");
                }
            };
            if (mBridgeManager != null && mBridgeManager.isJSFrameworkInit()) {
                mBridgeManager.post(runnable);
            } else {
                runnable.run();
            }
        }
    }

    @Nullable
    public Looper getJSLooper() {
        Looper ret = null;
        if (this.mJSThread != null) {
            ret = this.mJSThread.getLooper();
        }
        return ret;
    }

    public void notifySerializeCodeCache() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!WXBridgeManager.this.isJSFrameworkInit()) {
                    return;
                }
                WXBridgeManager.this.invokeExecJS("", null, WXBridgeManager.METHOD_NOTIFY_SERIALIZE_CODE_CACHE, new WXJSObject[0]);
            }
        });
    }

    public void takeJSHeapSnapshot(String filename) {
        Message msg = this.mJSHandler.obtainMessage();
        msg.obj = filename;
        msg.what = 13;
        msg.setTarget(this.mJSHandler);
        msg.sendToTarget();
    }

    static {
        LOW_MEM_VALUE = 120L;
        reInitCount = 1;
        crashUrl = null;
        lastCrashTime = 0L;
        mInit = false;
        globalConfig = "none";
        GLOBAL_CONFIG_KEY = "global_switch_config";
    }

    public static class TimerInfo {
        public String callbackId;
        public long time;
        public String instanceId;
    }
}

