/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ComponentObserver;
import com.taobao.weex.IWXActivityStateListener;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.LayoutFinishListener;
import com.taobao.weex.RenderContainer;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXGlobalEventReceiver;
import com.taobao.weex.WXRenderErrorCode;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.bridge.EventResult;
import com.taobao.weex.bridge.NativeInvokeHelper;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.dom.DomContext;
import com.taobao.weex.dom.WXDomTask;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.http.WXHttpUtil;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.component.NestedContainer;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXEmbed;
import com.taobao.weex.ui.flat.FlatGUIContext;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.utils.Trace;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WXSDKInstance
implements IWXActivityStateListener,
DomContext,
View.OnLayoutChangeListener {
    private static final String SOURCE_TEMPLATE_BASE64_MD5 = "templateSourceBase64MD5";
    public boolean mEnd = false;
    public static final String BUNDLE_URL = "bundleUrl";
    private IWXUserTrackAdapter mUserTrackAdapter;
    private IWXRenderListener mRenderListener;
    private IWXStatisticsListener mStatisticsListener;
    Context mContext;
    private final String mInstanceId;
    private RenderContainer mRenderContainer;
    private WXComponent mRootComp;
    private boolean mRendered;
    private WXRefreshData mLastRefreshData;
    private NestedInstanceInterceptor mNestedInstanceInterceptor;
    private String mBundleUrl = "";
    public static String requestUrl = "requestUrl";
    private boolean isDestroy = false;
    private Map<String, Serializable> mUserTrackParams;
    private NativeInvokeHelper mNativeInvokeHelper;
    private boolean isCommit = false;
    private WXGlobalEventReceiver mGlobalEventReceiver = null;
    private boolean trackComponent;
    private boolean enableLayerType = true;
    private boolean mNeedValidate = false;
    private boolean mNeedReLoad = false;
    private static volatile int mViewPortWidth = 750;
    private int mInstanceViewPortWidth = 750;
    @NonNull
    private FlatGUIContext mFlatGUIContext = new FlatGUIContext();
    public long mRenderStartNanos;
    public int mExecJSTraceId = WXTracing.nextId();
    public String[] mwxDims = new String[5];
    public long[] measureTimes = new long[5];
    public WeakReference<String> templateRef;
    public Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
    private WXRenderStrategy mRenderStrategy = WXRenderStrategy.APPEND_ASYNC;
    public long mRenderStartTime;
    private long mRefreshStartTime;
    private WXPerformance mWXPerformance;
    private ScrollView mScrollView;
    private WXScrollView.WXScrollViewListener mWXScrollViewListener;
    private List<OnWXScrollListener> mWXScrollListeners;
    private volatile boolean isPreRenderMode;
    private LayoutFinishListener mLayoutFinishListener;
    private boolean mCurrentGround = false;
    private ComponentObserver mComponentObserver;
    private boolean mIsCommitedDomAtionExp = false;
    public PriorityQueue<WXEmbed> hiddenEmbeds;
    private int maxHiddenEmbedsNum = -1;
    private int mMaxDeepLayer;
    private List<OnInstanceVisibleListener> mVisibleListeners = new ArrayList<OnInstanceVisibleListener>();
    private boolean mCreateInstance = true;
    private HashMap<String, List<String>> mGlobalEvents = new HashMap();

    public boolean getismIsCommitedDomAtionExp() {
        return this.mIsCommitedDomAtionExp;
    }

    public void setmIsCommitedDomAtionExp(boolean mIsCommitedDomAtionExp) {
        this.mIsCommitedDomAtionExp = mIsCommitedDomAtionExp;
    }

    public int getMaxHiddenEmbedsNum() {
        return this.maxHiddenEmbedsNum;
    }

    public void setMaxHiddenEmbedsNum(int maxHiddenEmbedsNum) {
        this.maxHiddenEmbedsNum = maxHiddenEmbedsNum;
    }

    public void setRenderContainer(RenderContainer a) {
        if (a != null) {
            a.setSDKInstance(this);
            a.addOnLayoutChangeListener(this);
        }
        this.mRenderContainer = a;
    }

    public boolean isTrackComponent() {
        return this.trackComponent;
    }

    public void setTrackComponent(boolean trackComponent) {
        this.trackComponent = trackComponent;
    }

    public boolean isLayerTypeEnabled() {
        return this.enableLayerType;
    }

    public void enableLayerType(boolean enable) {
        this.enableLayerType = enable;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public FlatGUIContext getFlatUIContext() {
        return this.mFlatGUIContext;
    }

    public boolean isNeedValidate() {
        return this.mNeedValidate;
    }

    public boolean isNeedReLoad() {
        return this.mNeedReLoad;
    }

    public void setNeedLoad(boolean load) {
        this.mNeedReLoad = load;
    }

    @Deprecated
    public void setViewPortWidth(int viewPortWidth) {
        mViewPortWidth = viewPortWidth;
    }

    @Deprecated
    public static int getViewPortWidth() {
        return mViewPortWidth;
    }

    public void setInstanceViewPortWidth(int instanceViewPortWidth) {
        this.mInstanceViewPortWidth = instanceViewPortWidth;
    }

    public int getInstanceViewPortWidth() {
        return this.mInstanceViewPortWidth;
    }

    public WXSDKInstance(Context context) {
        this.mInstanceId = WXSDKManager.getInstance().generateInstanceId();
        this.init(context);
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    WXSDKInstance(Context context, String id2) {
        this.mInstanceId = id2;
        this.init(context);
    }

    public WXComponent getRootComponent() {
        return this.mRootComp;
    }

    public void setNestedInstanceInterceptor(NestedInstanceInterceptor interceptor) {
        this.mNestedInstanceInterceptor = interceptor;
    }

    public final WXSDKInstance createNestedInstance(NestedContainer container) {
        WXSDKInstance sdkInstance = this.newNestedInstance();
        if (this.mNestedInstanceInterceptor != null) {
            this.mNestedInstanceInterceptor.onCreateNestInstance(sdkInstance, container);
        }
        return sdkInstance;
    }

    protected WXSDKInstance newNestedInstance() {
        return new WXSDKInstance(this.mContext);
    }

    public void addOnInstanceVisibleListener(OnInstanceVisibleListener l) {
        this.mVisibleListeners.add(l);
    }

    public void removeOnInstanceVisibleListener(OnInstanceVisibleListener l) {
        this.mVisibleListeners.remove(l);
    }

    public void init(Context context) {
        this.mContext = context;
        this.mNativeInvokeHelper = new NativeInvokeHelper(this.mInstanceId);
        this.mWXPerformance = new WXPerformance();
        this.mWXPerformance.WXSDKVersion = WXEnvironment.WXSDK_VERSION;
        this.mWXPerformance.JSLibInitTime = WXEnvironment.sJSLibInitTime;
        this.mUserTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
    }

    public void setComponentObserver(ComponentObserver observer) {
        this.mComponentObserver = observer;
    }

    public ComponentObserver getComponentObserver() {
        return this.mComponentObserver;
    }

    public NativeInvokeHelper getNativeInvokeHelper() {
        return this.mNativeInvokeHelper;
    }

    public void setBizType(String bizType) {
        if (!TextUtils.isEmpty((CharSequence)bizType)) {
            this.mWXPerformance.bizType = bizType;
        }
    }

    public ScrollView getScrollView() {
        return this.mScrollView;
    }

    public void setRootScrollView(ScrollView scrollView) {
        this.mScrollView = scrollView;
        if (this.mWXScrollViewListener != null) {
            ((WXScrollView)this.mScrollView).addScrollViewListener(this.mWXScrollViewListener);
        }
    }

    @Deprecated
    public void registerScrollViewListener(WXScrollView.WXScrollViewListener scrollViewListener) {
        this.mWXScrollViewListener = scrollViewListener;
    }

    @Deprecated
    public WXScrollView.WXScrollViewListener getScrollViewListener() {
        return this.mWXScrollViewListener;
    }

    @Deprecated
    public void setIWXUserTrackAdapter(IWXUserTrackAdapter adapter) {
    }

    public void render(String template, Map<String, Object> options, String jsonInitData) {
        this.render(template, options, jsonInitData, WXRenderStrategy.APPEND_ASYNC);
    }

    @Deprecated
    public void render(String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.render("default", template, options, jsonInitData, flag);
    }

    public void render(String pageName, String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        if (WXEnvironment.isApkDebugable() && "default".equals(pageName)) {
            WXLogUtils.e("WXSDKInstance", "Please set your pageName or your js bundle url !!!!!!!");
            if (this.getUIContext() != null) {
                new AlertDialog.Builder(this.getUIContext()).setTitle((CharSequence)"Error: Missing pageName").setMessage((CharSequence)"We highly recommend you to set pageName. Call\nWXSDKInstance#render(String pageName, String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag)\nto fix it.").show();
            }
            return;
        }
        this.renderInternal(pageName, template, options, jsonInitData, flag);
    }

    private void ensureRenderArchor() {
        if (this.mRenderContainer == null && this.getContext() != null) {
            this.mRenderContainer = new RenderContainer(this.getContext());
            this.mRenderContainer.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.mRenderContainer.setBackgroundColor(0);
            this.mRenderContainer.setSDKInstance(this);
            this.mRenderContainer.addOnLayoutChangeListener(this);
        }
    }

    private void renderInternal(String pageName, String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        if (this.mRendered || TextUtils.isEmpty((CharSequence)template)) {
            return;
        }
        String string2 = this.mWXPerformance.pageName = TextUtils.isEmpty((CharSequence)pageName) ? "defaultBundleUrl" : pageName;
        if (TextUtils.isEmpty((CharSequence)this.mBundleUrl)) {
            this.mBundleUrl = this.mWXPerformance.pageName;
        }
        WXLogUtils.d("WXSDKInstance", "Start render page: " + pageName);
        if (WXTracing.isAvailable()) {
            WXTracing.TraceEvent traceEvent = WXTracing.newEvent("executeBundleJS", this.mInstanceId, -1);
            traceEvent.traceId = this.mExecJSTraceId;
            traceEvent.iid = this.mInstanceId;
            traceEvent.tname = "JSThread";
            traceEvent.ph = "B";
            traceEvent.submit();
            this.mRenderStartNanos = System.nanoTime();
        }
        this.ensureRenderArchor();
        Map<String, Object> renderOptions = options;
        if (renderOptions == null) {
            renderOptions = new HashMap<String, Object>();
        }
        if (WXEnvironment.sDynamicMode && !TextUtils.isEmpty((CharSequence)WXEnvironment.sDynamicUrl) && renderOptions.get("dynamicMode") == null) {
            renderOptions.put("dynamicMode", "true");
            this.renderByUrl(pageName, WXEnvironment.sDynamicUrl, renderOptions, jsonInitData, flag);
            return;
        }
        this.mWXPerformance.JSTemplateSize = (float)template.length() / 1024.0f;
        this.mRenderStartTime = System.currentTimeMillis();
        this.mRenderStrategy = flag;
        WXSDKManager.getInstance().setCrashInfo("wx_current_url", pageName);
        WXSDKManager.getInstance().createInstance(this, template, renderOptions, jsonInitData);
        this.mRendered = true;
    }

    private void renderByUrlInternal(String pageName, String url, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        Uri uri;
        Map<String, Object> renderOptions;
        this.ensureRenderArchor();
        pageName = this.wrapPageName(pageName, url);
        this.mBundleUrl = url;
        if (WXSDKManager.getInstance().getValidateProcessor() != null) {
            this.mNeedValidate = WXSDKManager.getInstance().getValidateProcessor().needValidate(this.mBundleUrl);
        }
        if ((renderOptions = options) == null) {
            renderOptions = new HashMap<String, Object>();
        }
        if (!renderOptions.containsKey(BUNDLE_URL)) {
            renderOptions.put(BUNDLE_URL, url);
        }
        if ((uri = Uri.parse((String)url)) != null && TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file")) {
            this.render(pageName, WXFileUtils.loadFileOrAsset(this.assembleFilePath(uri), this.mContext), renderOptions, jsonInitData, flag);
            return;
        }
        IWXHttpAdapter adapter = WXSDKManager.getInstance().getIWXHttpAdapter();
        WXRequest wxRequest = new WXRequest();
        wxRequest.url = this.rewriteUri(Uri.parse((String)url), "bundle").toString();
        requestUrl = wxRequest != null && !TextUtils.isEmpty((CharSequence)wxRequest.url) ? wxRequest.url : pageName;
        if (wxRequest.paramMap == null) {
            wxRequest.paramMap = new HashMap<String, String>();
        }
        wxRequest.paramMap.put("user-agent", WXHttpUtil.assembleUserAgent(this.mContext, WXEnvironment.getConfig()));
        WXHttpListener httpListener = new WXHttpListener(pageName, renderOptions, jsonInitData, flag, System.currentTimeMillis());
        httpListener.setSDKInstance(this);
        adapter.sendRequest(wxRequest, httpListener);
    }

    @Deprecated
    public void render(String pageName, String template, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag) {
        this.render(pageName, template, options, jsonInitData, flag);
    }

    public void render(String template) {
        this.render("default", template, null, null, this.mRenderStrategy);
    }

    @Deprecated
    public void render(String template, int width, int height) {
        this.render(template);
    }

    @Deprecated
    public void renderByUrl(String pageName, String url, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag) {
        this.renderByUrl(pageName, url, options, jsonInitData, flag);
    }

    public void renderByUrl(String pageName, String url, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.renderByUrlInternal(pageName, url, options, jsonInitData, flag);
    }

    private String wrapPageName(String pageName, String url) {
        if (TextUtils.equals((CharSequence)pageName, (CharSequence)"default")) {
            WXExceptionUtils.degradeUrl = pageName = url;
            try {
                Uri uri = Uri.parse((String)url);
                if (uri != null) {
                    Uri.Builder builder = new Uri.Builder();
                    builder.scheme(uri.getScheme());
                    builder.authority(uri.getAuthority());
                    builder.path(uri.getPath());
                    pageName = builder.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pageName;
    }

    private String assembleFilePath(Uri uri) {
        if (uri != null && uri.getPath() != null) {
            return uri.getPath().replaceFirst("/", "");
        }
        return "";
    }

    public void reloadPage(boolean reloadThis) {
        WXSDKEngine.reload();
        if (reloadThis && this.mContext != null) {
            Intent intent = new Intent();
            intent.setAction("INSTANCE_RELOAD");
            intent.putExtra("url", this.mBundleUrl);
            this.mContext.sendBroadcast(intent);
        }
    }

    public void refreshInstance(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.refreshInstance(WXJsonUtils.fromObjectToJSONString(data));
    }

    public void refreshInstance(String jsonData) {
        if (jsonData == null) {
            return;
        }
        this.mRefreshStartTime = System.currentTimeMillis();
        if (this.mLastRefreshData != null) {
            this.mLastRefreshData.isDirty = true;
        }
        this.mLastRefreshData = new WXRefreshData(jsonData, false);
        WXSDKManager.getInstance().refreshInstance(this.mInstanceId, this.mLastRefreshData);
    }

    public WXRenderStrategy getRenderStrategy() {
        return this.mRenderStrategy;
    }

    @Override
    public Context getUIContext() {
        return this.mContext;
    }

    @Override
    public String getInstanceId() {
        return this.mInstanceId;
    }

    public Context getContext() {
        if (this.mContext == null) {
            WXLogUtils.e("WXSdkInstance mContext == null");
        }
        return this.mContext;
    }

    public int getWeexHeight() {
        return this.mRenderContainer == null ? 0 : this.mRenderContainer.getHeight();
    }

    public int getWeexWidth() {
        return this.mRenderContainer == null ? 0 : this.mRenderContainer.getWidth();
    }

    public IWXImgLoaderAdapter getImgLoaderAdapter() {
        return WXSDKManager.getInstance().getIWXImgLoaderAdapter();
    }

    public IDrawableLoader getDrawableLoader() {
        return WXSDKManager.getInstance().getDrawableLoader();
    }

    public URIAdapter getURIAdapter() {
        return WXSDKManager.getInstance().getURIAdapter();
    }

    public Uri rewriteUri(Uri uri, String type) {
        return this.getURIAdapter().rewrite(this, type, uri);
    }

    public IWXHttpAdapter getWXHttpAdapter() {
        return WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public IWXStatisticsListener getWXStatisticsListener() {
        return this.mStatisticsListener;
    }

    @Nullable
    public IWebSocketAdapter getWXWebSocketAdapter() {
        return WXSDKManager.getInstance().getIWXWebSocketAdapter();
    }

    @Deprecated
    public void reloadImages() {
        if (this.mScrollView == null) {
            return;
        }
    }

    public boolean isPreRenderMode() {
        return this.isPreRenderMode;
    }

    public void setPreRenderMode(final boolean isPreRenderMode) {
        WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(new Runnable(){

            @Override
            public void run() {
                WXSDKInstance.this.isPreRenderMode = isPreRenderMode;
            }
        }, 0L);
    }

    public void setContext(@NonNull Context context) {
        this.mContext = context;
    }

    public void registerRenderListener(IWXRenderListener listener) {
        this.mRenderListener = listener;
    }

    @Deprecated
    public void registerActivityStateListener(IWXActivityStateListener listener) {
    }

    public void registerStatisticsListener(IWXStatisticsListener listener) {
        this.mStatisticsListener = listener;
    }

    public void setLayoutFinishListener(@Nullable LayoutFinishListener listener) {
        this.mLayoutFinishListener = listener;
    }

    public LayoutFinishListener getLayoutFinishListener() {
        return this.mLayoutFinishListener;
    }

    public void setRenderStartTime(long renderStartTime) {
        this.mRenderStartTime = renderStartTime;
    }

    @Override
    public void onActivityCreate() {
        WXModuleManager.onActivityCreate(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityCreate();
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely,onActivityCreate can not be call!");
        }
        this.mGlobalEventReceiver = new WXGlobalEventReceiver(this);
        this.getContext().registerReceiver((BroadcastReceiver)this.mGlobalEventReceiver, new IntentFilter("wx_global_action"));
    }

    @Override
    public void onActivityStart() {
        WXModuleManager.onActivityStart(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityStart();
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely,onActivityStart can not be call!");
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        WXModuleManager.onCreateOptionsMenu(this.getInstanceId(), menu);
        if (this.mRootComp != null) {
            this.mRootComp.onCreateOptionsMenu(menu);
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely,onActivityStart can not be call!");
        }
        return true;
    }

    @Override
    public void onActivityPause() {
        this.onViewDisappear();
        if (!this.isCommit) {
            Set<String> componentTypes = WXComponentFactory.getComponentTypesByInstanceId(this.getInstanceId());
            if (componentTypes != null && componentTypes.contains("scroller")) {
                this.mWXPerformance.useScroller = 1;
            }
            this.mWXPerformance.maxDeepViewLayer = this.getMaxDeepLayer();
            this.mWXPerformance.wxDims = this.mwxDims;
            this.mWXPerformance.measureTimes = this.measureTimes;
            if (this.mUserTrackAdapter != null) {
                this.mUserTrackAdapter.commit(this.mContext, null, "load", this.mWXPerformance, this.getUserTrackParams());
            }
            this.isCommit = true;
        }
        WXModuleManager.onActivityPause(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityPause();
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely,onActivityPause can not be call!");
        }
        WXLogUtils.i("Application onActivityPause()");
        if (!this.mCurrentGround) {
            WXLogUtils.i("Application to be in the backround");
            Intent intent = new Intent("wx_global_action");
            intent.putExtra("eventName", "WXApplicationWillResignActiveEvent");
            intent.putExtra("wx_instanceid", this.getInstanceId());
            this.mContext.sendBroadcast(intent);
            this.mCurrentGround = true;
        }
    }

    @Override
    public void onActivityResume() {
        WXModuleManager.onActivityResume(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityResume();
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityResume can not be call!");
        }
        if (this.mCurrentGround) {
            WXLogUtils.i("Application  to be in the foreground");
            Intent intent = new Intent("wx_global_action");
            intent.putExtra("eventName", "WXApplicationDidBecomeActiveEvent");
            intent.putExtra("wx_instanceid", this.getInstanceId());
            this.mContext.sendBroadcast(intent);
            this.mCurrentGround = false;
        }
        this.onViewAppear();
        this.setViewPortWidth(this.mInstanceViewPortWidth);
    }

    @Override
    public void onActivityStop() {
        WXModuleManager.onActivityStop(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityStop();
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityStop can not be call!");
        }
    }

    @Override
    public void onActivityDestroy() {
        WXModuleManager.onActivityDestroy(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityDestroy();
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityDestroy can not be call!");
        }
        this.destroy();
    }

    @Override
    public boolean onActivityBack() {
        WXModuleManager.onActivityBack(this.getInstanceId());
        if (this.mRootComp != null) {
            return this.mRootComp.onActivityBack();
        }
        WXLogUtils.w("Warning :Component tree has not build completely, onActivityBack can not be call!");
        return false;
    }

    public boolean onBackPressed() {
        WXComponent comp = this.getRootComponent();
        if (comp != null) {
            WXEvent events = comp.getDomObject().getEvents();
            boolean hasBackPressed = events.contains("clickbackitem");
            if (hasBackPressed) {
                this.fireEvent(comp.getRef(), "clickbackitem", null, null);
            }
            return hasBackPressed;
        }
        return false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        WXModuleManager.onActivityResult(this.getInstanceId(), requestCode, resultCode, data);
        if (this.mRootComp != null) {
            this.mRootComp.onActivityResult(requestCode, resultCode, data);
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityResult can not be call!");
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        WXModuleManager.onRequestPermissionsResult(this.getInstanceId(), requestCode, permissions, grantResults);
        if (this.mRootComp != null) {
            this.mRootComp.onRequestPermissionsResult(requestCode, permissions, grantResults);
        } else {
            WXLogUtils.w("Warning :Component tree has not build completely, onRequestPermissionsResult can not be call!");
        }
    }

    public void onViewDisappear() {
        WXComponent comp = this.getRootComponent();
        if (comp != null) {
            this.fireEvent(comp.getRef(), "viewdisappear", null, null);
            for (OnInstanceVisibleListener instance : this.mVisibleListeners) {
                instance.onDisappear();
            }
        }
    }

    public void onViewAppear() {
        WXComponent comp = this.getRootComponent();
        if (comp != null) {
            this.fireEvent(comp.getRef(), "viewappear", null, null);
            for (OnInstanceVisibleListener instance : this.mVisibleListeners) {
                instance.onAppear();
            }
        }
    }

    public void onCreateFinish() {
        if (this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.onViewAppear();
                        RenderContainer wxView = WXSDKInstance.this.mRenderContainer;
                        if (WXSDKInstance.this.mRenderListener != null) {
                            WXSDKInstance.this.mRenderListener.onViewCreated(WXSDKInstance.this, (View)wxView);
                        }
                        if (WXSDKInstance.this.mStatisticsListener != null) {
                            WXSDKInstance.this.mStatisticsListener.onFirstView();
                        }
                    }
                }
            });
        }
    }

    public void onUpdateFinish() {
        WXLogUtils.d("Instance onUpdateSuccess");
    }

    public void runOnUiThread(Runnable action) {
        WXSDKManager.getInstance().postOnUiThread(action, 0L);
    }

    public void onRenderSuccess(final int width, final int height) {
        this.firstScreenRenderFinished();
        long time = System.currentTimeMillis() - this.mRenderStartTime;
        WXLogUtils.renderPerformanceLog("onRenderSuccess", time);
        WXLogUtils.renderPerformanceLog("   invokeCreateInstance", this.mWXPerformance.communicateTime);
        WXLogUtils.renderPerformanceLog("   TotalCallNativeTime", this.mWXPerformance.callNativeTime);
        WXLogUtils.renderPerformanceLog("       TotalJsonParseTime", this.mWXPerformance.parseJsonTime);
        WXLogUtils.renderPerformanceLog("   TotalBatchTime", this.mWXPerformance.batchTime);
        WXLogUtils.renderPerformanceLog("       TotalCssLayoutTime", this.mWXPerformance.cssLayoutTime);
        WXLogUtils.renderPerformanceLog("       TotalApplyUpdateTime", this.mWXPerformance.applyUpdateTime);
        WXLogUtils.renderPerformanceLog("       TotalUpdateDomObjTime", this.mWXPerformance.updateDomObjTime);
        this.mWXPerformance.totalTime = time;
        if ((double)this.mWXPerformance.screenRenderTime < 0.001) {
            this.mWXPerformance.screenRenderTime = time;
        }
        this.mWXPerformance.componentCount = WXComponent.mComponentNum;
        WXLogUtils.d("weex_perf", "mComponentNum:" + WXComponent.mComponentNum);
        WXComponent.mComponentNum = 0;
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onRenderSuccess(WXSDKInstance.this, width, height);
                        if (WXSDKInstance.this.mUserTrackAdapter != null) {
                            WXPerformance performance = new WXPerformance();
                            performance.errCode = WXErrorCode.WX_SUCCESS.getErrorCode();
                            performance.args = WXSDKInstance.this.getBundleUrl();
                            WXSDKInstance.this.mUserTrackAdapter.commit(WXSDKInstance.this.mContext, null, "jsBridge", performance, WXSDKInstance.this.getUserTrackParams());
                        }
                        WXLogUtils.d("weex_perf", WXSDKInstance.this.mWXPerformance.toString());
                    }
                }
            });
        }
        if (!WXEnvironment.isApkDebugable()) {
            WXLogUtils.e("weex_perf", this.mWXPerformance.getPerfData());
        }
    }

    public void onRefreshSuccess(final int width, final int height) {
        WXLogUtils.renderPerformanceLog("onRefreshSuccess", System.currentTimeMillis() - this.mRefreshStartTime);
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onRefreshSuccess(WXSDKInstance.this, width, height);
                    }
                }
            });
        }
    }

    public void onRenderError(final String errCode, final String msg) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onException(WXSDKInstance.this, errCode, msg);
                    }
                }
            });
        }
    }

    public void onJSException(final String errCode, final String function, final String exception) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(function);
                        builder.append(exception);
                        WXSDKInstance.this.mRenderListener.onException(WXSDKInstance.this, errCode, builder.toString());
                    }
                }
            });
        }
    }

    public final void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
            this.onLayoutChange(v);
        }
    }

    public void onLayoutChange(View godView) {
    }

    public void firstScreenCreateInstanceTime(long time) {
        if (this.mCreateInstance) {
            this.mWXPerformance.firstScreenJSFExecuteTime = time - this.mRenderStartTime;
            this.mCreateInstance = false;
        }
    }

    public void callNativeTime(long time) {
        this.mWXPerformance.callNativeTime += time;
    }

    public void jsonParseTime(long time) {
        this.mWXPerformance.parseJsonTime += time;
    }

    public void firstScreenRenderFinished() {
        if (this.mEnd) {
            return;
        }
        this.mEnd = true;
        if (this.mStatisticsListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mStatisticsListener != null && WXSDKInstance.this.mContext != null) {
                        Trace.beginSection("onFirstScreen");
                        WXSDKInstance.this.mStatisticsListener.onFirstScreen();
                        Trace.endSection();
                    }
                }
            });
        }
        this.mWXPerformance.screenRenderTime = System.currentTimeMillis() - this.mRenderStartTime;
        WXLogUtils.renderPerformanceLog("firstScreenRenderFinished", this.mWXPerformance.screenRenderTime);
        WXLogUtils.renderPerformanceLog("   firstScreenJSFExecuteTime", this.mWXPerformance.firstScreenJSFExecuteTime);
        WXLogUtils.renderPerformanceLog("   firstScreenCallNativeTime", this.mWXPerformance.callNativeTime);
        WXLogUtils.renderPerformanceLog("       firstScreenJsonParseTime", this.mWXPerformance.parseJsonTime);
        WXLogUtils.renderPerformanceLog("   firstScreenBatchTime", this.mWXPerformance.batchTime);
        WXLogUtils.renderPerformanceLog("       firstScreenCssLayoutTime", this.mWXPerformance.cssLayoutTime);
        WXLogUtils.renderPerformanceLog("       firstScreenApplyUpdateTime", this.mWXPerformance.applyUpdateTime);
        WXLogUtils.renderPerformanceLog("       firstScreenUpdateDomObjTime", this.mWXPerformance.updateDomObjTime);
    }

    public void batchTime(long time) {
        this.mWXPerformance.batchTime += time;
    }

    public void cssLayoutTime(long time) {
        this.mWXPerformance.cssLayoutTime += time;
    }

    public void applyUpdateTime(long time) {
        this.mWXPerformance.applyUpdateTime += time;
    }

    public void updateDomObjTime(long time) {
        this.mWXPerformance.updateDomObjTime += time;
    }

    public void createInstanceFinished(long time) {
        if (time > 0L) {
            this.mWXPerformance.communicateTime = time;
        }
    }

    private void destroyView(View rootView) {
        try {
            if (rootView instanceof ViewGroup) {
                ViewGroup cViewGroup = (ViewGroup)rootView;
                for (int index = 0; index < cViewGroup.getChildCount(); ++index) {
                    this.destroyView(cViewGroup.getChildAt(index));
                }
                cViewGroup.removeViews(0, ((ViewGroup)rootView).getChildCount());
                WXReflectionUtils.setValue(rootView, "mChildrenCount", 0);
            }
            if (rootView instanceof Destroyable) {
                ((Destroyable)rootView).destroy();
            }
        }
        catch (Exception e) {
            WXLogUtils.e("WXSDKInstance destroyView Exception: ", e);
        }
    }

    public synchronized void destroy() {
        if (!this.isDestroy()) {
            if (this.mRendered) {
                WXSDKManager.getInstance().destroyInstance(this.mInstanceId);
            }
            WXComponentFactory.removeComponentTypesByInstanceId(this.getInstanceId());
            if (this.mGlobalEventReceiver != null) {
                this.getContext().unregisterReceiver((BroadcastReceiver)this.mGlobalEventReceiver);
                this.mGlobalEventReceiver = null;
            }
            if (this.mRootComp != null) {
                this.mRootComp.destroy();
                this.destroyView((View)this.mRenderContainer);
                this.mRootComp = null;
            }
            if (this.mGlobalEvents != null) {
                this.mGlobalEvents.clear();
            }
            if (this.mComponentObserver != null) {
                this.mComponentObserver = null;
            }
            this.getFlatUIContext().destroy();
            this.mFlatGUIContext = null;
            this.mWXScrollListeners = null;
            this.mRenderContainer = null;
            this.mNestedInstanceInterceptor = null;
            this.mUserTrackAdapter = null;
            this.mScrollView = null;
            this.mContext = null;
            this.mRenderListener = null;
            this.isDestroy = true;
            this.mStatisticsListener = null;
            if (this.responseHeaders != null) {
                this.responseHeaders.clear();
            }
            if (this.templateRef != null) {
                this.templateRef = null;
            }
        }
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    @Nullable
    public String getBundleUrl() {
        return this.mBundleUrl;
    }

    public View getRootView() {
        return this.mRootComp.getRealView();
    }

    public View getContainerView() {
        return this.mRenderContainer;
    }

    @Deprecated
    public void setBundleUrl(String url) {
        this.mBundleUrl = url;
        if (WXSDKManager.getInstance().getValidateProcessor() != null) {
            this.mNeedValidate = WXSDKManager.getInstance().getValidateProcessor().needValidate(this.mBundleUrl);
        }
    }

    public void onRootCreated(WXComponent root) {
        this.mRootComp = root;
        this.mRenderContainer.addView((View)root.getHostView());
        this.setSize(this.mRenderContainer.getWidth(), this.mRenderContainer.getHeight());
    }

    public void moveFixedView(View fixedChild) {
        if (this.mRenderContainer != null) {
            ViewGroup parent = (ViewGroup)fixedChild.getParent();
            if (parent != null) {
                if (parent != this.mRenderContainer) {
                    parent.removeView(fixedChild);
                    this.mRenderContainer.addView(fixedChild);
                }
            } else {
                this.mRenderContainer.addView(fixedChild);
            }
        }
    }

    public void removeFixedView(View fixedChild) {
        if (this.mRenderContainer != null) {
            this.mRenderContainer.removeView(fixedChild);
        }
    }

    public synchronized List<OnWXScrollListener> getWXScrollListeners() {
        return this.mWXScrollListeners;
    }

    public synchronized void registerOnWXScrollListener(OnWXScrollListener wxScrollListener) {
        if (this.mWXScrollListeners == null) {
            this.mWXScrollListeners = new ArrayList<OnWXScrollListener>();
        }
        this.mWXScrollListeners.add(wxScrollListener);
    }

    private void updateRootComponentStyle(JSONObject style) {
        Message message = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.getInstanceId();
        if (task.args == null) {
            task.args = new ArrayList<Object>();
        }
        task.args.add("_root");
        task.args.add(style);
        message.obj = task;
        message.what = 2;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(message);
    }

    public void setSize(int width, int height) {
        ViewGroup.LayoutParams layoutParams;
        if (width < 0 || height < 0 || this.isDestroy || !this.mRendered) {
            return;
        }
        float realWidth = WXViewUtils.getWebPxByWidth(width, this.getInstanceViewPortWidth());
        float realHeight = WXViewUtils.getWebPxByWidth(height, this.getInstanceViewPortWidth());
        RenderContainer godView = this.mRenderContainer;
        if (godView != null && (layoutParams = godView.getLayoutParams()) != null) {
            if (godView.getWidth() != width || godView.getHeight() != height) {
                layoutParams.width = width;
                layoutParams.height = height;
                godView.setLayoutParams(layoutParams);
            }
            JSONObject style = new JSONObject();
            WXComponent rootComponent = this.mRootComp;
            if (rootComponent == null) {
                return;
            }
            style.put("defaultWidth", (Object)Float.valueOf(realWidth));
            style.put("defaultHeight", (Object)Float.valueOf(realHeight));
            this.updateRootComponentStyle(style);
        }
    }

    public void fireGlobalEventCallback(String eventName, Map<String, Object> params) {
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks != null) {
            for (String callback : callbacks) {
                WXSDKManager.getInstance().callback(this.mInstanceId, callback, params, true);
            }
        }
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data, Map<String, Object> domChanges, List<Object> eventArgs) {
        this.fireEvent(elementRef, type, data, domChanges, eventArgs, null);
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data, Map<String, Object> domChanges, List<Object> eventArgs, EventResult callback) {
        WXBridgeManager.getInstance().fireEventOnNode(this.getInstanceId(), elementRef, type, data, domChanges, eventArgs, callback);
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        this.fireEvent(elementRef, type, data, domChanges, null);
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data) {
        this.fireEvent(elementRef, type, data, null);
    }

    public void fireEvent(String ref, String type) {
        this.fireEvent(ref, type, new HashMap<String, Object>());
    }

    protected void addEventListener(String eventName, String callback) {
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)callback)) {
            return;
        }
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks == null) {
            callbacks = new ArrayList<String>();
            this.mGlobalEvents.put(eventName, callbacks);
        }
        callbacks.add(callback);
    }

    protected void removeEventListener(String eventName, String callback) {
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)callback)) {
            return;
        }
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks != null) {
            callbacks.remove(callback);
        }
    }

    protected void removeEventListener(String eventName) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        this.mGlobalEvents.remove(eventName);
    }

    public void fireModuleEvent(String eventName, WXModule module, Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)eventName) || module == null) {
            return;
        }
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("type", eventName);
        event.put("module", module.getModuleName());
        event.put("data", params);
        List<String> callbacks = module.getEventCallbacks(eventName);
        if (callbacks != null) {
            for (String callback : callbacks) {
                SimpleJSCallback jsCallback = new SimpleJSCallback(this.mInstanceId, callback);
                if (module.isOnce(callback)) {
                    jsCallback.invoke(event);
                    continue;
                }
                jsCallback.invokeAndKeepAlive(event);
            }
        }
    }

    public boolean checkModuleEventRegistered(String eventName, WXModule module) {
        List<String> events;
        return module != null && (events = module.getEventCallbacks(eventName)) != null && events.size() > 0;
    }

    public WXPerformance getWXPerformance() {
        return this.mWXPerformance;
    }

    public Map<String, Serializable> getUserTrackParams() {
        return this.mUserTrackParams;
    }

    public void addUserTrackParameter(String key, Serializable value) {
        if (this.mUserTrackParams == null) {
            this.mUserTrackParams = new ConcurrentHashMap<String, Serializable>();
        }
        this.mUserTrackParams.put(key, value);
    }

    public void clearUserTrackParameters() {
        if (this.mUserTrackParams != null) {
            this.mUserTrackParams.clear();
        }
    }

    public void removeUserTrackParameter(String key) {
        if (this.mUserTrackParams != null) {
            this.mUserTrackParams.remove(key);
        }
    }

    public int getMaxDeepLayer() {
        return this.mMaxDeepLayer;
    }

    public void setMaxDeepLayer(int maxDeepLayer) {
        this.mMaxDeepLayer = maxDeepLayer;
    }

    public String getTemplateInfo() {
        String template = this.getTemplate();
        if (template == null) {
            return " template md5 null " + JSONObject.toJSONString(this.responseHeaders);
        }
        if (TextUtils.isEmpty((CharSequence)template)) {
            return " template md5  length 0 " + JSONObject.toJSONString(this.responseHeaders);
        }
        try {
            byte[] bts = template.getBytes("UTF-8");
            String sourceMD5 = WXFileUtils.md5(bts);
            String sourceBase64MD5 = WXFileUtils.base64Md5(bts);
            ArrayList<String> sourceMD5List = new ArrayList<String>();
            ArrayList<String> sourceBase64MD5List = new ArrayList<String>();
            sourceMD5List.add(sourceMD5);
            sourceBase64MD5List.add(sourceBase64MD5);
            this.responseHeaders.put("templateSourceMD5", sourceMD5List);
            this.responseHeaders.put(SOURCE_TEMPLATE_BASE64_MD5, sourceBase64MD5List);
            return " template md5 " + sourceMD5 + " length " + bts.length + " base64 md5 " + sourceBase64MD5 + " response header " + JSONObject.toJSONString(this.responseHeaders);
        }
        catch (UnsupportedEncodingException e) {
            return "template md5 getBytes error";
        }
    }

    public boolean isContentMd5Match() {
        if (this.responseHeaders == null) {
            return true;
        }
        List<String> contentMD5s = this.responseHeaders.get("Content-Md5");
        if (contentMD5s == null) {
            contentMD5s = this.responseHeaders.get("content-md5");
        }
        if (contentMD5s == null || contentMD5s.size() <= 0) {
            return true;
        }
        String md5 = contentMD5s.get(0);
        List<String> sourceBase64Md5 = this.responseHeaders.get(SOURCE_TEMPLATE_BASE64_MD5);
        if (sourceBase64Md5 == null) {
            this.getTemplateInfo();
            sourceBase64Md5 = this.responseHeaders.get(SOURCE_TEMPLATE_BASE64_MD5);
        }
        if (sourceBase64Md5 == null || sourceBase64Md5.size() == 0) {
            return true;
        }
        return md5.equals(sourceBase64Md5.get(0));
    }

    public String getTemplate() {
        if (this.templateRef == null) {
            return null;
        }
        return (String)this.templateRef.get();
    }

    public void setTemplate(String template) {
        this.templateRef = new WeakReference<String>(template);
    }

    public static interface NestedInstanceInterceptor {
        public void onCreateNestInstance(WXSDKInstance var1, NestedContainer var2);
    }

    class WXHttpListener
    implements IWXHttpAdapter.OnHttpListener {
        private String pageName;
        private Map<String, Object> options;
        private String jsonInitData;
        private WXRenderStrategy flag;
        private WXSDKInstance instance;
        private long startRequestTime;
        private int traceId;

        private WXHttpListener(String pageName, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag, long startRequestTime) {
            this.pageName = pageName;
            this.options = options;
            this.jsonInitData = jsonInitData;
            this.flag = flag;
            this.startRequestTime = startRequestTime;
            this.traceId = WXTracing.nextId();
            if (WXTracing.isAvailable()) {
                WXTracing.TraceEvent event = WXTracing.newEvent("downloadBundleJS", WXSDKInstance.this.mInstanceId, -1);
                event.iid = WXSDKInstance.this.mInstanceId;
                event.tname = "Network";
                event.ph = "B";
                event.traceId = this.traceId;
                event.submit();
            }
        }

        public void setSDKInstance(WXSDKInstance instance) {
            this.instance = instance;
        }

        @Override
        public void onHttpStart() {
            if (this.instance != null && this.instance.getWXStatisticsListener() != null) {
                this.instance.getWXStatisticsListener().onHttpStart();
            }
        }

        @Override
        public void onHeadersReceived(int statusCode, Map<String, List<String>> headers) {
            if (this.instance != null && this.instance.getWXStatisticsListener() != null) {
                this.instance.getWXStatisticsListener().onHeadersReceived();
            }
            if (this.instance != null && this.instance.responseHeaders != null && headers != null) {
                this.instance.responseHeaders.putAll(headers);
            }
        }

        @Override
        public void onHttpUploadProgress(int uploadProgress) {
        }

        @Override
        public void onHttpResponseProgress(int loadedLength) {
        }

        @Override
        public void onHttpFinish(WXResponse response) {
            if (this.instance != null && this.instance.getWXStatisticsListener() != null) {
                this.instance.getWXStatisticsListener().onHttpFinish();
            }
            if (WXTracing.isAvailable()) {
                WXTracing.TraceEvent event = WXTracing.newEvent("downloadBundleJS", WXSDKInstance.this.mInstanceId, -1);
                event.traceId = this.traceId;
                event.tname = "Network";
                event.ph = "E";
                event.extParams = new HashMap<String, Object>();
                if (response != null && response.originalData != null) {
                    event.extParams.put("BundleSize", response.originalData.length);
                }
                event.submit();
            }
            ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.networkTime = System.currentTimeMillis() - this.startRequestTime;
            if (response.extendParams != null) {
                Object actualNetworkTime = response.extendParams.get("actualNetworkTime");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.actualNetworkTime = actualNetworkTime instanceof Long ? (Long)actualNetworkTime : 0L;
                WXLogUtils.renderPerformanceLog("actualNetworkTime", ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.actualNetworkTime);
                Object pureNetworkTime = response.extendParams.get("pureNetworkTime");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.pureNetworkTime = pureNetworkTime instanceof Long ? (Long)pureNetworkTime : 0L;
                WXLogUtils.renderPerformanceLog("pureNetworkTime", ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.pureNetworkTime);
                Object connectionType = response.extendParams.get("connectionType");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.connectionType = connectionType instanceof String ? (String)connectionType : "";
                Object packageSpendTime = response.extendParams.get("packageSpendTime");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.packageSpendTime = packageSpendTime instanceof Long ? (Long)packageSpendTime : 0L;
                Object syncTaskTime = response.extendParams.get("syncTaskTime");
                ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.syncTaskTime = syncTaskTime instanceof Long ? (Long)syncTaskTime : 0L;
                Object requestType = response.extendParams.get("requestType");
                String string2 = ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.requestType = requestType instanceof String ? (String)requestType : "";
                if ("network".equals(requestType) && WXSDKInstance.this.mUserTrackAdapter != null) {
                    WXPerformance performance = new WXPerformance();
                    if (!TextUtils.isEmpty((CharSequence)WXSDKInstance.this.mBundleUrl)) {
                        try {
                            performance.args = Uri.parse((String)WXSDKInstance.this.mBundleUrl).buildUpon().clearQuery().toString();
                        }
                        catch (Exception e) {
                            performance.args = this.pageName;
                        }
                    }
                    if (!"200".equals(response.statusCode)) {
                        performance.errCode = WXErrorCode.WX_ERR_JSBUNDLE_DOWNLOAD.getErrorCode();
                        performance.appendErrMsg(response.errorCode);
                        performance.appendErrMsg("|");
                        performance.appendErrMsg(response.errorMsg);
                        WXExceptionUtils.commitCriticalExceptionRT(WXSDKInstance.this.getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_JS_DOWNLOAD_FAILED.getErrorCode(), "WX_KEY_EXCEPTION_JS_DOWNLOAD_FAILED", WXErrorCode.WX_KEY_EXCEPTION_JS_DOWNLOAD_FAILED.getErrorMsg() + "\n response.errorCode=" + response.errorCode + "\n response.errorMsg=" + response.errorMsg + "\n response=" + WXSDKInstance.this.getTemplateInfo(), null);
                    } else if ("200".equals(response.statusCode) && (response.originalData == null || response.originalData.length <= 0)) {
                        performance.errCode = WXErrorCode.WX_ERR_JSBUNDLE_DOWNLOAD.getErrorCode();
                        performance.appendErrMsg(response.statusCode);
                        performance.appendErrMsg("|template is null!");
                        WXExceptionUtils.commitCriticalExceptionRT(WXSDKInstance.this.getInstanceId(), WXErrorCode.WX_KEY_EXCEPTION_JS_DOWNLOAD_FAILED.getErrorCode(), "WX_KEY_EXCEPTION_JS_DOWNLOAD_FAILED_TEMPLATE_NULL", WXErrorCode.WX_KEY_EXCEPTION_JS_DOWNLOAD_FAILED.getErrorMsg() + "\n response.errorCode=" + response.errorCode + "\n response.errorMsg=" + response.errorMsg + "\n response=" + WXSDKInstance.this.getTemplateInfo(), null);
                    } else {
                        performance.errCode = WXErrorCode.WX_SUCCESS.getErrorCode();
                    }
                    if (WXSDKInstance.this.mUserTrackAdapter != null) {
                        WXSDKInstance.this.mUserTrackAdapter.commit(WXSDKInstance.this.getContext(), null, "jsDownload", performance, null);
                    }
                }
            }
            WXLogUtils.renderPerformanceLog("networkTime", ((WXSDKInstance)WXSDKInstance.this).mWXPerformance.networkTime);
            if (response != null && response.originalData != null && TextUtils.equals((CharSequence)"200", (CharSequence)response.statusCode)) {
                String template = new String(response.originalData);
                WXSDKInstance.this.render(this.pageName, template, this.options, this.jsonInitData, this.flag);
            } else if (TextUtils.equals((CharSequence)WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_BUNDLE_CONTENTTYPE_ERROR.getDegradErrorCode(), (CharSequence)response.statusCode)) {
                WXLogUtils.e("user intercept: WX_DEGRAD_ERR_BUNDLE_CONTENTTYPE_ERROR");
                WXSDKInstance.this.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_BUNDLE_CONTENTTYPE_ERROR.getDegradErrorCode(), "|response.errorMsg==" + response.errorMsg + "|instance.getTemplateInfo == \n" + this.instance.getTemplateInfo() + "|instance bundleUrl = \n" + this.instance.getBundleUrl() + "|instance requestUrl = \n" + Uri.decode((String)requestUrl));
            } else if (response != null && response.originalData != null && TextUtils.equals((CharSequence)"-206", (CharSequence)response.statusCode)) {
                WXLogUtils.e("user intercept: WX_DEGRAD_ERR_NETWORK_CHECK_CONTENT_LENGTH_FAILED");
                WXSDKInstance.this.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_NETWORK_CHECK_CONTENT_LENGTH_FAILED.getDegradErrorCode(), WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_NETWORK_CHECK_CONTENT_LENGTH_FAILED.getDegradErrorMsg() + "|response.errorMsg==" + response.errorMsg + "|instance.getTemplateInfo == \n" + this.instance.getTemplateInfo());
            } else {
                WXSDKInstance.this.onRenderError(WXRenderErrorCode.DegradPassivityCode.WX_DEGRAD_ERR_NETWORK_BUNDLE_DOWNLOAD_FAILED.getDegradErrorCode(), response.errorMsg);
            }
        }
    }

    public static interface OnInstanceVisibleListener {
        public void onAppear();

        public void onDisappear();
    }
}

