/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list.template;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Looper;
import android.os.MessageQueue;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.ICheckBindingScroller;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXCellDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXRecyclerDomObject;
import com.taobao.weex.dom.flex.CSSLayoutContext;
import com.taobao.weex.el.parse.ArrayStack;
import com.taobao.weex.ui.component.AppearanceHelper;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.binding.Layouts;
import com.taobao.weex.ui.component.binding.Statements;
import com.taobao.weex.ui.component.helper.ScrollStartEndHelper;
import com.taobao.weex.ui.component.list.RecyclerTransform;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.template.DomTreeBuilder;
import com.taobao.weex.ui.component.list.template.TemplateCache;
import com.taobao.weex.ui.component.list.template.TemplateStickyHelper;
import com.taobao.weex.ui.component.list.template.TemplateViewHolder;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.ui.view.listview.adapter.IRecyclerAdapterListener;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.listview.adapter.WXRecyclerViewOnScrollListener;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@Component(lazyload=false)
public class WXRecyclerTemplateList
extends WXVContainer<BounceRecyclerView>
implements IRecyclerAdapterListener<TemplateViewHolder>,
IOnLoadMoreListener,
Scrollable {
    public static final String TAG = "WXRecyclerTemplateList";
    private static final String NAME_HAS_FIXED_SIZE = "hasFixedSize";
    private static final String NAME_ITEM_VIEW_CACHE_SIZE = "itemViewCacheSize";
    private static final String NAME_TEMPLATE_CACHE_SIZE = "templateCacheSize";
    private WXRecyclerDomObject mDomObject;
    protected int mLayoutType = 1;
    protected int mColumnCount = 1;
    protected float mColumnGap = 0.0f;
    protected float mColumnWidth = 0.0f;
    private float mPaddingLeft;
    private float mPaddingRight;
    private WXRecyclerViewOnScrollListener mViewOnScrollListener = new WXRecyclerViewOnScrollListener(this);
    private int mListCellCount = 0;
    private boolean mForceLoadmoreNextTime = false;
    private RecyclerView.ItemAnimator mItemAnimator;
    private int orientation = 1;
    private boolean isScrollable = true;
    private int mOffsetAccuracy = 10;
    private Point mLastReport = new Point(-1, -1);
    private boolean mHasAddScrollEvent = false;
    private JSONArray listData;
    private String listDataKey = "listData";
    private String listDataItemKey = null;
    private String listDataIndexKey = null;
    private ArrayMap<String, Integer> mTemplateViewTypes;
    private Map<String, WXCell> mTemplateSources;
    private String listDataTemplateKey = "templateType";
    private Runnable listUpdateRunnable;
    private ConcurrentHashMap<String, TemplateCache> mTemplatesCache;
    private int templateCacheSize = 2;
    private ScrollStartEndHelper mScrollStartEndHelper;
    private TemplateStickyHelper mStickyHelper;
    private ArrayMap<Integer, List<AppearanceHelper>> mAppearHelpers = new ArrayMap();
    private ArrayMap<Integer, Map<String, Map<Integer, List<Object>>>> mDisAppearWatchList = new ArrayMap();
    private ArrayStack bindIngStackContext = new ArrayStack();
    private Map bindIngMapContext = new HashMap();

    public WXRecyclerTemplateList(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
        this.initRecyclerTemplateList(instance, node, parent);
    }

    private void initRecyclerTemplateList(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        JSONArray array;
        if (node != null && node instanceof WXRecyclerDomObject) {
            this.mDomObject = (WXRecyclerDomObject)node;
            this.mDomObject.preCalculateCellWidth();
            this.mLayoutType = this.mDomObject.getLayoutType();
            this.updateRecyclerAttr();
        }
        this.mTemplateViewTypes = new ArrayMap();
        this.mTemplateViewTypes.put((Object)"", (Object)0);
        this.mTemplateSources = new HashMap<String, WXCell>();
        this.mTemplatesCache = new ConcurrentHashMap();
        this.mStickyHelper = new TemplateStickyHelper(this);
        this.orientation = this.mDomObject.getOrientation();
        this.listDataTemplateKey = WXUtils.getString(this.getDomObject().getAttrs().get("templateKey"), "templateType");
        this.listDataItemKey = WXUtils.getString(this.getDomObject().getAttrs().get("alias"), this.listDataItemKey);
        this.listDataIndexKey = WXUtils.getString(this.getDomObject().getAttrs().get("index"), this.listDataIndexKey);
        if (this.getDomObject().getAttrs().get("listData") instanceof JSONArray && (array = (JSONArray)this.getDomObject().getAttrs().get("listData")).size() > 0) {
            this.listData = array;
        }
        long start = System.currentTimeMillis();
        if (this.mDomObject != null && this.mDomObject.getCellList() != null) {
            for (int i = 0; i < this.mDomObject.getCellList().size(); ++i) {
                this.addChild(DomTreeBuilder.buildTree(this.mDomObject.getCellList().get(i), this));
            }
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "TemplateList BuildDomTree Used " + (System.currentTimeMillis() - start));
        }
    }

    @Override
    protected BounceRecyclerView initComponentHostView(@NonNull Context context) {
        BounceRecyclerView bounceRecyclerView = new BounceRecyclerView(context, this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        WXAttr attrs = this.getDomObject().getAttrs();
        String transforms = (String)attrs.get("transform");
        if (transforms != null) {
            ((WXRecyclerView)bounceRecyclerView.getInnerView()).addItemDecoration(RecyclerTransform.parseTransforms(this.getOrientation(), transforms));
        }
        this.mItemAnimator = ((WXRecyclerView)bounceRecyclerView.getInnerView()).getItemAnimator();
        if (attrs.get(NAME_TEMPLATE_CACHE_SIZE) != null) {
            this.templateCacheSize = WXUtils.getInteger(attrs.get(NAME_TEMPLATE_CACHE_SIZE), this.templateCacheSize);
        }
        boolean hasFixedSize = false;
        int itemViewCacheSize = 2;
        if (attrs.get(NAME_ITEM_VIEW_CACHE_SIZE) != null) {
            itemViewCacheSize = WXUtils.getNumberInt(this.getDomObject().getAttrs().get(NAME_ITEM_VIEW_CACHE_SIZE), itemViewCacheSize);
        }
        if (attrs.get(NAME_HAS_FIXED_SIZE) != null) {
            hasFixedSize = WXUtils.getBoolean(attrs.get(NAME_HAS_FIXED_SIZE), hasFixedSize);
        }
        RecyclerViewBaseAdapter recyclerViewBaseAdapter = new RecyclerViewBaseAdapter(this);
        recyclerViewBaseAdapter.setHasStableIds(true);
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).setItemAnimator(null);
        if (itemViewCacheSize != 2) {
            ((WXRecyclerView)bounceRecyclerView.getInnerView()).setItemViewCacheSize(itemViewCacheSize);
        }
        if (bounceRecyclerView.getSwipeLayout() != null && WXUtils.getBoolean(this.getDomObject().getAttrs().get("nestedScrollingEnabled"), false).booleanValue()) {
            bounceRecyclerView.getSwipeLayout().setNestedScrollingEnabled(true);
        }
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).setHasFixedSize(hasFixedSize);
        bounceRecyclerView.setRecyclerViewBaseAdapter(recyclerViewBaseAdapter);
        bounceRecyclerView.setOverScrollMode(2);
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).clearOnScrollListeners();
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).addOnScrollListener(this.mViewOnScrollListener);
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                List<OnWXScrollListener> listeners = WXRecyclerTemplateList.this.getInstance().getWXScrollListeners();
                if (listeners != null && listeners.size() > 0) {
                    for (OnWXScrollListener listener : listeners) {
                        View topView;
                        if (listener == null || (topView = recyclerView.getChildAt(0)) == null) continue;
                        int y = topView.getTop();
                        listener.onScrollStateChanged((View)recyclerView, 0, y, newState);
                    }
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                List<OnWXScrollListener> listeners = WXRecyclerTemplateList.this.getInstance().getWXScrollListeners();
                if (listeners != null && listeners.size() > 0) {
                    try {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            if (listener instanceof ICheckBindingScroller) {
                                if (!((ICheckBindingScroller)((Object)listener)).isNeedScroller(WXRecyclerTemplateList.this.getRef(), null)) continue;
                                listener.onScrolled((View)recyclerView, dx, dy);
                                continue;
                            }
                            listener.onScrolled((View)recyclerView, dx, dy);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        bounceRecyclerView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                BounceRecyclerView view = (BounceRecyclerView)WXRecyclerTemplateList.this.getHostView();
                if (view == null) {
                    return;
                }
                WXRecyclerTemplateList.this.mViewOnScrollListener.onScrolled((RecyclerView)view.getInnerView(), 0, 0);
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.listUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                if (WXRecyclerTemplateList.this.mStickyHelper != null) {
                    WXRecyclerTemplateList.this.mStickyHelper.getStickyPositions().clear();
                    if (WXRecyclerTemplateList.this.listData != null) {
                        for (int i = 0; i < WXRecyclerTemplateList.this.listData.size(); ++i) {
                            WXCell cell = WXRecyclerTemplateList.this.getSourceTemplate(i);
                            if (cell == null || !cell.isSticky()) continue;
                            WXRecyclerTemplateList.this.mStickyHelper.getStickyPositions().add(i);
                        }
                    }
                }
                if (WXRecyclerTemplateList.this.getHostView() != null && ((BounceRecyclerView)WXRecyclerTemplateList.this.getHostView()).getRecyclerViewBaseAdapter() != null) {
                    ((BounceRecyclerView)WXRecyclerTemplateList.this.getHostView()).getRecyclerViewBaseAdapter().notifyDataSetChanged();
                }
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(WXRecyclerTemplateList.TAG, "WXTemplateList notifyDataSetChanged");
                }
            }
        };
        return bounceRecyclerView;
    }

    @Override
    protected void onHostViewInitialized(BounceRecyclerView host) {
        super.onHostViewInitialized(host);
        WXRecyclerView recyclerView = (WXRecyclerView)host.getInnerView();
        if (recyclerView == null || recyclerView.getAdapter() == null) {
            WXLogUtils.e(TAG, "RecyclerView is not found or Adapter is not bound");
            return;
        }
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
        int weexH = WXViewUtils.getWeexHeight(this.getInstanceId());
        int outHeight = height > (weexH >= screenH ? screenH : weexH) ? weexH - this.getAbsoluteY() : height;
        return super.measure((int)((float)width + this.mColumnGap), outHeight);
    }

    @Override
    public void bindStickStyle(WXComponent component) {
        WXComponent template = this.findParentType(component, WXCell.class);
        if (template == null) {
            return;
        }
        if (this.listData == null || this.mStickyHelper == null) {
            return;
        }
        if (!this.mStickyHelper.getStickyTypes().contains(template.getRef())) {
            this.mStickyHelper.getStickyTypes().add(template.getRef());
            this.notifyUpdateList();
        }
    }

    @Override
    public void unbindStickStyle(WXComponent component) {
        WXComponent template = this.findParentType(component, WXCell.class);
        if (template == null || this.listData == null || this.mStickyHelper == null) {
            return;
        }
        if (this.mStickyHelper.getStickyTypes().contains(template.getRef())) {
            this.mStickyHelper.getStickyTypes().remove(template.getRef());
            this.notifyUpdateList();
        }
    }

    @Nullable
    private WXCell findCell(WXComponent component) {
        WXVContainer parent;
        if (component instanceof WXCell) {
            return (WXCell)component;
        }
        if (component == null || (parent = component.getParent()) == null) {
            return null;
        }
        return this.findCell(parent);
    }

    private void setAppearanceWatch(WXComponent component, int event, boolean enable) {
        if (this.listData == null || this.mAppearHelpers == null || TextUtils.isEmpty((CharSequence)component.getRef())) {
            return;
        }
        WXCell cell = this.findCell(component);
        int type = this.getCellItemType(cell);
        if (type <= 0) {
            return;
        }
        ArrayList<AppearanceHelper> mAppearListeners = (ArrayList<AppearanceHelper>)this.mAppearHelpers.get((Object)type);
        if (mAppearListeners == null) {
            mAppearListeners = new ArrayList<AppearanceHelper>();
            this.mAppearHelpers.put((Object)type, mAppearListeners);
        }
        AppearanceHelper item = null;
        for (AppearanceHelper mAppearListener : mAppearListeners) {
            if (!component.getRef().equals(mAppearListener.getAwareChild().getRef())) continue;
            item = mAppearListener;
            break;
        }
        if (item != null) {
            item.setWatchEvent(event, enable);
        } else {
            item = new AppearanceHelper(component, type);
            item.setWatchEvent(event, enable);
            mAppearListeners.add(item);
        }
    }

    @Override
    public void bindAppearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 0, true);
    }

    @Override
    public void bindDisappearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 1, true);
    }

    @Override
    public void unbindAppearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 0, false);
    }

    @Override
    public void unbindDisappearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 1, false);
    }

    @JSMethod
    public void scrollTo(int position, Map<String, Object> options) {
        if (position >= 0) {
            boolean smooth = true;
            if (options != null) {
                smooth = WXUtils.getBoolean(options.get("animated"), true);
            }
            int pos = position;
            BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.getHostView();
            if (bounceRecyclerView == null) {
                return;
            }
            WXRecyclerView view = (WXRecyclerView)bounceRecyclerView.getInnerView();
            view.scrollTo(smooth, pos, 0, this.getOrientation());
        }
    }

    @Override
    public void scrollTo(WXComponent component, Map<String, Object> options) {
        float offsetFloat = 0.0f;
        boolean smooth = true;
        int position = -1;
        int typeIndex = -1;
        if (options != null) {
            String offsetStr = options.get("offset") == null ? "0" : options.get("offset").toString();
            smooth = WXUtils.getBoolean(options.get("animated"), true);
            if (offsetStr != null) {
                try {
                    offsetFloat = WXViewUtils.getRealPxByWidth(Float.parseFloat(offsetStr), this.getInstance().getInstanceViewPortWidth());
                }
                catch (Exception e) {
                    WXLogUtils.e("Float parseFloat error :" + e.getMessage());
                }
            }
            position = WXUtils.getNumberInt(options.get("cellIndex"), -1);
            typeIndex = WXUtils.getNumberInt(options.get("typeIndex"), -1);
        }
        WXCell cell = this.findCell(component);
        if (typeIndex >= 0 && this.listData != null && component.getRef() != null) {
            int typePosition = 0;
            for (int i = 0; i < this.listData.size(); ++i) {
                WXCell template = this.getSourceTemplate(i);
                if (template == null) continue;
                if (cell.getRef().equals(template.getRef())) {
                    ++typePosition;
                }
                if (typePosition <= typeIndex) continue;
                position = i;
                break;
            }
            if (position < 0) {
                position = this.listData.size() - 1;
            }
        }
        int offset = (int)offsetFloat;
        BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.getHostView();
        if (bounceRecyclerView == null) {
            return;
        }
        if (position >= 0) {
            int pos = position;
            WXRecyclerView view = (WXRecyclerView)bounceRecyclerView.getInnerView();
            view.scrollTo(smooth, pos, offset, this.getOrientation());
        }
    }

    @Override
    public int getScrollY() {
        BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.getHostView();
        return bounceRecyclerView == null ? 0 : ((WXRecyclerView)bounceRecyclerView.getInnerView()).getScrollY();
    }

    @Override
    public int getScrollX() {
        BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.getHostView();
        return bounceRecyclerView == null ? 0 : ((WXRecyclerView)bounceRecyclerView.getInnerView()).getScrollX();
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public boolean isScrollable() {
        return this.isScrollable;
    }

    @Override
    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    @Override
    protected int getChildrenLayoutTopOffset() {
        return 0;
    }

    @Override
    public void addChild(WXComponent child, int index) {
        if (!(child instanceof WXCell)) {
            super.addChild(child, index);
        }
        if (child instanceof WXBaseRefresh) {
            return;
        }
        if (child instanceof WXCell) {
            Object templateId;
            String key;
            if (child.getDomObject() != null && child.getDomObject().getAttrs() != null && (key = WXUtils.getString(templateId = child.getDomObject().getAttrs().get("templateType"), null)) != null) {
                if (child.getDomObject() instanceof WXCellDomObject && this.getDomObject() instanceof WXRecyclerDomObject) {
                    WXCellDomObject domObject = (WXCellDomObject)child.getDomObject();
                    domObject.setRecyclerDomObject((WXRecyclerDomObject)this.getDomObject());
                }
                this.mTemplateSources.put(key, (WXCell)child);
                this.ensureSourceCellRenderWithData((WXCell)child);
                if (this.mTemplateViewTypes.get((Object)key) == null) {
                    this.mTemplateViewTypes.put((Object)key, (Object)this.mTemplateViewTypes.size());
                }
            }
            this.notifyUpdateList();
        }
    }

    @Override
    public void addSubView(View child, int index) {
    }

    @Override
    public void createChildViewAt(int index) {
        int indexToCreate = index;
        if (indexToCreate < 0 && (indexToCreate = this.childCount() - 1) < 0) {
            return;
        }
        WXComponent child = this.getChild(indexToCreate);
        if (child instanceof WXBaseRefresh) {
            child.createView();
            this.setRefreshOrLoading(child);
        }
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        this.removeFooterOrHeader(child);
        super.remove(child, destroy);
    }

    @Override
    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        RecyclerView view = (RecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        pointF.set((float)view.computeHorizontalScrollOffset(), (float)view.computeVerticalScrollOffset());
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "listData": {
                this.setListData(param);
                return true;
            }
            case "alias": {
                this.listDataItemKey = WXUtils.getString(param, this.listDataItemKey);
                return true;
            }
            case "index": {
                this.listDataIndexKey = WXUtils.getString(param, this.listDataIndexKey);
                return true;
            }
            case "templateKey": 
            case "templateType": {
                this.listDataTemplateKey = WXUtils.getString(param, "templateType");
                return true;
            }
            case "loadmoreoffset": {
                return true;
            }
            case "scrollable": {
                boolean scrollable = WXUtils.getBoolean(param, true);
                this.setScrollable(scrollable);
                return true;
            }
            case "showScrollbar": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setShowScrollbar(result);
                }
                return true;
            }
            case "itemViewCacheSize": {
                return true;
            }
            case "hasFixedSize": {
                return true;
            }
            case "offsetAccuracy": {
                int accuracy = WXUtils.getInteger(param, 10);
                this.setOffsetAccuracy(accuracy);
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="offsetAccuracy")
    public void setOffsetAccuracy(int accuracy) {
        float real = WXViewUtils.getRealPxByWidth(accuracy, this.getInstance().getInstanceViewPortWidth());
        this.mOffsetAccuracy = (int)real;
    }

    private void updateRecyclerAttr() {
        this.mColumnCount = this.mDomObject.getColumnCount();
        this.mColumnGap = this.mDomObject.getColumnGap();
        this.mColumnWidth = this.mDomObject.getColumnWidth();
        this.mPaddingLeft = this.mDomObject.getPadding().get(0);
        this.mPaddingRight = this.mDomObject.getPadding().get(2);
    }

    @WXComponentProp(name="columnWidth")
    public void setColumnWidth(int columnCount) {
        if (this.mDomObject.getColumnWidth() != this.mColumnWidth) {
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="showScrollbar")
    public void setShowScrollbar(boolean show) {
        if (this.getHostView() == null || ((BounceRecyclerView)this.getHostView()).getInnerView() == null) {
            return;
        }
        if (this.getOrientation() == 1) {
            ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).setVerticalScrollBarEnabled(show);
        } else {
            ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).setHorizontalScrollBarEnabled(show);
        }
    }

    @WXComponentProp(name="columnCount")
    public void setColumnCount(int columnCount) {
        if (this.mDomObject.getColumnCount() != this.mColumnCount) {
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="columnGap")
    public void setColumnGap(float columnGap) throws InterruptedException {
        if (this.mDomObject.getColumnGap() != this.mColumnGap) {
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        WXRecyclerView inner = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        inner.setScrollable(scrollable);
    }

    @JSMethod
    public void setListData(Object param) {
        boolean update;
        boolean bl = update = this.listData != null && this.listData != param;
        if (param instanceof JSONArray) {
            this.listData = (JSONArray)param;
        }
        if (update) {
            this.notifyUpdateList();
        }
    }

    @JSMethod
    public void appendData(JSONArray arrayObject) {
        if (this.listData == null) {
            this.listData = new JSONArray();
        }
        if (arrayObject instanceof JSONArray) {
            this.listData.addAll((Collection)arrayObject);
        }
        this.notifyUpdateList();
    }

    @JSMethod
    public void insertData(JSONObject data, int index) {
        if (data == null) {
            return;
        }
        if (this.listData == null || index >= this.listData.size()) {
            return;
        }
        this.listData.add(index, (Object)data);
        this.notifyUpdateList();
    }

    @JSMethod
    public void updateData(JSONObject data, int index) {
        if (data == null) {
            return;
        }
        if (this.listData == null || index >= this.listData.size()) {
            return;
        }
        this.listData.set(index, (Object)data);
        this.notifyUpdateList();
    }

    @JSMethod
    public void removeData(List<Integer> array) {
        if (array == null || array.size() == 0) {
            return;
        }
        int offset = 0;
        for (Integer index : array) {
            if (this.listData == null || index == null) {
                return;
            }
            if ((index = Integer.valueOf(index - offset)) >= this.listData.size()) continue;
            this.listData.remove(index.intValue());
            ++offset;
        }
        this.notifyUpdateList();
    }

    @JSMethod
    public void resetLoadmore() {
        this.mForceLoadmoreNextTime = true;
        this.mListCellCount = 0;
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        if ((props.containsKey("padding") || props.containsKey("paddingLeft") || props.containsKey("paddingRight")) && (this.mPaddingLeft != this.mDomObject.getPadding().get(0) || this.mPaddingRight != this.mDomObject.getPadding().get(2))) {
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (ScrollStartEndHelper.isScrollEvent(type) && this.getHostView() != null && ((BounceRecyclerView)this.getHostView()).getInnerView() != null && !this.mHasAddScrollEvent) {
            this.mHasAddScrollEvent = true;
            WXRecyclerView innerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            innerView.addOnScrollListener(new RecyclerView.OnScrollListener(){
                private int offsetXCorrection;
                private int offsetYCorrection;
                private boolean mFirstEvent = true;

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                    if (!layoutManager.canScrollVertically()) {
                        return;
                    }
                    int offsetX = recyclerView.computeHorizontalScrollOffset();
                    int offsetY = recyclerView.computeVerticalScrollOffset();
                    if (dx == 0 && dy == 0) {
                        this.offsetXCorrection = offsetX;
                        this.offsetYCorrection = offsetY;
                        offsetX = 0;
                        offsetY = 0;
                    } else {
                        offsetX -= this.offsetXCorrection;
                        offsetY -= this.offsetYCorrection;
                    }
                    WXRecyclerTemplateList.this.getScrollStartEndHelper().onScrolled(offsetX, offsetY);
                    if (!WXRecyclerTemplateList.this.getDomObject().getEvents().contains("scroll")) {
                        return;
                    }
                    if (this.mFirstEvent) {
                        this.mFirstEvent = false;
                        return;
                    }
                    if (WXRecyclerTemplateList.this.shouldReport(offsetX, offsetY)) {
                        WXRecyclerTemplateList.this.fireScrollEvent(recyclerView, offsetX, offsetY);
                    }
                }
            });
        }
    }

    private void fireScrollEvent(RecyclerView recyclerView, int offsetX, int offsetY) {
        this.fireEvent("scroll", this.getScrollEvent(recyclerView, offsetX, offsetY));
    }

    public Map<String, Object> getScrollEvent(RecyclerView recyclerView, int offsetX, int offsetY) {
        offsetY = -this.calcContentOffset(recyclerView);
        int contentWidth = recyclerView.getMeasuredWidth() + recyclerView.computeHorizontalScrollRange();
        int contentHeight = this.calcContentSize();
        HashMap<String, Object> event = new HashMap<String, Object>(2);
        HashMap<String, Float> contentSize = new HashMap<String, Float>(2);
        HashMap<String, Float> contentOffset = new HashMap<String, Float>(2);
        contentSize.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(contentWidth, this.getInstance().getInstanceViewPortWidth())));
        contentSize.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(contentHeight, this.getInstance().getInstanceViewPortWidth())));
        contentOffset.put("x", Float.valueOf(-WXViewUtils.getWebPxByWidth(offsetX, this.getInstance().getInstanceViewPortWidth())));
        contentOffset.put("y", Float.valueOf(-WXViewUtils.getWebPxByWidth(offsetY, this.getInstance().getInstanceViewPortWidth())));
        event.put("contentSize", contentSize);
        event.put("contentOffset", contentOffset);
        return event;
    }

    private boolean shouldReport(int offsetX, int offsetY) {
        if (this.mLastReport.x == -1 && this.mLastReport.y == -1) {
            this.mLastReport.x = offsetX;
            this.mLastReport.y = offsetY;
            return true;
        }
        int gapX = Math.abs(this.mLastReport.x - offsetX);
        int gapY = Math.abs(this.mLastReport.y - offsetY);
        if (gapX >= this.mOffsetAccuracy || gapY >= this.mOffsetAccuracy) {
            this.mLastReport.x = offsetX;
            this.mLastReport.y = offsetY;
            return true;
        }
        return false;
    }

    private boolean setRefreshOrLoading(final WXComponent child) {
        if (child instanceof WXRefresh && this.getHostView() != null) {
            ((BounceRecyclerView)this.getHostView()).setOnRefreshListener((WXRefresh)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXRecyclerTemplateList.this.getHostView()).setHeaderView(child);
                }
            }, 100L);
            return true;
        }
        if (child instanceof WXLoading && this.getHostView() != null) {
            ((BounceRecyclerView)this.getHostView()).setOnLoadingListener((WXLoading)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXRecyclerTemplateList.this.getHostView()).setFooterView(child);
                }
            }, 100L);
            return true;
        }
        return false;
    }

    private void removeFooterOrHeader(WXComponent child) {
        if (child instanceof WXLoading) {
            ((BounceRecyclerView)this.getHostView()).removeFooterView(child);
        } else if (child instanceof WXRefresh) {
            ((BounceRecyclerView)this.getHostView()).removeHeaderView(child);
        }
    }

    @Override
    public ViewGroup.LayoutParams getChildLayoutParams(WXComponent child, View hostView, int width, int height, int left, int right, int top, int bottom) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)hostView.getLayoutParams();
        if (child instanceof WXBaseRefresh && params == null) {
            params = new LinearLayout.LayoutParams(width, height);
        } else if (params == null) {
            params = new RecyclerView.LayoutParams(width, height);
        } else {
            params.width = width;
            params.height = height;
            params.setMargins(left, 0, right, 0);
        }
        return params;
    }

    @Override
    public void destroy() {
        if (this.getHostView() != null) {
            ((BounceRecyclerView)this.getHostView()).removeCallbacks(this.listUpdateRunnable);
            if (((BounceRecyclerView)this.getHostView()).getInnerView() != null) {
                ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).setAdapter(null);
            }
        }
        if (this.listData != null) {
            this.listData = null;
        }
        if (this.mStickyHelper != null) {
            this.mStickyHelper = null;
        }
        if (this.mTemplateViewTypes != null) {
            this.mTemplateViewTypes.clear();
        }
        if (this.mTemplateSources != null) {
            this.mTemplateSources.clear();
        }
        if (this.mAppearHelpers != null) {
            this.mAppearHelpers.clear();
        }
        if (this.mDisAppearWatchList != null) {
            this.mDisAppearWatchList.clear();
        }
        super.destroy();
    }

    @Override
    public void onViewRecycled(TemplateViewHolder holder) {
    }

    @Override
    public void onBindViewHolder(TemplateViewHolder templateViewHolder, int position) {
        if (templateViewHolder == null) {
            return;
        }
        WXCell component = templateViewHolder.getTemplate();
        if (component == null) {
            return;
        }
        long start = System.currentTimeMillis();
        boolean resuse = templateViewHolder.getHolderPosition() >= 0;
        templateViewHolder.setHolderPosition(position);
        Object data = this.listData.get(position);
        if (component.getRenderData() == data) {
            component.setHasLayout(true);
        } else {
            List<WXComponent> updates = Statements.doRender(component, this.getStackContextForPosition(position, data));
            Statements.doInitCompontent(updates);
            component.setRenderData(data);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, position + this.getTemplateKey(position) + " onBindViewHolder render used " + (System.currentTimeMillis() - start));
            }
            if (component.isHasLayout()) {
                resuse = true;
            }
            Layouts.doLayoutAsync(templateViewHolder, true);
            component.setHasLayout(true);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, position + this.getTemplateKey(position) + " onBindViewHolder layout used " + (System.currentTimeMillis() - start) + resuse);
            }
        }
    }

    @Override
    public TemplateViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        String template = (String)this.mTemplateViewTypes.keyAt(viewType);
        WXCell source = this.mTemplateSources.get(template);
        if (source == null) {
            FrameLayout view = new FrameLayout(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
            return new TemplateViewHolder((View)view, viewType);
        }
        TemplateCache cache = this.mTemplatesCache.get(template);
        WXCell component = null;
        boolean cacheHit = true;
        if (cache != null && cache.cells != null && cache.cells.size() > 0) {
            component = cache.cells.poll();
        }
        if (cache == null || !cache.isLoadIng) {
            this.asyncLoadTemplateCache(template);
        }
        if (component == null) {
            cacheHit = false;
            if (!source.isSourceUsed()) {
                source.setSourceUsed(true);
                this.ensureSourceCellRenderWithData(source);
                component = source;
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(TAG, template + " onCreateViewHolder source");
                }
            }
        }
        if (component == null) {
            long start = System.currentTimeMillis();
            component = (WXCell)this.copyCell(source);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, template + " onCreateViewHolder copy used " + (System.currentTimeMillis() - start));
            }
        }
        if (component.isLazy()) {
            WXRecyclerTemplateList.doInitLazyCell(component, template, false);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, template + " onCreateViewHolder  cache hit " + cacheHit + " idle init false ");
            }
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, template + " onCreateViewHolder  cache hit " + cacheHit + " idle init true");
        }
        TemplateViewHolder templateViewHolder = new TemplateViewHolder(component, viewType);
        return templateViewHolder;
    }

    private WXComponent copyCell(WXCell cell) {
        this.ensureSourceCellRenderWithData(cell);
        WXCell component = (WXCell)Statements.copyComponentTree(cell);
        if (component.getDomObject() instanceof WXCellDomObject && this.getDomObject() instanceof WXRecyclerDomObject) {
            WXCellDomObject domObject = (WXCellDomObject)component.getDomObject();
            domObject.setRecyclerDomObject((WXRecyclerDomObject)this.getDomObject());
        }
        component.setRenderData(cell.getRenderData());
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSourceCellRenderWithData(WXCell cell) {
        if (cell.getRenderData() == null && this.listData != null && this.listData.size() > 0) {
            WXRecyclerTemplateList wXRecyclerTemplateList = this;
            synchronized (wXRecyclerTemplateList) {
                if (cell.getRenderData() == null) {
                    for (int i = 0; i < this.listData.size(); ++i) {
                        if (cell != this.getSourceTemplate(i)) continue;
                        Object data = this.listData.get(i);
                        Statements.doRender(cell, this.getStackContextForPosition(i, data));
                        Layouts.doSafeLayout(cell, new CSSLayoutContext());
                        cell.setRenderData(data);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public int getItemViewType(int position) {
        int type;
        JSONObject data = this.safeGetListData(position);
        String template = data.getString(this.listDataTemplateKey);
        if (TextUtils.isEmpty((CharSequence)template)) {
            template = "";
        }
        if ((type = this.mTemplateViewTypes.indexOfKey((Object)template)) < 0) {
            type = 0;
        }
        return type;
    }

    private ArrayStack getStackContextForPosition(int position, Object item) {
        if (!this.bindIngStackContext.isEmpty()) {
            this.bindIngStackContext.getList().clear();
        }
        if (!this.bindIngMapContext.isEmpty()) {
            this.bindIngMapContext.clear();
        }
        ArrayStack stack = this.bindIngStackContext;
        Map map = this.bindIngMapContext;
        if (this.listData != null) {
            stack.push(this.listData);
            stack.push(map);
            map.put(this.listDataKey, this.listData);
            if (!TextUtils.isEmpty((CharSequence)this.listDataIndexKey)) {
                map.put(this.listDataIndexKey, position);
            }
            if (!TextUtils.isEmpty((CharSequence)this.listDataItemKey)) {
                map.put(this.listDataItemKey, item);
            } else {
                stack.push(item);
            }
        }
        return stack;
    }

    public String getTemplateKey(int position) {
        JSONObject data = this.safeGetListData(position);
        String template = data.getString(this.listDataTemplateKey);
        if (TextUtils.isEmpty((CharSequence)template)) {
            template = "";
        }
        return template;
    }

    public WXCell getSourceTemplate(int position) {
        String template = this.getTemplateKey(position);
        return this.mTemplateSources.get(template);
    }

    private int getCellItemType(WXComponent cell) {
        if (cell == null) {
            return -1;
        }
        if (cell.getDomObject() != null && cell.getDomObject().getAttrs() != null) {
            Object templateId = cell.getDomObject().getAttrs().get("templateType");
            String template = WXUtils.getString(templateId, null);
            if (template == null) {
                return 0;
            }
            int type = this.mTemplateViewTypes.indexOfKey((Object)template);
            if (type < 0) {
                return -1;
            }
            return type;
        }
        return 0;
    }

    @Override
    public int getItemCount() {
        if (this.listData == null) {
            return 0;
        }
        if (this.mTemplateViewTypes == null || this.mTemplateViewTypes.size() <= 1) {
            return 0;
        }
        if (this.mTemplateSources == null || this.mTemplateSources.size() == 0) {
            return 0;
        }
        return this.listData.size();
    }

    @Override
    public boolean onFailedToRecycleView(TemplateViewHolder holder) {
        return false;
    }

    @Override
    public long getItemId(int position) {
        if (this.getItemViewType(position) <= 0) {
            return -1L;
        }
        JSONObject data = this.safeGetListData(position);
        if (data.containsKey((Object)"itemId")) {
            String itemKey = data.getString("itemId");
            if (TextUtils.isEmpty((CharSequence)itemKey)) {
                return position;
            }
            return itemKey.hashCode();
        }
        return position;
    }

    @Override
    public void onBeforeScroll(int dx, int dy) {
        if (this.mStickyHelper != null) {
            this.mStickyHelper.onBeforeScroll(dx, dy);
        }
    }

    @Override
    public void onLoadMore(int offScreenY) {
        try {
            float offsetParsed;
            String offset = this.getDomObject().getAttrs().getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                offset = "0";
            }
            if ((float)offScreenY <= (offsetParsed = WXViewUtils.getRealPxByWidth(Integer.parseInt(offset), this.getInstance().getInstanceViewPortWidth())) && this.listData != null && (this.mListCellCount != this.listData.size() || this.mForceLoadmoreNextTime)) {
                this.fireEvent("loadmore");
                this.mListCellCount = this.listData.size();
                this.mForceLoadmoreNextTime = false;
            }
        }
        catch (Exception e) {
            WXLogUtils.d("WXRecyclerTemplateListonLoadMore :", e);
        }
    }

    @Override
    public void notifyAppearStateChange(int firstVisible, int lastVisible, int directionX, int directionY) {
        String direction;
        if (this.mAppearHelpers == null || this.mAppearHelpers.size() <= 0) {
            return;
        }
        String string = directionY > 0 ? "up" : (direction = directionY < 0 ? "down" : null);
        if (this.getOrientation() == 0 && directionX != 0) {
            direction = directionX > 0 ? "left" : "right";
        }
        RecyclerView recyclerView = (RecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        block0: for (int position = firstVisible; position <= lastVisible; ++position) {
            int type = this.getItemViewType(position);
            List helpers = (List)this.mAppearHelpers.get((Object)type);
            if (helpers == null) continue;
            for (AppearanceHelper helper : helpers) {
                Map componentDisAppearList;
                List<WXComponent> childListeners;
                if (!helper.isWatch()) continue;
                TemplateViewHolder itemHolder = (TemplateViewHolder)recyclerView.findViewHolderForAdapterPosition(position);
                if (itemHolder == null || itemHolder.getComponent() == null || (childListeners = this.findChildListByRef(itemHolder.getComponent(), helper.getAwareChild().getRef())) == null || childListeners.size() == 0) continue block0;
                Map disAppearList = (Map)this.mDisAppearWatchList.get((Object)position);
                if (disAppearList == null) {
                    disAppearList = new ArrayMap();
                    this.mDisAppearWatchList.put((Object)position, (Object)disAppearList);
                }
                if ((componentDisAppearList = (Map)disAppearList.get(helper.getAwareChild().getRef())) == null) {
                    componentDisAppearList = new ArrayMap();
                    disAppearList.put(helper.getAwareChild().getRef(), componentDisAppearList);
                }
                for (int m = 0; m < childListeners.size(); ++m) {
                    WXComponent childLisener = childListeners.get(m);
                    if (childLisener.getHostView() == null) continue;
                    boolean appear = helper.isViewVisible((View)childLisener.getHostView());
                    int key = childLisener.getHostView().hashCode();
                    if (appear) {
                        if (componentDisAppearList.containsKey(key)) continue;
                        childLisener.notifyWatchAppearDisappearEvent("appear", direction);
                        List eventArgs = null;
                        if (childLisener.getDomObject().getEvents() != null && childLisener.getDomObject().getEvents().getEventBindingArgsValues() != null && childLisener.getDomObject().getEvents().getEventBindingArgsValues().get((Object)"disappear") != null) {
                            eventArgs = (List)childLisener.getDomObject().getEvents().getEventBindingArgsValues().get((Object)"disappear");
                        }
                        componentDisAppearList.put(key, eventArgs);
                        continue;
                    }
                    if (!componentDisAppearList.containsKey(key)) continue;
                    childLisener.notifyWatchAppearDisappearEvent("disappear", direction);
                    componentDisAppearList.remove(key);
                }
            }
        }
        int count = this.getItemCount();
        for (int position = 0; position < count; ++position) {
            if (position >= firstVisible && position <= lastVisible) {
                position = lastVisible + 1;
                continue;
            }
            Map map = (Map)this.mDisAppearWatchList.get((Object)position);
            if (map == null) continue;
            WXCell template = this.mTemplateSources.get(this.getTemplateKey(position));
            if (template == null) {
                return;
            }
            Set cellWatcherEntries = map.entrySet();
            for (Map.Entry cellWatcherEntry : cellWatcherEntries) {
                Map eventWatchers;
                String ref = (String)cellWatcherEntry.getKey();
                WXComponent component = this.findChildByRef(template, ref);
                if (component == null || (eventWatchers = (Map)cellWatcherEntry.getValue()) == null || eventWatchers.size() == 0) continue;
                WXEvent events = component.getDomObject().getEvents();
                Set eventWatcherEntries = eventWatchers.entrySet();
                for (Map.Entry eventWatcherEntry : eventWatcherEntries) {
                    events.putEventBindingArgsValue("disappear", (List)eventWatcherEntry.getValue());
                    component.notifyWatchAppearDisappearEvent("disappear", direction);
                }
                eventWatchers.clear();
            }
            this.mDisAppearWatchList.remove((Object)position);
        }
    }

    private JSONObject safeGetListData(int position) {
        try {
            return this.listData.getJSONObject(position);
        }
        catch (Exception e) {
            return JSONObject.parseObject((String)"{}");
        }
    }

    private void notifyUpdateList() {
        if (this.getHostView() == null || ((BounceRecyclerView)this.getHostView()).getInnerView() == null || this.listUpdateRunnable == null) {
            return;
        }
        if (Looper.getMainLooper().getThread().getId() != Thread.currentThread().getId()) {
            ((BounceRecyclerView)this.getHostView()).removeCallbacks(this.listUpdateRunnable);
            ((BounceRecyclerView)this.getHostView()).post(this.listUpdateRunnable);
        } else {
            this.listUpdateRunnable.run();
        }
    }

    private int calcContentSize() {
        int totalHeight = 0;
        if (this.listData == null) {
            return totalHeight;
        }
        for (int i = 0; i < this.listData.size(); ++i) {
            WXCell child = this.getSourceTemplate(i);
            if (child == null) continue;
            totalHeight = (int)((float)totalHeight + child.getLayoutHeight());
        }
        return totalHeight;
    }

    private int calcContentOffset(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            View firstVisibleView;
            int firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            int offset = 0;
            for (int i = 0; i < firstVisibleItemPosition; ++i) {
                WXCell cell = this.getSourceTemplate(i);
                if (cell == null) continue;
                offset = (int)((float)offset - cell.getLayoutHeight());
            }
            if (layoutManager instanceof GridLayoutManager) {
                int spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
                offset /= spanCount;
            }
            if ((firstVisibleView = layoutManager.findViewByPosition(firstVisibleItemPosition)) != null) {
                offset += firstVisibleView.getTop();
            }
            return offset;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
            int firstVisibleItemPosition = ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null)[0];
            int offset = 0;
            for (int i = 0; i < firstVisibleItemPosition; ++i) {
                WXCell cell = this.getSourceTemplate(i);
                if (cell == null) continue;
                offset = (int)((float)offset - cell.getLayoutHeight());
            }
            offset /= spanCount;
            View firstVisibleView = layoutManager.findViewByPosition(firstVisibleItemPosition);
            if (firstVisibleView != null) {
                offset += firstVisibleView.getTop();
            }
            return offset;
        }
        return -1;
    }

    public WXComponent findParentType(WXComponent component, Class type) {
        if (component.getClass() == type) {
            return component;
        }
        if (component.getParent() != null) {
            this.findTypeParent(component.getParent(), type);
        }
        return null;
    }

    public WXComponent findChildByRef(WXComponent component, String ref) {
        if (ref.equals(component.getRef())) {
            return component;
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            for (int i = 0; i < container.getChildCount(); ++i) {
                WXComponent child = this.findChildByRef(container.getChild(i), ref);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    public List<WXComponent> findChildListByRef(WXComponent component, String ref) {
        WXComponent child = this.findChildByRef(component, ref);
        if (child == null) {
            return null;
        }
        ArrayList<WXComponent> componentList = new ArrayList<WXComponent>();
        WXVContainer container = child.getParent();
        if (container != null && !(container instanceof WXRecyclerTemplateList)) {
            for (int i = 0; i < container.getChildCount(); ++i) {
                WXComponent element = container.getChild(i);
                if (!ref.equals(element.getRef())) continue;
                componentList.add(element);
            }
        } else {
            componentList.add(child);
        }
        return componentList;
    }

    private void asyncLoadTemplateCache(final String template) {
        WXCell source;
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            if (this.listData == null || this.listData.size() == 0) {
                return;
            }
            boolean firstScreenContains = false;
            for (int i = 0; i < this.listData.size(); ++i) {
                if (!template.equals(this.getTemplateKey(i))) continue;
                firstScreenContains = true;
                break;
            }
            if (!firstScreenContains) {
                return;
            }
        }
        if ((source = this.mTemplateSources.get(template)) == null) {
            return;
        }
        TemplateCache cellCache = this.mTemplatesCache.get(template);
        if (cellCache == null) {
            cellCache = new TemplateCache();
            this.mTemplatesCache.put(template, cellCache);
        }
        if (cellCache.cells.size() > 0) {
            cellCache.isLoadIng = false;
            return;
        }
        if (cellCache.isLoadIng) {
            return;
        }
        cellCache.isLoadIng = true;
        AsyncTask<Void, Void, Void> preloadTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                TemplateCache cellCache = (TemplateCache)WXRecyclerTemplateList.this.mTemplatesCache.get(template);
                if (cellCache == null || cellCache.cells == null) {
                    return null;
                }
                while (cellCache.cells.size() < WXRecyclerTemplateList.this.templateCacheSize) {
                    WXCell component = (WXCell)WXRecyclerTemplateList.this.copyCell(source);
                    if (component == null) {
                        return null;
                    }
                    if (source.getInstance() == null || source.getInstance().isDestroy()) {
                        return null;
                    }
                    cellCache.cells.add(component);
                }
                return null;
            }

            protected void onPostExecute(Void aVoid) {
                if (source.getInstance() == null || source.getInstance().isDestroy()) {
                    return;
                }
                final TemplateCache cellCache = (TemplateCache)WXRecyclerTemplateList.this.mTemplatesCache.get(template);
                if (cellCache == null) {
                    return;
                }
                if (cellCache.cells == null || cellCache.cells.size() == 0) {
                    cellCache.isLoadIng = false;
                    return;
                }
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        if (source.getInstance() == null || source.getInstance().isDestroy()) {
                            return false;
                        }
                        ConcurrentLinkedQueue<WXCell> queue = cellCache.cells;
                        Iterator<WXCell> iterator = queue.iterator();
                        while (iterator.hasNext()) {
                            WXCell component = iterator.next();
                            if (!component.isLazy()) continue;
                            WXRecyclerTemplateList.doInitLazyCell(component, template, true);
                            return iterator.hasNext();
                        }
                        return false;
                    }
                });
                cellCache.isLoadIng = false;
            }
        };
        preloadTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private static void doInitLazyCell(WXCell component, String template, boolean inPreload) {
        if (component.isLazy()) {
            long start = System.currentTimeMillis();
            component.lazy(false);
            component.createView();
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, "doInitLazyCell idle" + inPreload + template + " createView used " + (System.currentTimeMillis() - start));
            }
            component.applyLayoutAndEvent(component);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, "doInitLazyCell idle" + inPreload + template + " apply layout used " + (System.currentTimeMillis() - start));
            }
            component.bindData(component);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(TAG, "doInitLazyCell idle" + inPreload + template + " bindData used " + (System.currentTimeMillis() - start));
            }
        }
    }

    public ScrollStartEndHelper getScrollStartEndHelper() {
        if (this.mScrollStartEndHelper == null) {
            this.mScrollStartEndHelper = new ScrollStartEndHelper(this);
        }
        return this.mScrollStartEndHelper;
    }
}

