/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.v4.util.ArrayMap;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.dom.binding.ELUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class WXEvent
extends ArrayList<String>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8186587029452440107L;
    private ArrayMap mEventBindingArgs;
    private ArrayMap<String, List<Object>> mEventBindingArgsValues;
    public static final String EVENT_KEY_TYPE = "type";
    public static final String EVENT_KEY_ARGS = "params";

    @Override
    public WXEvent clone() {
        WXEvent event = (WXEvent)super.clone();
        event.mEventBindingArgs = this.mEventBindingArgs;
        event.mEventBindingArgsValues = this.mEventBindingArgsValues;
        return event;
    }

    @Override
    public void clear() {
        if (this.mEventBindingArgs != null) {
            this.mEventBindingArgs.clear();
        }
        if (this.mEventBindingArgsValues != null) {
            this.mEventBindingArgsValues.clear();
        }
        super.clear();
    }

    public boolean remove(String o) {
        if (this.mEventBindingArgs != null) {
            this.mEventBindingArgs.remove((Object)o);
        }
        if (this.mEventBindingArgsValues != null) {
            this.mEventBindingArgsValues.remove((Object)o);
        }
        return super.remove(o);
    }

    public ArrayMap getEventBindingArgs() {
        return this.mEventBindingArgs;
    }

    public ArrayMap<String, List<Object>> getEventBindingArgsValues() {
        return this.mEventBindingArgsValues;
    }

    public void addEvent(Object event) {
        if (event instanceof CharSequence) {
            String eventName = event.toString();
            if (!this.contains(eventName)) {
                this.add(eventName);
            }
        } else if (event instanceof JSONObject) {
            JSONObject bindings = (JSONObject)event;
            String eventName = bindings.getString(EVENT_KEY_TYPE);
            Object args = bindings.get((Object)EVENT_KEY_ARGS);
            if (eventName != null) {
                this.putEventBindingArgs(eventName, args);
            }
        }
    }

    public static String getEventName(Object event) {
        if (event instanceof CharSequence) {
            return event.toString();
        }
        if (event instanceof JSONObject) {
            JSONObject bindings = (JSONObject)event;
            String eventName = bindings.getString(EVENT_KEY_TYPE);
            return eventName;
        }
        if (event == null) {
            return null;
        }
        return event.toString();
    }

    public void putEventBindingArgs(String event, Object args) {
        if (!this.contains(event)) {
            this.add(event);
        }
        if (args != null) {
            if (this.mEventBindingArgs == null) {
                this.mEventBindingArgs = new ArrayMap();
            }
            this.mEventBindingArgs.put((Object)event, ELUtils.bindingBlock(args));
        }
    }

    public void putEventBindingArgsValue(String event, List<Object> value) {
        if (this.mEventBindingArgsValues == null) {
            this.mEventBindingArgsValues = new ArrayMap();
        }
        if (value == null) {
            this.mEventBindingArgsValues.remove((Object)event);
        } else {
            this.mEventBindingArgsValues.put((Object)event, value);
        }
    }
}

