/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.os.SystemClock;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.action.AbstractAddElementAction;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.IWXRenderTask;

class RenderActionTask
implements IWXRenderTask {
    private final RenderAction mRenderTask;
    private final RenderActionContext mContext;
    private final long mStartMillis = SystemClock.uptimeMillis();

    public RenderActionTask(RenderAction action, RenderActionContext context) {
        this.mRenderTask = action;
        this.mContext = context;
    }

    @Override
    public void execute() {
        if (WXTracing.isAvailable() && this.mRenderTask instanceof TraceableAction) {
            ((TraceableAction)((Object)this.mRenderTask)).mUIQueueTime = SystemClock.uptimeMillis() - this.mStartMillis;
        }
        long start = System.currentTimeMillis();
        long uiNanos = System.nanoTime();
        this.mRenderTask.executeRender(this.mContext);
        if (WXTracing.isAvailable()) {
            uiNanos = System.nanoTime() - uiNanos;
            if (this.mRenderTask instanceof TraceableAction) {
                if (!(this.mRenderTask instanceof AbstractAddElementAction)) {
                    WXTracing.TraceEvent uiExecuteEvent = WXTracing.newEvent("UIExecute", this.mContext.getInstance().getInstanceId(), ((TraceableAction)((Object)this.mRenderTask)).mTracingEventId);
                    uiExecuteEvent.duration = Stopwatch.nanosToMillis(uiNanos);
                    uiExecuteEvent.ts = start;
                    uiExecuteEvent.submit();
                }
                ((TraceableAction)((Object)this.mRenderTask)).onFinishUIExecute();
            }
        }
    }
}

