/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils.batch;

import com.taobao.weex.utils.batch.BactchExecutor;
import com.taobao.weex.utils.batch.Interceptor;
import java.util.ArrayList;
import java.util.Iterator;

public class BatchOperationHelper
implements Interceptor {
    private BactchExecutor mExecutor;
    private ArrayList<Runnable> sRegisterTasks = new ArrayList();
    private boolean isCollecting = false;

    public BatchOperationHelper(BactchExecutor executor) {
        this.mExecutor = executor;
        executor.setInterceptor(this);
        this.isCollecting = true;
    }

    @Override
    public boolean take(Runnable runnable) {
        if (this.isCollecting) {
            this.sRegisterTasks.add(runnable);
            return true;
        }
        return false;
    }

    public void flush() {
        this.isCollecting = false;
        this.mExecutor.post(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = BatchOperationHelper.this.sRegisterTasks.iterator();
                while (iterator.hasNext()) {
                    Runnable item = (Runnable)iterator.next();
                    item.run();
                    iterator.remove();
                }
            }
        });
        this.mExecutor.setInterceptor(null);
    }
}

