/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.flat.widget;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.view.View;
import com.taobao.weex.ui.flat.FlatGUIContext;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXViewUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
abstract class BaseWidget
implements Widget {
    private BorderDrawable backgroundBorder;
    private int leftOffset;
    private int topOffset;
    private int rightOffset;
    private int bottomOffset;
    private Rect borderBox = new Rect();
    private Point offsetOfContainer = new Point();
    @NonNull
    private final FlatGUIContext context;

    BaseWidget(@NonNull FlatGUIContext context) {
        this.context = context;
    }

    @Override
    public void setLayout(int width, int height, int left, int right, int top, int bottom, Point offset) {
        this.offsetOfContainer = offset;
        this.borderBox.set(left, top, left + width, top + height);
        if (this.backgroundBorder != null) {
            this.setBackgroundAndBorder(this.backgroundBorder);
        }
        this.invalidate();
    }

    @Override
    public void setContentBox(int leftOffset, int topOffset, int rightOffset, int bottomOffset) {
        this.leftOffset = leftOffset;
        this.topOffset = topOffset;
        this.rightOffset = rightOffset;
        this.bottomOffset = bottomOffset;
        this.invalidate();
    }

    @Override
    public void setBackgroundAndBorder(@NonNull BorderDrawable backgroundBorder) {
        this.backgroundBorder = backgroundBorder;
        Rect backgroundBox = new Rect(this.borderBox);
        backgroundBox.offset(-this.borderBox.left, -this.borderBox.top);
        backgroundBorder.setBounds(backgroundBox);
        this.setCallback(backgroundBorder);
        this.invalidate();
    }

    @Override
    @NonNull
    public final Point getLocInFlatContainer() {
        return this.offsetOfContainer;
    }

    @Override
    @Nullable
    public final BorderDrawable getBackgroundAndBorder() {
        return this.backgroundBorder;
    }

    @Override
    @NonNull
    public final Rect getBorderBox() {
        return this.borderBox;
    }

    @Override
    public final void draw(@NonNull Canvas canvas) {
        canvas.save();
        WXViewUtils.clipCanvasWithinBorderBox(this, canvas);
        canvas.translate((float)this.borderBox.left, (float)this.borderBox.top);
        if (this.backgroundBorder != null) {
            this.backgroundBorder.draw(canvas);
        }
        canvas.clipRect(this.leftOffset, this.topOffset, this.borderBox.width() - this.rightOffset, this.borderBox.height() - this.bottomOffset);
        canvas.translate((float)this.leftOffset, (float)this.topOffset);
        this.onDraw(canvas);
        canvas.restore();
    }

    protected void invalidate() {
        Rect dirtyRegion = new Rect(this.borderBox);
        dirtyRegion.offset(this.offsetOfContainer.x, this.offsetOfContainer.y);
        View widgetContainer = this.context.getWidgetContainerView(this);
        if (widgetContainer != null) {
            widgetContainer.invalidate(dirtyRegion);
        }
    }

    protected void setCallback(@NonNull Drawable drawable2) {
        View widgetContainer = this.context.getWidgetContainerView(this);
        if (widgetContainer != null) {
            drawable2.setCallback((Drawable.Callback)widgetContainer);
        }
    }
}

