/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;

final class MoveElementAction
implements DOMAction,
RenderAction {
    private final String mRef;
    private final String mParentRef;
    private final int mIndex;
    private int mNewIndex;

    MoveElementAction(String ref, String parentRef, int index) {
        this.mRef = ref;
        this.mParentRef = parentRef;
        this.mIndex = index;
        this.mNewIndex = index;
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (context.isDestory()) {
            return;
        }
        WXSDKInstance instance = context.getInstance();
        WXDomObject domObject = context.getDomByRef(this.mRef);
        WXDomObject parentObject = context.getDomByRef(this.mParentRef);
        if (domObject == null || domObject.parent == null || parentObject == null || parentObject.hasNewLayout()) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_MOVEELEMENT);
            }
            return;
        }
        int index = this.mIndex;
        if (domObject.parent.equals(parentObject)) {
            if (parentObject.index(domObject) == index) {
                return;
            }
            if (domObject.parent.index(domObject) < index) {
                --index;
            }
        }
        this.mNewIndex = index;
        domObject.parent.remove(domObject);
        parentObject.add(domObject, this.mNewIndex);
        context.postRenderTask(this);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent component = context.getComponent(this.mRef);
        WXComponent newParent = context.getComponent(this.mParentRef);
        if (component == null || component.getParent() == null || newParent == null || !(newParent instanceof WXVContainer)) {
            return;
        }
        WXVContainer oldParent = component.getParent();
        oldParent.remove(component, false);
        ((WXVContainer)newParent).addChild(component, this.mNewIndex);
    }
}

