/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom.action;

import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.DOMActionContext;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.component.WXComponent;
import java.util.List;

class AddEventAction
extends TraceableAction
implements DOMAction,
RenderAction {
    private final String mRef;
    private final String mEvent;
    private WXDomObject mUpdatedDom;

    AddEventAction(String ref, String event) {
        this.mRef = ref;
        this.mEvent = event;
    }

    @Override
    public void executeDom(DOMActionContext context) {
        if (context.isDestory()) {
            return;
        }
        Stopwatch.tick();
        WXSDKInstance instance = context.getInstance();
        WXDomObject domObject = context.getDomByRef(this.mRef);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_ADDEVENT);
            }
            return;
        }
        domObject.addEvent(this.mEvent);
        this.mUpdatedDom = domObject;
        if (WXTracing.isAvailable() && this.mBeginEvent != null) {
            this.submitPerformance("addEventToDom", "X", instance.getInstanceId(), Stopwatch.tack(), Stopwatch.lastTickStamp(), true);
        }
        context.postRenderTask(this);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    @Override
    public void executeRender(RenderActionContext context) {
        WXComponent comp = context.getComponent(this.mRef);
        if (comp != null) {
            Stopwatch.tick();
            comp.updateDom(this.mUpdatedDom);
            Stopwatch.split("updateDom");
            comp.addEvent(this.mEvent);
            Stopwatch.split("addEventToComponent");
            if (WXTracing.isAvailable() && this.mBeginEvent != null) {
                List<Stopwatch.ProcessEvent> events = Stopwatch.getProcessEvents();
                for (Stopwatch.ProcessEvent event : events) {
                    this.submitPerformance(event.fname, "X", comp.getInstanceId(), event.duration, event.startMillis, true);
                }
            }
        }
    }
}

