/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.Menu;
import com.alibaba.fastjson.JSONArray;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.DOMAction;
import com.taobao.weex.dom.WXDomModule;
import com.taobao.weex.dom.action.Actions;
import com.taobao.weex.ui.module.WXTimerModule;
import com.taobao.weex.utils.WXLogUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXModuleManager {
    private static Map<String, ModuleFactory> sModuleFactoryMap = new HashMap<String, ModuleFactory>();
    private static Map<String, WXModule> sGlobalModuleMap = new HashMap<String, WXModule>();
    private static Map<String, WXDomModule> sDomModuleMap = new HashMap<String, WXDomModule>();
    private static String MONITOR_ERROR_CODE = "errCode";
    private static String MONITOR_ARG = "arg";
    private static String MONITOR_ERROR_MSG = "errMsg";
    private static Map<String, Map<String, WXModule>> sInstanceModuleMap = new ConcurrentHashMap<String, Map<String, WXModule>>();

    public static boolean registerModule(final String moduleName, final ModuleFactory factory, final boolean global) throws WXException {
        if (moduleName == null || factory == null) {
            return false;
        }
        if (TextUtils.equals((CharSequence)moduleName, (CharSequence)"dom")) {
            WXLogUtils.e("Cannot registered module with name 'dom'.");
            return false;
        }
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (sModuleFactoryMap.containsKey(moduleName)) {
                    WXLogUtils.w("WXComponentRegistry Duplicate the Module name: " + moduleName);
                }
                if (global) {
                    try {
                        Object wxModule = factory.buildInstance();
                        ((WXModule)wxModule).setModuleName(moduleName);
                        sGlobalModuleMap.put(moduleName, wxModule);
                    }
                    catch (Exception e) {
                        WXLogUtils.e(moduleName + " class must have a default constructor without params. ", e);
                    }
                }
                try {
                    WXModuleManager.registerNativeModule(moduleName, factory);
                }
                catch (WXException e) {
                    WXLogUtils.e("", e);
                }
                WXModuleManager.registerJSModule(moduleName, factory);
            }
        });
        return true;
    }

    static boolean registerNativeModule(String moduleName, ModuleFactory factory) throws WXException {
        if (factory == null) {
            return false;
        }
        try {
            sModuleFactoryMap.put(moduleName, factory);
        }
        catch (ArrayStoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    static boolean registerJSModule(String moduleName, ModuleFactory factory) {
        HashMap<String, Object> modules = new HashMap<String, Object>();
        modules.put(moduleName, factory.getMethods());
        WXSDKManager.getInstance().registerModules(modules);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args) {
        WXSDKInstance instance;
        ModuleFactory factory = sModuleFactoryMap.get(moduleStr);
        if (factory == null) {
            WXLogUtils.e("[WXModuleManager] module factory not found.");
            return null;
        }
        WXModule wxModule = WXModuleManager.findModule(instanceId, moduleStr, factory);
        if (wxModule == null) {
            return null;
        }
        wxModule.mWXSDKInstance = instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        Invoker invoker = factory.getMethodInvoker(methodStr);
        try {
            if (instance != null) {
                IWXUserTrackAdapter userTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
                if (userTrackAdapter != null) {
                    HashMap<String, Serializable> data = new HashMap<String, Serializable>();
                    data.put(MONITOR_ERROR_CODE, (Serializable)((Object)"101"));
                    data.put(MONITOR_ARG, (Serializable)((Object)(moduleStr + "." + methodStr)));
                    data.put(MONITOR_ERROR_MSG, (Serializable)((Object)instance.getBundleUrl()));
                    userTrackAdapter.commit(instance.getContext(), null, "invokeModule", null, data);
                }
                Object object = WXModuleManager.dispatchCallModuleMethod(instance, wxModule, args, invoker);
                return object;
            }
            WXLogUtils.e("callModuleMethod >>> instance is null");
            Object userTrackAdapter = null;
            return userTrackAdapter;
        }
        catch (Exception e) {
            WXLogUtils.e("callModuleMethod >>> invoke module:" + moduleStr + ", method:" + methodStr + " failed. ", e);
            Object var9_12 = null;
            return var9_12;
        }
        finally {
            if (wxModule instanceof WXDomModule || wxModule instanceof WXTimerModule) {
                wxModule.mWXSDKInstance = null;
            }
        }
    }

    private static Object dispatchCallModuleMethod(@NonNull WXSDKInstance instance, @NonNull WXModule wxModule, @NonNull JSONArray args, @NonNull Invoker invoker) throws Exception {
        if (!instance.isPreRenderMode()) {
            return instance.getNativeInvokeHelper().invoke(wxModule, invoker, args);
        }
        if (invoker.isRunOnUIThread()) {
            DOMAction moduleInvocationAction = Actions.getModuleInvocationAction(wxModule, args, invoker);
            WXSDKManager.getInstance().getWXDomManager().postAction(instance.getInstanceId(), moduleInvocationAction, false);
            return null;
        }
        return instance.getNativeInvokeHelper().invoke(wxModule, invoker, args);
    }

    private static WXModule findModule(String instanceId, String moduleStr, ModuleFactory factory) {
        WXModule wxModule = sGlobalModuleMap.get(moduleStr);
        if (wxModule == null) {
            Map<String, WXModule> moduleMap = sInstanceModuleMap.get(instanceId);
            if (moduleMap == null) {
                moduleMap = new ConcurrentHashMap<String, WXModule>();
                sInstanceModuleMap.put(instanceId, moduleMap);
            }
            if ((wxModule = moduleMap.get(moduleStr)) == null) {
                try {
                    wxModule = factory.buildInstance();
                    wxModule.setModuleName(moduleStr);
                }
                catch (Exception e) {
                    WXLogUtils.e(moduleStr + " module build instace failed.", e);
                    return null;
                }
                moduleMap.put(moduleStr, wxModule);
            }
        }
        return wxModule;
    }

    public static void onActivityCreate(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityCreate();
                    continue;
                }
                WXLogUtils.w("onActivityCreate can not find the " + key + " module");
            }
        }
    }

    public static void onActivityStart(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityStart();
                    continue;
                }
                WXLogUtils.w("onActivityStart can not find the " + key + " module");
            }
        }
    }

    public static void onActivityPause(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityPause();
                    continue;
                }
                WXLogUtils.w("onActivityPause can not find the " + key + " module");
            }
        }
    }

    public static void onActivityResume(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityResume();
                    continue;
                }
                WXLogUtils.w("onActivityResume can not find the " + key + " module");
            }
        }
    }

    public static void onActivityStop(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityStop();
                    continue;
                }
                WXLogUtils.w("onActivityStop can not find the " + key + " module");
            }
        }
    }

    public static void onActivityDestroy(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityDestroy();
                    continue;
                }
                WXLogUtils.w("onActivityDestroy can not find the " + key + " module");
            }
        }
    }

    public static boolean onActivityBack(String instanceId) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    return module.onActivityBack();
                }
                WXLogUtils.w("onActivityCreate can not find the " + key + " module");
            }
        }
        return false;
    }

    public static void onActivityResult(String instanceId, int requestCode, int resultCode, Intent data) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onActivityResult(requestCode, resultCode, data);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + key + " module");
            }
        }
    }

    public static boolean onCreateOptionsMenu(String instanceId, Menu menu) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onCreateOptionsMenu(menu);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + key + " module");
            }
        }
        return false;
    }

    public static void onRequestPermissionsResult(String instanceId, int requestCode, String[] permissions, int[] grantResults) {
        Map<String, WXModule> modules = sInstanceModuleMap.get(instanceId);
        if (modules != null) {
            for (String key : modules.keySet()) {
                WXModule module = modules.get(key);
                if (module != null) {
                    module.onRequestPermissionsResult(requestCode, permissions, grantResults);
                    continue;
                }
                WXLogUtils.w("onActivityResult can not find the " + key + " module");
            }
        }
    }

    public static void destroyInstanceModules(String instanceId) {
        sDomModuleMap.remove(instanceId);
        Map<String, WXModule> moduleMap = sInstanceModuleMap.remove(instanceId);
        if (moduleMap == null || moduleMap.size() < 1) {
            return;
        }
        for (Map.Entry<String, WXModule> entry : moduleMap.entrySet()) {
            WXModule module = entry.getValue();
            if (!(module instanceof Destroyable)) continue;
            ((Destroyable)((Object)module)).destroy();
        }
    }

    public static void createDomModule(WXSDKInstance instance) {
        if (instance != null) {
            sDomModuleMap.put(instance.getInstanceId(), new WXDomModule(instance));
        }
    }

    public static void destoryDomModule(String instanceID) {
        sDomModuleMap.remove(instanceID);
    }

    public static WXDomModule getDomModule(String instanceId) {
        return sDomModuleMap.get(instanceId);
    }

    public static void reload() {
        if (sModuleFactoryMap != null && sModuleFactoryMap.size() > 0) {
            for (Map.Entry<String, ModuleFactory> entry : sModuleFactoryMap.entrySet()) {
                WXModuleManager.registerJSModule(entry.getKey(), entry.getValue());
            }
        }
    }
}

