/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DefaultWXHttpAdapter
implements IWXHttpAdapter {
    private static final IEventReporterDelegate DEFAULT_DELEGATE = new NOPEventReportDelegate();
    private ExecutorService mExecutorService;

    private void execute(Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newFixedThreadPool(3);
        }
        this.mExecutorService.execute(runnable);
    }

    @Override
    public void sendRequest(final WXRequest request, final IWXHttpAdapter.OnHttpListener listener) {
        if (listener != null) {
            listener.onHttpStart();
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                block7: {
                    WXResponse response = new WXResponse();
                    IEventReporterDelegate reporter = DefaultWXHttpAdapter.this.getEventReporterDelegate();
                    try {
                        HttpURLConnection connection = DefaultWXHttpAdapter.this.openConnection(request, listener);
                        reporter.preConnect(connection, request.body);
                        Map<String, List<String>> headers = connection.getHeaderFields();
                        int responseCode = connection.getResponseCode();
                        if (listener != null) {
                            listener.onHeadersReceived(responseCode, headers);
                        }
                        reporter.postConnect();
                        response.statusCode = String.valueOf(responseCode);
                        if (responseCode >= 200 && responseCode <= 299) {
                            InputStream rawStream = connection.getInputStream();
                            rawStream = reporter.interpretResponseStream(rawStream);
                            response.originalData = DefaultWXHttpAdapter.this.readInputStreamAsBytes(rawStream, listener);
                        } else {
                            response.errorMsg = DefaultWXHttpAdapter.this.readInputStream(connection.getErrorStream(), listener);
                        }
                        if (listener != null) {
                            listener.onHttpFinish(response);
                        }
                    }
                    catch (IOException | IllegalArgumentException e) {
                        e.printStackTrace();
                        response.statusCode = "-1";
                        response.errorCode = "-1";
                        response.errorMsg = e.getMessage();
                        if (listener != null) {
                            listener.onHttpFinish(response);
                        }
                        if (!(e instanceof IOException)) break block7;
                        reporter.httpExchangeFailed((IOException)e);
                    }
                }
            }
        });
    }

    private HttpURLConnection openConnection(WXRequest request, IWXHttpAdapter.OnHttpListener listener) throws IOException {
        URL url = new URL(request.url);
        HttpURLConnection connection = this.createConnection(url);
        connection.setConnectTimeout(request.timeoutMs);
        connection.setReadTimeout(request.timeoutMs);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        if (request.paramMap != null) {
            Set<String> keySets = request.paramMap.keySet();
            for (String key : keySets) {
                connection.addRequestProperty(key, request.paramMap.get(key));
            }
        }
        if ("POST".equals(request.method) || "PUT".equals(request.method) || "PATCH".equals(request.method)) {
            connection.setRequestMethod(request.method);
            if (request.body != null) {
                if (listener != null) {
                    listener.onHttpUploadProgress(0);
                }
                connection.setDoOutput(true);
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                out.write(request.body.getBytes());
                out.close();
                if (listener != null) {
                    listener.onHttpUploadProgress(100);
                }
            }
        } else if (!TextUtils.isEmpty((CharSequence)request.method)) {
            connection.setRequestMethod(request.method);
        } else {
            connection.setRequestMethod("GET");
        }
        return connection;
    }

    private byte[] readInputStreamAsBytes(InputStream inputStream, IWXHttpAdapter.OnHttpListener listener) throws IOException {
        int nRead;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int readCount = 0;
        byte[] data = new byte[2048];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
            readCount += nRead;
            if (listener == null) continue;
            listener.onHttpResponseProgress(readCount);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private String readInputStream(InputStream inputStream, IWXHttpAdapter.OnHttpListener listener) throws IOException {
        int len;
        if (inputStream == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        char[] data = new char[2048];
        while ((len = localBufferedReader.read(data)) != -1) {
            builder.append(data, 0, len);
            if (listener == null) continue;
            listener.onHttpResponseProgress(builder.length());
        }
        localBufferedReader.close();
        return builder.toString();
    }

    protected HttpURLConnection createConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    @NonNull
    public IEventReporterDelegate getEventReporterDelegate() {
        return DEFAULT_DELEGATE;
    }

    private static class NOPEventReportDelegate
    implements IEventReporterDelegate {
        private NOPEventReportDelegate() {
        }

        @Override
        public void preConnect(HttpURLConnection connection, @Nullable String body) {
        }

        @Override
        public void postConnect() {
        }

        @Override
        public InputStream interpretResponseStream(@Nullable InputStream inputStream) {
            return inputStream;
        }

        @Override
        public void httpExchangeFailed(IOException e) {
        }
    }

    public static interface IEventReporterDelegate {
        public void preConnect(HttpURLConnection var1, @Nullable String var2);

        public void postConnect();

        public InputStream interpretResponseStream(@Nullable InputStream var1);

        public void httpExchangeFailed(IOException var1);
    }
}

