/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.InitConfig;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.DefaultUriAdapter;
import com.taobao.weex.adapter.DefaultWXHttpAdapter;
import com.taobao.weex.adapter.ICrashInfoReporter;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.ITracingAdapter;
import com.taobao.weex.adapter.IWXDebugAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXSoLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.navigator.IActivityNavBarSetter;
import com.taobao.weex.appfram.storage.DefaultWXStorage;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapterFactory;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXValidateProcessor;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.common.WXWorkThreadManager;
import com.taobao.weex.dom.WXDomManager;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WXSDKManager {
    private static volatile WXSDKManager sManager;
    private static AtomicInteger sInstanceId;
    private final WXDomManager mWXDomManager;
    private final WXWorkThreadManager mWXWorkThreadManager;
    private WXBridgeManager mBridgeManager;
    WXRenderManager mWXRenderManager;
    private IWXUserTrackAdapter mIWXUserTrackAdapter;
    private IWXImgLoaderAdapter mIWXImgLoaderAdapter;
    private IWXSoLoaderAdapter mIWXSoLoaderAdapter;
    private IDrawableLoader mDrawableLoader;
    private IWXHttpAdapter mIWXHttpAdapter;
    private IWXDebugAdapter mIWXDebugAdapter;
    private IActivityNavBarSetter mActivityNavBarSetter;
    private ICrashInfoReporter mCrashInfo;
    private IWXJSExceptionAdapter mIWXJSExceptionAdapter;
    private IWXStorageAdapter mIWXStorageAdapter;
    private IWXStatisticsListener mStatisticsListener;
    private URIAdapter mURIAdapter;
    private IWebSocketAdapterFactory mIWebSocketAdapterFactory;
    private ITracingAdapter mTracingAdapter;
    private WXValidateProcessor mWXValidateProcessor;
    private boolean mNeedInitV8 = true;
    private List<InstanceLifeCycleCallbacks> mLifeCycleCallbacks;
    private static final int DEFAULT_VIEWPORT_WIDTH = 750;

    private WXSDKManager() {
        this(new WXRenderManager());
    }

    private WXSDKManager(WXRenderManager renderManager) {
        this.mWXRenderManager = renderManager;
        this.mWXDomManager = new WXDomManager(this.mWXRenderManager);
        this.mBridgeManager = WXBridgeManager.getInstance();
        this.mWXWorkThreadManager = new WXWorkThreadManager();
    }

    static void initInstance(WXRenderManager renderManager) {
        sManager = new WXSDKManager(renderManager);
    }

    public void registerStatisticsListener(IWXStatisticsListener listener) {
        this.mStatisticsListener = listener;
    }

    public IWXStatisticsListener getWXStatisticsListener() {
        return this.mStatisticsListener;
    }

    public void onSDKEngineInitialize() {
        if (this.mStatisticsListener != null) {
            this.mStatisticsListener.onSDKEngineInitialize();
        }
    }

    public void setNeedInitV8(boolean need) {
        this.mNeedInitV8 = need;
    }

    public boolean needInitV8() {
        return this.mNeedInitV8;
    }

    public void takeJSHeapSnapshot(String path) {
        File file = new File(path);
        if (!file.exists() && !file.mkdir()) {
            return;
        }
        String name = String.valueOf(sInstanceId.get());
        String filename = path;
        if (!path.endsWith(File.separator)) {
            filename = filename + File.separator;
        }
        filename = filename + name;
        filename = filename + ".heapsnapshot";
        this.mBridgeManager.takeJSHeapSnapshot(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXSDKManager getInstance() {
        if (sManager != null) return sManager;
        Class<WXSDKManager> clazz = WXSDKManager.class;
        synchronized (WXSDKManager.class) {
            if (sManager != null) return sManager;
            sManager = new WXSDKManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sManager;
        }
    }

    public static int getInstanceViewPortWidth(String instanceId) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance == null) {
            return 750;
        }
        return instance.getInstanceViewPortWidth();
    }

    static void setInstance(WXSDKManager manager) {
        sManager = manager;
    }

    public IActivityNavBarSetter getActivityNavBarSetter() {
        return this.mActivityNavBarSetter;
    }

    public void setActivityNavBarSetter(IActivityNavBarSetter mActivityNavBarSetter) {
        this.mActivityNavBarSetter = mActivityNavBarSetter;
    }

    public void restartBridge() {
        this.mBridgeManager.restart();
    }

    public WXDomManager getWXDomManager() {
        return this.mWXDomManager;
    }

    public WXBridgeManager getWXBridgeManager() {
        return this.mBridgeManager;
    }

    public WXRenderManager getWXRenderManager() {
        return this.mWXRenderManager;
    }

    public WXWorkThreadManager getWXWorkThreadManager() {
        return this.mWXWorkThreadManager;
    }

    @Nullable
    public WXSDKInstance getSDKInstance(String instanceId) {
        return instanceId == null ? null : this.mWXRenderManager.getWXSDKInstance(instanceId);
    }

    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderManager.postOnUiThread(WXThread.secure(runnable), delayMillis);
    }

    public void destroy() {
        if (this.mWXDomManager != null) {
            this.mWXDomManager.destroy();
        }
        if (this.mWXWorkThreadManager != null) {
            this.mWXWorkThreadManager.destroy();
        }
    }

    @Deprecated
    public void callback(String instanceId, String funcId, Map<String, Object> data) {
        this.mBridgeManager.callback(instanceId, funcId, data);
    }

    @Deprecated
    public void callback(String instanceId, String funcId, Map<String, Object> data, boolean keepAlive) {
        this.mBridgeManager.callback(instanceId, funcId, data, keepAlive);
    }

    public void initScriptsFramework(String framework) {
        this.mBridgeManager.initScriptsFramework(framework);
    }

    public void registerComponents(List<Map<String, Object>> components) {
        this.mBridgeManager.registerComponents(components);
    }

    public void registerModules(Map<String, Object> modules) {
        this.mBridgeManager.registerModules(modules);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type) {
        this.fireEvent(instanceId, ref, type, new HashMap<String, Object>());
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> params) {
        this.fireEvent(instanceId, ref, type, params, null);
    }

    @Deprecated
    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> params, Map<String, Object> domChanges) {
        if (WXEnvironment.isApkDebugable() && Looper.getMainLooper().getThread().getId() != Thread.currentThread().getId()) {
            throw new WXRuntimeException("[WXSDKManager]  fireEvent error");
        }
        this.mBridgeManager.fireEventOnNode(instanceId, ref, type, params, domChanges);
    }

    void createInstance(WXSDKInstance instance, String code, Map<String, Object> options, String jsonInitData) {
        this.mWXRenderManager.registerInstance(instance);
        this.mBridgeManager.createInstance(instance.getInstanceId(), code, options, jsonInitData);
        if (this.mLifeCycleCallbacks != null) {
            for (InstanceLifeCycleCallbacks callbacks : this.mLifeCycleCallbacks) {
                callbacks.onInstanceCreated(instance.getInstanceId());
            }
        }
    }

    void refreshInstance(String instanceId, WXRefreshData jsonData) {
        this.mBridgeManager.refreshInstance(instanceId, jsonData);
    }

    void destroyInstance(String instanceId) {
        this.setCrashInfo("wx_current_url", "");
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXSDKManager] destroyInstance error");
        }
        if (this.mLifeCycleCallbacks != null) {
            for (InstanceLifeCycleCallbacks callbacks : this.mLifeCycleCallbacks) {
                callbacks.onInstanceDestroyed(instanceId);
            }
        }
        this.mWXRenderManager.removeRenderStatement(instanceId);
        this.mWXDomManager.removeDomStatement(instanceId);
        this.mBridgeManager.destroyInstance(instanceId);
        WXModuleManager.destroyInstanceModules(instanceId);
    }

    String generateInstanceId() {
        return String.valueOf(sInstanceId.incrementAndGet());
    }

    public IWXUserTrackAdapter getIWXUserTrackAdapter() {
        return this.mIWXUserTrackAdapter;
    }

    public IWXImgLoaderAdapter getIWXImgLoaderAdapter() {
        return this.mIWXImgLoaderAdapter;
    }

    public IDrawableLoader getDrawableLoader() {
        return this.mDrawableLoader;
    }

    public IWXJSExceptionAdapter getIWXJSExceptionAdapter() {
        return this.mIWXJSExceptionAdapter;
    }

    public void setIWXJSExceptionAdapter(IWXJSExceptionAdapter IWXJSExceptionAdapter2) {
        this.mIWXJSExceptionAdapter = IWXJSExceptionAdapter2;
    }

    @NonNull
    public IWXHttpAdapter getIWXHttpAdapter() {
        if (this.mIWXHttpAdapter == null) {
            this.mIWXHttpAdapter = new DefaultWXHttpAdapter();
        }
        return this.mIWXHttpAdapter;
    }

    @NonNull
    public URIAdapter getURIAdapter() {
        if (this.mURIAdapter == null) {
            this.mURIAdapter = new DefaultUriAdapter();
        }
        return this.mURIAdapter;
    }

    public IWXSoLoaderAdapter getIWXSoLoaderAdapter() {
        return this.mIWXSoLoaderAdapter;
    }

    void setInitConfig(InitConfig config) {
        this.mIWXDebugAdapter = config.getDebugAdapter();
        this.mIWXHttpAdapter = config.getHttpAdapter();
        this.mIWXImgLoaderAdapter = config.getImgAdapter();
        this.mDrawableLoader = config.getDrawableLoader();
        this.mIWXStorageAdapter = config.getStorageAdapter();
        this.mIWXUserTrackAdapter = config.getUtAdapter();
        this.mURIAdapter = config.getURIAdapter();
        this.mIWebSocketAdapterFactory = config.getWebSocketAdapterFactory();
        this.mIWXJSExceptionAdapter = config.getJSExceptionAdapter();
        this.mIWXSoLoaderAdapter = config.getIWXSoLoaderAdapter();
    }

    public IWXDebugAdapter getIWXDebugAdapter() {
        return this.mIWXDebugAdapter;
    }

    public IWXStorageAdapter getIWXStorageAdapter() {
        if (this.mIWXStorageAdapter == null) {
            if (WXEnvironment.sApplication != null) {
                this.mIWXStorageAdapter = new DefaultWXStorage((Context)WXEnvironment.sApplication);
            } else {
                WXLogUtils.e("WXStorageModule", "No Application context found,you should call WXSDKEngine#initialize() method in your application");
            }
        }
        return this.mIWXStorageAdapter;
    }

    public void notifyTrimMemory() {
        this.mBridgeManager.notifyTrimMemory();
    }

    public void notifySerializeCodeCache() {
        this.mBridgeManager.notifySerializeCodeCache();
    }

    @Nullable
    public IWebSocketAdapter getIWXWebSocketAdapter() {
        if (this.mIWebSocketAdapterFactory != null) {
            return this.mIWebSocketAdapterFactory.createWebSocketAdapter();
        }
        return null;
    }

    public void registerValidateProcessor(WXValidateProcessor processor) {
        this.mWXValidateProcessor = processor;
    }

    public WXValidateProcessor getValidateProcessor() {
        return this.mWXValidateProcessor;
    }

    public void setCrashInfoReporter(ICrashInfoReporter mCrashInfo) {
        this.mCrashInfo = mCrashInfo;
    }

    public void setCrashInfo(String key, String value) {
        if (this.mCrashInfo != null) {
            this.mCrashInfo.addCrashInfo(key, value);
        }
    }

    public void setTracingAdapter(ITracingAdapter adapter) {
        this.mTracingAdapter = adapter;
    }

    public ITracingAdapter getTracingAdapter() {
        return this.mTracingAdapter;
    }

    public void registerInstanceLifeCycleCallbacks(InstanceLifeCycleCallbacks callbacks) {
        if (this.mLifeCycleCallbacks == null) {
            this.mLifeCycleCallbacks = new ArrayList<InstanceLifeCycleCallbacks>();
        }
        this.mLifeCycleCallbacks.add(callbacks);
    }

    static {
        sInstanceId = new AtomicInteger(0);
    }

    public static interface InstanceLifeCycleCallbacks {
        public void onInstanceDestroyed(String var1);

        public void onInstanceCreated(String var1);
    }
}

