/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.text.TextUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class WXFileUtils {
    public static String loadFileOrAsset(String path, Context context) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            File file = new File(path);
            if (file.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    return WXFileUtils.readStreamToString(fis);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                return WXFileUtils.loadAsset(path, context);
            }
        }
        return "";
    }

    public static String loadAsset(String path, Context context) {
        if (context == null || TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(path);
            return WXFileUtils.readStreamToString(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        try {
            StringBuilder builder = new StringBuilder(inputStream.available() + 10);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] data = new char[4096];
            int len = -1;
            while ((len = bufferedReader.read(data)) > 0) {
                builder.append(data, 0, len);
            }
            String string2 = builder.toString();
            return string2;
        }
        catch (IOException e) {
            e.printStackTrace();
            WXLogUtils.e("", e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                WXLogUtils.e("WXFileUtils loadAsset: ", e);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                WXLogUtils.e("WXFileUtils loadAsset: ", e);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(String path, byte[] content, Context context) {
        if (TextUtils.isEmpty((CharSequence)path) || content == null || context == null) {
            return false;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(path);
            outStream.write(content);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            WXLogUtils.e("WXFileUtils saveFile: " + WXLogUtils.getStackTrace(e));
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

