/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.listview.ExtendedLinearLayoutManager;
import com.taobao.weex.ui.view.listview.ExtendedStaggeredGridLayoutManager;

public class WXRecyclerView
extends RecyclerView
implements WXGestureObservable {
    public static final int TYPE_LINEAR_LAYOUT = 1;
    public static final int TYPE_GRID_LAYOUT = 2;
    public static final int TYPE_STAGGERED_GRID_LAYOUT = 3;
    private WXGesture mGesture;
    private boolean scrollable = true;

    public WXRecyclerView(Context context) {
        super(context);
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public boolean postDelayed(Runnable action, long delayMillis) {
        return super.postDelayed(WXThread.secure(action), delayMillis);
    }

    public void initView(Context context, int type, int orientation) {
        this.initView(context, type, 1, 32.0f, orientation);
    }

    @TargetApi(value=16)
    public void initView(Context context, int type, int columnCount, float columnGap, int orientation) {
        if (type == 2) {
            this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, columnCount, orientation, false));
        } else if (type == 3) {
            this.setLayoutManager((RecyclerView.LayoutManager)new ExtendedStaggeredGridLayoutManager(columnCount, orientation));
        } else if (type == 1) {
            this.setLayoutManager((RecyclerView.LayoutManager)new ExtendedLinearLayoutManager(context, orientation, false));
        }
    }

    @Override
    public void registerGestureListener(@Nullable WXGesture wxGesture) {
        this.mGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.scrollable) {
            return true;
        }
        boolean result = super.onTouchEvent(event);
        if (this.mGesture != null) {
            result |= this.mGesture.onTouch((View)this, event);
        }
        return result;
    }
}

