/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.taobao.weex.ui.view.border.BorderCorner;

class BottomRightCorner
extends BorderCorner {
    BottomRightCorner(float cornerRadius, float preBorderWidth, float postBorderWidth, @NonNull RectF borderBox) {
        super(cornerRadius, preBorderWidth, postBorderWidth, borderBox, 45.0f);
    }

    @Override
    @NonNull
    protected RectF getOvalIfInnerCornerExist() {
        return new RectF(this.getBorderBox().width() - (2.0f * this.getOuterCornerRadius() - this.getPreBorderWidth() / 2.0f), this.getBorderBox().height() - (2.0f * this.getOuterCornerRadius() - this.getPostBorderWidth() / 2.0f), this.getBorderBox().width() - this.getPreBorderWidth() / 2.0f, this.getBorderBox().height() - this.getPostBorderWidth() / 2.0f);
    }

    @Override
    @NonNull
    protected RectF getOvalIfInnerCornerNotExist() {
        return new RectF(this.getBorderBox().width() - 1.5f * this.getOuterCornerRadius(), this.getBorderBox().height() - 1.5f * this.getOuterCornerRadius(), this.getBorderBox().width() - this.getOuterCornerRadius() / 2.0f, this.getBorderBox().height() - this.getOuterCornerRadius() / 2.0f);
    }

    @Override
    @NonNull
    protected PointF getRoundCornerStart() {
        return new PointF(this.getBorderBox().width() - this.getPreBorderWidth() / 2.0f, this.getBorderBox().height() - this.getOuterCornerRadius());
    }

    @Override
    @NonNull
    protected PointF getSharpCornerVertex() {
        return new PointF(this.getBorderBox().width() - this.getPreBorderWidth() / 2.0f, this.getBorderBox().height() - this.getPostBorderWidth() / 2.0f);
    }

    @Override
    @NonNull
    protected PointF getSharpCornerStart() {
        PointF pointF = this.getSharpCornerVertex();
        pointF.x = this.getBorderBox().right;
        return pointF;
    }

    @Override
    @NonNull
    protected PointF getSharpCornerEnd() {
        PointF pointF = this.getSharpCornerVertex();
        pointF.y = this.getBorderBox().height();
        return pointF;
    }

    @Override
    @NonNull
    protected PointF getRoundCornerEnd() {
        return new PointF(this.getBorderBox().width() - this.getOuterCornerRadius(), this.getBorderBox().height() - this.getPostBorderWidth() / 2.0f);
    }
}

