/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.ICheckBindingScroller;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.AppearanceHelper;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.WXStickyHelper;
import com.taobao.weex.ui.component.list.DefaultDragHelper;
import com.taobao.weex.ui.component.list.DragHelper;
import com.taobao.weex.ui.component.list.EventTrigger;
import com.taobao.weex.ui.component.list.ListComponentView;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.ui.view.listview.adapter.IRecyclerAdapterListener;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.listview.adapter.TransformItemDecoration;
import com.taobao.weex.ui.view.listview.adapter.WXRecyclerViewOnScrollListener;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BasicListComponent<T extends ViewGroup>
extends WXVContainer<T>
implements IRecyclerAdapterListener<ListBaseViewHolder>,
IOnLoadMoreListener,
Scrollable {
    public static final String TRANSFORM = "transform";
    public static final String LOADMOREOFFSET = "loadmoreoffset";
    private String TAG = "BasicListComponent";
    private int mListCellCount = 0;
    private boolean mForceLoadmoreNextTime = false;
    private static final Pattern transformPattern = Pattern.compile("([a-z]+)\\(([0-9\\.]+),?([0-9\\.]+)?\\)");
    private Map<String, AppearanceHelper> mAppearComponents = new HashMap<String, AppearanceHelper>();
    private boolean isScrollable = true;
    private ArrayMap<String, Long> mRefToViewType;
    private SparseArray<ArrayList<WXComponent>> mViewTypes;
    private WXRecyclerViewOnScrollListener mViewOnScrollListener = new WXRecyclerViewOnScrollListener(this);
    private static final int MAX_VIEWTYPE_ALLOW_CACHE = 9;
    private static boolean mAllowCacheViewHolder = true;
    private static boolean mDownForBidCacheViewHolder = false;
    protected int mLayoutType = 1;
    protected int mColumnCount = 1;
    protected float mColumnGap = 0.0f;
    protected float mColumnWidth = 0.0f;
    private int mOffsetAccuracy = 10;
    private Point mLastReport = new Point(-1, -1);
    private RecyclerView.ItemAnimator mItemAnimator;
    private DragHelper mDragHelper;
    private static final String EXCLUDED = "dragExcluded";
    private static final String DRAG_TRIGGER_TYPE = "dragTriggerType";
    private static final String DEFAULT_TRIGGER_TYPE = "longpress";
    private static final boolean DEFAULT_EXCLUDED = false;
    private static final String DRAG_ANCHOR = "dragAnchor";
    private String mTriggerType;
    private Map<String, Map<String, WXComponent>> mStickyMap = new HashMap<String, Map<String, WXComponent>>();
    private WXStickyHelper stickyHelper = new WXStickyHelper(this);

    public BasicListComponent(WXSDKInstance instance, WXDomObject node, WXVContainer parent) {
        super(instance, node, parent);
    }

    @Override
    protected void onHostViewInitialized(T host) {
        super.onHostViewInitialized(host);
        WXRecyclerView recyclerView = ((ListComponentView)host).getInnerView();
        if (recyclerView == null || recyclerView.getAdapter() == null) {
            WXLogUtils.e(this.TAG, "RecyclerView is not found or Adapter is not bound");
            return;
        }
        if (this.mChildren == null) {
            WXLogUtils.e(this.TAG, "children is null");
            return;
        }
        this.mDragHelper = new DefaultDragHelper(this.mChildren, recyclerView, new EventTrigger(){

            @Override
            public void triggerEvent(String type, Map<String, Object> args) {
                BasicListComponent.this.fireEvent(type, args);
            }
        });
        this.mTriggerType = this.getTriggerType(this.getDomObject());
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
        int weexH = WXViewUtils.getWeexHeight(this.getInstanceId());
        int outHeight = height > (weexH >= screenH ? screenH : weexH) ? weexH - this.getAbsoluteY() : height;
        return super.measure((int)((float)width + this.mColumnGap), outHeight);
    }

    @Override
    public int getOrientation() {
        return 1;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mStickyMap != null) {
            this.mStickyMap.clear();
        }
        if (this.mViewTypes != null) {
            this.mViewTypes.clear();
        }
        if (this.mRefToViewType != null) {
            this.mRefToViewType.clear();
        }
    }

    @Override
    public ViewGroup.LayoutParams getChildLayoutParams(WXComponent child, View hostView, int width, int height, int left, int right, int top, int bottom) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)hostView.getLayoutParams();
        if (child instanceof WXBaseRefresh && params == null) {
            params = new LinearLayout.LayoutParams(width, height);
        } else if (params == null) {
            params = new RecyclerView.LayoutParams(width, height);
        } else {
            params.width = width;
            params.height = height;
            params.setMargins(left, 0, right, 0);
        }
        return params;
    }

    private RecyclerView.ItemDecoration parseTransforms(String raw) {
        if (raw == null) {
            return null;
        }
        float scaleX = 0.0f;
        float scaleY = 0.0f;
        int translateX = 0;
        int translateY = 0;
        float opacity = 0.0f;
        int rotate = 0;
        Matcher matcher = transformPattern.matcher(raw);
        while (matcher.find()) {
            String match = matcher.group();
            String name = matcher.group(1);
            try {
                switch (name) {
                    case "scale": {
                        scaleX = Float.parseFloat(matcher.group(2));
                        scaleY = Float.parseFloat(matcher.group(3));
                        break;
                    }
                    case "translate": {
                        translateX = Integer.parseInt(matcher.group(2));
                        translateY = Integer.parseInt(matcher.group(3));
                        break;
                    }
                    case "opacity": {
                        opacity = Float.parseFloat(matcher.group(2));
                        break;
                    }
                    case "rotate": {
                        rotate = Integer.parseInt(matcher.group(2));
                        break;
                    }
                    default: {
                        WXLogUtils.e(this.TAG, "Invaild transform expression:" + match);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                WXLogUtils.e("", e);
                WXLogUtils.e(this.TAG, "Invaild transform expression:" + match);
            }
        }
        return new TransformItemDecoration(this.getOrientation() == 1, opacity, translateX, translateY, rotate, scaleX, scaleY);
    }

    abstract T generateListView(Context var1, int var2);

    @Override
    protected T initComponentHostView(@NonNull Context context) {
        T bounceRecyclerView = this.generateListView(context, this.getOrientation());
        String transforms = (String)this.getDomObject().getAttrs().get(TRANSFORM);
        if (transforms != null) {
            ((ListComponentView)bounceRecyclerView).getInnerView().addItemDecoration(this.parseTransforms(transforms));
        }
        this.mItemAnimator = ((ListComponentView)bounceRecyclerView).getInnerView().getItemAnimator();
        RecyclerViewBaseAdapter recyclerViewBaseAdapter = new RecyclerViewBaseAdapter(this);
        recyclerViewBaseAdapter.setHasStableIds(true);
        ((ListComponentView)bounceRecyclerView).setRecyclerViewBaseAdapter(recyclerViewBaseAdapter);
        bounceRecyclerView.setOverScrollMode(2);
        ((ListComponentView)bounceRecyclerView).getInnerView().clearOnScrollListeners();
        ((ListComponentView)bounceRecyclerView).getInnerView().addOnScrollListener(this.mViewOnScrollListener);
        ((ListComponentView)bounceRecyclerView).getInnerView().addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                List<OnWXScrollListener> listeners = BasicListComponent.this.getInstance().getWXScrollListeners();
                if (listeners != null && listeners.size() > 0) {
                    for (OnWXScrollListener listener : listeners) {
                        View topView;
                        if (listener == null || (topView = recyclerView.getChildAt(0)) == null) continue;
                        int y = topView.getTop();
                        listener.onScrollStateChanged((View)recyclerView, 0, y, newState);
                    }
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                List<OnWXScrollListener> listeners = BasicListComponent.this.getInstance().getWXScrollListeners();
                if (listeners != null && listeners.size() > 0) {
                    try {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            if (listener instanceof ICheckBindingScroller) {
                                if (!((ICheckBindingScroller)((Object)listener)).isNeedScroller(BasicListComponent.this.getRef(), null)) continue;
                                listener.onScrolled((View)recyclerView, dx, dy);
                                continue;
                            }
                            listener.onScrolled((View)recyclerView, dx, dy);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        bounceRecyclerView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                ViewGroup view = (ViewGroup)BasicListComponent.this.getHostView();
                if (view == null) {
                    return;
                }
                BasicListComponent.this.mViewOnScrollListener.onScrolled(((ListComponentView)view).getInnerView(), 0, 0);
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        return bounceRecyclerView;
    }

    @Override
    public void bindStickStyle(WXComponent component) {
        this.stickyHelper.bindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void unbindStickStyle(WXComponent component) {
        this.stickyHelper.unbindStickStyle(component, this.mStickyMap);
    }

    @Nullable
    private WXComponent findDirectListChild(WXComponent comp) {
        WXVContainer parent;
        if (comp == null || (parent = comp.getParent()) == null) {
            return null;
        }
        if (parent instanceof BasicListComponent) {
            return comp;
        }
        return this.findDirectListChild(parent);
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "loadmoreoffset": {
                return true;
            }
            case "scrollable": {
                boolean scrollable = WXUtils.getBoolean(param, true);
                this.setScrollable(scrollable);
                return true;
            }
            case "offsetAccuracy": {
                int accuracy = WXUtils.getInteger(param, 10);
                this.setOffsetAccuracy(accuracy);
                return true;
            }
            case "draggable": {
                boolean draggable = WXUtils.getBoolean(param, false);
                this.setDraggable(draggable);
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        this.isScrollable = scrollable;
        WXRecyclerView inner = ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView();
        if (inner != null) {
            inner.setScrollable(scrollable);
        }
    }

    @WXComponentProp(name="offsetAccuracy")
    public void setOffsetAccuracy(int accuracy) {
        float real = WXViewUtils.getRealPxByWidth(accuracy, this.getInstance().getInstanceViewPortWidth());
        this.mOffsetAccuracy = (int)real;
    }

    @WXComponentProp(name="draggable")
    public void setDraggable(boolean isDraggable) {
        if (this.mDragHelper != null) {
            this.mDragHelper.setDraggable(isDraggable);
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("set draggable : " + isDraggable);
        }
    }

    @Override
    public boolean isScrollable() {
        return this.isScrollable;
    }

    private void setAppearanceWatch(WXComponent component, int event, boolean enable) {
        WXComponent dChild;
        int index;
        AppearanceHelper item = this.mAppearComponents.get(component.getRef());
        if (item != null) {
            item.setWatchEvent(event, enable);
        } else if (enable && (index = this.mChildren.indexOf(dChild = this.findDirectListChild(component))) != -1) {
            item = new AppearanceHelper(component, index);
            item.setWatchEvent(event, true);
            this.mAppearComponents.put(component.getRef(), item);
        }
    }

    @Override
    public void bindAppearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 0, true);
    }

    @Override
    public void bindDisappearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 1, true);
    }

    @Override
    public void unbindAppearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 0, false);
    }

    @Override
    public void unbindDisappearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 1, false);
    }

    @Override
    public void scrollTo(WXComponent component, Map<String, Object> options) {
        float offsetFloat = 0.0f;
        boolean smooth = true;
        if (options != null) {
            String offsetStr = options.get("offset") == null ? "0" : options.get("offset").toString();
            smooth = WXUtils.getBoolean(options.get("animated"), true);
            if (offsetStr != null) {
                try {
                    offsetFloat = WXViewUtils.getRealPxByWidth(Float.parseFloat(offsetStr), this.getInstance().getInstanceViewPortWidth());
                }
                catch (Exception e) {
                    WXLogUtils.e("Float parseFloat error :" + e.getMessage());
                }
            }
        }
        final int offset = (int)offsetFloat;
        ViewGroup bounceRecyclerView = (ViewGroup)this.getHostView();
        if (bounceRecyclerView == null) {
            return;
        }
        WXCell cell = null;
        for (WXComponent parent = component; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof WXCell)) continue;
            cell = (WXCell)parent;
            break;
        }
        if (cell != null) {
            int pos = this.mChildren.indexOf(cell);
            if (pos == -1) {
                return;
            }
            WXRecyclerView view = ((ListComponentView)bounceRecyclerView).getInnerView();
            if (!smooth) {
                RecyclerView.LayoutManager layoutManager = view.getLayoutManager();
                if (layoutManager instanceof LinearLayoutManager) {
                    ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(pos, -offset);
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    ((StaggeredGridLayoutManager)layoutManager).scrollToPositionWithOffset(pos, -offset);
                }
            } else {
                view.smoothScrollToPosition(pos);
                if (offset != 0) {
                    view.addOnScrollListener(new RecyclerView.OnScrollListener(){

                        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                            if (newState == 0) {
                                if (BasicListComponent.this.getOrientation() == 1) {
                                    recyclerView.smoothScrollBy(0, offset);
                                } else {
                                    recyclerView.smoothScrollBy(offset, 0);
                                }
                                recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public void onBeforeScroll(int dx, int dy) {
        ViewGroup bounceRecyclerView = (ViewGroup)this.getHostView();
        if (this.mStickyMap == null || bounceRecyclerView == null) {
            return;
        }
        Map<String, WXComponent> stickyMap = this.mStickyMap.get(this.getRef());
        if (stickyMap == null) {
            return;
        }
        Iterator<Map.Entry<String, WXComponent>> iterator = stickyMap.entrySet().iterator();
        int currentStickyPos = -1;
        while (iterator.hasNext()) {
            boolean removeSticky;
            Map.Entry<String, WXComponent> entry = iterator.next();
            WXComponent stickyComponent = entry.getValue();
            if (stickyComponent == null || stickyComponent.getDomObject() == null || !(stickyComponent instanceof WXCell)) continue;
            WXCell cell = (WXCell)stickyComponent;
            if (cell.getHostView() == null) {
                return;
            }
            boolean beforeFirstVisibleItem = false;
            boolean removeOldSticky = false;
            RecyclerView.LayoutManager layoutManager = ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView().getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager || layoutManager instanceof GridLayoutManager) {
                int fVisible = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                int pos = this.mChildren.indexOf(cell);
                cell.setScrollPositon(pos);
                if (pos <= fVisible) {
                    beforeFirstVisibleItem = true;
                    if (pos > currentStickyPos) {
                        currentStickyPos = pos;
                    }
                }
                if (pos > fVisible) {
                    removeOldSticky = true;
                }
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                int[] firstItems = new int[3];
                int fVisible = ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(firstItems)[0];
                int pos = this.mChildren.indexOf(cell);
                if (pos <= fVisible) {
                    beforeFirstVisibleItem = true;
                }
                if (pos > fVisible) {
                    removeOldSticky = true;
                }
            }
            int[] location = new int[2];
            stickyComponent.getHostView().getLocationOnScreen(location);
            int[] parentLocation = new int[2];
            stickyComponent.getParentScroller().getView().getLocationOnScreen(parentLocation);
            int top = location[1] - parentLocation[1];
            boolean showSticky = beforeFirstVisibleItem && cell.getLocationFromStart() >= 0 && top <= 0 && dy >= 0;
            boolean bl = removeSticky = cell.getLocationFromStart() <= 0 && top > 0 && dy <= 0;
            if (showSticky) {
                ((ListComponentView)bounceRecyclerView).notifyStickyShow(cell);
            } else if (removeSticky || removeOldSticky) {
                ((ListComponentView)bounceRecyclerView).notifyStickyRemove(cell);
            }
            cell.setLocationFromStart(top);
        }
        if (currentStickyPos >= 0) {
            ((ListComponentView)bounceRecyclerView).updateStickyView(currentStickyPos);
        }
    }

    @Override
    public int getScrollY() {
        ViewGroup bounceRecyclerView = (ViewGroup)this.getHostView();
        return bounceRecyclerView == null ? 0 : ((ListComponentView)bounceRecyclerView).getInnerView().getScrollY();
    }

    @Override
    public int getScrollX() {
        ViewGroup bounceRecyclerView = (ViewGroup)this.getHostView();
        return bounceRecyclerView == null ? 0 : ((ListComponentView)bounceRecyclerView).getInnerView().getScrollX();
    }

    @Override
    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    @Override
    protected int getChildrenLayoutTopOffset() {
        return 0;
    }

    @Override
    public void addChild(WXComponent child, int index) {
        super.addChild(child, index);
        if (child == null || index < -1) {
            return;
        }
        int count = this.mChildren.size();
        index = index >= count ? -1 : index;
        this.bindViewType(child);
        int adapterPosition = index == -1 ? this.mChildren.size() - 1 : index;
        ViewGroup view = (ViewGroup)this.getHostView();
        if (view != null) {
            Object attr;
            Object attr2;
            boolean isAddAnimation = false;
            ImmutableDomObject domObject = child.getDomObject();
            if (domObject != null && "default".equals(attr2 = domObject.getAttrs().get("insertAnimation"))) {
                isAddAnimation = true;
            }
            if (isAddAnimation) {
                ((ListComponentView)view).getInnerView().setItemAnimator(this.mItemAnimator);
            } else {
                ((ListComponentView)view).getInnerView().setItemAnimator(null);
            }
            boolean isKeepScrollPosition = false;
            if (child.getDomObject() != null && WXUtils.getBoolean(attr = child.getDomObject().getAttrs().get("keepScrollPosition"), false).booleanValue() && index <= this.getChildCount() && index > -1) {
                isKeepScrollPosition = true;
            }
            if (isKeepScrollPosition) {
                int last = ((LinearLayoutManager)((ListComponentView)view).getInnerView().getLayoutManager()).findLastVisibleItemPosition();
                ((ListComponentView)view).getInnerView().getLayoutManager().scrollToPosition(last);
                ((ListComponentView)view).getRecyclerViewBaseAdapter().notifyItemInserted(adapterPosition);
            } else {
                ((ListComponentView)view).getRecyclerViewBaseAdapter().notifyItemChanged(adapterPosition);
            }
        }
        this.relocateAppearanceHelper();
    }

    private void relocateAppearanceHelper() {
        for (Map.Entry<String, AppearanceHelper> item : this.mAppearComponents.entrySet()) {
            AppearanceHelper value = item.getValue();
            WXComponent dChild = this.findDirectListChild(value.getAwareChild());
            int index = this.mChildren.indexOf(dChild);
            value.setCellPosition(index);
        }
    }

    @Override
    protected void addSubView(View child, int index) {
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        Object attr;
        int index = this.mChildren.indexOf(child);
        if (destroy) {
            child.detachViewAndClearPreInfo();
        }
        this.unBindViewType(child);
        ViewGroup view = (ViewGroup)this.getHostView();
        if (view == null) {
            return;
        }
        boolean isRemoveAnimation = false;
        ImmutableDomObject domObject = child.getDomObject();
        if (domObject != null && "default".equals(attr = domObject.getAttrs().get("deleteAnimation"))) {
            isRemoveAnimation = true;
        }
        if (isRemoveAnimation) {
            ((ListComponentView)view).getInnerView().setItemAnimator(this.mItemAnimator);
        } else {
            ((ListComponentView)view).getInnerView().setItemAnimator(null);
        }
        ((ListComponentView)view).getRecyclerViewBaseAdapter().notifyItemRemoved(index);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "removeChild child at " + index);
        }
        super.remove(child, destroy);
    }

    @Override
    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        WXRecyclerView view = ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView();
        pointF.set((float)view.computeHorizontalScrollOffset(), (float)view.computeVerticalScrollOffset());
    }

    @Override
    public void onViewRecycled(ListBaseViewHolder holder) {
        long begin = System.currentTimeMillis();
        holder.setComponentUsing(false);
        if (holder != null && holder.canRecycled() && holder.getComponent() != null && !holder.getComponent().isUsing()) {
            holder.recycled();
        } else {
            WXLogUtils.w(this.TAG, "this holder can not be allowed to  recycled");
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "Recycle holder " + (System.currentTimeMillis() - begin) + "  Thread:" + Thread.currentThread().getName());
        }
    }

    @Override
    public void onBindViewHolder(final ListBaseViewHolder holder, int position) {
        if (holder == null) {
            return;
        }
        holder.setComponentUsing(true);
        WXComponent component = this.getChild(position);
        if (component == null || component instanceof WXRefresh || component instanceof WXLoading || component.getDomObject() != null && component.getDomObject().isFixed()) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d(this.TAG, "Bind WXRefresh & WXLoading " + (Object)((Object)holder));
            }
            if (component instanceof WXBaseRefresh && holder.getView() != null && component.getDomObject() != null && component.getDomObject().getAttrs().get("holderBackground") != null) {
                Object holderBackground = component.getDomObject().getAttrs().get("holderBackground");
                int color = WXResourceUtils.getColor(holderBackground.toString(), -1);
                holder.getView().setBackgroundColor(color);
                holder.getView().setVisibility(0);
                holder.getView().postInvalidate();
            }
            return;
        }
        if (holder.getComponent() != null && holder.getComponent() instanceof WXCell) {
            if (holder.isRecycled()) {
                holder.bindData(component);
                component.onRenderFinish(1);
            }
            if (this.mDragHelper == null || !this.mDragHelper.isDraggable()) {
                return;
            }
            this.mTriggerType = this.mTriggerType == null ? DEFAULT_TRIGGER_TYPE : this.mTriggerType;
            WXCell cell = (WXCell)holder.getComponent();
            boolean isExcluded = false;
            if (cell.getDomObject() != null) {
                WXAttr cellAttrs = cell.getDomObject().getAttrs();
                isExcluded = WXUtils.getBoolean(cellAttrs.get(EXCLUDED), false);
            }
            this.mDragHelper.setDragExcluded(holder, isExcluded);
            if ("pan".equals(this.mTriggerType)) {
                this.mDragHelper.setLongPressDragEnabled(false);
                WXComponent anchorComponent = this.findComponentByAnchorName(cell, DRAG_ANCHOR);
                if (anchorComponent != null && anchorComponent.getHostView() != null && !isExcluded) {
                    Object anchor = anchorComponent.getHostView();
                    anchor.setOnTouchListener(new View.OnTouchListener(){

                        public boolean onTouch(View v, MotionEvent event) {
                            if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0) {
                                BasicListComponent.this.mDragHelper.startDrag(holder);
                            }
                            return true;
                        }
                    });
                } else if (WXEnvironment.isApkDebugable()) {
                    if (!isExcluded) {
                        WXLogUtils.e(this.TAG, "[error] onBindViewHolder: the anchor component or view is not found");
                    } else {
                        WXLogUtils.d(this.TAG, "onBindViewHolder: position " + position + " is drag excluded");
                    }
                }
            } else if (DEFAULT_TRIGGER_TYPE.equals(this.mTriggerType)) {
                this.mDragHelper.setLongPressDragEnabled(true);
            }
        }
    }

    protected void markComponentUsable() {
        for (WXComponent component : this.mChildren) {
            component.setUsing(false);
        }
    }

    @Override
    public ListBaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mChildren != null) {
            if (this.mViewTypes == null) {
                return this.createVHForFakeComponent(viewType);
            }
            ArrayList mTypes = (ArrayList)this.mViewTypes.get(viewType);
            this.checkRecycledViewPool(viewType);
            if (mTypes == null) {
                return this.createVHForFakeComponent(viewType);
            }
            for (int i = 0; i < mTypes.size(); ++i) {
                WXComponent component = (WXComponent)mTypes.get(i);
                if (component == null || component.isUsing()) continue;
                if (component.getDomObject() != null && component.getDomObject().isFixed()) {
                    return this.createVHForFakeComponent(viewType);
                }
                if (component instanceof WXCell) {
                    if (component.getRealView() != null) {
                        return new ListBaseViewHolder(component, viewType);
                    }
                    ((WXCell)component).lazy(false);
                    component.createView();
                    component.applyLayoutAndEvent(component);
                    return new ListBaseViewHolder(component, viewType);
                }
                if (component instanceof WXBaseRefresh) {
                    return this.createVHForRefreshComponent(viewType);
                }
                WXLogUtils.e(this.TAG, "List cannot include element except cell\u3001header\u3001fixed\u3001refresh and loading");
                return this.createVHForFakeComponent(viewType);
            }
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.e(this.TAG, "Cannot find request viewType: " + viewType);
        }
        return this.createVHForFakeComponent(viewType);
    }

    private void checkRecycledViewPool(int viewType) {
        try {
            if (this.mViewTypes.size() > 9) {
                mAllowCacheViewHolder = false;
            }
            if (mDownForBidCacheViewHolder && this.getHostView() != null && ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView() != null) {
                ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView().getRecycledViewPool().setMaxRecycledViews(viewType, 0);
            }
            if (!mDownForBidCacheViewHolder && !mAllowCacheViewHolder && this.getHostView() != null && ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView() != null) {
                for (int i = 0; i < this.mViewTypes.size(); ++i) {
                    ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView().getRecycledViewPool().setMaxRecycledViews(this.mViewTypes.keyAt(i), 0);
                }
                mDownForBidCacheViewHolder = true;
            }
        }
        catch (Exception e) {
            WXLogUtils.e(this.TAG, "Clear recycledViewPool error!");
        }
    }

    @Override
    public int getItemViewType(int position) {
        return this.generateViewType(this.getChild(position));
    }

    @Nullable
    private WXComponent findComponentByAnchorName(@NonNull WXComponent root, @NonNull String anchorName) {
        long start = 0L;
        if (WXEnvironment.isApkDebugable()) {
            start = System.currentTimeMillis();
        }
        ArrayDeque<WXComponent> deque = new ArrayDeque<WXComponent>();
        deque.add(root);
        while (!deque.isEmpty()) {
            String isAnchorSet;
            WXComponent curComponent = (WXComponent)deque.removeFirst();
            ImmutableDomObject object = curComponent.getDomObject();
            if (object != null && (isAnchorSet = WXUtils.getString(object.getAttrs().get(anchorName), null)) != null && isAnchorSet.equals("true")) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("dragPerf", "findComponentByAnchorName time: " + (System.currentTimeMillis() - start) + "ms");
                }
                return curComponent;
            }
            if (!(curComponent instanceof WXVContainer)) continue;
            WXVContainer container = (WXVContainer)curComponent;
            int len = container.childCount();
            for (int i = 0; i < len; ++i) {
                WXComponent child = container.getChild(i);
                deque.add(child);
            }
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("dragPerf", "findComponentByAnchorName elapsed time: " + (System.currentTimeMillis() - start) + "ms");
        }
        return null;
    }

    private String getTriggerType(@Nullable ImmutableDomObject domObject) {
        String triggerType = DEFAULT_TRIGGER_TYPE;
        if (domObject == null) {
            return triggerType;
        }
        triggerType = WXUtils.getString(domObject.getAttrs().get(DRAG_TRIGGER_TYPE), DEFAULT_TRIGGER_TYPE);
        if (!DEFAULT_TRIGGER_TYPE.equals(triggerType) && !"pan".equals(triggerType)) {
            triggerType = DEFAULT_TRIGGER_TYPE;
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "trigger type is " + triggerType);
        }
        return triggerType;
    }

    private void bindViewType(WXComponent component) {
        ArrayList<WXComponent> mTypes;
        int id2 = this.generateViewType(component);
        if (this.mViewTypes == null) {
            this.mViewTypes = new SparseArray();
        }
        if ((mTypes = (ArrayList<WXComponent>)this.mViewTypes.get(id2)) == null) {
            mTypes = new ArrayList<WXComponent>();
            this.mViewTypes.put(id2, mTypes);
        }
        mTypes.add(component);
    }

    private void unBindViewType(WXComponent component) {
        int id2 = this.generateViewType(component);
        if (this.mViewTypes == null) {
            return;
        }
        ArrayList mTypes = (ArrayList)this.mViewTypes.get(id2);
        if (mTypes == null) {
            return;
        }
        mTypes.remove(component);
    }

    private int generateViewType(WXComponent component) {
        long id2;
        try {
            id2 = Integer.parseInt(component.getDomObject().getRef());
            String type = component.getDomObject().getAttrs().getScope();
            if (!TextUtils.isEmpty((CharSequence)type)) {
                if (this.mRefToViewType == null) {
                    this.mRefToViewType = new ArrayMap();
                }
                if (!this.mRefToViewType.containsKey((Object)type)) {
                    this.mRefToViewType.put((Object)type, (Object)id2);
                }
                id2 = (Long)this.mRefToViewType.get((Object)type);
            }
        }
        catch (RuntimeException e) {
            WXLogUtils.eTag(this.TAG, e);
            id2 = -1L;
            WXLogUtils.e(this.TAG, "getItemViewType: NO ID, this will crash the whole render system of WXListRecyclerView");
        }
        return (int)id2;
    }

    @Override
    public int getItemCount() {
        return this.getChildCount();
    }

    @Override
    public boolean onFailedToRecycleView(ListBaseViewHolder holder) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "Failed to recycle " + (Object)((Object)holder));
        }
        return false;
    }

    @Override
    public long getItemId(int position) {
        long id2;
        try {
            id2 = Long.parseLong(this.getChild(position).getDomObject().getRef());
        }
        catch (RuntimeException e) {
            WXLogUtils.e(this.TAG, WXLogUtils.getStackTrace(e));
            id2 = -1L;
        }
        return id2;
    }

    @Override
    public void onLoadMore(int offScreenY) {
        try {
            float offsetParsed;
            String offset = this.getDomObject().getAttrs().getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                offset = "0";
            }
            if ((float)offScreenY <= (offsetParsed = WXViewUtils.getRealPxByWidth(Integer.parseInt(offset), this.getInstance().getInstanceViewPortWidth())) && (this.mListCellCount != this.mChildren.size() || this.mForceLoadmoreNextTime)) {
                this.fireEvent("loadmore");
                this.mListCellCount = this.mChildren.size();
                this.mForceLoadmoreNextTime = false;
            }
        }
        catch (Exception e) {
            WXLogUtils.d(this.TAG + "onLoadMore :", e);
        }
    }

    @Override
    public void notifyAppearStateChange(int firstVisible, int lastVisible, int directionX, int directionY) {
        String direction;
        Iterator<AppearanceHelper> it = this.mAppearComponents.values().iterator();
        String string2 = directionY > 0 ? "up" : (direction = directionY < 0 ? "down" : null);
        if (this.getOrientation() == 0 && directionX != 0) {
            String string3 = direction = directionX > 0 ? "left" : "right";
        }
        while (it.hasNext()) {
            boolean outOfVisibleRange;
            AppearanceHelper item = it.next();
            WXComponent component = item.getAwareChild();
            if (!item.isWatch()) continue;
            boolean bl = outOfVisibleRange = item.getCellPositionINScollable() < firstVisible || item.getCellPositionINScollable() > lastVisible;
            Object view = component.getHostView();
            if (view == null) continue;
            boolean visible = !outOfVisibleRange && item.isViewVisible(true);
            int result = item.setAppearStatus(visible);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("appear", "item " + item.getCellPositionINScollable() + " result " + result);
            }
            if (result == 0) continue;
            component.notifyAppearStateChange(result == 1 ? "appear" : "disappear", direction);
        }
    }

    @NonNull
    private ListBaseViewHolder createVHForFakeComponent(int viewType) {
        FrameLayout view = new FrameLayout(this.getContext());
        view.setBackgroundColor(-1);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
        return new ListBaseViewHolder((View)view, viewType);
    }

    private ListBaseViewHolder createVHForRefreshComponent(int viewType) {
        FrameLayout view = new FrameLayout(this.getContext());
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, 1));
        return new ListBaseViewHolder((View)view, viewType);
    }

    @JSMethod
    public void resetLoadmore() {
        this.mForceLoadmoreNextTime = true;
        this.mListCellCount = 0;
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if ("scroll".equals(type) && this.getHostView() != null && ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView() != null) {
            WXRecyclerView innerView = ((ListComponentView)((ViewGroup)this.getHostView())).getInnerView();
            innerView.addOnScrollListener(new RecyclerView.OnScrollListener(){
                private int offsetXCorrection;
                private int offsetYCorrection;
                private boolean mFirstEvent = true;

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    int offsetX = recyclerView.computeHorizontalScrollOffset();
                    int offsetY = recyclerView.computeVerticalScrollOffset();
                    if (dx == 0 && dy == 0) {
                        this.offsetXCorrection = offsetX;
                        this.offsetYCorrection = offsetY;
                        offsetX = 0;
                        offsetY = 0;
                    } else {
                        offsetX -= this.offsetXCorrection;
                        offsetY -= this.offsetYCorrection;
                    }
                    if (this.mFirstEvent) {
                        this.mFirstEvent = false;
                        return;
                    }
                    RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                    if (!layoutManager.canScrollVertically()) {
                        return;
                    }
                    if (BasicListComponent.this.shouldReport(offsetX, offsetY)) {
                        BasicListComponent.this.fireScrollEvent(recyclerView, offsetX, offsetY);
                    }
                }
            });
        }
    }

    private void fireScrollEvent(RecyclerView recyclerView, int offsetX, int offsetY) {
        if (this.getOrientation() == 1) {
            offsetY = -this.calcContentOffset(recyclerView);
        }
        int contentWidth = recyclerView.getMeasuredWidth() + recyclerView.computeHorizontalScrollRange();
        int contentHeight = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            WXComponent child = this.getChild(i);
            if (child == null) continue;
            contentHeight = (int)((float)contentHeight + child.getLayoutHeight());
        }
        HashMap<String, Object> event = new HashMap<String, Object>(2);
        HashMap<String, Float> contentSize = new HashMap<String, Float>(2);
        HashMap<String, Float> contentOffset = new HashMap<String, Float>(2);
        contentSize.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(contentWidth, this.getInstance().getInstanceViewPortWidth())));
        contentSize.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(contentHeight, this.getInstance().getInstanceViewPortWidth())));
        contentOffset.put("x", Float.valueOf(-WXViewUtils.getWebPxByWidth(offsetX, this.getInstance().getInstanceViewPortWidth())));
        contentOffset.put("y", Float.valueOf(-WXViewUtils.getWebPxByWidth(offsetY, this.getInstance().getInstanceViewPortWidth())));
        event.put("contentSize", contentSize);
        event.put("contentOffset", contentOffset);
        this.fireEvent("scroll", event);
    }

    private boolean shouldReport(int offsetX, int offsetY) {
        if (this.mLastReport.x == -1 && this.mLastReport.y == -1) {
            this.mLastReport.x = offsetX;
            this.mLastReport.y = offsetY;
            return true;
        }
        int gapX = Math.abs(this.mLastReport.x - offsetX);
        int gapY = Math.abs(this.mLastReport.y - offsetY);
        if (gapX >= this.mOffsetAccuracy || gapY >= this.mOffsetAccuracy) {
            this.mLastReport.x = offsetX;
            this.mLastReport.y = offsetY;
            return true;
        }
        return false;
    }

    private int calcContentOffset(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            int firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            if (firstVisibleItemPosition == -1) {
                return 0;
            }
            View firstVisibleView = layoutManager.findViewByPosition(firstVisibleItemPosition);
            int firstVisibleViewOffset = 0;
            if (firstVisibleView != null) {
                firstVisibleViewOffset = firstVisibleView.getTop();
            }
            int offset = 0;
            for (int i = 0; i < firstVisibleItemPosition; ++i) {
                WXComponent child = this.getChild(i);
                if (child == null) continue;
                offset = (int)((float)offset - child.getLayoutHeight());
            }
            if (layoutManager instanceof GridLayoutManager) {
                int spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
                offset /= spanCount;
            }
            return offset += firstVisibleViewOffset;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
            int firstVisibleItemPosition = ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null)[0];
            if (firstVisibleItemPosition == -1) {
                return 0;
            }
            View firstVisibleView = layoutManager.findViewByPosition(firstVisibleItemPosition);
            int firstVisibleViewOffset = 0;
            if (firstVisibleView != null) {
                firstVisibleViewOffset = firstVisibleView.getTop();
            }
            int offset = 0;
            for (int i = 0; i < firstVisibleItemPosition; ++i) {
                WXComponent child = this.getChild(i);
                if (child == null) continue;
                offset = (int)((float)offset - child.getLayoutHeight());
            }
            offset /= spanCount;
            return offset += firstVisibleViewOffset;
        }
        return -1;
    }

    static interface DragTriggerType {
        public static final String PAN = "pan";
        public static final String LONG_PRESS = "longpress";
    }
}

