/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.FrameLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXVideoView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;

@Component(lazyload=false)
public class WXVideo
extends WXComponent<FrameLayout> {
    private boolean mAutoPlay;
    private WXVideoView.Wrapper mWrapper;
    boolean mPrepared;
    private boolean mError;
    private boolean mStopped;

    @Deprecated
    public WXVideo(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXVideo(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
    }

    @Override
    protected FrameLayout initComponentHostView(@NonNull Context context) {
        final WXVideoView.Wrapper video = new WXVideoView.Wrapper(context);
        video.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onError:" + what);
                }
                video.getProgressBar().setVisibility(8);
                WXVideo.this.mPrepared = false;
                WXVideo.this.mError = true;
                if (WXVideo.this.getDomObject().getEvents().contains("fail")) {
                    WXVideo.this.notify("fail", "stop");
                }
                return true;
            }
        });
        video.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onPrepared");
                }
                video.getProgressBar().setVisibility(8);
                WXVideo.this.mPrepared = true;
                if (WXVideo.this.mAutoPlay) {
                    video.start();
                }
                WXVideoView videoView = video.getVideoView();
                videoView.seekTo(5);
                if (video.getMediaController() != null) {
                    if (!WXVideo.this.mStopped) {
                        video.getMediaController().show(3);
                    } else {
                        video.getMediaController().hide();
                    }
                }
                WXVideo.this.mStopped = false;
            }
        });
        video.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onCompletion");
                }
                if (WXVideo.this.getDomObject().getEvents().contains("finish")) {
                    WXVideo.this.notify("finish", "stop");
                }
            }
        });
        video.setOnVideoPauseListener(new WXVideoView.VideoPlayListener(){

            @Override
            public void onPause() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onPause");
                }
                if (WXVideo.this.getDomObject().getEvents().contains("pause")) {
                    WXVideo.this.notify("pause", "pause");
                }
            }

            @Override
            public void onStart() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onStart");
                }
                if (WXVideo.this.getDomObject().getEvents().contains("start")) {
                    WXVideo.this.notify("start", "play");
                }
            }
        });
        this.mWrapper = video;
        return video;
    }

    private void notify(String event, String newStatus) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("playStatus", newStatus);
        params.put("timeStamp", System.currentTimeMillis());
        HashMap<String, Object> domChanges = new HashMap<String, Object>();
        HashMap<String, String> attrsChanges = new HashMap<String, String>();
        attrsChanges.put("playStatus", newStatus);
        domChanges.put("attrs", attrsChanges);
        WXSDKManager.getInstance().fireEvent(this.getInstanceId(), this.getRef(), event, params, domChanges);
    }

    @Override
    public void bindData(WXComponent component) {
        super.bindData(component);
        this.addEvent("appear");
    }

    @Override
    public void notifyAppearStateChange(String wxEventType, String direction) {
        super.notifyAppearStateChange(wxEventType, direction);
        this.mWrapper.createVideoViewIfVisible();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
            case "autoPlay": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setAutoPlay(result);
                }
                return true;
            }
            case "playStatus": {
                String status = WXUtils.getString(param, null);
                if (status != null) {
                    this.setPlaystatus(status);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        if (TextUtils.isEmpty((CharSequence)src) || this.getHostView() == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)src)) {
            WXSDKInstance instance = this.getInstance();
            this.mWrapper.setVideoURI(instance.rewriteUri(Uri.parse((String)src), "video"));
            this.mWrapper.getProgressBar().setVisibility(0);
        }
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(boolean autoPlay) {
        this.mAutoPlay = autoPlay;
        if (autoPlay) {
            this.mWrapper.createIfNotExist();
            this.mWrapper.start();
        }
    }

    @WXComponentProp(name="playStatus")
    public void setPlaystatus(String playstatus) {
        if (this.mPrepared && !this.mError && !this.mStopped) {
            if (playstatus.equals("play")) {
                this.mWrapper.start();
            } else if (playstatus.equals("pause")) {
                this.mWrapper.pause();
            } else if (playstatus.equals("stop")) {
                this.mWrapper.stopPlayback();
                this.mStopped = true;
            }
        } else if ((this.mError || this.mStopped) && playstatus.equals("play")) {
            this.mError = false;
            this.mWrapper.resume();
            this.mWrapper.getProgressBar().setVisibility(0);
        }
    }
}

