/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ComponentObserver;
import com.taobao.weex.IWXActivityStateListener;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXDomTask;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.action.Actions;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.animation.WXAnimationModule;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.pesudo.OnActivePseudoListner;
import com.taobao.weex.ui.component.pesudo.PesudoStatus;
import com.taobao.weex.ui.component.pesudo.TouchActivePseudoListener;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.FlatGUIContext;
import com.taobao.weex.ui.flat.WidgetContainer;
import com.taobao.weex.ui.flat.widget.AndroidViewWidget;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXDataStructureUtil;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class WXComponent<T extends View>
implements IWXObject,
IWXActivityStateListener,
OnActivePseudoListner {
    public static final String PROP_FIXED_SIZE = "fixedSize";
    public static final String PROP_FS_MATCH_PARENT = "m";
    public static final String PROP_FS_WRAP_CONTENT = "w";
    private int mFixedProp = 0;
    public static int mComponentNum = 0;
    T mHost;
    private volatile WXVContainer mParent;
    private volatile ImmutableDomObject mDomObj;
    private WXSDKInstance mInstance;
    private Context mContext;
    private int mAbsoluteY = 0;
    private int mAbsoluteX = 0;
    private Set<String> mGestureType;
    private BorderDrawable mBackgroundDrawable;
    private int mPreRealWidth = 0;
    private int mPreRealHeight = 0;
    private int mPreRealLeft = 0;
    private int mPreRealTop = 0;
    private int mStickyOffset = 0;
    private WXGesture mGesture;
    private IFComponentHolder mHolder;
    private boolean isUsing = false;
    private List<OnClickListener> mHostClickListeners;
    private List<OnFocusChangeListener> mFocusChangeListeners;
    private String mCurrentRef;
    private Set<String> mAppendEvents = new HashSet<String>();
    private WXAnimationModule.AnimationHolder mAnimationHolder;
    private PesudoStatus mPesudoStatus = new PesudoStatus();
    private boolean mIsDestroyed = false;
    private boolean mIsDisabled = false;
    private int mType = 0;
    private boolean mNeedLayoutOnAnimation = false;
    public WXTracing.TraceInfo mTraceInfo = new WXTracing.TraceInfo();
    public static final int TYPE_COMMON = 0;
    public static final int TYPE_VIRTUAL = 1;
    private OnClickListener mClickEventListener = new OnClickListener(){

        @Override
        public void onHostViewClick() {
            HashMap<String, Object> param = WXDataStructureUtil.newHashMapWithExpectedSize(1);
            HashMap<String, Float> position = WXDataStructureUtil.newHashMapWithExpectedSize(4);
            int[] location = new int[2];
            WXComponent.this.mHost.getLocationOnScreen(location);
            position.put("x", Float.valueOf(WXViewUtils.getWebPxByWidth(location[0], WXComponent.this.mInstance.getInstanceViewPortWidth())));
            position.put("y", Float.valueOf(WXViewUtils.getWebPxByWidth(location[1], WXComponent.this.mInstance.getInstanceViewPortWidth())));
            position.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(WXComponent.this.mDomObj.getLayoutWidth(), WXComponent.this.mInstance.getInstanceViewPortWidth())));
            position.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(WXComponent.this.mDomObj.getLayoutHeight(), WXComponent.this.mInstance.getInstanceViewPortWidth())));
            param.put("position", position);
            WXComponent.this.fireEvent("click", param);
        }
    };
    public static final int STATE_DOM_FINISH = 0;
    public static final int STATE_UI_FINISH = 1;
    public static final int STATE_ALL_FINISH = 2;

    public void postAnimation(WXAnimationModule.AnimationHolder holder) {
        this.mAnimationHolder = holder;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isFlatUIEnabled() {
        return this.mParent != null && this.mParent.isFlatUIEnabled();
    }

    public String getInstanceId() {
        return this.mInstance.getInstanceId();
    }

    public Rect getComponentSize() {
        Rect size = new Rect();
        if (this.mHost != null) {
            int[] location = new int[2];
            int[] anchor = new int[2];
            this.mHost.getLocationOnScreen(location);
            this.mInstance.getContainerView().getLocationOnScreen(anchor);
            int left = location[0] - anchor[0];
            int top = location[1] - this.mStickyOffset - anchor[1];
            int width = (int)this.mDomObj.getLayoutWidth();
            int height = (int)this.mDomObj.getLayoutHeight();
            size.set(left, top, left + width, top + height);
        }
        return size;
    }

    public final void invoke(String method, JSONArray args) {
        Invoker invoker = this.mHolder.getMethodInvoker(method);
        if (invoker != null) {
            try {
                this.getInstance().getNativeInvokeHelper().invoke(this, invoker, args);
            }
            catch (Exception e) {
                WXLogUtils.e("[WXComponent] updateProperties :class:" + this.getClass() + "method:" + invoker.toString() + " function " + WXLogUtils.getStackTrace(e));
            }
        } else {
            this.onInvokeUnknownMethod(method, args);
        }
    }

    protected void onInvokeUnknownMethod(String method, JSONArray args) {
    }

    @Deprecated
    public WXComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    @Deprecated
    public WXComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        this(instance, dom, parent);
    }

    public WXComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent) {
        this(instance, dom, parent, 0);
    }

    public WXComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, int type) {
        this.mInstance = instance;
        this.mContext = this.mInstance.getContext();
        this.mParent = parent;
        this.mType = type;
        this.mDomObj = dom.clone();
        this.mCurrentRef = this.mDomObj.getRef();
        this.mGestureType = new HashSet<String>();
        ++mComponentNum;
        this.onCreate();
        ComponentObserver observer = this.getInstance().getComponentObserver();
        if (observer != null) {
            observer.onCreate(this);
        }
    }

    protected void onCreate() {
    }

    public void bindHolder(IFComponentHolder holder) {
        this.mHolder = holder;
    }

    public WXSDKInstance getInstance() {
        return this.mInstance;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected final WXComponent findComponent(String ref) {
        if (this.mInstance != null && ref != null) {
            return WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.mInstance.getInstanceId(), ref);
        }
        return null;
    }

    public final void fireEvent(String type) {
        this.fireEvent(type, null);
    }

    public final void fireEvent(String type, Map<String, Object> params) {
        this.fireEvent(type, params, null);
    }

    protected final void fireEvent(String type, Map<String, Object> params, Map<String, Object> domChanges) {
        if (this.mInstance != null && this.mDomObj != null) {
            this.mInstance.fireEvent(this.mCurrentRef, type, params, domChanges);
        }
    }

    public boolean isLazy() {
        return this.mParent != null && this.mParent.isLazy();
    }

    public void applyLayoutAndEvent(WXComponent component) {
        long startNanos = System.nanoTime();
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            this.setLayout(component.getDomObject());
            this.setPadding(component.getDomObject().getPadding(), component.getDomObject().getBorder());
            this.addEvents();
        }
        this.mTraceInfo.uiThreadNanos += System.nanoTime() - startNanos;
    }

    protected final void addFocusChangeListener(OnFocusChangeListener l) {
        View view;
        if (l != null && (view = this.getRealView()) != null) {
            if (this.mFocusChangeListeners == null) {
                this.mFocusChangeListeners = new ArrayList<OnFocusChangeListener>();
                view.setFocusable(true);
                view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                    public void onFocusChange(View v, boolean hasFocus) {
                        for (OnFocusChangeListener listener : WXComponent.this.mFocusChangeListeners) {
                            if (listener == null) continue;
                            listener.onFocusChange(hasFocus);
                        }
                    }
                });
            }
            this.mFocusChangeListeners.add(l);
        }
    }

    protected final void addClickListener(OnClickListener l) {
        View view;
        if (l != null && (view = this.getRealView()) != null) {
            if (this.mHostClickListeners == null) {
                this.mHostClickListeners = new ArrayList<OnClickListener>();
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (WXComponent.this.mGesture != null && WXComponent.this.mGesture.isTouchEventConsumedByAdvancedGesture()) {
                            return;
                        }
                        for (OnClickListener listener : WXComponent.this.mHostClickListeners) {
                            if (listener == null) continue;
                            listener.onHostViewClick();
                        }
                    }
                });
            }
            this.mHostClickListeners.add(l);
        }
    }

    protected final void removeClickListener(OnClickListener l) {
        this.mHostClickListeners.remove(l);
    }

    public void bindData(WXComponent component) {
        long startNanos = System.nanoTime();
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            this.mCurrentRef = component.getDomObject().getRef();
            this.updateStyle(component);
            this.updateAttrs(component);
            this.updateExtra(component.getDomObject().getExtra());
        }
        this.mTraceInfo.uiThreadNanos += System.nanoTime() - startNanos;
    }

    public void updateStyle(WXComponent component) {
        ImmutableDomObject domObject = component.getDomObject();
        if (domObject != null) {
            this.updateProperties(domObject.getStyles());
        }
    }

    public void updateAttrs(WXComponent component) {
        ImmutableDomObject domObject = component.getDomObject();
        if (domObject != null) {
            this.updateProperties(domObject.getAttrs());
        }
    }

    public void refreshData(WXComponent component) {
    }

    protected BorderDrawable getOrCreateBorder() {
        if (this.mBackgroundDrawable == null) {
            this.mBackgroundDrawable = new BorderDrawable();
            if (this.mHost != null) {
                Drawable backgroundDrawable = this.mHost.getBackground();
                WXViewUtils.setBackGround(this.mHost, null);
                if (backgroundDrawable == null) {
                    WXViewUtils.setBackGround(this.mHost, this.mBackgroundDrawable);
                } else {
                    WXViewUtils.setBackGround(this.mHost, (Drawable)new LayerDrawable(new Drawable[]{this.mBackgroundDrawable, backgroundDrawable}));
                }
            }
        }
        return this.mBackgroundDrawable;
    }

    public final void setLayout(ImmutableDomObject domObject) {
        if (domObject == null || TextUtils.isEmpty((CharSequence)this.mCurrentRef)) {
            return;
        }
        boolean nullParent = this.mParent == null;
        this.mDomObj = domObject;
        int siblingOffset = nullParent ? 0 : this.mParent.getChildrenLayoutTopOffset();
        Spacing parentPadding = nullParent ? new Spacing() : this.mParent.getDomObject().getPadding();
        Spacing parentBorder = nullParent ? new Spacing() : this.mParent.getDomObject().getBorder();
        Spacing margin = this.mDomObj.getMargin();
        int realWidth = (int)this.mDomObj.getLayoutWidth();
        int realHeight = (int)this.mDomObj.getLayoutHeight();
        int realLeft = (int)(this.mDomObj.getLayoutX() - parentPadding.get(0) - parentBorder.get(0));
        int realTop = (int)(this.mDomObj.getLayoutY() - parentPadding.get(1) - parentBorder.get(1)) + siblingOffset;
        int realRight = (int)margin.get(2);
        int realBottom = (int)margin.get(3);
        Point rawOffset = new Point((int)this.mDomObj.getCSSLayoutLeft(), (int)this.mDomObj.getCSSLayoutTop());
        if (this.mPreRealWidth == realWidth && this.mPreRealHeight == realHeight && this.mPreRealLeft == realLeft && this.mPreRealTop == realTop) {
            return;
        }
        this.mAbsoluteY = (int)(nullParent ? 0.0f : (float)this.mParent.getAbsoluteY() + this.mDomObj.getLayoutY());
        this.mAbsoluteX = (int)(nullParent ? 0.0f : (float)this.mParent.getAbsoluteX() + this.mDomObj.getLayoutX());
        if (!this.mInstance.mEnd && !(this.mHost instanceof ViewGroup) && this.mAbsoluteY + realHeight > this.mInstance.getWeexHeight() + 1) {
            this.mInstance.firstScreenRenderFinished();
        }
        MeasureOutput measureOutput = this.measure(realWidth, realHeight);
        realWidth = measureOutput.width;
        realHeight = measureOutput.height;
        this.setComponentLayoutParams(realWidth, realHeight, realLeft, realTop, realRight, realBottom, rawOffset);
    }

    private void setComponentLayoutParams(int realWidth, int realHeight, int realLeft, int realTop, int realRight, int realBottom, Point rawOffset) {
        FlatGUIContext UIImp = this.getInstance().getFlatUIContext();
        WidgetContainer ancestor = UIImp.getFlatComponentAncestor(this);
        if (ancestor != null) {
            AndroidViewWidget widget = this instanceof FlatComponent && !((FlatComponent)((Object)this)).promoteToView(true) ? ((FlatComponent)((Object)this)).getOrCreateFlatWidget() : UIImp.getAndroidViewWidget(this);
            this.setWidgetParams(widget, UIImp, rawOffset, realWidth, realHeight, realLeft, realRight, realTop, realBottom);
        } else if (this.mHost != null) {
            if (this.mDomObj.isFixed()) {
                this.setFixedHostLayoutParams(this.mHost, realWidth, realHeight, realLeft, realRight, realTop, realBottom);
            } else {
                this.setHostLayoutParams(this.mHost, realWidth, realHeight, realLeft, realRight, realTop, realBottom);
            }
            this.mPreRealWidth = realWidth;
            this.mPreRealHeight = realHeight;
            this.mPreRealLeft = realLeft;
            this.mPreRealTop = realTop;
            this.onFinishLayout();
        }
    }

    private void setWidgetParams(Widget widget, FlatGUIContext UIImp, Point rawoffset, int width, int height, int left, int right, int top, int bottom) {
        Point childOffset = new Point();
        if (this.mParent != null) {
            ViewGroup.LayoutParams lp;
            if (this.mParent instanceof FlatComponent && UIImp.getFlatComponentAncestor(this.mParent) != null && UIImp.getAndroidViewWidget(this.mParent) == null) {
                childOffset.set(rawoffset.x, rawoffset.y);
            } else {
                childOffset.set(left, top);
            }
            if (this.mParent instanceof FlatComponent && UIImp.getFlatComponentAncestor(this.mParent) != null && UIImp.getAndroidViewWidget(this.mParent) == null) {
                Point parentLayoutOffset = ((FlatComponent)((Object)this.mParent)).getOrCreateFlatWidget().getLocInFlatContainer();
                childOffset.offset(parentLayoutOffset.x, parentLayoutOffset.y);
            }
            if ((lp = this.mParent.getChildLayoutParams(this, (View)this.mHost, width, height, left, right, top, bottom)) instanceof ViewGroup.MarginLayoutParams) {
                width = lp.width;
                height = lp.height;
                left = ((ViewGroup.MarginLayoutParams)lp).leftMargin;
                right = ((ViewGroup.MarginLayoutParams)lp).rightMargin;
                top = ((ViewGroup.MarginLayoutParams)lp).topMargin;
                bottom = ((ViewGroup.MarginLayoutParams)lp).bottomMargin;
            }
        }
        widget.setLayout(width, height, left, right, top, bottom, childOffset);
        if (widget instanceof AndroidViewWidget && ((AndroidViewWidget)widget).getView() != null) {
            this.setHostLayoutParams(((AndroidViewWidget)widget).getView(), width, height, childOffset.x, right, childOffset.y, bottom);
        }
    }

    protected void setHostLayoutParams(T host, int width, int height, int left, int right, int top, int bottom) {
        ViewGroup.LayoutParams lp;
        if (this.mParent == null) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, height);
            params.setMargins(left, top, right, bottom);
            lp = params;
        } else {
            lp = this.mParent.getChildLayoutParams(this, (View)host, width, height, left, right, top, bottom);
        }
        if (lp != null) {
            this.mHost.setLayoutParams(lp);
        }
    }

    private void setFixedHostLayoutParams(T host, int width, int height, int left, int right, int top, int bottom) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.width = width;
        params.height = height;
        params.setMargins(left, top, right, bottom);
        host.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mInstance.moveFixedView((View)host);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("Weex_Fixed_Style", "WXComponent:setLayout :" + left + " " + top + " " + width + " " + height);
            WXLogUtils.d("Weex_Fixed_Style", "WXComponent:setLayout Left:" + this.mDomObj.getStyles().getLeft() + " " + (int)this.mDomObj.getStyles().getTop());
        }
    }

    protected void onFinishLayout() {
        Object param;
        Object object = param = this.mDomObj.getStyles() != null ? this.mDomObj.getStyles().get("backgroundImage") : null;
        if (param != null) {
            this.setBackgroundImage(param.toString());
        }
    }

    public int getLayoutTopOffsetForSibling() {
        return 0;
    }

    public float getLayoutWidth() {
        float w = 0.0f;
        if (this.mDomObj != null) {
            w = this.mDomObj.getLayoutWidth();
            w = Float.isNaN(w) ? 0.0f : w;
        }
        return w;
    }

    public float getLayoutHeight() {
        float h = 0.0f;
        if (this.mDomObj != null) {
            h = this.mDomObj.getLayoutHeight();
            h = Float.isNaN(h) ? 0.0f : h;
        }
        return h;
    }

    public void setPadding(Spacing padding, Spacing border) {
        int left = (int)(padding.get(0) + border.get(0));
        int top = (int)(padding.get(1) + border.get(1));
        int right = (int)(padding.get(2) + border.get(2));
        int bottom = (int)(padding.get(3) + border.get(3));
        if (this instanceof FlatComponent && !((FlatComponent)((Object)this)).promoteToView(true)) {
            ((FlatComponent)((Object)this)).getOrCreateFlatWidget().setContentBox(left, top, right, bottom);
        } else if (this.mHost != null) {
            this.mHost.setPadding(left, top, right, bottom);
        }
    }

    private void addEvents() {
        int count = this.mDomObj.getEvents().size();
        for (int i = 0; i < count; ++i) {
            this.addEvent((String)this.mDomObj.getEvents().get(i));
        }
        this.setActiveTouchListener();
    }

    public void updateExtra(Object extra) {
    }

    public ImmutableDomObject getDomObject() {
        return this.mDomObj;
    }

    protected MeasureOutput measure(int width, int height) {
        MeasureOutput measureOutput = new MeasureOutput();
        if (this.mFixedProp != 0) {
            measureOutput.width = this.mFixedProp;
            measureOutput.height = this.mFixedProp;
        } else {
            measureOutput.width = width;
            measureOutput.height = height;
        }
        return measureOutput;
    }

    @Deprecated
    public void updateProperties(Map<String, Object> props) {
        FlatComponent flatComponent;
        if (props == null || this.mHost == null && !this.isVirtualComponent()) {
            return;
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object param = entry.getValue();
            String value = WXUtils.getString(param, null);
            if (TextUtils.isEmpty((CharSequence)value)) {
                param = this.convertEmptyProperty(key, value);
            }
            if (this.setProperty(key, param)) continue;
            if (this.mHolder == null) {
                return;
            }
            Invoker invoker = this.mHolder.getPropertyInvoker(key);
            if (invoker == null) continue;
            try {
                Type[] paramClazzs = invoker.getParameterTypes();
                if (paramClazzs.length != 1) {
                    WXLogUtils.e("[WXComponent] setX method only one parameter\uff1a" + invoker);
                    return;
                }
                param = WXReflectionUtils.parseArgument(paramClazzs[0], param);
                invoker.invoke(this, param);
            }
            catch (Exception e) {
                WXLogUtils.e("[WXComponent] updateProperties :class:" + this.getClass() + "method:" + invoker.toString() + " function " + WXLogUtils.getStackTrace(e));
            }
        }
        this.readyToRender();
        if (this instanceof FlatComponent && this.mBackgroundDrawable != null && !(flatComponent = (FlatComponent)((Object)this)).promoteToView(true) && !(flatComponent.getOrCreateFlatWidget() instanceof AndroidViewWidget)) {
            flatComponent.getOrCreateFlatWidget().setBackgroundAndBorder(this.mBackgroundDrawable);
        }
    }

    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "preventMoveEvent": {
                if (this.mGesture != null) {
                    this.mGesture.setPreventMoveEvent(WXUtils.getBoolean(param, false));
                }
                return true;
            }
            case "disabled": {
                Boolean disabled = WXUtils.getBoolean(param, null);
                if (disabled != null) {
                    this.setDisabled(disabled);
                    this.setPseudoClassStatus(":disabled", disabled);
                }
                return true;
            }
            case "position": {
                String position = WXUtils.getString(param, null);
                if (position != null) {
                    this.setSticky(position);
                }
                return true;
            }
            case "backgroundColor": {
                String bgColor = WXUtils.getString(param, null);
                if (bgColor != null) {
                    this.setBackgroundColor(bgColor);
                }
                return true;
            }
            case "backgroundImage": {
                String bgImage = WXUtils.getString(param, null);
                if (bgImage != null) {
                    this.setBackgroundImage(bgImage);
                }
                return true;
            }
            case "opacity": {
                Float opacity = WXUtils.getFloat(param, null);
                if (opacity != null) {
                    this.setOpacity(opacity.floatValue());
                }
                return true;
            }
            case "borderRadius": 
            case "borderTopLeftRadius": 
            case "borderTopRightRadius": 
            case "borderBottomRightRadius": 
            case "borderBottomLeftRadius": {
                Float radius = WXUtils.getFloat(param, null);
                if (radius != null) {
                    this.setBorderRadius(key, radius.floatValue());
                }
                return true;
            }
            case "borderWidth": 
            case "borderTopWidth": 
            case "borderRightWidth": 
            case "borderBottomWidth": 
            case "borderLeftWidth": {
                Float width = WXUtils.getFloat(param, null);
                if (width != null) {
                    this.setBorderWidth(key, width.floatValue());
                }
                return true;
            }
            case "borderStyle": 
            case "borderRightStyle": 
            case "borderBottomStyle": 
            case "borderLeftStyle": 
            case "borderTopStyle": {
                String border_style = WXUtils.getString(param, null);
                if (border_style != null) {
                    this.setBorderStyle(key, border_style);
                }
                return true;
            }
            case "borderColor": 
            case "borderTopColor": 
            case "borderRightColor": 
            case "borderBottomColor": 
            case "borderLeftColor": {
                String border_color = WXUtils.getString(param, null);
                if (border_color != null) {
                    this.setBorderColor(key, border_color);
                }
                return true;
            }
            case "visibility": {
                String visibility = WXUtils.getString(param, null);
                if (visibility != null) {
                    this.setVisibility(visibility);
                }
                return true;
            }
            case "elevation": {
                if (param != null) {
                    this.updateElevation();
                }
                return true;
            }
            case "fixedSize": {
                String fixedSize = WXUtils.getString(param, PROP_FS_MATCH_PARENT);
                this.setFixedSize(fixedSize);
                return true;
            }
            case "ariaLabel": {
                String label = WXUtils.getString(param, "");
                this.setAriaLabel(label);
                return true;
            }
            case "ariaHidden": {
                boolean isHidden = WXUtils.getBoolean(param, false);
                this.setAriaHidden(isHidden);
                return true;
            }
            case "width": 
            case "minWidth": 
            case "maxWidth": 
            case "height": 
            case "minHeight": 
            case "maxHeight": 
            case "alignItems": 
            case "alignSelf": 
            case "flex": 
            case "flexDirection": 
            case "justifyContent": 
            case "flexWrap": 
            case "margin": 
            case "marginTop": 
            case "marginLeft": 
            case "marginRight": 
            case "marginBottom": 
            case "padding": 
            case "paddingTop": 
            case "paddingLeft": 
            case "paddingRight": 
            case "paddingBottom": 
            case "left": 
            case "top": 
            case "right": 
            case "bottom": {
                return true;
            }
        }
        return false;
    }

    @TargetApi(value=16)
    protected void setAriaHidden(boolean isHidden) {
        T host = this.getHostView();
        if (host != null && Build.VERSION.SDK_INT >= 16) {
            host.setImportantForAccessibility(isHidden ? 2 : 1);
        }
    }

    protected void setAriaLabel(String label) {
        T host = this.getHostView();
        if (host != null) {
            host.setContentDescription((CharSequence)label);
        }
    }

    private void setFixedSize(String fixedSize) {
        ViewGroup.LayoutParams layoutParams;
        if (PROP_FS_MATCH_PARENT.equals(fixedSize)) {
            this.mFixedProp = -1;
        } else if (PROP_FS_WRAP_CONTENT.equals(fixedSize)) {
            this.mFixedProp = -2;
        } else {
            this.mFixedProp = 0;
            return;
        }
        if (this.mHost != null && (layoutParams = this.mHost.getLayoutParams()) != null) {
            layoutParams.height = this.mFixedProp;
            layoutParams.width = this.mFixedProp;
            this.mHost.setLayoutParams(layoutParams);
        }
    }

    protected void appendEventToDOM(String type) {
        WXSDKManager.getInstance().getWXDomManager().postAction(this.getInstanceId(), Actions.getAddEvent(this.getRef(), type), false);
    }

    public void addEvent(String type) {
        if (TextUtils.isEmpty((CharSequence)type) || this.mAppendEvents.contains(type)) {
            return;
        }
        this.mAppendEvents.add(type);
        View view = this.getRealView();
        if (type.equals("click") && view != null) {
            this.addClickListener(this.mClickEventListener);
        } else if (type.equals("focus") || type.equals("blur")) {
            this.addFocusChangeListener(new OnFocusChangeListener(){

                @Override
                public void onFocusChange(boolean hasFocus) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("timeStamp", System.currentTimeMillis());
                    WXComponent.this.fireEvent(hasFocus ? "focus" : "blur", params);
                }
            });
        } else if (view != null && this.needGestureDetector(type)) {
            if (view instanceof WXGestureObservable) {
                if (this.mGesture == null) {
                    this.mGesture = new WXGesture(this, this.mContext);
                    boolean isPreventMove = WXUtils.getBoolean(this.getDomObject().getAttrs().get("preventMoveEvent"), false);
                    this.mGesture.setPreventMoveEvent(isPreventMove);
                }
                this.mGestureType.add(type);
                ((WXGestureObservable)view).registerGestureListener(this.mGesture);
            } else {
                WXLogUtils.e(view.getClass().getSimpleName() + " don't implement WXGestureObservable, so no gesture is supported.");
            }
        } else {
            Scrollable scroller = this.getParentScroller();
            if (type.equals("appear") && scroller != null) {
                scroller.bindAppearEvent(this);
            }
            if (type.equals("disappear") && scroller != null) {
                scroller.bindDisappearEvent(this);
            }
        }
    }

    public View getRealView() {
        return this.mHost;
    }

    private boolean needGestureDetector(String type) {
        if (this.mHost != null) {
            for (WXGestureType.LowLevelGesture lowLevelGesture : WXGestureType.LowLevelGesture.values()) {
                if (!type.equals(((Object)lowLevelGesture).toString())) continue;
                return true;
            }
            for (Enum enum_ : WXGestureType.HighLevelGesture.values()) {
                if (!type.equals(enum_.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public Scrollable getParentScroller() {
        WXComponent component = this;
        WXVContainer container;
        while ((container = component.getParent()) != null) {
            if (container instanceof Scrollable) {
                Scrollable scroller = (Scrollable)((Object)container);
                return scroller;
            }
            if (container.getRef().equals("_root")) {
                return null;
            }
            component = container;
        }
        return null;
    }

    @Nullable
    public Scrollable getFirstScroller() {
        if (this instanceof Scrollable) {
            return (Scrollable)((Object)this);
        }
        return null;
    }

    public WXVContainer getParent() {
        return this.mParent;
    }

    public String getRef() {
        if (this.mDomObj == null) {
            return null;
        }
        return this.mCurrentRef;
    }

    public final void createView() {
        long startNanos = System.nanoTime();
        if (!this.isLazy()) {
            this.createViewImpl();
        }
        this.mTraceInfo.uiThreadStart = System.currentTimeMillis();
        this.mTraceInfo.uiThreadNanos += System.nanoTime() - startNanos;
    }

    protected void createViewImpl() {
        if (this.mContext != null) {
            this.mHost = this.initComponentHostView(this.mContext);
            if (this.mHost == null && !this.isVirtualComponent()) {
                this.initView();
            }
            if (this.mHost != null) {
                this.mHost.setId(WXViewUtils.generateViewId());
                ComponentObserver observer = this.getInstance().getComponentObserver();
                if (observer != null) {
                    observer.onViewCreated(this, (View)this.mHost);
                }
            }
            this.onHostViewInitialized(this.mHost);
        } else {
            WXLogUtils.e("createViewImpl", "Context is null");
        }
    }

    @Deprecated
    protected void initView() {
        if (this.mContext != null) {
            this.mHost = this.initComponentHostView(this.mContext);
        }
    }

    protected T initComponentHostView(@NonNull Context context) {
        return null;
    }

    @CallSuper
    protected void onHostViewInitialized(T host) {
        if (this.mAnimationHolder != null) {
            this.mAnimationHolder.execute(this.mInstance, this);
        }
        this.setActiveTouchListener();
    }

    public T getHostView() {
        return this.mHost;
    }

    @Deprecated
    public View getView() {
        return this.mHost;
    }

    public int getAbsoluteY() {
        return this.mAbsoluteY;
    }

    public int getAbsoluteX() {
        return this.mAbsoluteX;
    }

    public void updateDom(WXDomObject dom) {
        if (dom == null) {
            return;
        }
        this.mDomObj = dom.clone();
    }

    public final void removeEvent(String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.mAppendEvents.remove(type);
        this.mGestureType.remove(type);
        this.removeEventFromView(type);
    }

    protected void removeEventFromView(String type) {
        if (type.equals("click") && this.getRealView() != null && this.mHostClickListeners != null) {
            this.mHostClickListeners.remove(this.mClickEventListener);
        }
        Scrollable scroller = this.getParentScroller();
        if (type.equals("appear") && scroller != null) {
            scroller.unbindAppearEvent(this);
        }
        if (type.equals("disappear") && scroller != null) {
            scroller.unbindDisappearEvent(this);
        }
    }

    public final void removeAllEvent() {
        if (this.mDomObj == null || this.mDomObj.getEvents().size() < 1) {
            return;
        }
        for (String event : this.mDomObj.getEvents()) {
            if (event == null) continue;
            this.removeEventFromView(event);
        }
        this.mAppendEvents.clear();
        this.mGestureType.clear();
        this.mGesture = null;
        if (this.getRealView() != null && this.getRealView() instanceof WXGestureObservable) {
            ((WXGestureObservable)this.getRealView()).registerGestureListener(null);
        }
        if (this.mHost != null) {
            this.mHost.setOnFocusChangeListener(null);
            if (this.mHostClickListeners != null && this.mHostClickListeners.size() > 0) {
                this.mHostClickListeners.clear();
                this.mHost.setOnClickListener(null);
            }
        }
    }

    public final void removeStickyStyle() {
        Scrollable scroller;
        if (this.mDomObj == null) {
            return;
        }
        if (this.isSticky() && (scroller = this.getParentScroller()) != null) {
            scroller.unbindStickStyle(this);
        }
    }

    public boolean isSticky() {
        return this.mDomObj.getStyles().isSticky();
    }

    public boolean isFixed() {
        return this.mDomObj.getStyles().isFixed();
    }

    public void setDisabled(boolean disabled) {
        this.mIsDisabled = disabled;
        if (this.mHost == null) {
            return;
        }
        this.mHost.setEnabled(!disabled);
    }

    public boolean isDisabled() {
        return this.mIsDisabled;
    }

    public void setSticky(String sticky) {
        Scrollable waScroller;
        if (!TextUtils.isEmpty((CharSequence)sticky) && sticky.equals("sticky") && (waScroller = this.getParentScroller()) != null) {
            waScroller.bindStickStyle(this);
        }
    }

    public void setBackgroundColor(String color) {
        int colorInt;
        if (!(TextUtils.isEmpty((CharSequence)color) || (colorInt = WXResourceUtils.getColor(color)) == 0 && this.mBackgroundDrawable == null)) {
            this.getOrCreateBorder().setColor(colorInt);
        }
    }

    public void setBackgroundImage(@NonNull String bgImage) {
        if ("".equals(bgImage.trim())) {
            this.getOrCreateBorder().setImage(null);
        } else {
            Shader shader = WXResourceUtils.getShader(bgImage, this.mDomObj.getLayoutWidth(), this.mDomObj.getLayoutHeight());
            this.getOrCreateBorder().setImage(shader);
        }
    }

    public void setOpacity(float opacity) {
        if (opacity >= 0.0f && opacity <= 1.0f && this.mHost.getAlpha() != opacity) {
            if (this.isLayerTypeEnabled()) {
                this.mHost.setLayerType(2, null);
            }
            this.mHost.setAlpha(opacity);
        }
    }

    public void setBorderRadius(String key, float borderRadius) {
        if (borderRadius >= 0.0f) {
            switch (key) {
                case "borderRadius": {
                    this.getOrCreateBorder().setBorderRadius(8, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidth()));
                    break;
                }
                case "borderTopLeftRadius": {
                    this.getOrCreateBorder().setBorderRadius(0, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidth()));
                    break;
                }
                case "borderTopRightRadius": {
                    this.getOrCreateBorder().setBorderRadius(1, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidth()));
                    break;
                }
                case "borderBottomRightRadius": {
                    this.getOrCreateBorder().setBorderRadius(2, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidth()));
                    break;
                }
                case "borderBottomLeftRadius": {
                    this.getOrCreateBorder().setBorderRadius(3, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidth()));
                }
            }
        }
    }

    public void setBorderWidth(String key, float borderWidth) {
        if (borderWidth >= 0.0f) {
            switch (key) {
                case "borderWidth": {
                    this.getOrCreateBorder().setBorderWidth(8, WXViewUtils.getRealSubPxByWidth(borderWidth, this.getInstance().getInstanceViewPortWidth()));
                    break;
                }
                case "borderTopWidth": {
                    this.getOrCreateBorder().setBorderWidth(1, WXViewUtils.getRealSubPxByWidth(borderWidth, this.getInstance().getInstanceViewPortWidth()));
                    break;
                }
                case "borderRightWidth": {
                    this.getOrCreateBorder().setBorderWidth(2, WXViewUtils.getRealSubPxByWidth(borderWidth, this.getInstance().getInstanceViewPortWidth()));
                    break;
                }
                case "borderBottomWidth": {
                    this.getOrCreateBorder().setBorderWidth(3, WXViewUtils.getRealSubPxByWidth(borderWidth, this.getInstance().getInstanceViewPortWidth()));
                    break;
                }
                case "borderLeftWidth": {
                    this.getOrCreateBorder().setBorderWidth(0, WXViewUtils.getRealSubPxByWidth(borderWidth, this.getInstance().getInstanceViewPortWidth()));
                }
            }
        }
    }

    public void setBorderStyle(String key, String borderStyle) {
        if (!TextUtils.isEmpty((CharSequence)borderStyle)) {
            switch (key) {
                case "borderStyle": {
                    this.getOrCreateBorder().setBorderStyle(8, borderStyle);
                    break;
                }
                case "borderRightStyle": {
                    this.getOrCreateBorder().setBorderStyle(2, borderStyle);
                    break;
                }
                case "borderBottomStyle": {
                    this.getOrCreateBorder().setBorderStyle(3, borderStyle);
                    break;
                }
                case "borderLeftStyle": {
                    this.getOrCreateBorder().setBorderStyle(0, borderStyle);
                    break;
                }
                case "borderTopStyle": {
                    this.getOrCreateBorder().setBorderStyle(1, borderStyle);
                }
            }
        }
    }

    public void setBorderColor(String key, String borderColor) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)borderColor) && (colorInt = WXResourceUtils.getColor(borderColor)) != Integer.MIN_VALUE) {
            switch (key) {
                case "borderColor": {
                    this.getOrCreateBorder().setBorderColor(8, colorInt);
                    break;
                }
                case "borderTopColor": {
                    this.getOrCreateBorder().setBorderColor(1, colorInt);
                    break;
                }
                case "borderRightColor": {
                    this.getOrCreateBorder().setBorderColor(2, colorInt);
                    break;
                }
                case "borderBottomColor": {
                    this.getOrCreateBorder().setBorderColor(3, colorInt);
                    break;
                }
                case "borderLeftColor": {
                    this.getOrCreateBorder().setBorderColor(0, colorInt);
                }
            }
        }
    }

    @Nullable
    public String getVisibility() {
        try {
            return (String)this.getDomObject().getStyles().get("visibility");
        }
        catch (Exception e) {
            return "visible";
        }
    }

    public void setVisibility(String visibility) {
        View view = this.getRealView();
        if (view != null) {
            if (TextUtils.equals((CharSequence)visibility, (CharSequence)"visible")) {
                view.setVisibility(0);
            } else if (TextUtils.equals((CharSequence)visibility, (CharSequence)"hidden")) {
                view.setVisibility(8);
            }
        }
    }

    private void updateElevation() {
        float elevation = this.getDomObject().getAttrs().getElevation(this.getInstance().getInstanceViewPortWidth());
        if (!Float.isNaN(elevation)) {
            ViewCompat.setElevation(this.getHostView(), (float)elevation);
        }
    }

    @Deprecated
    public void registerActivityStateListener() {
    }

    @Override
    public void onActivityCreate() {
    }

    @Override
    public void onActivityStart() {
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }

    @Override
    public void onActivityStop() {
    }

    @Override
    public void onActivityDestroy() {
    }

    @Override
    public boolean onActivityBack() {
        return false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public void recycled() {
        if (this.mDomObj.isFixed()) {
            return;
        }
    }

    public void destroy() {
        T view;
        ComponentObserver observer = this.getInstance().getComponentObserver();
        if (observer != null) {
            observer.onPreDestory(this);
        }
        if (WXEnvironment.isApkDebugable() && !WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXComponent] destroy can only be called in main thread");
        }
        if (this.mHost != null && this.mHost.getLayerType() == 2 && this.isLayerTypeEnabled()) {
            this.mHost.setLayerType(0, null);
        }
        this.removeAllEvent();
        this.removeStickyStyle();
        if (this.mDomObj.isFixed() && (view = this.getHostView()) != null) {
            this.getInstance().removeFixedView((View)view);
        }
        this.mDomObj = ImmutableDomObject.DESTROYED;
        this.mIsDestroyed = true;
    }

    public boolean isDestoryed() {
        return this.mIsDestroyed;
    }

    public View detachViewAndClearPreInfo() {
        T original = this.mHost;
        this.mPreRealLeft = 0;
        this.mPreRealWidth = 0;
        this.mPreRealHeight = 0;
        this.mPreRealTop = 0;
        return original;
    }

    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        View view = this.getRealView();
        pointF.set((float)view.getScrollX(), (float)view.getScrollY());
    }

    public boolean containsGesture(WXGestureType WXGestureType2) {
        return this.mGestureType != null && this.mGestureType.contains(WXGestureType2.toString());
    }

    protected boolean containsEvent(String event) {
        return this.mDomObj.getEvents().contains(event) || this.mAppendEvents.contains(event);
    }

    public void notifyAppearStateChange(String wxEventType, String direction) {
        if (this.containsEvent("appear") || this.containsEvent("disappear")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("direction", direction);
            this.fireEvent(wxEventType, params);
        }
    }

    public boolean isUsing() {
        return this.isUsing;
    }

    public void setUsing(boolean using) {
        this.isUsing = using;
    }

    public void readyToRender() {
        if (this.mParent != null && this.getInstance().isTrackComponent()) {
            this.mParent.readyToRender();
        }
    }

    public boolean isVirtualComponent() {
        return this.mType == 1;
    }

    public void removeVirtualComponent() {
    }

    public void setType(int type) {
        this.mType = type;
    }

    public boolean hasScrollParent(WXComponent component) {
        if (component.getParent() == null) {
            return true;
        }
        if (component.getParent() instanceof WXScroller) {
            return false;
        }
        return this.hasScrollParent(component.getParent());
    }

    @CheckResult
    protected Object convertEmptyProperty(String propName, Object originalValue) {
        switch (propName) {
            case "backgroundColor": {
                return "transparent";
            }
            case "borderRadius": 
            case "borderBottomLeftRadius": 
            case "borderBottomRightRadius": 
            case "borderTopLeftRadius": 
            case "borderTopRightRadius": {
                return 0;
            }
            case "borderWidth": 
            case "borderTopWidth": 
            case "borderLeftWidth": 
            case "borderRightWidth": 
            case "borderBottomWidth": {
                return 0;
            }
            case "borderColor": 
            case "borderTopColor": 
            case "borderLeftColor": 
            case "borderRightColor": 
            case "borderBottomColor": {
                return "black";
            }
        }
        return originalValue;
    }

    private void setActiveTouchListener() {
        View view;
        boolean hasActivePesudo = this.mDomObj.getStyles().getPesudoStyles().containsKey(":active");
        if (hasActivePesudo && (view = this.getRealView()) != null) {
            boolean hasTouchConsumer = this.isConsumeTouch();
            view.setOnTouchListener((View.OnTouchListener)new TouchActivePseudoListener(this, !hasTouchConsumer));
        }
    }

    protected boolean isConsumeTouch() {
        return this.mHostClickListeners != null && this.mHostClickListeners.size() > 0 || this.mGesture != null;
    }

    @Override
    public void updateActivePseudo(boolean isSet) {
        this.setPseudoClassStatus(":active", isSet);
    }

    protected void setPseudoClassStatus(String clzName, boolean status) {
        WXStyle styles = this.getDomObject().getStyles();
        Map<String, Map<String, Object>> pesudoStyles = styles.getPesudoStyles();
        if (pesudoStyles == null || pesudoStyles.size() == 0) {
            return;
        }
        Map<String, Object> resultStyles = this.mPesudoStatus.updateStatusAndGetUpdateStyles(clzName, status, pesudoStyles, styles.getPesudoResetStyles());
        this.updateStyleByPesudo(resultStyles);
    }

    private void updateStyleByPesudo(Map<String, Object> styles) {
        Message message = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.getInstanceId();
        task.args = new ArrayList<Object>();
        JSONObject styleJson = new JSONObject(styles);
        task.args.add(this.getRef());
        task.args.add(styleJson);
        task.args.add(true);
        message.obj = task;
        message.what = 2;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(message);
    }

    public int getStickyOffset() {
        return this.mStickyOffset;
    }

    public boolean canRecycled() {
        return (!this.isFixed() || !this.isSticky()) && this.mDomObj.getAttrs().canRecycled();
    }

    public void setStickyOffset(int stickyOffset) {
        this.mStickyOffset = stickyOffset;
    }

    public boolean isLayerTypeEnabled() {
        return this.getInstance().isLayerTypeEnabled();
    }

    public void setNeedLayoutOnAnimation(boolean need) {
        this.mNeedLayoutOnAnimation = need;
    }

    public void notifyNativeSizeChanged(int w, int h) {
        if (!this.mNeedLayoutOnAnimation) {
            return;
        }
        Message message = Message.obtain();
        WXDomTask task = new WXDomTask();
        task.instanceId = this.getInstanceId();
        if (task.args == null) {
            task.args = new ArrayList<Object>();
        }
        JSONObject style = new JSONObject(2);
        float webW = WXViewUtils.getWebPxByWidth(w);
        float webH = WXViewUtils.getWebPxByWidth(h);
        style.put("width", (Object)Float.valueOf(webW));
        style.put("height", (Object)Float.valueOf(webH));
        task.args.add(this.getRef());
        task.args.add(style);
        message.obj = task;
        message.what = 2;
        WXSDKManager.getInstance().getWXDomManager().sendMessage(message);
    }

    @CallSuper
    public void onRenderFinish(int state) {
        if (WXTracing.isAvailable()) {
            double domTime = Stopwatch.nanosToMillis(((WXDomObject)this.mDomObj).mDomThreadNanos + this.mTraceInfo.domThreadNanos);
            double uiTime = Stopwatch.nanosToMillis(this.mTraceInfo.uiThreadNanos);
            if (state == 2 || state == 0) {
                WXTracing.TraceEvent domEvent = WXTracing.newEvent("DomExecute", this.getInstanceId(), this.mTraceInfo.rootEventId);
                domEvent.ph = "X";
                domEvent.duration = domTime;
                domEvent.ts = this.mTraceInfo.domThreadStart;
                domEvent.tname = "DOMThread";
                domEvent.name = this.getDomObject().getType();
                domEvent.classname = this.getClass().getSimpleName();
                if (this.getParent() != null) {
                    domEvent.parentRef = this.getParent().getRef();
                }
                domEvent.submit();
            }
            if (state == 2 || state == 1) {
                if (this.mTraceInfo.uiThreadStart != -1L) {
                    WXTracing.TraceEvent uiEvent = WXTracing.newEvent("UIExecute", this.getInstanceId(), this.mTraceInfo.rootEventId);
                    uiEvent.ph = "X";
                    uiEvent.duration = uiTime;
                    uiEvent.ts = this.mTraceInfo.uiThreadStart;
                    uiEvent.name = this.getDomObject().getType();
                    uiEvent.classname = this.getClass().getSimpleName();
                    if (this.getParent() != null) {
                        uiEvent.parentRef = this.getParent().getRef();
                    }
                    uiEvent.submit();
                } else {
                    WXLogUtils.w("onRenderFinish", "createView() not called");
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER})
    public static @interface RenderState {
    }

    public static class MeasureOutput {
        public int width;
        public int height;
    }

    static interface OnFocusChangeListener {
        public void onFocusChange(boolean var1);
    }

    public static interface OnClickListener {
        public void onHostViewClick();
    }
}

