/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.animation;

import android.animation.PropertyValuesHolder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Property;
import android.view.View;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.ui.animation.CameraDistanceProperty;
import com.taobao.weex.utils.FunctionParser;
import com.taobao.weex.utils.WXDataStructureUtil;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WXAnimationBean {
    public static final String LINEAR = "linear";
    public static final String EASE_IN_OUT = "ease-in-out";
    public static final String EASE_IN = "ease-in";
    public static final String EASE_OUT = "ease-out";
    public static final String CUBIC_BEZIER = "cubic-bezier";
    public static final int NUM_CUBIC_PARAM = 4;
    public long delay;
    public long duration;
    public String timingFunction;
    @Nullable
    public Style styles;
    public boolean needLayout;

    public static class Style {
        public static final String WX_TRANSLATE = "translate";
        public static final String WX_TRANSLATE_X = "translateX";
        public static final String WX_TRANSLATE_Y = "translateY";
        public static final String WX_ROTATE = "rotate";
        public static final String WX_SCALE_X = "scaleX";
        public static final String WX_SCALE_Y = "scaleY";
        public static final String WX_SCALE = "scale";
        public static final String WX_ROTATE_X = "rotateX";
        public static final String WX_ROTATE_Y = "rotateY";
        public static final String BACKGROUND_COLOR = "backgroundColor";
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
        public static final String TOP = "top";
        public static final String BOTTOM = "bottom";
        public static final String RIGHT = "right";
        public static final String LEFT = "left";
        public static final String CENTER = "center";
        private static final String HALF = "50%";
        private static final String FULL = "100%";
        private static final String ZERO = "0%";
        private static final String PX = "px";
        private static final String DEG = "deg";
        public static Map<String, List<Property<View, Float>>> wxToAndroidMap = new ArrayMap();
        private static Map<Property<View, Float>, Float> defaultMap = new ArrayMap();
        public String opacity;
        public String backgroundColor;
        public String width;
        public String height;
        public String transform;
        public String transformOrigin;
        private Map<Property<View, Float>, Float> transformMap = new LinkedHashMap<Property<View, Float>, Float>();
        private Pair<Float, Float> pivot;
        private List<PropertyValuesHolder> holders = new LinkedList<PropertyValuesHolder>();
        private float cameraDistance = Float.MAX_VALUE;

        private static Map<Property<View, Float>, Float> parseTransForm(@Nullable String rawTransform, final int width, final int height, final int viewportW) {
            if (!TextUtils.isEmpty((CharSequence)rawTransform)) {
                FunctionParser<Property<View, Float>, Float> parser = new FunctionParser<Property<View, Float>, Float>(rawTransform, new FunctionParser.Mapper<Property<View, Float>, Float>(){

                    @Override
                    public Map<Property<View, Float>, Float> map(String functionName, List<String> raw) {
                        if (raw != null && !raw.isEmpty() && wxToAndroidMap.containsKey(functionName)) {
                            return this.convertParam(width, height, viewportW, wxToAndroidMap.get(functionName), raw);
                        }
                        return new HashMap<Property<View, Float>, Float>();
                    }

                    private Map<Property<View, Float>, Float> convertParam(int width2, int height2, int viewportW2, @NonNull List<Property<View, Float>> propertyList, @NonNull List<String> rawValue) {
                        HashMap<Property<View, Float>, Float> result = WXDataStructureUtil.newHashMapWithExpectedSize(propertyList.size());
                        ArrayList<Float> convertedList = new ArrayList<Float>(propertyList.size());
                        if (propertyList.contains(View.ROTATION) || propertyList.contains(View.ROTATION_X) || propertyList.contains(View.ROTATION_Y)) {
                            convertedList.addAll(this.parseRotationZ(rawValue));
                        } else if (propertyList.contains(View.TRANSLATION_X) || propertyList.contains(View.TRANSLATION_Y)) {
                            convertedList.addAll(this.parseTranslation(propertyList, width2, height2, rawValue, viewportW2));
                        } else if (propertyList.contains(View.SCALE_X) || propertyList.contains(View.SCALE_Y)) {
                            convertedList.addAll(this.parseScale(propertyList.size(), rawValue));
                        } else if (propertyList.contains(CameraDistanceProperty.getInstance())) {
                            convertedList.add(this.parseCameraDistance(rawValue));
                        }
                        if (propertyList.size() == convertedList.size()) {
                            for (int i = 0; i < propertyList.size(); ++i) {
                                result.put(propertyList.get(i), (Float)convertedList.get(i));
                            }
                        }
                        return result;
                    }

                    private List<Float> parseScale(int size, @NonNull List<String> rawValue) {
                        ArrayList<Float> convertedList = new ArrayList<Float>(rawValue.size() * 2);
                        ArrayList<Float> rawFloat = new ArrayList<Float>(rawValue.size());
                        for (String item : rawValue) {
                            rawFloat.add(Float.valueOf(WXUtils.fastGetFloat(item)));
                        }
                        convertedList.addAll(rawFloat);
                        if (size != 1 && rawValue.size() == 1) {
                            convertedList.addAll(rawFloat);
                        }
                        return convertedList;
                    }

                    @NonNull
                    private List<Float> parseRotationZ(@NonNull List<String> rawValue) {
                        ArrayList<Float> convertedList = new ArrayList<Float>(1);
                        for (String raw : rawValue) {
                            int suffix = raw.lastIndexOf(Style.DEG);
                            if (suffix != -1) {
                                convertedList.add(Float.valueOf(WXUtils.fastGetFloat(raw.substring(0, suffix))));
                                continue;
                            }
                            convertedList.add(Float.valueOf((float)Math.toDegrees(Double.parseDouble(raw))));
                        }
                        return convertedList;
                    }

                    private List<Float> parseTranslation(List<Property<View, Float>> propertyList, int width2, int height2, @NonNull List<String> rawValue, int viewportW2) {
                        ArrayList<Float> convertedList = new ArrayList<Float>(2);
                        String first = rawValue.get(0);
                        if (propertyList.size() == 1) {
                            this.parseSingleTranslation(propertyList, width2, height2, convertedList, first, viewportW2);
                        } else {
                            this.parseDoubleTranslation(width2, height2, rawValue, convertedList, first, viewportW2);
                        }
                        return convertedList;
                    }

                    private void parseSingleTranslation(List<Property<View, Float>> propertyList, int width2, int height2, List<Float> convertedList, String first, int viewportW2) {
                        if (propertyList.contains(View.TRANSLATION_X)) {
                            convertedList.add(Float.valueOf(Style.parsePercentOrPx(first, width2, viewportW2)));
                        } else if (propertyList.contains(View.TRANSLATION_Y)) {
                            convertedList.add(Float.valueOf(Style.parsePercentOrPx(first, height2, viewportW2)));
                        }
                    }

                    private void parseDoubleTranslation(int width2, int height2, @NonNull List<String> rawValue, List<Float> convertedList, String first, int viewportW2) {
                        String second = rawValue.size() == 1 ? first : rawValue.get(1);
                        convertedList.add(Float.valueOf(Style.parsePercentOrPx(first, width2, viewportW2)));
                        convertedList.add(Float.valueOf(Style.parsePercentOrPx(second, height2, viewportW2)));
                    }

                    private Float parseCameraDistance(List<String> rawValue) {
                        float ret = Float.MAX_VALUE;
                        if (rawValue.size() == 1) {
                            float value = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(rawValue.get(0)), viewportW);
                            float scale = WXEnvironment.getApplication().getResources().getDisplayMetrics().density;
                            if (!Float.isNaN(value) && value > 0.0f) {
                                ret = value * scale;
                            }
                        }
                        return Float.valueOf(ret);
                    }
                });
                return parser.parse();
            }
            return new LinkedHashMap<Property<View, Float>, Float>();
        }

        private static Pair<Float, Float> parsePivot(@Nullable String transformOrigin, int width, int height, int viewportW) {
            int firstSpace;
            if (!TextUtils.isEmpty((CharSequence)transformOrigin) && (firstSpace = transformOrigin.indexOf(32)) != -1) {
                int i;
                for (i = firstSpace; i < transformOrigin.length() && transformOrigin.charAt(i) == ' '; ++i) {
                }
                if (i < transformOrigin.length() && transformOrigin.charAt(i) != ' ') {
                    ArrayList<String> list = new ArrayList<String>(2);
                    list.add(transformOrigin.substring(0, firstSpace).trim());
                    list.add(transformOrigin.substring(i, transformOrigin.length()).trim());
                    return Style.parsePivot(list, width, height, viewportW);
                }
            }
            return null;
        }

        private static Pair<Float, Float> parsePivot(@NonNull List<String> list, int width, int height, int viewportW) {
            return new Pair((Object)Float.valueOf(Style.parsePivotX(list.get(0), width, viewportW)), (Object)Float.valueOf(Style.parsePivotY(list.get(1), height, viewportW)));
        }

        private static float parsePivotX(String x, int width, int viewportW) {
            String value = x;
            if (LEFT.equals(x)) {
                value = ZERO;
            } else if (RIGHT.equals(x)) {
                value = FULL;
            } else if (CENTER.equals(x)) {
                value = HALF;
            }
            return Style.parsePercentOrPx(value, width, viewportW);
        }

        private static float parsePivotY(String y, int height, int viewportW) {
            String value = y;
            if (TOP.equals(y)) {
                value = ZERO;
            } else if (BOTTOM.equals(y)) {
                value = FULL;
            } else if (CENTER.equals(y)) {
                value = HALF;
            }
            return Style.parsePercentOrPx(value, height, viewportW);
        }

        private static float parsePercentOrPx(String raw, int unit, int viewportW) {
            boolean precision = true;
            int suffix = raw.lastIndexOf(37);
            if (suffix != -1) {
                return Style.parsePercent(raw.substring(0, suffix), unit, 1);
            }
            suffix = raw.lastIndexOf(PX);
            if (suffix != -1) {
                return WXViewUtils.getRealPxByWidth(WXUtils.fastGetFloat(raw.substring(0, suffix), 1), viewportW);
            }
            return WXViewUtils.getRealPxByWidth(WXUtils.fastGetFloat(raw, 1), viewportW);
        }

        private static float parsePercent(String percent, int unit, int precision) {
            return WXUtils.fastGetFloat(percent, precision) / 100.0f * (float)unit;
        }

        private void resetToDefaultIfAbsent() {
            for (Map.Entry<Property<View, Float>, Float> entry : defaultMap.entrySet()) {
                if (this.transformMap.containsKey(entry.getKey())) continue;
                this.transformMap.put(entry.getKey(), entry.getValue());
            }
        }

        @Nullable
        public Pair<Float, Float> getPivot() {
            return this.pivot;
        }

        public void init(@Nullable String transformOrigin, @Nullable String rawTransform, int width, int height, int viewportW) {
            this.pivot = Style.parsePivot(transformOrigin, width, height, viewportW);
            this.transformMap.putAll(Style.parseTransForm(rawTransform, width, height, viewportW));
            this.resetToDefaultIfAbsent();
            if (this.transformMap.containsKey(CameraDistanceProperty.getInstance())) {
                this.cameraDistance = this.transformMap.remove(CameraDistanceProperty.getInstance()).floatValue();
            }
            this.initHolders();
        }

        public void init(@NonNull Map<Property<View, Float>, Pair<Float, Float>> styles) {
            for (Map.Entry<Property<View, Float>, Pair<Float, Float>> entry : styles.entrySet()) {
                this.holders.add(PropertyValuesHolder.ofFloat(entry.getKey(), (float[])new float[]{((Float)entry.getValue().first).floatValue(), ((Float)entry.getValue().second).floatValue()}));
            }
        }

        private void initHolders() {
            for (Map.Entry<Property<View, Float>, Float> entry : this.transformMap.entrySet()) {
                this.holders.add(PropertyValuesHolder.ofFloat(entry.getKey(), (float[])new float[]{entry.getValue().floatValue()}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.opacity)) {
                this.holders.add(PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{WXUtils.fastGetFloat(this.opacity, 3)}));
            }
        }

        public List<PropertyValuesHolder> getHolders() {
            return this.holders;
        }

        public float getCameraDistance() {
            return this.cameraDistance;
        }

        static {
            wxToAndroidMap.put(WX_TRANSLATE, Arrays.asList(View.TRANSLATION_X, View.TRANSLATION_Y));
            wxToAndroidMap.put(WX_TRANSLATE_X, Collections.singletonList(View.TRANSLATION_X));
            wxToAndroidMap.put(WX_TRANSLATE_Y, Collections.singletonList(View.TRANSLATION_Y));
            wxToAndroidMap.put(WX_ROTATE, Collections.singletonList(View.ROTATION));
            wxToAndroidMap.put(WX_ROTATE_X, Collections.singletonList(View.ROTATION_X));
            wxToAndroidMap.put(WX_ROTATE_Y, Collections.singletonList(View.ROTATION_Y));
            wxToAndroidMap.put(WX_SCALE, Arrays.asList(View.SCALE_X, View.SCALE_Y));
            wxToAndroidMap.put(WX_SCALE_X, Collections.singletonList(View.SCALE_X));
            wxToAndroidMap.put(WX_SCALE_Y, Collections.singletonList(View.SCALE_Y));
            wxToAndroidMap.put("perspective", Collections.singletonList(CameraDistanceProperty.getInstance()));
            wxToAndroidMap = Collections.unmodifiableMap(wxToAndroidMap);
            defaultMap.put((Property<View, Float>)View.TRANSLATION_X, Float.valueOf(0.0f));
            defaultMap.put((Property<View, Float>)View.TRANSLATION_Y, Float.valueOf(0.0f));
            defaultMap.put((Property<View, Float>)View.SCALE_X, Float.valueOf(1.0f));
            defaultMap.put((Property<View, Float>)View.SCALE_Y, Float.valueOf(1.0f));
            defaultMap.put((Property<View, Float>)View.ROTATION, Float.valueOf(0.0f));
            defaultMap.put((Property<View, Float>)View.ROTATION_X, Float.valueOf(0.0f));
            defaultMap.put((Property<View, Float>)View.ROTATION_Y, Float.valueOf(0.0f));
        }
    }
}

