/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.RenderAction;
import com.taobao.weex.dom.RenderActionContext;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.action.AbstractAddElementAction;
import com.taobao.weex.dom.action.TraceableAction;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.IWXRenderTask;
import com.taobao.weex.ui.RenderActionContextImpl;
import com.taobao.weex.ui.WXRenderHandler;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXRenderManager {
    private ConcurrentHashMap<String, RenderActionContextImpl> mRegistries = new ConcurrentHashMap();
    private WXRenderHandler mWXRenderHandler = new WXRenderHandler();

    public RenderActionContext getRenderContext(String instanceId) {
        return this.mRegistries.get(instanceId);
    }

    @Nullable
    public WXComponent getWXComponent(String instanceId, String ref) {
        if (instanceId == null || TextUtils.isEmpty((CharSequence)ref)) {
            return null;
        }
        RenderActionContext stmt = this.getRenderContext(instanceId);
        return stmt == null ? null : stmt.getComponent(ref);
    }

    public WXSDKInstance getWXSDKInstance(String instanceId) {
        RenderActionContextImpl statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return null;
        }
        return statement.getWXSDKInstance();
    }

    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderHandler.postDelayed(WXThread.secure(runnable), delayMillis);
    }

    public void removeRenderStatement(String instanceId) {
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXRenderManager] removeRenderStatement can only be called in main thread");
        }
        RenderActionContextImpl statement = this.mRegistries.remove(instanceId);
        if (statement != null) {
            statement.destroy();
        }
    }

    public void runOnThread(final String instanceId, final IWXRenderTask task) {
        this.mWXRenderHandler.post(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                if (WXRenderManager.this.mRegistries.get(instanceId) == null) {
                    return;
                }
                task.execute();
            }
        }));
    }

    public void runOnThread(final String instanceId, final RenderAction action) {
        final long start = SystemClock.uptimeMillis();
        this.mWXRenderHandler.post(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                if (WXRenderManager.this.mRegistries.get(instanceId) == null) {
                    return;
                }
                if (WXTracing.isAvailable() && action instanceof TraceableAction) {
                    ((TraceableAction)((Object)action)).mUIQueueTime = SystemClock.uptimeMillis() - start;
                }
                long start2 = System.currentTimeMillis();
                long uiNanos = System.nanoTime();
                action.executeRender(WXRenderManager.this.getRenderContext(instanceId));
                if (WXTracing.isAvailable()) {
                    uiNanos = System.nanoTime() - uiNanos;
                    if (action instanceof TraceableAction) {
                        if (!(action instanceof AbstractAddElementAction)) {
                            WXTracing.TraceEvent uiExecuteEvent = WXTracing.newEvent("UIExecute", instanceId, ((TraceableAction)((Object)action)).mTracingEventId);
                            uiExecuteEvent.duration = Stopwatch.nanosToMillis(uiNanos);
                            uiExecuteEvent.ts = start2;
                            uiExecuteEvent.submit();
                        }
                        ((TraceableAction)((Object)action)).onFinishUIExecute();
                    }
                }
            }
        }));
    }

    public void registerInstance(WXSDKInstance instance) {
        this.mRegistries.put(instance.getInstanceId(), new RenderActionContextImpl(instance));
    }

    public void setLayout(String instanceId, String ref, WXDomObject domObject) {
        RenderActionContextImpl statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.setLayout(ref, domObject);
    }

    public void setExtra(String instanceId, String ref, Object extra) {
        RenderActionContextImpl statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.setExtra(ref, extra);
    }

    public List<WXSDKInstance> getAllInstances() {
        ArrayList<WXSDKInstance> instances = null;
        if (this.mRegistries != null && !this.mRegistries.isEmpty()) {
            instances = new ArrayList<WXSDKInstance>();
            for (Map.Entry<String, RenderActionContextImpl> entry : this.mRegistries.entrySet()) {
                RenderActionContextImpl renderStatement = entry.getValue();
                if (renderStatement == null) continue;
                instances.add(renderStatement.getWXSDKInstance());
            }
        }
        return instances;
    }

    public void registerComponent(String instanceId, String ref, WXComponent comp) {
        RenderActionContextImpl statement = this.mRegistries.get(instanceId);
        if (statement != null) {
            statement.registerComponent(ref, comp);
        }
    }
}

