/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.util.Pair;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.IExternalComponentGetter;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.SimpleComponentHolder;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;

public class ExternalLoaderComponentHolder
implements IFComponentHolder {
    public static final String TAG = "SimpleComponentHolder";
    private Map<String, Invoker> mPropertyInvokers;
    private Map<String, Invoker> mMethodInvokers;
    private final IExternalComponentGetter mClzGetter;
    private final String mType;
    private Class mClass;

    public ExternalLoaderComponentHolder(String type, IExternalComponentGetter clzGetter) {
        this.mClzGetter = clzGetter;
        this.mType = type;
    }

    @Override
    public void loadIfNonLazy() {
    }

    private synchronized boolean generate() {
        if (this.mClass == null) {
            return false;
        }
        Pair<Map<String, Invoker>, Map<String, Invoker>> methodPair = SimpleComponentHolder.getMethods(this.mClass);
        this.mPropertyInvokers = (Map)methodPair.first;
        this.mMethodInvokers = (Map)methodPair.second;
        return true;
    }

    @Override
    public synchronized WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.mClass == null) {
            this.mClass = this.mClzGetter.getExternalComponentClass(this.mType, instance);
        }
        SimpleComponentHolder.ClazzComponentCreator creator = new SimpleComponentHolder.ClazzComponentCreator(this.mClass);
        WXComponent component = creator.createInstance(instance, node, parent);
        component.bindHolder(this);
        return component;
    }

    @Override
    public synchronized Invoker getPropertyInvoker(String name) {
        if (this.mPropertyInvokers == null && !this.generate()) {
            return null;
        }
        return this.mPropertyInvokers.get(name);
    }

    @Override
    public Invoker getMethodInvoker(String name) {
        if (this.mMethodInvokers == null && !this.generate()) {
            return null;
        }
        return this.mMethodInvokers.get(name);
    }

    @Override
    public String[] getMethods() {
        if (this.mMethodInvokers == null && !this.generate()) {
            return new String[0];
        }
        Set<String> keys = this.mMethodInvokers.keySet();
        return keys.toArray(new String[keys.size()]);
    }
}

